/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.tools;

import com.redhat.qe.tools.SSHCommandRunner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SplitStreamLogger {
    protected SSHCommandRunner runner = null;
    protected InputStream stdout;
    protected InputStream stderr;
    protected static Logger log = Logger.getLogger(SplitStreamLogger.class.getName());
    StreamLogger sl_out;
    StreamLogger sl_err;

    public SplitStreamLogger(SSHCommandRunner runner) {
        this.runner = runner;
        this.stdout = runner.getStdoutStream();
        this.stderr = runner.getStdErrStream();
    }

    public SplitStreamLogger(InputStream stdout, InputStream stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public void log(Level outlevel, Level errlevel) {
        this.sl_out = new StreamLogger(this.stdout, outlevel, "Stdout");
        this.sl_err = new StreamLogger(this.stderr, errlevel, "Stderr");
        Thread out = new Thread(this.sl_out);
        Thread err = new Thread(this.sl_err);
        out.start();
        err.start();
    }

    public String getStdout() {
        return this.sl_out.toString();
    }

    public String getStderr() {
        return this.sl_err.toString();
    }

    public void log() {
        this.log(Level.INFO, Level.SEVERE);
    }

    class StreamLogger
    implements Runnable {
        protected String name;
        protected InputStream stream;
        protected Level level;
        protected StringBuffer sb = new StringBuffer();

        public StreamLogger(InputStream stream, Level level, String name) {
            this.name = name;
            this.stream = stream;
            this.level = level;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer stringBuffer = this.sb;
            synchronized (stringBuffer) {
                return this.sb.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    StringBuffer stringBuffer = this.sb;
                    synchronized (stringBuffer) {
                        this.sb.append(line + "\n");
                        log.log(this.level, String.format("%s: %s", this.name, line));
                    }
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

