(ns rp.metrics.timer.mem
  "Implementation of IRecordTime for in-memory use (such as tests)."
  (:require [rp.metrics.timer :as timer]))

(defrecord MemTimeRecorder [store]
  timer/IRecordTime
  (-record-time [this metric-name delta rate]
    (swap! store
           update
           metric-name
           (fnil conj  [])
           {:delta delta
            :rate rate})))

;; Convenience factory fn
(defn mem-time-recorder
  []
  (->MemTimeRecorder (atom {})))

(defn get-store
  [recorder]
  @(:store recorder))

(defn reset-store!
  [recorder]
  (reset! (:store recorder) {}))
