(ns rp.metrics.timer.statsd
  "Implementation of IRecordTime for StatsD.

  Assumes StatsD connection initialization is handled by `statsd-component`, even though the current clj-statsd library handles things statefully (in a \"hidden\" atom).
"
  (:require [clojure.string :as str]
            [clj-statsd :as statsd]
            [rp.metrics.timer :as timer]))

(defn sanitize-metric-name
  "StatsD will break if your metric name includes colons. Replaces colons and whitespace with underscores for this reason."
  [metric-name]
  (str/replace metric-name #"(:|\s)" "_"))

(defrecord StatsdTimeRecorder [statsd-component]
  ;; The above `statsd-component` goes unused, but future-proofs
  ;; referential transparency and makes clear
  ;; that this code expects the caller to handle
  ;; StatsD connection initialization.
  timer/IRecordTime
  (-record-time [this metric-name delta rate]
    (statsd/timing #_statsd-component
                   (sanitize-metric-name metric-name)
                   delta
                   rate)))
