(ns rp.metrics.timer
  "Abstractions for tracking the time it takes to evaluate code.")

(defprotocol IRecordTime
  (-record-time [this metric-name delta rate] "Record time spent as `delta`, using `metric-name` as the bucket, sending metrics at `rate` rate."))

(defmacro track-time
  "Macro that times execution of `body` and records it via an implementation of `-record-time`. Must be a macro so that the body is not evaluated before being timed. The rate of recording is currently hard-coded to 1.0 (to match StatsD default)."
  [irecord-time-impl metric-name & body]
  ;; TODO Consider use of more high-fidelity (System/nanoTime) as clojure.core/time does
  `(let [start# (System/currentTimeMillis)
         result# (do ~@body)
         delta# (- (System/currentTimeMillis) start#)]
     (-record-time ~irecord-time-impl ~metric-name delta# 1.0)
     result#))
