/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.authentication;

import com.redhat.reportengine.server.authentication.Password;
import com.redhat.reportengine.server.dbdata.AuthUserTable;
import com.redhat.reportengine.server.dbdata.LDAPTable;
import com.redhat.reportengine.server.dbmap.AuthUser;
import com.redhat.reportengine.server.dbmap.LDAPDetails;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.Logger;

public class Authentication {
    private static Logger _logger = Logger.getLogger(Authentication.class);
    public static final String AUTH_TYPE_INTERNAL = "Internal";
    public static final String AUTH_TYPE_LDAP = "LDAP";

    public boolean authenticate(String userName, String password, String authType) throws SQLException, NoSuchAlgorithmException {
        if (authType.equalsIgnoreCase(AUTH_TYPE_INTERNAL)) {
            return this.internalDB(userName, password);
        }
        return this.ldap(userName, password, authType);
    }

    public boolean ldap(String userName, String password, String ldapName) throws SQLException {
        LDAPDetails ldap = new LDAPTable().getByName(ldapName);
        boolean authenticated = false;
        Hashtable<String, String> environment = new Hashtable<String, String>(10);
        InitialLdapContext ldapContext = null;
        try {
            if (ldap.getUrl().startsWith("ldaps")) {
                environment.put("java.naming.security.authentication", "ssl");
            }
            environment.put("java.naming.security.authentication", "simple");
            environment.put("java.naming.security.principal", "uid=" + userName + "," + ldap.getBaseDn());
            environment.put("java.naming.security.credentials", password);
            environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            environment.put("java.naming.provider.url", ldap.getUrl());
            ldapContext = new InitialLdapContext(environment, null);
            if (ldapContext != null) {
                _logger.debug((Object)("Login Success[" + userName + "], LDAP: " + ldap.getName()));
                authenticated = true;
            }
        }
        catch (NamingException ex) {
            _logger.info((Object)("Login Failed[" + userName + "], LDAP: " + ldap.getName() + ", " + ex.getMessage()));
        }
        return authenticated;
    }

    public boolean internalDB(String userName, String password) throws SQLException, NoSuchAlgorithmException {
        AuthUser internalUser = new AuthUser();
        internalUser.setUserName(userName);
        internalUser = new AuthUserTable().getByName(internalUser);
        if (internalUser == null) {
            _logger.info((Object)("Internal Login Failed[" + userName + "], User not in DB!"));
            return false;
        }
        if (internalUser.getPassword().equals(new Password().getSaltedPassword(password, internalUser.getPasswordSalt()))) {
            _logger.info((Object)("Internal Login Success[" + userName + "]"));
            return true;
        }
        _logger.info((Object)("Internal Login Failed[" + userName + "], Wrong Password!"));
        return false;
    }
}

