/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;

public class Password {
    protected static final int DEFAULT_NEXT_BYTES_SIZE = 16;
    public static final int hashIterations = 1024;
    public static final String hashAlgorithmName = "SHA-512";

    public String getRandomSalt() {
        return this.getRandomSalt(16);
    }

    public String getRandomSalt(int nextByteSize) {
        byte[] bytes = new byte[nextByteSize];
        SecureRandom rnd = new SecureRandom();
        rnd.setSeed(bytes);
        rnd.nextBytes(bytes);
        return Base64.encodeBase64String((byte[])bytes);
    }

    public String getSaltedPassword(String plainPassword, String salt) throws NoSuchAlgorithmException {
        return this.getSaltedPassword(plainPassword, salt, 1024, hashAlgorithmName);
    }

    public String getSaltedPassword(String plainPassword, String salt, int hashIterations, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        digest.reset();
        digest.update(salt.getBytes());
        byte[] byteData = digest.digest(plainPassword.getBytes());
        for (int i = 0; i < hashIterations; ++i) {
            digest.reset();
            byteData = digest.digest(byteData);
        }
        return Base64.encodeBase64String((byte[])byteData);
    }
}

