/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.reports;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class General {
    public static final String guiInputDateFormat = "dd-MM-yyyy";
    public static final String dbDateFormat = "yyyy-MM-dd";
    public static final String dbDateTimeFormat = "yyyy-MM-dd HH:mm:ss.S";
    public static final String GUI_DATE_TIME = "MMM dd HH:mm:ss z yyyy";
    public static final String GUI_LOG_DATE_TIME = "MMM dd, HH:mm:ss.S z yyyy";
    public static final String GUI_TIME = "HH:mm:ss";

    public static String getColor(int value, boolean positive) {
        StringBuffer strValue = new StringBuffer("");
        String color = "red";
        if (value == 0) {
            return " (0)";
        }
        if (value > 0) {
            if (positive) {
                color = "green";
            }
        } else if (!positive) {
            color = "green";
        }
        strValue.append("<font color=\"");
        strValue.append(color);
        strValue.append("\"> (");
        if (value > 0) {
            strValue.append("+");
        }
        strValue.append(value).append(")</font>");
        return strValue.toString();
    }

    public static String getGuiDateTime(Date date) {
        if (date == null) {
            return "-";
        }
        return new SimpleDateFormat(GUI_DATE_TIME).format(date);
    }

    public static String getGuiLogDateTime(Date date) {
        if (date == null) {
            return "-";
        }
        return new SimpleDateFormat(GUI_LOG_DATE_TIME).format(date);
    }

    public static String getGuiDuration(long milliseconds) {
        if (milliseconds == 0L) {
            return "-";
        }
        return General.formatIntoHHMMSS(milliseconds);
    }

    public static String formatIntoHHMMSS(long milliseconds) {
        DecimalFormat df = new DecimalFormat("00");
        int seconds = (int)(milliseconds / 1000L) % 60;
        int minutes = (int)(milliseconds / 60000L % 60L);
        int hours = (int)(milliseconds / 3600000L);
        StringBuffer duration = new StringBuffer();
        duration.append(df.format(hours)).append(":").append(df.format(minutes)).append(":").append(df.format(seconds));
        return duration.toString();
    }

    public static String getBuildDetails(String buildInfo) {
        if (buildInfo == null) {
            return "-";
        }
        if (buildInfo.length() != 0) {
            return buildInfo.split("\n")[0].trim();
        }
        return buildInfo;
    }

    public static String getHtml(String string) {
        if (string == null) {
            return "-";
        }
        return string.replace("\n", "<br>");
    }

    public static String getScreenShotIconLink(String testStatus, String screenShot) {
        StringBuffer returnData = new StringBuffer();
        if (screenShot != null) {
            String[] screen = screenShot.split("=");
            returnData.append("<a href=\"getScreenShotImage.jsp?imageId=").append(screen[1]).append("\" title=\"File Name: ").append(screen[0] + "\" class=\"ajax\">").append("<img width=\"20\" height=\"20\"  src='../images/icons/").append(testStatus).append(".png' alt='").append(testStatus).append("'>").append("</a>");
        } else {
            returnData.append("<img width=\"20\" height=\"20\"  src='../images/icons/").append(testStatus).append(".png' alt='").append(testStatus).append("'>");
        }
        return returnData.toString();
    }

    public static String getNotNullString(Object string) {
        if (string == null) {
            return "-";
        }
        return string.toString();
    }

    public static String getHourMinute(Object string) {
        if (string == null) {
            return "-";
        }
        return new SimpleDateFormat(GUI_TIME).format((Date)string);
    }

    public static String getJobFrequency(Object frequency, Object weekDays) {
        if (frequency == null) {
            return "-";
        }
        if (((String)frequency).equalsIgnoreCase("OneTime")) {
            return (String)frequency;
        }
        return frequency + " [" + weekDays + "]";
    }

    public static String getLogFileString(Object string) {
        if (string == null) {
            return "";
        }
        return string.toString();
    }

    public static String getThrowableString(String throwable) {
        if (throwable == null) {
            return "";
        }
        return throwable.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String getLogLevelStr(String level) {
        if (level.equalsIgnoreCase("WARNING")) {
            return level.substring(0, 4);
        }
        return level;
    }
}

