/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.dbdata;

import com.redhat.reportengine.server.dbmap.TestSuite;
import com.redhat.reportengine.server.sql.SqlMap;
import java.sql.SQLException;
import java.util.ArrayList;

public class TestSuiteTable {
    private static final String GET_TEST_SUITE_BY_ID = "getTestSuiteById";
    private static final String GET_TEST_SUITE_BY_NAME_AND_REFF = "getTestSuiteByNameRef";
    private static final String GET_TEST_SUITES = "getTestSuites";
    private static final String GET_TOP_N_TEST_SUITES = "getTopNTestSuites";
    private static final String GET_TOP_N_TEST_SUITES_EXCLUDE_RUNNING = "getTopNTestSuitesExcludeRunning";
    private static final String GET_TREND_REPORT = "getTrendReportExcludeRunning";
    private static final String GET_TOP_N_TEST_REFERENCE_AGGREGATION_EXCLUDE_RUNNING = "getTopNTestReferenceAggregationExcludeRunning";
    private static final String GET_TEST_SUITES_NON_AGGREGATE = "getTestSuitesNonAggregate";
    private static final String GET_TEST_SUITES_RUNNING = "getTestSuitesRunning";
    private static final String GET_TOP_TEST_SUITE_BY_TEST_REFERENCE_IDS = "getTopTestSuitesByTestReferenceIds";
    private static final String GET_TEST_SUITE_AGGREGATION_BY_TEST_REFERENCE_ID = "getTestSuiteAggregationByReferenceId";
    private static final String INSERT_TEST_SUITE_AGGREGATION = "insertTestSuiteAggregation";
    private static final String ENABLE_TEST_SUITE_AGGREGATION_STATUS = "enableTestSuiteAggregationStatus";
    private static final String UPDATE_TEST_SUITE = "updateTestSuite";
    private static final String UPDATE_TEST_SUITE_NAME = "updateTestSuiteName";
    private static final String UPDATE_TEST_SUITE_STATUS_ID = "updateTestSuiteStatusById";
    private static final String INSERT_TEST_SUITE = "insertTestSuite";
    private static final String GET_TEST_SUITE_NEXT_SEQ_ID = "getTestSuiteNextId";
    private static final String DELETE_TEST_SUITE_BY_ID = "deleteTestSuiteById";

    public TestSuite get(int id) throws SQLException {
        return (TestSuite)SqlMap.getSqlMapClient().queryForObject(GET_TEST_SUITE_BY_ID, (Object)id);
    }

    public TestSuite getByNameAndRef(TestSuite testSuite) throws SQLException {
        return (TestSuite)SqlMap.getSqlMapClient().queryForObject(GET_TEST_SUITE_BY_NAME_AND_REFF, (Object)testSuite);
    }

    public ArrayList<TestSuite> getAll() throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TEST_SUITES);
    }

    public ArrayList<TestSuite> getTopN(TestSuite testSuite, boolean includeRunning) throws SQLException {
        if (includeRunning) {
            return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TOP_N_TEST_SUITES, (Object)testSuite);
        }
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TOP_N_TEST_SUITES_EXCLUDE_RUNNING, (Object)testSuite);
    }

    public ArrayList<TestSuite> getTopN(int topN, String orderBy, boolean includeRunning) throws SQLException {
        TestSuite testSuite = new TestSuite();
        testSuite.setTopN(topN);
        testSuite.setOrderBy(orderBy);
        return this.getTopN(testSuite, includeRunning);
    }

    public ArrayList<TestSuite> getTopN(int topN, String orderBy) throws SQLException {
        return this.getTopN(topN, orderBy, true);
    }

    public ArrayList<TestSuite> getTrendReport(TestSuite testSuite) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TREND_REPORT, (Object)testSuite);
    }

    public ArrayList<TestSuite> getTopNRefAggr(TestSuite testSuite) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TOP_N_TEST_REFERENCE_AGGREGATION_EXCLUDE_RUNNING, (Object)testSuite);
    }

    public ArrayList<TestSuite> getTopNRefAggr(int topN, String orderBy, int testReferenceId) throws SQLException {
        TestSuite testSuite = new TestSuite();
        testSuite.setTopN(topN);
        testSuite.setOrderBy(orderBy);
        testSuite.setTestReferenceId(testReferenceId);
        return this.getTopNRefAggr(testSuite);
    }

    public ArrayList<TestSuite> getTopNByRefIds(String referenceIds) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TOP_TEST_SUITE_BY_TEST_REFERENCE_IDS, (Object)referenceIds);
    }

    public ArrayList<TestSuite> getNonAggregate() throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TEST_SUITES_NON_AGGREGATE);
    }

    public ArrayList<TestSuite> getRunning() throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TEST_SUITES_RUNNING);
    }

    public TestSuite getAggregation(Integer testReferenceId) throws SQLException {
        return (TestSuite)SqlMap.getSqlMapClient().queryForObject(GET_TEST_SUITE_AGGREGATION_BY_TEST_REFERENCE_ID, (Object)testReferenceId);
    }

    public void add(TestSuite testSuite) throws SQLException {
        SqlMap.getSqlMapClient().insert(INSERT_TEST_SUITE, (Object)testSuite);
    }

    public void enableAggregationStatus(Integer testSuiteId) throws SQLException {
        SqlMap.getSqlMapClient().update(ENABLE_TEST_SUITE_AGGREGATION_STATUS, (Object)testSuiteId);
    }

    public void modify(TestSuite testSuite) throws SQLException {
        SqlMap.getSqlMapClient().update(UPDATE_TEST_SUITE, (Object)testSuite);
    }

    public void modifyName(TestSuite testSuite) throws SQLException {
        SqlMap.getSqlMapClient().update(UPDATE_TEST_SUITE_NAME, (Object)testSuite);
    }

    public void modifyStatus(TestSuite testSuite) throws SQLException {
        SqlMap.getSqlMapClient().update(UPDATE_TEST_SUITE_STATUS_ID, (Object)testSuite);
    }

    public void addAggregation(TestSuite testSuiteAggregation) throws SQLException {
        SqlMap.getSqlMapClient().insert(INSERT_TEST_SUITE_AGGREGATION, (Object)testSuiteAggregation);
    }

    public Integer getNextSeqId() throws SQLException {
        return (Integer)SqlMap.getSqlMapClient().queryForObject(GET_TEST_SUITE_NEXT_SEQ_ID);
    }

    public void remove(int testSuiteId) throws SQLException {
        SqlMap.getSqlMapClient().delete(DELETE_TEST_SUITE_BY_ID, (Object)testSuiteId);
    }
}

