/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.dbdata;

import com.redhat.reportengine.server.dbmap.DynamicTableName;
import com.redhat.reportengine.server.sql.SqlMap;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DynamicTableNameTable {
    private static Logger _logger = Logger.getLogger(DynamicTableNameTable.class);
    public static final String INSERT_DYNAMIC_TABLE_NAME = "insertDynamicTableName";
    public static final String GET_DYNAMIC_TABLE_NAME = "getDynamicTableName";
    public static final String GET_DYNAMIC_TABLE_NAME_BY_SERVER_ID = "getDynamicTableNameByServerId";
    public static final String GET_DYNAMIC_TABLE_NAME_BY_ID = "getDynamicTableNameById";
    public static final String GET_DYNAMIC_TABLE_NAME_BY_SERVER_ID_AND_TYPE = "getDynamicTableNameByServerIdAndType";
    public static final String DELETE_DYNAMIC_TABLE_NAME_BY_ID = "deleteDynamicTableNameById";
    public static final String DELETE_DYNAMIC_TABLE_NAME_BY_SERVER_ID = "deleteDynamicTableNameByServerId";
    public static final String DELETE_DYNAMIC_TABLE_NAME_BY_NAME = "deleteDynamicTableNameByName";
    public static final String DROP_DYNAMIC_TABLE = "dropDynamicTable";
    public static final String DROP_DYNAMIC_TABLE_SEQUENCE = "dropDynamicTableSequence";

    public static void add(String name, int serverId, DynamicTableName.TYPE type) throws SQLException {
        DynamicTableName tableName = new DynamicTableName();
        tableName.setServerId(serverId);
        tableName.setName(name);
        tableName.setTableType(type.toString());
        DynamicTableNameTable.add(tableName);
    }

    public static void add(DynamicTableName tableName) throws SQLException {
        SqlMap.getSqlMapClient().insert(INSERT_DYNAMIC_TABLE_NAME, (Object)tableName);
        _logger.debug((Object)("Added a row, " + tableName.getName()));
    }

    public static DynamicTableName get(String name) throws SQLException {
        return (DynamicTableName)SqlMap.getSqlMapClient().queryForObject(GET_DYNAMIC_TABLE_NAME, (Object)name);
    }

    public static DynamicTableName getById(int id) throws SQLException {
        return (DynamicTableName)SqlMap.getSqlMapClient().queryForObject(GET_DYNAMIC_TABLE_NAME_BY_ID, (Object)id);
    }

    public static ArrayList<DynamicTableName> get(int serverId) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_DYNAMIC_TABLE_NAME_BY_SERVER_ID, (Object)serverId);
    }

    public static ArrayList<DynamicTableName> get(DynamicTableName tableName) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_DYNAMIC_TABLE_NAME_BY_SERVER_ID_AND_TYPE, (Object)tableName);
    }

    public static ArrayList<DynamicTableName> get(int serverId, DynamicTableName.TYPE type) throws SQLException {
        DynamicTableName tableName = new DynamicTableName();
        tableName.setServerId(serverId);
        tableName.setTableType(type.toString());
        return DynamicTableNameTable.get(tableName);
    }

    public static void removeById(int id) throws SQLException {
        SqlMap.getSqlMapClient().delete(DELETE_DYNAMIC_TABLE_NAME_BY_ID, (Object)id);
    }

    public static void removeByName(String name) throws SQLException {
        SqlMap.getSqlMapClient().delete(DELETE_DYNAMIC_TABLE_NAME_BY_NAME, (Object)name);
    }

    public static void removeByServerId(int serverId) throws SQLException {
        SqlMap.getSqlMapClient().delete(DELETE_DYNAMIC_TABLE_NAME_BY_SERVER_ID, (Object)serverId);
    }

    public static void dropDynamicTable(String tableId) throws SQLException {
        SqlMap.getSqlMapClient().delete(DROP_DYNAMIC_TABLE, (Object)tableId);
    }

    public static void dropDynamicTableSequence(String tableId) throws SQLException {
        SqlMap.getSqlMapClient().delete(DROP_DYNAMIC_TABLE_SEQUENCE, (Object)tableId);
    }

    public static void dropDynamicTableAndSequence(String tableId) throws SQLException {
        DynamicTableNameTable.dropDynamicTable(tableId);
        DynamicTableNameTable.dropDynamicTableSequence(tableId);
    }
}

