/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.dbdata;

import com.redhat.reportengine.server.dbmap.JvmMemory;
import com.redhat.reportengine.server.dbmap.ResourceCpu;
import com.redhat.reportengine.server.sql.SqlMap;
import java.sql.SQLException;
import java.util.ArrayList;

public class JvmMemoryTable {
    public static final String CREATE_JVM_MEMORY_TABLE_SEQUENCE = "createJvmMemoryTableSequence";
    public static final String CREATE_JVM_MEMORY_TABLE = "createJvmMemoryTable";
    public static final String INSERT_JVM_MEMORY_USAGE = "insertJvmMemoryUsage";
    public static final String GET_JVM_MEMORY_USAGE = "getJvmMemoryUsage";
    public static final String GET_JVM_MEMORY_HEAP_USAGE_BY_TIME_RANGE = "getJvmMemoryHeapUsageByTimeRange";
    public static final String GET_JVM_MEMORY_NON_HEAP_USAGE_BY_TIME_RANGE = "getJvmMemoryNonHeapUsageByTimeRange";
    public static final String GET_JVM_MEMORY_USAGE_ROW_COUNT_BY_TIME_RANGE = "getJvmMemoryUsageCountByTimeRange";
    public static final String DROP_JVM_MEMORY_TABLE_SEQUENCE = "dropJvmMemoryTableSequence";
    public static final String DROP_JVM_MEMORY_TABLE = "dropJvmMemoryTable";

    public static String getTableSubName(String jvmName, int serverId) {
        return jvmName + "_" + serverId;
    }

    public void createTable(String subName) throws SQLException {
        SqlMap.getSqlMapClient().insert(CREATE_JVM_MEMORY_TABLE_SEQUENCE, (Object)subName);
        SqlMap.getSqlMapClient().insert(CREATE_JVM_MEMORY_TABLE, (Object)subName);
    }

    public void add(JvmMemory jvmMemory) throws SQLException {
        SqlMap.getSqlMapClient().insert(INSERT_JVM_MEMORY_USAGE, (Object)jvmMemory);
    }

    public ArrayList<ResourceCpu> get() throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_JVM_MEMORY_USAGE);
    }

    public ArrayList<JvmMemory> getHeapByTimeRange(JvmMemory jvmMemory) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_JVM_MEMORY_HEAP_USAGE_BY_TIME_RANGE, (Object)jvmMemory);
    }

    public ArrayList<JvmMemory> getNonHeapByTimeRange(JvmMemory jvmMemory) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_JVM_MEMORY_NON_HEAP_USAGE_BY_TIME_RANGE, (Object)jvmMemory);
    }

    public void dropTable(String subName) throws SQLException {
        SqlMap.getSqlMapClient().delete(DROP_JVM_MEMORY_TABLE, (Object)subName);
        SqlMap.getSqlMapClient().delete(DROP_JVM_MEMORY_TABLE_SEQUENCE, (Object)subName);
    }

    public Long getRowCount(JvmMemory jvmMemory) throws SQLException {
        return (Long)SqlMap.getSqlMapClient().queryForObject(GET_JVM_MEMORY_USAGE_ROW_COUNT_BY_TIME_RANGE, (Object)jvmMemory);
    }
}

