/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server;

import com.redhat.reportengine.server.cache.ServerSettings;
import com.redhat.reportengine.server.queue.actions.ManageQueues;
import com.redhat.reportengine.server.scheduler.ManageJobs;
import com.redhat.reportengine.server.scheduler.ManageScheduler;
import com.redhat.reportengine.server.sql.SqlMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class InitServer
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    static final Logger _logger = Logger.getLogger(InitServer.class);

    public void init() throws ServletException {
        try {
            ServerSettings.setBaseLocation((String)this.getServletContext().getRealPath("/"));
            System.out.println("Report Engine: Base Location: " + ServerSettings.getBaseLocation());
            System.setProperty("log4file.location", String.valueOf(ServerSettings.getBaseLocation()) + ServerSettings.getLog4jloglocation());
            PropertyConfigurator.configureAndWatch((String)(String.valueOf(ServerSettings.getBaseLocation()) + ServerSettings.getLog4jlocation()));
            SqlMap.setUpSqlClient();
            ServerSettings.updateSystemSettingsFromDB();
            _logger.info((Object)"Engine Settings are loaded successfully!!");
            new Thread((Runnable)new ManageScheduler()).start();
            Thread.sleep(5000L);
            ManageJobs.loadAllJobs();
            ManageQueues.startAllQueueManagers();
        }
        catch (Exception ex) {
            _logger.fatal((Object)"error, ", (Throwable)ex);
        }
    }

    public void destroy() {
        _logger.info((Object)"Shutdown application command has been issued! Shutting down services (Threads)...");
        ManageScheduler.shutdownScheduler();
        ManageQueues.stopAllQueueManagers();
        SqlMap.stopSqlMapClient();
        _logger.info((Object)"Shutdown all services (Threads) has been completed!!");
    }
}

