/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.ContextListener;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ReportEngineBasicStuffInitializer
implements ServletContextListener {
    public static final String DEFAULT_CONFIG = "${user.home}/.java/reportengine";
    public static final String REPORTENGINE_CONF_LOCATION = "conf/reportengine.properties";
    private static Properties reportEngineProperies;
    public static final String REPORTENGINE_HOME_DIR = "reportengine.home.dir";
    static Logger _logger;

    public void contextInitialized(ServletContextEvent sce) {
        if (System.getProperty(REPORTENGINE_HOME_DIR) == null) {
            String descriptorValue = sce.getServletContext().getInitParameter(REPORTENGINE_HOME_DIR);
            if (null == descriptorValue) {
                descriptorValue = DEFAULT_CONFIG;
                String[] matches = StringUtils.substringsBetween((String)descriptorValue, (String)"${", (String)"}");
                System.out.println("Value: " + descriptorValue);
                for (String match : matches) {
                    String propertyValue = System.getProperty(match);
                    String searchString = "${" + match + "}";
                    descriptorValue = StringUtils.replace((String)descriptorValue, (String)searchString, (String)propertyValue);
                }
            }
            if (!descriptorValue.endsWith("/")) {
                descriptorValue = descriptorValue + "/";
            }
            System.setProperty(REPORTENGINE_HOME_DIR, descriptorValue);
        }
        reportEngineProperies = new Properties();
        try {
            ReportEngineBasicStuffInitializer.checkDefaultConfigOnDisk(System.getProperty(REPORTENGINE_HOME_DIR));
            reportEngineProperies.load(new FileInputStream(System.getProperty(REPORTENGINE_HOME_DIR) + REPORTENGINE_CONF_LOCATION));
            Enumeration<Object> em = reportEngineProperies.keys();
            while (em.hasMoreElements()) {
                String key = (String)em.nextElement();
                System.setProperty(key.trim(), reportEngineProperies.getProperty(key.trim()).trim());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.setProperty("log4j.conf.file", System.getProperty(REPORTENGINE_HOME_DIR) + System.getProperty("log4j.conf.file"));
        System.setProperty("log4j.log.file", System.getProperty(REPORTENGINE_HOME_DIR) + System.getProperty("log4j.log.file"));
        ReportEngineBasicStuffInitializer.initializeLog4j();
    }

    private static void checkDefaultConfigOnDisk(String confLocation) {
        System.out.println("Checking Conf File....");
        File destDir = new File(confLocation);
        System.out.println("***  Dir Size: " + FileUtils.sizeOfDirectory((File)destDir));
        if (destDir.exists() && FileUtils.sizeOfDirectory((File)destDir) > 0L) {
            System.out.println("Already available! no need to create, Location:" + confLocation);
            return;
        }
        try {
            File resource = new File(new URI(ReportEngineBasicStuffInitializer.class.getResource("/").toString()));
            FileFilter confFileFilter = new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().contains("/conf");
                }
            };
            FileUtils.cleanDirectory((File)destDir);
            FileUtils.copyDirectory((File)resource, (File)destDir, (FileFilter)confFileFilter);
            System.out.println("Configurations files copied to: " + destDir.getAbsolutePath());
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        System.out.println("Check conf file Done....");
    }

    public static void initializeLog4j() {
        new File(System.getProperty("log4j.log.file")).getParentFile().mkdirs();
        System.out.println("log4j Configuration File:" + System.getProperty("log4j.conf.file"));
        System.out.println("Log4j Log fine: " + System.getProperty("log4j.log.file"));
        PropertyConfigurator.configureAndWatch((String)System.getProperty("log4j.conf.file"));
        _logger.debug((Object)("log4j:" + System.getProperty("log4j.conf.file")));
        _logger.debug((Object)("LOG: " + System.getProperty("log4j.log.file")));
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    public static Properties getReportEngineProperies() {
        return reportEngineProperies;
    }

    static {
        _logger = Logger.getLogger(ReportEngineBasicStuffInitializer.class);
    }
}

