/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.ClientCommon;
import com.redhat.reportengine.client.RemoteAPI;
import java.net.InetAddress;
import java.util.Arrays;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.internal.IResultListener;

public class ReportEngineTestNGListner
implements IResultListener,
ISuiteListener {
    private static RemoteAPI reportEngine = new RemoteAPI();

    public ReportEngineTestNGListner() throws Exception {
        reportEngine.initClient(InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "]");
    }

    public String getParametersString(Object[] parameters) {
        String parametersString = "";
        if (parameters != null && parameters.length > 0) {
            parametersString = Arrays.deepToString(parameters);
        }
        return parametersString;
    }

    public void onFinish(ITestContext context) {
        if (reportEngine.isClientConfigurationSuccess()) {
            // empty if block
        }
    }

    public void onStart(ITestContext context) {
        if (reportEngine.isClientConfigurationSuccess()) {
            try {
                reportEngine.insertTestGroup(context.getName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult arg0) {
    }

    public void onTestFailure(ITestResult result) {
        if (reportEngine.isClientConfigurationSuccess()) {
            try {
                reportEngine.takeScreenShot();
                reportEngine.updateTestCase("Failed", ClientCommon.toString(result.getThrowable()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onTestSkipped(ITestResult result) {
        if (reportEngine.isClientConfigurationSuccess()) {
            try {
                if (reportEngine.isLastTestStateRunning()) {
                    reportEngine.updateTestCase("Skipped");
                } else {
                    reportEngine.insertTestCase(result.getName(), result.getName() + "(" + this.getParametersString(result.getParameters()) + ")", "Skipped");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onTestStart(ITestResult test) {
        if (reportEngine.isClientConfigurationSuccess()) {
            try {
                reportEngine.insertTestCase(test.getName(), test.getName() + "(" + this.getParametersString(test.getParameters()) + ")", "Running");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onTestSuccess(ITestResult result) {
        if (reportEngine.isClientConfigurationSuccess()) {
            try {
                reportEngine.updateTestCase("Passed");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onConfigurationFailure(ITestResult arg0) {
        if (reportEngine.isClientConfigurationSuccess()) {
            reportEngine.runLogHandler();
        }
    }

    public void onConfigurationSkip(ITestResult arg0) {
        if (reportEngine.isClientConfigurationSuccess()) {
            reportEngine.runLogHandler();
        }
    }

    public void onConfigurationSuccess(ITestResult arg0) {
        if (reportEngine.isClientConfigurationSuccess()) {
            reportEngine.runLogHandler();
        }
    }

    public void onFinish(ISuite suite) {
        if (reportEngine.isClientConfigurationSuccess()) {
            try {
                reportEngine.updateTestSuite("Completed", ReportEngineTestNGListner.getBuildVersion());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onStart(ISuite suite) {
        if (reportEngine.isClientConfigurationSuccess()) {
            try {
                reportEngine.updateTestSuiteName(suite.getName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String getBuildVersion() {
        return System.getProperty(reportEngine.getBuildVersionReference());
    }
}

