/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.jobs;

import com.redhat.reportengine.server.dbdata.FileStorageTable;
import com.redhat.reportengine.server.dbmap.FileStorage;
import com.redhat.reportengine.server.dbmap.TestCase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class ImportImagesToDB {
    private static String screenShotLocation = "/opt/jeeva/temp";
    private static Logger _logger = Logger.getLogger(ImportImagesToDB.class);

    public static void importImagesToDatabase() throws SQLException, IOException {
        ArrayList testCases = new FileStorageTable().getScreenShotFilesAll();
        FileStorage fileStorage = new FileStorage();
        for (TestCase testCase : testCases) {
            fileStorage.setCreationTime(new Date());
            fileStorage.setFileName(testCase.getTestGuiFiles());
            fileStorage.setTestCaseId(testCase.getId());
            fileStorage.setScreenShot(true);
            File screenShot = new File(screenShotLocation + "/" + testCase.getTestGuiFiles());
            if (!screenShot.exists()) {
                _logger.warn((Object)("File Not Found: " + screenShotLocation + "/" + testCase.getTestGuiFiles()));
                continue;
            }
            byte[] screenShotByte = new byte[(int)screenShot.length()];
            FileInputStream in = new FileInputStream(screenShot);
            in.read(screenShotByte);
            in.close();
            fileStorage.setFileByte(screenShotByte);
            new FileStorageTable().add(fileStorage);
        }
    }
}

