/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.queue.actions;

import com.redhat.reportengine.server.dbdata.TestLogsTable;
import com.redhat.reportengine.server.dbmap.TestLogs;
import com.redhat.reportengine.server.queue.TestLogsQueue;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class InsertUpdateTestLogs
implements Runnable {
    private static Logger _logger = Logger.getLogger(InsertUpdateTestLogs.class);
    private static boolean stopMe = false;
    private static boolean stopMeImmeditate = false;
    private TestLogs testLogs = null;

    public void run() {
        _logger.info((Object)"Started Test Logs Queue Manager...");
        while (!stopMeImmeditate) {
            if (TestLogsQueue.getTestLogSize() > 0) {
                this.insertTestLogs();
            } else {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    _logger.error((Object)"Thread sleep exception,", (Throwable)ex);
                }
            }
            if (!stopMe || TestLogsQueue.getTestLogSize() != 0) continue;
            _logger.info((Object)"Stopping Test Logs Queue Manager...");
            break;
        }
        _logger.info((Object)"Stopped Test Logs Queue Manager..");
    }

    private void insertTestLogs() {
        try {
            this.testLogs = TestLogsQueue.getFirstTestLog();
            _logger.debug((Object)("Original Log: " + this.testLogs));
            if (this.testLogs.getThrowable() != null && this.testLogs.getThrowable().length() > 10000) {
                this.testLogs.setThrowable(this.testLogs.getThrowable().substring(0, 9999));
                _logger.warn((Object)"Test Log 'Throwable' size has been truncated to 10000 chars, Portion of data has been dropped!!");
            }
            if (this.testLogs.getMessage().length() > 10000) {
                _logger.warn((Object)"Limited message size to 10000 chars length! Portion of data has been dropped!!");
                this.testLogs.setMessage(this.testLogs.getMessage().substring(0, 9999));
            }
            new TestLogsTable().add(this.testLogs);
        }
        catch (SQLException ex) {
            _logger.error((Object)"Error on Test Log insertion,", (Throwable)ex);
        }
    }

    public static boolean isStopMeEnabled() {
        return stopMe;
    }

    public static void setStopMe(boolean stopMe) {
        InsertUpdateTestLogs.stopMe = stopMe;
    }

    public static boolean isStopMeImmeditate() {
        return stopMeImmeditate;
    }

    public static void setStopMeImmeditate(boolean stopMeImmeditate) {
        InsertUpdateTestLogs.stopMeImmeditate = stopMeImmeditate;
    }
}

