/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.scheduler;

import com.redhat.reportengine.server.dbdata.JobSchedulerTable;
import com.redhat.reportengine.server.dbmap.JobScheduler;
import com.redhat.reportengine.server.scheduler.JobDetails;
import com.redhat.reportengine.server.scheduler.ManageScheduler;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.SchedulerException;

public class ManageJobs {
    static final Logger _logger = Logger.getLogger(ManageJobs.class);
    static String jobGroupName = "reportEngineJobGroup";
    static String triggerGroupName = "reportEngineTriggerGroup";

    public static void addAllJobsInScheduler() {
        JobDetails job = new JobDetails();
        job.setTriggerGroupName(triggerGroupName);
        job.setJobName("System Job - Test Suite Aggregation");
        job.setJobTargetClass("com.redhat.reportengine.server.jobs.TestSuiteAggregationImpl");
        job.setJobFromTime(new Date());
        job.setJobGroupName(jobGroupName);
        job.setRepeatInterval(1800000L);
        job.setRepeatCount(-1);
        ManageScheduler.addNewSimpleJob(job);
        job.setJobName("System Job - Update Job Status");
        job.setJobTargetClass("com.redhat.reportengine.server.jobs.UpdateJobStatus");
        ManageScheduler.addNewSimpleJob(job);
    }

    public static void addAJobInScheduler(int id) throws SQLException {
        ManageJobs.addJobInscheduler(new JobSchedulerTable().get(Integer.valueOf(id)));
    }

    public static void addAJobInScheduler(String jobName) throws SQLException {
        ManageJobs.addJobInscheduler(new JobSchedulerTable().get(jobName));
    }

    public static boolean removeAJobFromScheduler(int id) throws ParseException, SchedulerException, SQLException {
        return ManageJobs.removeAJobFromScheduler(new JobSchedulerTable().get(Integer.valueOf(id)).getJobName());
    }

    public static boolean removeAJobFromScheduler(String jobName) throws ParseException, SchedulerException {
        return ManageScheduler.removeJob(jobName, jobGroupName);
    }

    public static void loadAllJobs() throws SQLException {
        ArrayList jobs = new JobSchedulerTable().getAll();
        for (JobScheduler job : jobs) {
            ManageJobs.addJobInscheduler(job);
        }
    }

    private static void addJobInscheduler(JobScheduler jobScheduler) {
        if (!jobScheduler.isJobEnabled()) {
            _logger.debug((Object)("[" + jobScheduler.getJobName() + "] Job has been disabled.. Skipped to update in scheduler..."));
            return;
        }
        JobDetails job = new JobDetails();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("id", jobScheduler.getDataReferenceId());
        job.setTriggerGroupName(triggerGroupName);
        job.setJobName(jobScheduler.getJobName());
        job.setJobTargetClass(jobScheduler.getTargetClass());
        job.setJobDataMap(jobDataMap);
        if (jobScheduler.getValidFromTime() != null) {
            job.setJobFromTime(jobScheduler.getValidFromTime());
        } else {
            job.setJobFromTime(new Date());
        }
        if (jobScheduler.getValidToTime() != null) {
            job.setJobToTime(jobScheduler.getValidToTime());
        }
        job.setJobGroupName(jobGroupName);
        if (jobScheduler.isSimpleJob()) {
            job.setRepeatInterval((long)jobScheduler.getRepeatInterval().intValue() * 1000L);
            job.setRepeatCount(jobScheduler.getRepeatCount());
            ManageScheduler.addNewSimpleJob(job);
            return;
        }
        if (jobScheduler.getCronExpression() != null) {
            job.setJobCronExpression(jobScheduler.getCronExpression());
        } else {
            String cornExpression = "";
            String cronSeconds = new SimpleDateFormat("ss").format(jobScheduler.getJobExecutionTime());
            String cronMinutes = new SimpleDateFormat("mm").format(jobScheduler.getJobExecutionTime());
            String cronHours = new SimpleDateFormat("HH").format(jobScheduler.getJobExecutionTime());
            String cronSHM = cronSeconds + " " + cronMinutes + " " + cronHours;
            if (jobScheduler.getJobFrequency().equalsIgnoreCase("Daily")) {
                cornExpression = cronSHM + " ? * " + jobScheduler.getJobWeekday();
            } else if (jobScheduler.getJobFrequency().equalsIgnoreCase("Weekly")) {
                cornExpression = cronSHM + " ? * " + jobScheduler.getJobWeekday();
            } else if (jobScheduler.getJobFrequency().equalsIgnoreCase("Monthly")) {
                cornExpression = cronSHM + " " + jobScheduler.getJobDayMonth() + " * ?";
            } else if (jobScheduler.getJobFrequency().equalsIgnoreCase("OneTime")) {
                cornExpression = cronSHM + " " + new SimpleDateFormat("d").format(jobScheduler.getValidFromTime()) + " " + new SimpleDateFormat("MM").format(jobScheduler.getValidFromTime()) + " ? " + new SimpleDateFormat("yyyy").format(jobScheduler.getValidFromTime());
            }
            _logger.debug((Object)("Job Corn Expression: " + cornExpression));
            job.setJobCronExpression(cornExpression);
        }
        if (jobScheduler.getValidToTime() != null && jobScheduler.getValidToTime().before(new Date())) {
            _logger.info((Object)("This job got expired! --> Job Name: " + jobScheduler.getJobName()));
            return;
        }
        ManageScheduler.addNewCronJob(job);
    }
}

