/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.api;

import com.redhat.reportengine.server.api.TestResultException;
import com.redhat.reportengine.server.dbdata.FileStorageTable;
import com.redhat.reportengine.server.dbdata.TestCaseTable;
import com.redhat.reportengine.server.dbdata.TestGroupTable;
import com.redhat.reportengine.server.dbdata.TestReferenceTable;
import com.redhat.reportengine.server.dbdata.TestSuiteTable;
import com.redhat.reportengine.server.dbmap.FileStorage;
import com.redhat.reportengine.server.dbmap.TestCase;
import com.redhat.reportengine.server.dbmap.TestGroup;
import com.redhat.reportengine.server.dbmap.TestLogs;
import com.redhat.reportengine.server.dbmap.TestReference;
import com.redhat.reportengine.server.dbmap.TestSuite;
import com.redhat.reportengine.server.jobs.system.TestSuiteAggregationImpl;
import com.redhat.reportengine.server.queue.TestLogsQueue;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class TestResult {
    private static Logger _logger = Logger.getLogger(TestResult.class);

    public Date getServerTime() {
        return new Date();
    }

    public void insertTestSuite(TestSuite testSuite) throws TestResultException {
        try {
            TestReference testReference = new TestReference();
            testReference.setTestReference(testSuite.getTestReference());
            testReference = new TestReferenceTable().get(testReference);
            if (testReference == null) {
                testReference = new TestReference();
                int id = new TestReferenceTable().getNextSeqId();
                testReference.setId(id);
                testReference.setTestReference(testSuite.getTestReference());
                testReference.setCreationTime(new Date());
                new TestReferenceTable().add(testReference);
            }
            testSuite.setTestReferenceId(testReference.getId());
            testSuite.setLocalStartTime(new Date());
            _logger.debug((Object)("Test Suite Status: " + testSuite.getTestStatus()));
            new TestSuiteTable().add(testSuite);
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
            throw new TestResultException(ex.getMessage());
        }
    }

    public void updateTestSuiteName(TestSuite testSuite) throws TestResultException {
        try {
            _logger.debug((Object)("Test Suite Status: " + testSuite.getTestSuiteName()));
            new TestSuiteTable().modifyName(testSuite);
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
            throw new TestResultException(ex.getMessage());
        }
    }

    public void updateTestSuite(TestSuite testSuite) throws TestResultException {
        try {
            _logger.debug((Object)("Test Suite Status: " + testSuite.getTestStatus()));
            testSuite.setLocalEndTime(new Date());
            new TestSuiteTable().modify(testSuite);
            if (testSuite.getTestStatus() != null && !testSuite.getTestStatus().equalsIgnoreCase("Running")) {
                TestSuiteAggregationImpl.doAggregateTestSuite();
            }
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
            throw new TestResultException(ex.getMessage());
        }
    }

    public int getTestSuiteNextAvailableId() throws TestResultException {
        try {
            return new TestSuiteTable().getNextSeqId();
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
            throw new TestResultException(ex.getMessage());
        }
    }

    public TestSuite getTestSuite(int id) throws TestResultException {
        try {
            _logger.debug((Object)("Test ID: " + id));
            return new TestSuiteTable().get(id);
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
            throw new TestResultException(ex.getMessage());
        }
    }

    public TestSuite getTestSuite(TestSuite testSuite) throws TestResultException {
        try {
            _logger.debug((Object)("Test Suite: " + testSuite.getTestSuiteName()));
            return new TestSuiteTable().getByNameAndRef(testSuite);
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
            throw new TestResultException(ex.getMessage());
        }
    }

    public TestGroup insertTestGroup(TestGroup testGroup) throws TestResultException {
        try {
            _logger.debug((Object)("Input --> ID: " + testGroup.getId() + ", TestSuiteId: " + testGroup.getTestSuiteId() + ", TestGroup: " + testGroup.getTestGroup()));
            TestGroup tmpGroup = new TestGroupTable().getByTestSuiteIdAndGroupName(testGroup);
            if (tmpGroup == null) {
                testGroup.setLocalTime(new Date());
                new TestGroupTable().add(testGroup);
                tmpGroup = new TestGroupTable().getByTestSuiteIdAndGroupName(testGroup);
            } else {
                _logger.debug((Object)("Specified Group already available! --> ID: " + tmpGroup.getId() + ", TestTitleId: " + tmpGroup.getTestSuiteId() + ", TestGroup: " + tmpGroup.getTestGroup()));
            }
            return tmpGroup;
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
            throw new TestResultException(ex.getMessage());
        }
    }

    public int insertTestCase(TestCase testCase) throws TestResultException {
        try {
            testCase.setLocalStartTime(new Date());
            new TestCaseTable().add(testCase);
            testCase = new TestCaseTable().getId(testCase);
            return testCase.getId();
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
            throw new TestResultException(ex.getMessage());
        }
    }

    public void updateTestCase(TestCase testCase) throws TestResultException, IOException {
        try {
            testCase.setLocalEndTime(new Date());
            if (testCase.getScreenShotFileName() != null) {
                _logger.debug((Object)("Screen Shot File Name: " + testCase.getScreenShotFileName()));
                FileStorage fileStorage = new FileStorage();
                fileStorage.setCreationTime(new Date());
                fileStorage.setFileName(testCase.getScreenShotFileName());
                fileStorage.setTestCaseId(testCase.getId());
                fileStorage.setScreenShot(true);
                if (testCase.getScreenShotFileByte() != null) {
                    fileStorage.setFileByte(testCase.getScreenShotFileByte());
                } else {
                    fileStorage.setFileByte(Base64.decodeBase64((byte[])testCase.getScreenShotFileBase64().getBytes()));
                }
                new FileStorageTable().add(fileStorage);
            }
            if (testCase.getTestComments() != null && testCase.getTestComments().length() > 10000) {
                testCase.setTestComments(testCase.getTestComments().substring(0, 9999));
                _logger.warn((Object)"Test Case comments size has been truncated to 10000 chars, Portion of data has been dropped!!");
            }
            new TestCaseTable().modify(testCase);
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
            throw new TestResultException(ex.getMessage());
        }
    }

    public void insertTestLog(TestLogs testLogs) throws TestResultException {
        testLogs.setLocalTime(new Date());
        TestLogsQueue.addTestLog(testLogs);
    }
}

