/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.insert;

import com.redhat.reportengine.agent.rest.mapper.UsageCpu;
import com.redhat.reportengine.server.dbdata.ResourceCpuTable;
import com.redhat.reportengine.server.dbmap.ResourceCpu;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class InsertCpuUsage
implements Runnable {
    private static Logger _logger = Logger.getLogger(InsertCpuUsage.class);
    private int serverId;
    private UsageCpu usageCpu;

    public InsertCpuUsage(int serverId, UsageCpu usageCpu) {
        this.serverId = serverId;
        this.usageCpu = usageCpu;
    }

    public void updateCpuUsage(int serverId, UsageCpu usageCpu) {
        ResourceCpu resourceCpu = new ResourceCpu();
        resourceCpu.setLocalTime(new Date());
        resourceCpu.setTableSubName(ResourceCpuTable.getCoreCpuSubName((int)serverId));
        try {
            resourceCpu.setCombined(Float.valueOf((float)usageCpu.getCpu().getCombined()));
            resourceCpu.setIdle(Float.valueOf((float)usageCpu.getCpu().getIdle()));
            resourceCpu.setIrq(Float.valueOf((float)usageCpu.getCpu().getIrq()));
            resourceCpu.setNice(Float.valueOf((float)usageCpu.getCpu().getNice()));
            resourceCpu.setSoftIrq(Float.valueOf((float)usageCpu.getCpu().getSoftIrq()));
            resourceCpu.setStolen(Float.valueOf((float)usageCpu.getCpu().getStolen()));
            resourceCpu.setSys(Float.valueOf((float)usageCpu.getCpu().getSys()));
            resourceCpu.setUser(Float.valueOf((float)usageCpu.getCpu().getUser()));
            resourceCpu.setWait(Float.valueOf((float)usageCpu.getCpu().getWait()));
            resourceCpu.setRemoteTime(new Date(usageCpu.getTime()));
            new ResourceCpuTable().add(resourceCpu);
        }
        catch (SQLException ex) {
            if (ex.getMessage().contains("does not exist")) {
                try {
                    new ResourceCpuTable().createTable(resourceCpu.getTableSubName());
                    new ResourceCpuTable().add(resourceCpu);
                }
                catch (SQLException e) {
                    _logger.error((Object)"Exception, ", (Throwable)ex);
                }
            }
            _logger.error((Object)"Exception, ", (Throwable)ex);
        }
    }

    public void run() {
        this.updateCpuUsage(this.serverId, this.usageCpu);
    }
}

