/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.insert;

import com.redhat.reportengine.agent.rest.mapper.UsageCpus;
import com.redhat.reportengine.server.dbdata.ResourceCpuTable;
import com.redhat.reportengine.server.dbmap.ResourceCpu;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.hyperic.sigar.CpuPerc;

public class InsertCpusUsage
implements Runnable {
    private static Logger _logger = Logger.getLogger(InsertCpusUsage.class);
    private int serverId;
    private UsageCpus usageCpus;

    public InsertCpusUsage() {
    }

    public InsertCpusUsage(int serverId, UsageCpus usageCpus) {
        this.serverId = serverId;
        this.usageCpus = usageCpus;
    }

    private ResourceCpu getResourceCpu(CpuPerc cpuPerc, ResourceCpu resourceCpu) {
        resourceCpu.setCombined(Float.valueOf((float)cpuPerc.getCombined()));
        resourceCpu.setIdle(Float.valueOf((float)cpuPerc.getIdle()));
        resourceCpu.setIrq(Float.valueOf((float)cpuPerc.getIrq()));
        resourceCpu.setNice(Float.valueOf((float)cpuPerc.getNice()));
        resourceCpu.setSoftIrq(Float.valueOf((float)cpuPerc.getSoftIrq()));
        resourceCpu.setStolen(Float.valueOf((float)cpuPerc.getStolen()));
        resourceCpu.setSys(Float.valueOf((float)cpuPerc.getSys()));
        resourceCpu.setUser(Float.valueOf((float)cpuPerc.getUser()));
        resourceCpu.setWait(Float.valueOf((float)cpuPerc.getWait()));
        return resourceCpu;
    }

    public void updateCpusUsage(int serverId, UsageCpus usageCpus) {
        ResourceCpu resourceCpu = new ResourceCpu();
        resourceCpu.setLocalTime(new Date());
        try {
            resourceCpu.setTableSubName(ResourceCpuTable.getCoreCpuSubName((int)serverId));
            resourceCpu.setRemoteTime(new Date(usageCpus.getTime()));
            new ResourceCpuTable().add(this.getResourceCpu(usageCpus.getCpu(), resourceCpu));
            for (int i = 0; i < usageCpus.getCpus().length; ++i) {
                try {
                    resourceCpu.setTableSubName(ResourceCpuTable.getMultiCpuSubName((int)serverId, (int)i));
                    resourceCpu.setRemoteTime(new Date(usageCpus.getTime()));
                    new ResourceCpuTable().add(this.getResourceCpu(usageCpus.getCpus()[i], resourceCpu));
                    continue;
                }
                catch (SQLException ex) {
                    if (!ex.getMessage().contains("does not exist")) continue;
                    new ResourceCpuTable().createTable(resourceCpu.getTableSubName());
                    new ResourceCpuTable().add(resourceCpu);
                }
            }
        }
        catch (SQLException ex) {
            if (ex.getMessage().contains("does not exist")) {
                try {
                    new ResourceCpuTable().createTable(resourceCpu.getTableSubName());
                    new ResourceCpuTable().add(resourceCpu);
                }
                catch (SQLException e) {
                    _logger.error((Object)"Exception, ", (Throwable)ex);
                }
            }
            _logger.error((Object)"Exception, ", (Throwable)ex);
        }
    }

    public void run() {
        this.updateCpusUsage(this.serverId, this.usageCpus);
    }
}

