/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.jobs.system;

import com.redhat.reportengine.agent.rest.mapper.CpuInformation;
import com.redhat.reportengine.agent.rest.mapper.NetworkInfo;
import com.redhat.reportengine.agent.rest.mapper.OsDetail;
import com.redhat.reportengine.agent.rest.mapper.UsageMemory;
import com.redhat.reportengine.server.dbdata.ServerCpuDetailTable;
import com.redhat.reportengine.server.dbdata.ServerMemoryDetailTable;
import com.redhat.reportengine.server.dbdata.ServerNetworkDetailTable;
import com.redhat.reportengine.server.dbdata.ServerOsDetailTable;
import com.redhat.reportengine.server.dbdata.ServerStatusTable;
import com.redhat.reportengine.server.dbdata.ServerTable;
import com.redhat.reportengine.server.dbmap.Server;
import com.redhat.reportengine.server.dbmap.ServerCpuDetail;
import com.redhat.reportengine.server.dbmap.ServerMemoryDetail;
import com.redhat.reportengine.server.dbmap.ServerNetworkDetail;
import com.redhat.reportengine.server.dbmap.ServerOsDetail;
import com.redhat.reportengine.server.dbmap.ServerStatus;
import com.redhat.reportengine.server.restclient.agent.AgentsConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.hyperic.sigar.SysInfo;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ServerAgentReachableStatus
implements Job {
    private static Logger _logger = Logger.getLogger(ServerAgentReachableStatus.class);

    public void updateServerCpuDetail(int serverId) {
        block5: {
            try {
                CpuInformation cpuInformation = (CpuInformation)AgentsConnection.getRestJSONclient(serverId).get("/conf/cpu", CpuInformation.class);
                ServerCpuDetail serverCpuDetail = new ServerCpuDetailTable().getByServerId(serverId);
                if (serverCpuDetail == null) {
                    serverCpuDetail = new ServerCpuDetail();
                }
                serverCpuDetail.setCacheSize(cpuInformation.getCacheSize());
                serverCpuDetail.setCoresPerSocket(cpuInformation.getCoresPerSocket());
                serverCpuDetail.setMhz(cpuInformation.getMhz());
                serverCpuDetail.setModel(cpuInformation.getModel());
                serverCpuDetail.setRemoteTime(new Date(cpuInformation.getTime()));
                serverCpuDetail.setTotalCores(cpuInformation.getTotalCores());
                serverCpuDetail.setTotalSockets(cpuInformation.getTotalSockets());
                serverCpuDetail.setVendor(cpuInformation.getVendor());
                serverCpuDetail.setRemoteTime(new Date(cpuInformation.getTime()));
                serverCpuDetail.setServerId(Integer.valueOf(serverId));
                if (serverCpuDetail.getId() == null) {
                    new ServerCpuDetailTable().add(serverCpuDetail);
                } else {
                    new ServerCpuDetailTable().update(serverCpuDetail);
                }
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("refused")) break block5;
                _logger.error((Object)"Error, ", (Throwable)ex);
            }
        }
    }

    public void updateServerOsDetail(int serverId) {
        block5: {
            try {
                OsDetail osDetail = (OsDetail)AgentsConnection.getRestJSONclient(serverId).get("/conf/os", OsDetail.class);
                ServerOsDetail serverOsDetail = new ServerOsDetailTable().getByServerId(serverId);
                if (serverOsDetail == null) {
                    serverOsDetail = new ServerOsDetail();
                }
                serverOsDetail.setArch(osDetail.getOperatingSystem().getArch());
                serverOsDetail.setCpuEndian(osDetail.getOperatingSystem().getCpuEndian());
                serverOsDetail.setDataModel(osDetail.getOperatingSystem().getDataModel());
                serverOsDetail.setDescription(osDetail.getOperatingSystem().getDescription());
                serverOsDetail.setMachine(osDetail.getOperatingSystem().getMachine());
                serverOsDetail.setName(osDetail.getOperatingSystem().getName());
                serverOsDetail.setPatchLevel(osDetail.getOperatingSystem().getPatchLevel());
                serverOsDetail.setVendor(osDetail.getOperatingSystem().getVendor());
                serverOsDetail.setVendorCodeName(osDetail.getOperatingSystem().getVendorCodeName());
                serverOsDetail.setVendorName(osDetail.getOperatingSystem().getVendorName());
                serverOsDetail.setVendorVersion(osDetail.getOperatingSystem().getVendorVersion());
                serverOsDetail.setKernelVersion(osDetail.getOperatingSystem().getVersion());
                serverOsDetail.setRemoteTime(new Date(osDetail.getTime()));
                serverOsDetail.setServerId(Integer.valueOf(serverId));
                if (serverOsDetail.getId() == null) {
                    new ServerOsDetailTable().add(serverOsDetail);
                } else {
                    new ServerOsDetailTable().update(serverOsDetail);
                }
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("refused")) break block5;
                _logger.error((Object)"Error, ", (Throwable)ex);
            }
        }
    }

    public void updateServerNetworkDetail(int serverId) {
        block5: {
            try {
                NetworkInfo networkInfo = (NetworkInfo)AgentsConnection.getRestJSONclient(serverId).get("/conf/nw", NetworkInfo.class);
                ServerNetworkDetail serverNetworkDetail = new ServerNetworkDetailTable().getByServerId(serverId);
                if (serverNetworkDetail == null) {
                    serverNetworkDetail = new ServerNetworkDetail();
                }
                serverNetworkDetail.setBroadcast(networkInfo.getNetInterfaceConfig().getBroadcast());
                serverNetworkDetail.setDefaultGateway(networkInfo.getNetInfo().getDefaultGateway());
                serverNetworkDetail.setDestination(networkInfo.getNetInterfaceConfig().getDestination());
                serverNetworkDetail.setDomainName(networkInfo.getNetInfo().getDomainName());
                serverNetworkDetail.setFlags(Long.valueOf(networkInfo.getNetInterfaceConfig().getFlags()));
                serverNetworkDetail.setHostname(networkInfo.getNetInfo().getHostName());
                serverNetworkDetail.setInterfaceDescription(networkInfo.getNetInterfaceConfig().getDescription());
                serverNetworkDetail.setInterfaceName(networkInfo.getNetInterfaceConfig().getName());
                serverNetworkDetail.setInterfaceType(networkInfo.getNetInterfaceConfig().getType());
                serverNetworkDetail.setIpAddress(networkInfo.getNetInterfaceConfig().getAddress());
                serverNetworkDetail.setMac(networkInfo.getNetInterfaceConfig().getHwaddr());
                serverNetworkDetail.setMetric(Long.valueOf(networkInfo.getNetInterfaceConfig().getMetric()));
                serverNetworkDetail.setMtu(Long.valueOf(networkInfo.getNetInterfaceConfig().getMtu()));
                serverNetworkDetail.setPrimaryDns(networkInfo.getNetInfo().getPrimaryDns());
                serverNetworkDetail.setSecondaryDns(networkInfo.getNetInfo().getSecondaryDns());
                serverNetworkDetail.setSubnetmask(networkInfo.getNetInterfaceConfig().getNetmask());
                serverNetworkDetail.setRemoteTime(new Date(networkInfo.getTime()));
                serverNetworkDetail.setServerId(Integer.valueOf(serverId));
                if (serverNetworkDetail.getId() == null) {
                    new ServerNetworkDetailTable().add(serverNetworkDetail);
                } else {
                    new ServerNetworkDetailTable().update(serverNetworkDetail);
                }
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("refused")) break block5;
                _logger.error((Object)"Error, ", (Throwable)ex);
            }
        }
    }

    public void updateServerMemoryDetail(int serverId) {
        block5: {
            try {
                UsageMemory usageMemory = (UsageMemory)AgentsConnection.getRestJSONclient(serverId).get("/usage/memory", UsageMemory.class);
                ServerMemoryDetail serverMemoryDetail = new ServerMemoryDetailTable().getByServerId(serverId);
                if (serverMemoryDetail == null) {
                    serverMemoryDetail = new ServerMemoryDetail();
                }
                serverMemoryDetail.setPhysical(Long.valueOf(usageMemory.getMemory().getTotal()));
                serverMemoryDetail.setSwap(Long.valueOf(usageMemory.getSwap().getTotal()));
                serverMemoryDetail.setRemoteTime(new Date(usageMemory.getTime()));
                serverMemoryDetail.setServerId(Integer.valueOf(serverId));
                if (serverMemoryDetail.getId() == null) {
                    new ServerMemoryDetailTable().add(serverMemoryDetail);
                } else {
                    new ServerMemoryDetailTable().update(serverMemoryDetail);
                }
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("refused")) break block5;
                _logger.error((Object)"Error, ", (Throwable)ex);
            }
        }
    }

    public void updateServerAgentReachableStatus(int serverId) {
        ServerStatusTable serverStatusTable = new ServerStatusTable();
        Server server = null;
        ServerStatus serverStatus = new ServerStatus();
        try {
            SysInfo sysInfo;
            InetAddress inet;
            block13: {
                server = new ServerTable().getById(Integer.valueOf(serverId));
                inet = InetAddress.getByName(server.getHostIp());
                serverStatus.setServerId(server.getId());
                serverStatus.setReachable(Boolean.valueOf(false));
                serverStatus.setAgentStatus(Boolean.valueOf(false));
                sysInfo = null;
                try {
                    sysInfo = (SysInfo)AgentsConnection.getRestJSONclient(serverId).get("/conf/system", SysInfo.class);
                }
                catch (Exception ex) {
                    if (ex.getMessage().contains("refused")) break block13;
                    _logger.error((Object)"Agent Status Error, ", (Throwable)ex);
                }
            }
            if (sysInfo != null) {
                if (server.getPlatform() == null) {
                    server.setPlatform(sysInfo.getName());
                    new ServerTable().update(server);
                }
                if (server.getPlatform().equals(sysInfo.getName())) {
                    serverStatus.setAgentStatus(Boolean.valueOf(true));
                }
            }
            if (inet.isReachable(5000)) {
                serverStatus.setReachable(Boolean.valueOf(true));
            } else {
                serverStatus.setReachable(Boolean.valueOf(false));
            }
            serverStatusTable.add(serverStatus);
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
        }
        catch (UnknownHostException ex) {
            try {
                serverStatus.setReachable(Boolean.valueOf(false));
                serverStatusTable.add(serverStatus);
            }
            catch (SQLException e) {
                _logger.error((Object)"Exception, ", (Throwable)ex);
            }
        }
        catch (IOException ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
        }
        this.updateServerCpuDetail(serverId);
        this.updateServerNetworkDetail(serverId);
        this.updateServerOsDetail(serverId);
        this.updateServerMemoryDetail(serverId);
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        try {
            this.updateServerAgentReachableStatus(jobDataMap.getInt("id"));
        }
        catch (Exception ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
        }
    }
}

