/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.jobs.system;

import com.redhat.reportengine.server.dbdata.TestSuiteAggregationTable;
import com.redhat.reportengine.server.dbdata.TestSuiteTable;
import com.redhat.reportengine.server.dbmap.TestSuite;
import com.redhat.reportengine.server.dbmap.TestSuiteAggregation;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class TestSuiteAggregationImpl
implements Job {
    static final Logger _logger = Logger.getLogger(TestSuiteAggregationImpl.class);

    public static synchronized void doAggregateTestSuite() {
        try {
            ArrayList testSuites = new TestSuiteTable().getNonAggregate();
            for (TestSuite testSuite : testSuites) {
                TestSuite aggregationRef = new TestSuiteTable().getAggregation(Integer.valueOf(testSuite.getTestReferenceId()));
                if (aggregationRef != null && aggregationRef.getTestSuiteId() == testSuite.getId()) {
                    _logger.info((Object)("Removing old Aggregation reference...[TestSuite: " + testSuite.getTestSuiteName() + ", TestSuiteId: " + aggregationRef.getTestSuiteId() + ", AggregationId:" + aggregationRef.getId() + "]"));
                    new TestSuiteAggregationTable().remove(aggregationRef.getTestSuiteId());
                    aggregationRef = new TestSuiteTable().getAggregation(Integer.valueOf(testSuite.getTestReferenceId()));
                }
                ArrayList preAggregations = new TestSuiteAggregationTable().get(testSuite.getId());
                for (TestSuiteAggregation preAggregation : preAggregations) {
                    if (preAggregation.getTestResult().equalsIgnoreCase("Passed")) {
                        testSuite.setPassedCases(preAggregation.getTestCount());
                        continue;
                    }
                    if (preAggregation.getTestResult().equalsIgnoreCase("Failed")) {
                        testSuite.setFailedCases(preAggregation.getTestCount());
                        continue;
                    }
                    if (preAggregation.getTestResult().equalsIgnoreCase("Skipped")) {
                        testSuite.setSkippedCases(preAggregation.getTestCount());
                        continue;
                    }
                    _logger.warn((Object)("Unknown result --> " + preAggregation.getTestResult() + ", Adding in to total"));
                    testSuite.setTotalCases(preAggregation.getTestCount());
                }
                testSuite.setTotalCases(testSuite.getTotalCases() + testSuite.getPassedCases() + testSuite.getFailedCases() + testSuite.getSkippedCases());
                if (aggregationRef == null) {
                    testSuite.setTotalChanges(0);
                    testSuite.setPassedChanges(0);
                    testSuite.setFailedChanges(0);
                    testSuite.setSkippedChanges(0);
                } else {
                    testSuite.setTotalChanges(testSuite.getTotalCases() - aggregationRef.getTotalCases());
                    testSuite.setPassedChanges(testSuite.getPassedCases() - aggregationRef.getPassedCases());
                    testSuite.setFailedChanges(testSuite.getFailedCases() - aggregationRef.getFailedCases());
                    testSuite.setSkippedChanges(testSuite.getSkippedCases() - aggregationRef.getSkippedCases());
                }
                if (testSuite.getLocalEndTime() != null) {
                    testSuite.setTestDuration(testSuite.getLocalEndTime().getTime() - testSuite.getLocalStartTime().getTime());
                }
                testSuite.setTestSuiteId(testSuite.getId());
                new TestSuiteTable().addAggregation(testSuite);
                testSuite.setAggregationStatus(true);
                new TestSuiteTable().enableAggregationStatus(Integer.valueOf(testSuite.getId()));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
        }
    }

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        TestSuiteAggregationImpl.doAggregateTestSuite();
    }
}

