/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.jobs.system;

import com.redhat.reportengine.server.cache.ServerSettings;
import com.redhat.reportengine.server.dbdata.TestCaseTable;
import com.redhat.reportengine.server.dbdata.TestSuiteTable;
import com.redhat.reportengine.server.dbmap.TestCase;
import com.redhat.reportengine.server.dbmap.TestSuite;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class UpdateJobStatus
implements Job {
    private static final Logger _logger = Logger.getLogger(UpdateJobStatus.class);

    private void updateNoResultSuites() throws SQLException {
        ArrayList testSuites = new TestSuiteTable().getRunning();
        _logger.debug((Object)("Size of Running Jobs: " + testSuites.size()));
        for (TestSuite testSuite : testSuites) {
            long lastUpdateTime;
            TestCase testCase = new TestCaseTable().getLatestByTestSuiteId(Integer.valueOf(testSuite.getId()));
            if (testCase != null) {
                _logger.info((Object)("Test Suite Name:" + testSuite.getTestSuiteName() + ", ID:" + testSuite.getId() + ", Test case: " + testCase.getTestName() + ", Time: " + testCase.getLocalStartTime()));
                lastUpdateTime = testCase.getLocalStartTime().getTime();
            } else {
                _logger.info((Object)("Test Suite Name:" + testSuite.getTestSuiteName() + ", ID:" + testSuite.getId() + ", [There is no test cases on RUNNING state on this suite!]"));
                lastUpdateTime = testSuite.getLocalStartTime().getTime();
            }
            if (new Date().getTime() - lastUpdateTime < ServerSettings.getTestSuiteInactiveTime() * 1000L) continue;
            if (testCase != null) {
                testCase.setTestResultNew("NoStatus");
                new TestCaseTable().modifyResult(testCase);
            }
            testSuite.setTestStatus("NoStatus");
            new TestSuiteTable().modifyStatus(testSuite);
        }
    }

    public void execute(JobExecutionContext jobDetails) throws JobExecutionException {
        try {
            this.updateNoResultSuites();
        }
        catch (SQLException ex) {
            _logger.error((Object)"Exception on Update Job Status, ", (Throwable)ex);
        }
    }
}

