/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.jobs.user;

import com.redhat.reportengine.server.cache.ServerSettings;
import com.redhat.reportengine.server.dbdata.ReportGroupReferenceTable;
import com.redhat.reportengine.server.dbdata.ReportGroupTable;
import com.redhat.reportengine.server.dbdata.TestSuiteTable;
import com.redhat.reportengine.server.dbmap.ReportGroup;
import com.redhat.reportengine.server.dbmap.ReportGroupReference;
import com.redhat.reportengine.server.email.SendEmail;
import com.redhat.reportengine.server.report.email.EmailGroupReport;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EmailReportGroupJob
implements Job {
    private static Logger _logger = Logger.getLogger(EmailReportGroupJob.class);

    public void executeEmailGroupReport(int id) throws Exception {
        ReportGroup reportGroup = new ReportGroupTable().get(Integer.valueOf(id));
        ArrayList reportGroupReferences = new ReportGroupReferenceTable().getByReportGroupId(Integer.valueOf(id));
        String testSuiteReferences = null;
        for (ReportGroupReference reportGroupReference : reportGroupReferences) {
            if (testSuiteReferences == null) {
                testSuiteReferences = "" + reportGroupReference.getTestReferenceId();
                continue;
            }
            testSuiteReferences = testSuiteReferences + "," + reportGroupReference.getTestReferenceId();
        }
        ArrayList testSuites = new TestSuiteTable().getTopNByRefIds(testSuiteReferences);
        String emailBody = new EmailGroupReport().getReport(testSuites, reportGroup.getGroupName(), reportGroup.isTestSuiteGroupEnabled());
        new SendEmail().sendEmail(reportGroup.getEmailTo(), reportGroup.getEmailCc(), ServerSettings.getEmailFrom(), "Summary report for '" + reportGroup.getGroupName() + "'", emailBody, ServerSettings.getEmailServer(), ServerSettings.getEmailServerPort());
    }

    public void execute(JobExecutionContext jobDetails) throws JobExecutionException {
        JobDataMap jobDataMap = jobDetails.getJobDetail().getJobDataMap();
        try {
            this.executeEmailGroupReport(Integer.valueOf("" + jobDataMap.get((Object)"id")));
        }
        catch (Exception ex) {
            _logger.error((Object)"Exception, ", (Throwable)ex);
        }
    }
}

