/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.restclient.agent;

import com.redhat.reportengine.server.dbdata.ServerTable;
import com.redhat.reportengine.server.dbmap.Server;
import com.redhat.reportengine.server.restclient.RestEasyJSONClient;
import java.sql.SQLException;
import java.util.HashMap;

public class AgentsConnection {
    public static final String SERVER_IP_REPLACEMENT = "#SERVER_LOCATION#";
    public static final String AGENT_URL = "http://#SERVER_LOCATION#";
    private static HashMap<Integer, RestEasyJSONClient> restJSONclient = new HashMap();

    public static RestEasyJSONClient getRestJSONclient(Integer serverId) throws SQLException {
        RestEasyJSONClient client = restJSONclient.get(serverId);
        Server server = new ServerTable().getById(serverId);
        if (client != null) {
            return client;
        }
        client = new RestEasyJSONClient();
        client.setServerUrl(AGENT_URL.replaceAll(SERVER_IP_REPLACEMENT, server.getHostIp() + ":" + server.getAgentPort()));
        client.setRootUrl("/agent");
        AgentsConnection.addRestJSONclient(serverId, client);
        return client;
    }

    public static synchronized void addRestJSONclient(Integer serverId, RestEasyJSONClient jsonClient) {
        restJSONclient.put(serverId, jsonClient);
    }

    public static synchronized void removeRestJSONClient(Integer serverId) {
        restJSONclient.remove(serverId);
    }
}

