/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.scheduler;

import com.redhat.reportengine.scheduler.JobDetails;
import com.redhat.reportengine.scheduler.ManageScheduler;
import com.redhat.reportengine.server.dbdata.JobSchedulerTable;
import com.redhat.reportengine.server.dbmap.JobScheduler;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class ManageJobs {
    static final Logger _logger = Logger.getLogger(ManageJobs.class);

    public static void addAJobInScheduler(int id) throws SQLException {
        ManageJobs.addAJobInScheduler(new JobSchedulerTable().get(Integer.valueOf(id)));
    }

    public static void addAJobInScheduler(String jobName) throws SQLException {
        ManageJobs.addAJobInScheduler(new JobSchedulerTable().get(jobName));
    }

    public static boolean removeAJobFromScheduler(int id) throws ParseException, SQLException, SchedulerException {
        JobScheduler jobScheduler = new JobSchedulerTable().get(Integer.valueOf(id));
        return ManageJobs.removeAJobFromScheduler(jobScheduler);
    }

    public static boolean removeAJobFromScheduler(JobScheduler jobScheduler) throws ParseException, SQLException, SchedulerException {
        return ManageJobs.removeAJobFromScheduler(new JobKey(jobScheduler.getJobName(), jobScheduler.getTargetClassDescription()));
    }

    public static boolean removeAJobFromScheduler(String jobName) throws ParseException, SQLException, SchedulerException {
        JobScheduler jobScheduler = new JobSchedulerTable().get(jobName);
        if (jobScheduler == null) {
            _logger.info((Object)("Job Not available on scheduler Table: " + jobName));
            return false;
        }
        return ManageJobs.removeAJobFromScheduler(new JobKey(jobScheduler.getJobName(), jobScheduler.getTargetClassDescription()));
    }

    public static boolean removeAJobFromScheduler(JobKey jobKey) throws ParseException, SchedulerException {
        return ManageScheduler.removeJob((JobKey)jobKey);
    }

    public static void loadAllJobs() throws SQLException {
        ArrayList jobs = new JobSchedulerTable().getAll();
        for (JobScheduler job : jobs) {
            ManageJobs.addAJobInScheduler(job);
        }
    }

    public static void addAJobInScheduler(JobScheduler jobScheduler) {
        if (!jobScheduler.isJobEnabled()) {
            _logger.debug((Object)("[" + jobScheduler.getJobName() + "] Job has been disabled.. Skipped to update in scheduler..."));
            return;
        }
        JobDetails job = new JobDetails();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("id", jobScheduler.getDataReferenceId());
        job.setTriggerGroupName(jobScheduler.getTargetClassDescription());
        job.setName(jobScheduler.getJobName());
        job.setJobTargetClass(jobScheduler.getTargetClass());
        job.setJobDataMap(jobDataMap);
        if (jobScheduler.getValidFromTime() != null) {
            job.setJobFromTime(jobScheduler.getValidFromTime());
        } else {
            job.setJobFromTime(new Date());
        }
        if (jobScheduler.getValidToTime() != null) {
            job.setJobToTime(jobScheduler.getValidToTime());
        }
        job.setGroup(jobScheduler.getTargetClassDescription());
        if (jobScheduler.isSimpleJob()) {
            job.setRepeatInterval(Long.valueOf((long)jobScheduler.getRepeatInterval().intValue() * 1000L));
            if (jobScheduler.getRepeatCount() != null) {
                job.setRepeatCount(jobScheduler.getRepeatCount());
            } else {
                job.setRepeatCount(Integer.valueOf(-1));
            }
            ManageScheduler.addJob((JobDetails)job);
            return;
        }
        if (jobScheduler.getCronExpression() != null) {
            job.setJobCronExpression(jobScheduler.getCronExpression());
        } else {
            String cornExpression = "";
            String cronSeconds = new SimpleDateFormat("ss").format(jobScheduler.getJobExecutionTime());
            String cronMinutes = new SimpleDateFormat("mm").format(jobScheduler.getJobExecutionTime());
            String cronHours = new SimpleDateFormat("HH").format(jobScheduler.getJobExecutionTime());
            String cronSHM = cronSeconds + " " + cronMinutes + " " + cronHours;
            if (jobScheduler.getJobFrequency().equalsIgnoreCase("Daily")) {
                cornExpression = cronSHM + " ? * " + jobScheduler.getJobWeekday();
            } else if (jobScheduler.getJobFrequency().equalsIgnoreCase("Weekly")) {
                cornExpression = cronSHM + " ? * " + jobScheduler.getJobWeekday();
            } else if (jobScheduler.getJobFrequency().equalsIgnoreCase("Monthly")) {
                cornExpression = cronSHM + " " + jobScheduler.getJobDayMonth() + " * ?";
            } else if (jobScheduler.getJobFrequency().equalsIgnoreCase("OneTime")) {
                cornExpression = cronSHM + " " + new SimpleDateFormat("d").format(jobScheduler.getValidFromTime()) + " " + new SimpleDateFormat("MM").format(jobScheduler.getValidFromTime()) + " ? " + new SimpleDateFormat("yyyy").format(jobScheduler.getValidFromTime());
            }
            _logger.debug((Object)("Job Corn Expression: " + cornExpression));
            job.setJobCronExpression(cornExpression);
        }
        if (jobScheduler.getValidToTime() != null && jobScheduler.getValidToTime().before(new Date())) {
            _logger.info((Object)("This job got expired! --> Job Name: " + jobScheduler.getJobName()));
            return;
        }
        ManageScheduler.addJob((JobDetails)job);
    }
}

