/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.impl;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BeanIntrospector {
    private static final Map<Class<?>, PropertyDescriptor[]> introspected = new HashMap();
    private static final String SETTER = "set";
    private static final String GETTER = "get";
    private static final String BOOLEAN_GETTER = "is";

    public static synchronized PropertyDescriptor[] getPropertyDescriptors(Class<?> klass) throws IntrospectionException {
        PropertyDescriptor[] descriptors = introspected.get(klass);
        if (descriptors == null) {
            descriptors = BeanIntrospector.getPDs(klass);
            introspected.put(klass, descriptors);
        }
        return descriptors;
    }

    private static PropertyDescriptor[] getPDs(Class<?> klass) throws IntrospectionException {
        Method[] methods = klass.getMethods();
        Map<String, PropertyDescriptor> getters = BeanIntrospector.getPDs(methods, false);
        Map<String, PropertyDescriptor> setters = BeanIntrospector.getPDs(methods, true);
        List<PropertyDescriptor> pds = BeanIntrospector.merge(getters, setters);
        PropertyDescriptor[] array = new PropertyDescriptor[pds.size()];
        pds.toArray(array);
        return array;
    }

    private static Map<String, PropertyDescriptor> getPDs(Method[] methods, boolean setters) throws IntrospectionException {
        HashMap<String, PropertyDescriptor> pds = new HashMap<String, PropertyDescriptor>();
        for (Method method : methods) {
            String pName = null;
            PropertyDescriptor pDescriptor = null;
            if ((method.getModifiers() & 1) != 0) {
                if (setters) {
                    if (method.getName().startsWith(SETTER) && method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1) {
                        pName = Introspector.decapitalize(method.getName().substring(3));
                        pDescriptor = new PropertyDescriptor(pName, null, method);
                    }
                } else if (method.getName().startsWith(GETTER) && method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0) {
                    pName = Introspector.decapitalize(method.getName().substring(3));
                    pDescriptor = new PropertyDescriptor(pName, method, null);
                } else if (method.getName().startsWith(BOOLEAN_GETTER) && method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 0) {
                    pName = Introspector.decapitalize(method.getName().substring(2));
                    pDescriptor = new PropertyDescriptor(pName, method, null);
                }
            }
            if (pName == null) continue;
            pds.put(pName, pDescriptor);
        }
        return pds;
    }

    private static List<PropertyDescriptor> merge(Map<String, PropertyDescriptor> getters, Map<String, PropertyDescriptor> setters) throws IntrospectionException {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        HashSet<String> processedProps = new HashSet<String>();
        for (String name : getters.keySet()) {
            PropertyDescriptor getter = getters.get(name);
            PropertyDescriptor setter = setters.get(name);
            if (setter != null) {
                processedProps.add(name);
                PropertyDescriptor prop = new PropertyDescriptor(name, getter.getReadMethod(), setter.getWriteMethod());
                props.add(prop);
                continue;
            }
            props.add(getter);
        }
        HashSet<String> writeOnlyProps = new HashSet<String>(setters.keySet());
        writeOnlyProps.removeAll(processedProps);
        for (String name : writeOnlyProps) {
            PropertyDescriptor setter = setters.get(name);
            props.add(setter);
        }
        return props;
    }
}

