/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.synd;

import com.sun.syndication.feed.CopyFrom;
import com.sun.syndication.feed.impl.CopyFromHelper;
import com.sun.syndication.feed.impl.ObjectBean;
import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.module.DCModuleImpl;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.SyModule;
import com.sun.syndication.feed.module.SyModuleImpl;
import com.sun.syndication.feed.module.impl.ModuleUtils;
import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndCategoryImpl;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEnclosureImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndLink;
import com.sun.syndication.feed.synd.SyndPerson;
import com.sun.syndication.feed.synd.impl.URINormalizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Element;

public class SyndEntryImpl
implements Serializable,
SyndEntry {
    private static final long serialVersionUID = 1944144041409866698L;
    private final ObjectBean objBean;
    private String uri;
    private String link;
    private String comments;
    private Date updatedDate;
    private SyndContent title;
    private SyndContent description;
    private List<SyndLink> links;
    private List<SyndContent> contents;
    private List<Module> modules;
    private List<SyndEnclosure> enclosures;
    private List<SyndPerson> authors;
    private List<SyndPerson> contributors;
    private SyndFeed source;
    private List<Element> foreignMarkup;
    private Object wireEntry;
    private List<SyndCategory> categories = new ArrayList<SyndCategory>();
    private static final Set<String> IGNORE_PROPERTIES = new HashSet<String>();
    public static final Set<String> CONVENIENCE_PROPERTIES = Collections.unmodifiableSet(IGNORE_PROPERTIES);
    private static final CopyFromHelper COPY_FROM_HELPER;

    protected SyndEntryImpl(Class<?> beanClass, Set<String> convenienceProperties) {
        this.objBean = new ObjectBean(beanClass, this, convenienceProperties);
    }

    public SyndEntryImpl() {
        this(SyndEntry.class, IGNORE_PROPERTIES);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.objBean.clone();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SyndEntryImpl)) {
            return false;
        }
        List<Element> fm = this.getForeignMarkup();
        this.setForeignMarkup(((SyndEntryImpl)other).getForeignMarkup());
        boolean ret = this.objBean.equals(other);
        this.setForeignMarkup(fm);
        return ret;
    }

    public int hashCode() {
        return this.objBean.hashCode();
    }

    public String toString() {
        return this.objBean.toString();
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = URINormalizer.normalize(uri);
    }

    @Override
    public String getTitle() {
        if (this.title != null) {
            return this.title.getValue();
        }
        return null;
    }

    @Override
    public void setTitle(String title) {
        if (this.title == null) {
            this.title = new SyndContentImpl();
        }
        this.title.setValue(title);
    }

    @Override
    public SyndContent getTitleEx() {
        return this.title;
    }

    @Override
    public void setTitleEx(SyndContent title) {
        this.title = title;
    }

    @Override
    public String getLink() {
        return this.link;
    }

    @Override
    public void setLink(String link) {
        this.link = link;
    }

    @Override
    public SyndContent getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(SyndContent description) {
        this.description = description;
    }

    @Override
    public List<SyndContent> getContents() {
        if (this.contents == null) {
            this.contents = new ArrayList<SyndContent>();
        }
        return this.contents;
    }

    @Override
    public void setContents(List<SyndContent> contents) {
        this.contents = contents;
    }

    @Override
    public List<SyndEnclosure> getEnclosures() {
        if (this.enclosures == null) {
            this.enclosures = new ArrayList<SyndEnclosure>();
        }
        return this.enclosures;
    }

    @Override
    public void setEnclosures(List<SyndEnclosure> enclosures) {
        this.enclosures = enclosures;
    }

    @Override
    public Date getPublishedDate() {
        return this.getDCModule().getDate();
    }

    @Override
    public void setPublishedDate(Date publishedDate) {
        this.getDCModule().setDate(publishedDate);
    }

    @Override
    public List<SyndCategory> getCategories() {
        return this.categories;
    }

    @Override
    public void setCategories(List<SyndCategory> categories) {
        this.categories = categories;
    }

    @Override
    public List<Module> getModules() {
        if (this.modules == null) {
            this.modules = new ArrayList<Module>();
        }
        if (ModuleUtils.getModule(this.modules, "http://purl.org/dc/elements/1.1/") == null) {
            this.modules.add(new DCModuleImpl());
        }
        return this.modules;
    }

    @Override
    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    @Override
    public Module getModule(String uri) {
        return ModuleUtils.getModule(this.getModules(), uri);
    }

    private DCModule getDCModule() {
        return (DCModule)this.getModule("http://purl.org/dc/elements/1.1/");
    }

    @Override
    public Class<SyndEntry> getInterface() {
        return SyndEntry.class;
    }

    @Override
    public void copyFrom(CopyFrom<? extends SyndEntry> obj) {
        COPY_FROM_HELPER.copy(this, obj);
    }

    @Override
    public List<SyndLink> getLinks() {
        if (this.links == null) {
            this.links = new ArrayList<SyndLink>();
        }
        return this.links;
    }

    @Override
    public void setLinks(List<SyndLink> links) {
        this.links = links;
    }

    @Override
    public Date getUpdatedDate() {
        if (this.updatedDate == null) {
            return null;
        }
        return new Date(this.updatedDate.getTime());
    }

    @Override
    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = new Date(updatedDate.getTime());
    }

    @Override
    public List<SyndPerson> getAuthors() {
        if (this.authors == null) {
            this.authors = new ArrayList<SyndPerson>();
        }
        return this.authors;
    }

    @Override
    public void setAuthors(List<SyndPerson> authors) {
        this.authors = authors;
    }

    @Override
    public String getAuthor() {
        String author = this.authors != null && this.authors.size() > 0 ? this.authors.get(0).getName() : this.getDCModule().getCreator();
        if (author == null) {
            author = "";
        }
        return author;
    }

    @Override
    public void setAuthor(String author) {
        DCModule dcModule = this.getDCModule();
        String currentValue = dcModule.getCreator();
        if (currentValue == null || currentValue.length() == 0) {
            this.getDCModule().setCreator(author);
        }
    }

    @Override
    public List<SyndPerson> getContributors() {
        if (this.contributors == null) {
            this.contributors = new ArrayList<SyndPerson>();
        }
        return this.contributors;
    }

    @Override
    public void setContributors(List<SyndPerson> contributors) {
        this.contributors = contributors;
    }

    @Override
    public SyndFeed getSource() {
        return this.source;
    }

    @Override
    public void setSource(SyndFeed source) {
        this.source = source;
    }

    @Override
    public List<Element> getForeignMarkup() {
        if (this.foreignMarkup == null) {
            this.foreignMarkup = new ArrayList<Element>();
        }
        return this.foreignMarkup;
    }

    @Override
    public void setForeignMarkup(List<Element> foreignMarkup) {
        this.foreignMarkup = foreignMarkup;
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public Object getWireEntry() {
        return this.wireEntry;
    }

    public void setWireEntry(Object wireEntry) {
        this.wireEntry = wireEntry;
    }

    @Override
    public SyndLink findRelatedLink(String relation) {
        for (SyndLink l : this.getLinks()) {
            if (!relation.equals(l.getRel())) continue;
            return l;
        }
        return null;
    }

    static {
        IGNORE_PROPERTIES.add("publishedDate");
        IGNORE_PROPERTIES.add("author");
        HashMap basePropInterfaceMap = new HashMap();
        basePropInterfaceMap.put("uri", String.class);
        basePropInterfaceMap.put("title", String.class);
        basePropInterfaceMap.put("link", String.class);
        basePropInterfaceMap.put("uri", String.class);
        basePropInterfaceMap.put("description", SyndContent.class);
        basePropInterfaceMap.put("contents", SyndContent.class);
        basePropInterfaceMap.put("enclosures", SyndEnclosure.class);
        basePropInterfaceMap.put("modules", Module.class);
        basePropInterfaceMap.put("categories", SyndCategory.class);
        HashMap basePropClassImplMap = new HashMap();
        basePropClassImplMap.put(SyndContent.class, SyndContentImpl.class);
        basePropClassImplMap.put(SyndEnclosure.class, SyndEnclosureImpl.class);
        basePropClassImplMap.put(SyndCategory.class, SyndCategoryImpl.class);
        basePropClassImplMap.put(DCModule.class, DCModuleImpl.class);
        basePropClassImplMap.put(SyModule.class, SyModuleImpl.class);
        COPY_FROM_HELPER = new CopyFromHelper(SyndEntry.class, basePropInterfaceMap, basePropClassImplMap);
    }
}

