/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import com.sun.syndication.io.impl.RSS091UserlandParser;
import org.jdom2.Attribute;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;

public class RSS091NetscapeParser
extends RSS091UserlandParser {
    static final String ELEMENT_NAME = "rss";
    static final String PUBLIC_ID = "-//Netscape Communications//DTD RSS 0.91//EN";
    static final String SYSTEM_ID = "http://my.netscape.com/publish/formats/rss-0.91.dtd";

    public RSS091NetscapeParser() {
        this("rss_0.91N");
    }

    protected RSS091NetscapeParser(String type) {
        super(type);
    }

    @Override
    public boolean isMyType(Document document) {
        boolean ok = false;
        Element rssRoot = document.getRootElement();
        ok = rssRoot.getName().equals(ELEMENT_NAME);
        if (ok) {
            ok = false;
            Attribute version = rssRoot.getAttribute("version");
            if (version != null && (ok = version.getValue().equals(this.getRSSVersion()))) {
                ok = false;
                DocType docType = document.getDocType();
                if (docType != null) {
                    ok = ELEMENT_NAME.equals(docType.getElementName());
                    ok = ok && PUBLIC_ID.equals(docType.getPublicID());
                    ok = ok && SYSTEM_ID.equals(docType.getSystemID());
                }
            }
        }
        return ok;
    }

    @Override
    protected boolean isHourFormat24(Element rssRoot) {
        return false;
    }

    @Override
    protected String getTextInputLabel() {
        return "textinput";
    }
}

