(ns lead.core
  [:require [clj-time.core :as time]])

(defrecord Series [name, start, end, step, values])

(def series map->Series)

(extend-protocol SeriesSource
  nil
  (load-serieses [this, interval] []))

(defn- random-walk
  ([] (random-walk 0))
  ([n] (cons n (lazy-seq (random-walk (-> n (+ (rand)) (- 0.5)))))))

(defrecord RandomWalkSource [name]
  SeriesSource
  (load-serieses [this, interval]
    [(series 
       {:name name
        :start (-> interval .getStartMillis (/ 1000))
        :end (-> interval .getEndMillis (/ 1000))
        :step 60
        :values (take (time/in-minutes interval) (random-walk))})]))

