goog.provide('cljs.compiler');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__53141 = s;
var map__53141__$1 = cljs.core.__destructure_map(map__53141);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53141__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53141__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__53143 = info;
var map__53144 = G__53143;
var map__53144__$1 = cljs.core.__destructure_map(map__53144);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53144__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__53143__$1 = G__53143;
while(true){
var d__$2 = d__$1;
var map__53146 = G__53143__$1;
var map__53146__$1 = cljs.core.__destructure_map(map__53146);
var shadow__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53146__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$2)){
var G__55110 = (d__$2 + (1));
var G__55111 = shadow__$2;
d__$1 = G__55110;
G__53143__$1 = G__55111;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__53150){
var map__53151 = p__53150;
var map__53151__$1 = cljs.core.__destructure_map(map__53151);
var name_var = map__53151__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53151__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53151__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__53152 = info;
var map__53152__$1 = cljs.core.__destructure_map(map__53152);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53152__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53152__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__53154 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__53154) : cljs.compiler.munge.call(null,G__53154));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__53168 = arguments.length;
switch (G__53168) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__53212 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11790,11790,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__53212.cljs$core$IFn$_invoke$arity$1 ? fexpr__53212.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__53212.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__53213 = cp;
switch (G__53213) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__53220_55127 = cljs.core.seq(s);
var chunk__53221_55128 = null;
var count__53222_55129 = (0);
var i__53223_55130 = (0);
while(true){
if((i__53223_55130 < count__53222_55129)){
var c_55133 = chunk__53221_55128.cljs$core$IIndexed$_nth$arity$2(null,i__53223_55130);
sb.append(cljs.compiler.escape_char(c_55133));


var G__55134 = seq__53220_55127;
var G__55135 = chunk__53221_55128;
var G__55136 = count__53222_55129;
var G__55137 = (i__53223_55130 + (1));
seq__53220_55127 = G__55134;
chunk__53221_55128 = G__55135;
count__53222_55129 = G__55136;
i__53223_55130 = G__55137;
continue;
} else {
var temp__5804__auto___55139 = cljs.core.seq(seq__53220_55127);
if(temp__5804__auto___55139){
var seq__53220_55140__$1 = temp__5804__auto___55139;
if(cljs.core.chunked_seq_QMARK_(seq__53220_55140__$1)){
var c__5568__auto___55141 = cljs.core.chunk_first(seq__53220_55140__$1);
var G__55142 = cljs.core.chunk_rest(seq__53220_55140__$1);
var G__55143 = c__5568__auto___55141;
var G__55144 = cljs.core.count(c__5568__auto___55141);
var G__55145 = (0);
seq__53220_55127 = G__55142;
chunk__53221_55128 = G__55143;
count__53222_55129 = G__55144;
i__53223_55130 = G__55145;
continue;
} else {
var c_55146 = cljs.core.first(seq__53220_55140__$1);
sb.append(cljs.compiler.escape_char(c_55146));


var G__55147 = cljs.core.next(seq__53220_55140__$1);
var G__55148 = null;
var G__55149 = (0);
var G__55150 = (0);
seq__53220_55127 = G__55147;
chunk__53221_55128 = G__55148;
count__53222_55129 = G__55149;
i__53223_55130 = G__55150;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__53228 = cljs.core.get_global_hierarchy;
return (fexpr__53228.cljs$core$IFn$_invoke$arity$0 ? fexpr__53228.cljs$core$IFn$_invoke$arity$0() : fexpr__53228.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__53231_55155 = ast;
var map__53231_55156__$1 = cljs.core.__destructure_map(map__53231_55155);
var env_55157 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53231_55156__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_55157))){
var map__53232_55158 = env_55157;
var map__53232_55159__$1 = cljs.core.__destructure_map(map__53232_55158);
var line_55160 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53232_55159__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_55161 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53232_55159__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__53235 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__53237 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__53236 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__53236.cljs$core$IFn$_invoke$arity$1 ? fexpr__53236.cljs$core$IFn$_invoke$arity$1(G__53237) : fexpr__53236.call(null,G__53237));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__53235,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__53235;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_55160 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_55161)?(column_55161 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__53250 = arguments.length;
switch (G__53250) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___55172 = arguments.length;
var i__5770__auto___55173 = (0);
while(true){
if((i__5770__auto___55173 < len__5769__auto___55172)){
args_arr__5794__auto__.push((arguments[i__5770__auto___55173]));

var G__55174 = (i__5770__auto___55173 + (1));
i__5770__auto___55173 = G__55174;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5795__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_55175 = (function (){var G__53255 = a;
if((!(typeof a === 'string'))){
return G__53255.toString();
} else {
return G__53255;
}
})();
var temp__5808__auto___55176 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5808__auto___55176 == null)){
} else {
var sm_data_55177 = temp__5808__auto___55176;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_55177,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__53241_SHARP_){
return (p1__53241_SHARP_ + s_55175.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_55175], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__53275 = cljs.core.seq(xs);
var chunk__53276 = null;
var count__53277 = (0);
var i__53278 = (0);
while(true){
if((i__53278 < count__53277)){
var x = chunk__53276.cljs$core$IIndexed$_nth$arity$2(null,i__53278);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__55182 = seq__53275;
var G__55183 = chunk__53276;
var G__55184 = count__53277;
var G__55185 = (i__53278 + (1));
seq__53275 = G__55182;
chunk__53276 = G__55183;
count__53277 = G__55184;
i__53278 = G__55185;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__53275);
if(temp__5804__auto__){
var seq__53275__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53275__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__53275__$1);
var G__55186 = cljs.core.chunk_rest(seq__53275__$1);
var G__55187 = c__5568__auto__;
var G__55188 = cljs.core.count(c__5568__auto__);
var G__55189 = (0);
seq__53275 = G__55186;
chunk__53276 = G__55187;
count__53277 = G__55188;
i__53278 = G__55189;
continue;
} else {
var x = cljs.core.first(seq__53275__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__55190 = cljs.core.next(seq__53275__$1);
var G__55191 = null;
var G__55192 = (0);
var G__55193 = (0);
seq__53275 = G__55190;
chunk__53276 = G__55191;
count__53277 = G__55192;
i__53278 = G__55193;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq53243){
var G__53244 = cljs.core.first(seq53243);
var seq53243__$1 = cljs.core.next(seq53243);
var G__53245 = cljs.core.first(seq53243__$1);
var seq53243__$2 = cljs.core.next(seq53243__$1);
var G__53246 = cljs.core.first(seq53243__$2);
var seq53243__$3 = cljs.core.next(seq53243__$2);
var G__53247 = cljs.core.first(seq53243__$3);
var seq53243__$4 = cljs.core.next(seq53243__$3);
var G__53248 = cljs.core.first(seq53243__$4);
var seq53243__$5 = cljs.core.next(seq53243__$4);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53244,G__53245,G__53246,G__53247,G__53248,seq53243__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__53293){
var map__53294 = p__53293;
var map__53294__$1 = cljs.core.__destructure_map(map__53294);
var m = map__53294__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53294__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__53307 = arguments.length;
switch (G__53307) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___55199 = arguments.length;
var i__5770__auto___55200 = (0);
while(true){
if((i__5770__auto___55200 < len__5769__auto___55199)){
args_arr__5794__auto__.push((arguments[i__5770__auto___55200]));

var G__55201 = (i__5770__auto___55200 + (1));
i__5770__auto___55200 = G__55201;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5795__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__53339_55204 = cljs.core.seq(xs);
var chunk__53340_55205 = null;
var count__53341_55206 = (0);
var i__53342_55207 = (0);
while(true){
if((i__53342_55207 < count__53341_55206)){
var x_55209 = chunk__53340_55205.cljs$core$IIndexed$_nth$arity$2(null,i__53342_55207);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_55209);


var G__55210 = seq__53339_55204;
var G__55211 = chunk__53340_55205;
var G__55212 = count__53341_55206;
var G__55213 = (i__53342_55207 + (1));
seq__53339_55204 = G__55210;
chunk__53340_55205 = G__55211;
count__53341_55206 = G__55212;
i__53342_55207 = G__55213;
continue;
} else {
var temp__5804__auto___55215 = cljs.core.seq(seq__53339_55204);
if(temp__5804__auto___55215){
var seq__53339_55216__$1 = temp__5804__auto___55215;
if(cljs.core.chunked_seq_QMARK_(seq__53339_55216__$1)){
var c__5568__auto___55217 = cljs.core.chunk_first(seq__53339_55216__$1);
var G__55218 = cljs.core.chunk_rest(seq__53339_55216__$1);
var G__55219 = c__5568__auto___55217;
var G__55220 = cljs.core.count(c__5568__auto___55217);
var G__55221 = (0);
seq__53339_55204 = G__55218;
chunk__53340_55205 = G__55219;
count__53341_55206 = G__55220;
i__53342_55207 = G__55221;
continue;
} else {
var x_55222 = cljs.core.first(seq__53339_55216__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_55222);


var G__55223 = cljs.core.next(seq__53339_55216__$1);
var G__55224 = null;
var G__55225 = (0);
var G__55226 = (0);
seq__53339_55204 = G__55223;
chunk__53340_55205 = G__55224;
count__53341_55206 = G__55225;
i__53342_55207 = G__55226;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq53301){
var G__53302 = cljs.core.first(seq53301);
var seq53301__$1 = cljs.core.next(seq53301);
var G__53303 = cljs.core.first(seq53301__$1);
var seq53301__$2 = cljs.core.next(seq53301__$1);
var G__53304 = cljs.core.first(seq53301__$2);
var seq53301__$3 = cljs.core.next(seq53301__$2);
var G__53305 = cljs.core.first(seq53301__$3);
var seq53301__$4 = cljs.core.next(seq53301__$3);
var G__53306 = cljs.core.first(seq53301__$4);
var seq53301__$5 = cljs.core.next(seq53301__$4);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53302,G__53303,G__53304,G__53305,G__53306,seq53301__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__5690__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__53382_55227 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__53383_55228 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__53384_55229 = true;
var _STAR_print_fn_STAR__temp_val__53385_55230 = (function (x__5691__auto__){
return sb__5690__auto__.append(x__5691__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__53384_55229);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__53385_55230);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__53383_55228);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__53382_55227);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__5690__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__53391 = cljs.core.get_global_hierarchy;
return (fexpr__53391.cljs$core$IFn$_invoke$arity$0 ? fexpr__53391.cljs$core$IFn$_invoke$arity$0() : fexpr__53391.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__53402 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53402,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53402,(1),null);
var G__53406 = ns;
var G__53407 = name;
var G__53408 = (function (){
var G__53409 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__53409) : cljs.compiler.emit_constant.call(null,G__53409));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__53406,G__53407,G__53408) : cljs.compiler.emit_record_value.call(null,G__53406,G__53407,G__53408));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__53411 = cljs.core.keys(x);
var G__53412 = cljs.core.vals(x);
var G__53413 = cljs.compiler.emit_constants_comma_sep;
var G__53414 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__53411,G__53412,G__53413,G__53414) : cljs.compiler.emit_map.call(null,G__53411,G__53412,G__53413,G__53414));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__53415 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__53416 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__53415,G__53416) : cljs.compiler.emit_with_meta.call(null,G__53415,G__53416));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
if((((x === (0))) && ((((1) / x) < (0))))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(-0)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__53427 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53427,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53427,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53427,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5802__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__5043__auto__)){
var G__53450 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__53450) : x.call(null,G__53450));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var value = temp__5802__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5802__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__5043__auto__)){
var G__53460 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__53460) : x.call(null,G__53460));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var value = temp__5802__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__53487 = items;
var G__53488 = (function (p1__53486_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__53486_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__53487,G__53488) : cljs.compiler.emit_js_object.call(null,G__53487,G__53488));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__53493){
var map__53494 = p__53493;
var map__53494__$1 = cljs.core.__destructure_map(map__53494);
var ast = map__53494__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53494__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53494__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53494__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5802__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5802__auto__)){
var const_expr = temp__5802__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__53495 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__53495__$1 = cljs.core.__destructure_map(map__53495);
var cenv = map__53495__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53495__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__5045__auto__ = js_module_name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__53498 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__5043__auto__ = (function (){var G__53499 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__53499) : cljs.compiler.es5_GT__EQ_.call(null,G__53499));
})();
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__5043__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__53498,cljs.analyzer.es5_allowed);
} else {
return G__53498;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__5045__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__53500 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__53500,reserved);
} else {
return G__53500;
}
})();
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__53501_55313 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__53501_55314__$1 = (((G__53501_55313 instanceof cljs.core.Keyword))?G__53501_55313.fqn:null);
switch (G__53501_55314__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__5043__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__53513){
var map__53515 = p__53513;
var map__53515__$1 = cljs.core.__destructure_map(map__53515);
var arg = map__53515__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53515__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53515__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53515__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53515__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__53520 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__53520__$1 = cljs.core.__destructure_map(map__53520);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53520__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__53521){
var map__53522 = p__53521;
var map__53522__$1 = cljs.core.__destructure_map(map__53522);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53522__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53522__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53522__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__53526_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__53526_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__53532 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__53532) : comma_sep.call(null,G__53532));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__53534 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__53534) : comma_sep.call(null,G__53534));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__53539){
var map__53540 = p__53539;
var map__53540__$1 = cljs.core.__destructure_map(map__53540);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53540__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53540__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53540__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__53545){
var map__53546 = p__53545;
var map__53546__$1 = cljs.core.__destructure_map(map__53546);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53546__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53546__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__53556_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__53556_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__53559 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__53559) : comma_sep.call(null,G__53559));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__53560){
var map__53561 = p__53560;
var map__53561__$1 = cljs.core.__destructure_map(map__53561);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53561__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53561__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5804__auto___55372 = cljs.core.seq(items);
if(temp__5804__auto___55372){
var items_55373__$1 = temp__5804__auto___55372;
var vec__53570_55374 = items_55373__$1;
var seq__53571_55375 = cljs.core.seq(vec__53570_55374);
var first__53572_55376 = cljs.core.first(seq__53571_55375);
var seq__53571_55377__$1 = cljs.core.next(seq__53571_55375);
var vec__53573_55378 = first__53572_55376;
var k_55379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53573_55378,(0),null);
var v_55380 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53573_55378,(1),null);
var r_55381 = seq__53571_55377__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_55379),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_55380) : emit_js_object_val.call(null,v_55380)));

var seq__53576_55383 = cljs.core.seq(r_55381);
var chunk__53577_55384 = null;
var count__53578_55385 = (0);
var i__53579_55386 = (0);
while(true){
if((i__53579_55386 < count__53578_55385)){
var vec__53596_55404 = chunk__53577_55384.cljs$core$IIndexed$_nth$arity$2(null,i__53579_55386);
var k_55405__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53596_55404,(0),null);
var v_55406__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53596_55404,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_55405__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_55406__$1) : emit_js_object_val.call(null,v_55406__$1)));


var G__55407 = seq__53576_55383;
var G__55408 = chunk__53577_55384;
var G__55409 = count__53578_55385;
var G__55410 = (i__53579_55386 + (1));
seq__53576_55383 = G__55407;
chunk__53577_55384 = G__55408;
count__53578_55385 = G__55409;
i__53579_55386 = G__55410;
continue;
} else {
var temp__5804__auto___55411__$1 = cljs.core.seq(seq__53576_55383);
if(temp__5804__auto___55411__$1){
var seq__53576_55412__$1 = temp__5804__auto___55411__$1;
if(cljs.core.chunked_seq_QMARK_(seq__53576_55412__$1)){
var c__5568__auto___55413 = cljs.core.chunk_first(seq__53576_55412__$1);
var G__55414 = cljs.core.chunk_rest(seq__53576_55412__$1);
var G__55415 = c__5568__auto___55413;
var G__55416 = cljs.core.count(c__5568__auto___55413);
var G__55417 = (0);
seq__53576_55383 = G__55414;
chunk__53577_55384 = G__55415;
count__53578_55385 = G__55416;
i__53579_55386 = G__55417;
continue;
} else {
var vec__53600_55418 = cljs.core.first(seq__53576_55412__$1);
var k_55419__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53600_55418,(0),null);
var v_55420__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53600_55418,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_55419__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_55420__$1) : emit_js_object_val.call(null,v_55420__$1)));


var G__55421 = cljs.core.next(seq__53576_55412__$1);
var G__55422 = null;
var G__55423 = (0);
var G__55424 = (0);
seq__53576_55383 = G__55421;
chunk__53577_55384 = G__55422;
count__53578_55385 = G__55423;
i__53579_55386 = G__55424;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__53608){
var map__53610 = p__53608;
var map__53610__$1 = cljs.core.__destructure_map(map__53610);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53610__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53610__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53610__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__53614){
var map__53615 = p__53614;
var map__53615__$1 = cljs.core.__destructure_map(map__53615);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53615__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53615__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__53616){
var map__53617 = p__53616;
var map__53617__$1 = cljs.core.__destructure_map(map__53617);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53617__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__53618){
var map__53619 = p__53618;
var map__53619__$1 = cljs.core.__destructure_map(map__53619);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53619__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53619__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__53623 = cljs.analyzer.unwrap_quote(expr);
var map__53623__$1 = cljs.core.__destructure_map(map__53623);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53623__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53623__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53623__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__5045__auto__ = (function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__5043__auto__){
var and__5043__auto____$1 = form;
if(cljs.core.truth_(and__5043__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = (!((const_expr == null)));
if(and__5043__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__5043__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__53630 = cljs.analyzer.unwrap_quote(expr);
var map__53630__$1 = cljs.core.__destructure_map(map__53630);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53630__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53630__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53630__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__5045__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = (!((const_expr == null)));
if(and__5043__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__5043__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__5045__auto__ = (function (){var fexpr__53640 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__53640.cljs$core$IFn$_invoke$arity$1 ? fexpr__53640.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__53640.call(null,tag));
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__53643){
var map__53644 = p__53643;
var map__53644__$1 = cljs.core.__destructure_map(map__53644);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53644__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53644__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53644__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53644__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53644__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__5045__auto__ = unchecked;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__53654){
var map__53658 = p__53654;
var map__53658__$1 = cljs.core.__destructure_map(map__53658);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53658__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53658__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53658__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53658__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__53666_55447 = cljs.core.seq(nodes);
var chunk__53667_55448 = null;
var count__53668_55449 = (0);
var i__53669_55450 = (0);
while(true){
if((i__53669_55450 < count__53668_55449)){
var map__53693_55451 = chunk__53667_55448.cljs$core$IIndexed$_nth$arity$2(null,i__53669_55450);
var map__53693_55452__$1 = cljs.core.__destructure_map(map__53693_55451);
var ts_55453 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53693_55452__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__53694_55454 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53693_55452__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__53694_55455__$1 = cljs.core.__destructure_map(map__53694_55454);
var then_55456 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53694_55455__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__53695_55457 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_55453));
var chunk__53696_55458 = null;
var count__53697_55459 = (0);
var i__53698_55460 = (0);
while(true){
if((i__53698_55460 < count__53697_55459)){
var test_55461 = chunk__53696_55458.cljs$core$IIndexed$_nth$arity$2(null,i__53698_55460);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_55461,":");


var G__55463 = seq__53695_55457;
var G__55465 = chunk__53696_55458;
var G__55466 = count__53697_55459;
var G__55467 = (i__53698_55460 + (1));
seq__53695_55457 = G__55463;
chunk__53696_55458 = G__55465;
count__53697_55459 = G__55466;
i__53698_55460 = G__55467;
continue;
} else {
var temp__5804__auto___55469 = cljs.core.seq(seq__53695_55457);
if(temp__5804__auto___55469){
var seq__53695_55471__$1 = temp__5804__auto___55469;
if(cljs.core.chunked_seq_QMARK_(seq__53695_55471__$1)){
var c__5568__auto___55472 = cljs.core.chunk_first(seq__53695_55471__$1);
var G__55473 = cljs.core.chunk_rest(seq__53695_55471__$1);
var G__55474 = c__5568__auto___55472;
var G__55475 = cljs.core.count(c__5568__auto___55472);
var G__55476 = (0);
seq__53695_55457 = G__55473;
chunk__53696_55458 = G__55474;
count__53697_55459 = G__55475;
i__53698_55460 = G__55476;
continue;
} else {
var test_55477 = cljs.core.first(seq__53695_55471__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_55477,":");


var G__55478 = cljs.core.next(seq__53695_55471__$1);
var G__55479 = null;
var G__55480 = (0);
var G__55481 = (0);
seq__53695_55457 = G__55478;
chunk__53696_55458 = G__55479;
count__53697_55459 = G__55480;
i__53698_55460 = G__55481;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_55456);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_55456);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__55485 = seq__53666_55447;
var G__55486 = chunk__53667_55448;
var G__55487 = count__53668_55449;
var G__55488 = (i__53669_55450 + (1));
seq__53666_55447 = G__55485;
chunk__53667_55448 = G__55486;
count__53668_55449 = G__55487;
i__53669_55450 = G__55488;
continue;
} else {
var temp__5804__auto___55489 = cljs.core.seq(seq__53666_55447);
if(temp__5804__auto___55489){
var seq__53666_55490__$1 = temp__5804__auto___55489;
if(cljs.core.chunked_seq_QMARK_(seq__53666_55490__$1)){
var c__5568__auto___55491 = cljs.core.chunk_first(seq__53666_55490__$1);
var G__55492 = cljs.core.chunk_rest(seq__53666_55490__$1);
var G__55493 = c__5568__auto___55491;
var G__55494 = cljs.core.count(c__5568__auto___55491);
var G__55495 = (0);
seq__53666_55447 = G__55492;
chunk__53667_55448 = G__55493;
count__53668_55449 = G__55494;
i__53669_55450 = G__55495;
continue;
} else {
var map__53720_55496 = cljs.core.first(seq__53666_55490__$1);
var map__53720_55497__$1 = cljs.core.__destructure_map(map__53720_55496);
var ts_55498 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53720_55497__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__53721_55499 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53720_55497__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__53721_55500__$1 = cljs.core.__destructure_map(map__53721_55499);
var then_55501 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53721_55500__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__53726_55502 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_55498));
var chunk__53727_55503 = null;
var count__53728_55504 = (0);
var i__53729_55505 = (0);
while(true){
if((i__53729_55505 < count__53728_55504)){
var test_55507 = chunk__53727_55503.cljs$core$IIndexed$_nth$arity$2(null,i__53729_55505);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_55507,":");


var G__55508 = seq__53726_55502;
var G__55509 = chunk__53727_55503;
var G__55510 = count__53728_55504;
var G__55511 = (i__53729_55505 + (1));
seq__53726_55502 = G__55508;
chunk__53727_55503 = G__55509;
count__53728_55504 = G__55510;
i__53729_55505 = G__55511;
continue;
} else {
var temp__5804__auto___55512__$1 = cljs.core.seq(seq__53726_55502);
if(temp__5804__auto___55512__$1){
var seq__53726_55513__$1 = temp__5804__auto___55512__$1;
if(cljs.core.chunked_seq_QMARK_(seq__53726_55513__$1)){
var c__5568__auto___55514 = cljs.core.chunk_first(seq__53726_55513__$1);
var G__55515 = cljs.core.chunk_rest(seq__53726_55513__$1);
var G__55516 = c__5568__auto___55514;
var G__55517 = cljs.core.count(c__5568__auto___55514);
var G__55518 = (0);
seq__53726_55502 = G__55515;
chunk__53727_55503 = G__55516;
count__53728_55504 = G__55517;
i__53729_55505 = G__55518;
continue;
} else {
var test_55519 = cljs.core.first(seq__53726_55513__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_55519,":");


var G__55520 = cljs.core.next(seq__53726_55513__$1);
var G__55521 = null;
var G__55522 = (0);
var G__55523 = (0);
seq__53726_55502 = G__55520;
chunk__53727_55503 = G__55521;
count__53728_55504 = G__55522;
i__53729_55505 = G__55523;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_55501);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_55501);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__55524 = cljs.core.next(seq__53666_55490__$1);
var G__55525 = null;
var G__55526 = (0);
var G__55527 = (0);
seq__53666_55447 = G__55524;
chunk__53667_55448 = G__55525;
count__53668_55449 = G__55526;
i__53669_55450 = G__55527;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__53741){
var map__53742 = p__53741;
var map__53742__$1 = cljs.core.__destructure_map(map__53742);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53742__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53742__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__53749 = env;
var G__53750 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__53749,G__53750) : cljs.compiler.resolve_type.call(null,G__53749,G__53750));
})())].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__53751 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53751,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53751,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__53743_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__53743_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__53743_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__53760 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__53760,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__53760;
}
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__53764 = env;
var G__53765 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__53764,G__53765) : cljs.compiler.resolve_type.call(null,G__53764,G__53765));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__53773_SHARP_){
return cljs.compiler.resolve_type(env,p1__53773_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__53783 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__53784 = cljs.core.seq(vec__53783);
var first__53785 = cljs.core.first(seq__53784);
var seq__53784__$1 = cljs.core.next(seq__53784);
var p = first__53785;
var first__53785__$1 = cljs.core.first(seq__53784__$1);
var seq__53784__$2 = cljs.core.next(seq__53784__$1);
var ts = first__53785__$1;
var first__53785__$2 = cljs.core.first(seq__53784__$2);
var seq__53784__$3 = cljs.core.next(seq__53784__$2);
var n = first__53785__$2;
var xs = seq__53784__$3;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__5043__auto__){
var and__5043__auto____$1 = ts;
if(cljs.core.truth_(and__5043__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__53790 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__53791 = cljs.core.seq(vec__53790);
var first__53792 = cljs.core.first(seq__53791);
var seq__53791__$1 = cljs.core.next(seq__53791);
var p = first__53792;
var first__53792__$1 = cljs.core.first(seq__53791__$1);
var seq__53791__$2 = cljs.core.next(seq__53791__$1);
var ts = first__53792__$1;
var xs = seq__53791__$2;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__5043__auto__){
var and__5043__auto____$1 = ts;
if(cljs.core.truth_(and__5043__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__53797 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__53796 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__53796.cljs$core$IFn$_invoke$arity$1 ? fexpr__53796.cljs$core$IFn$_invoke$arity$1(G__53797) : fexpr__53796.call(null,G__53797));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__53803 = arguments.length;
switch (G__53803) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__53824 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__53798_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__53798_SHARP_);
} else {
return p1__53798_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__53825 = cljs.core.seq(vec__53824);
var first__53826 = cljs.core.first(seq__53825);
var seq__53825__$1 = cljs.core.next(seq__53825);
var x = first__53826;
var ys = seq__53825__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__53827 = cljs.core.seq(ys);
var chunk__53828 = null;
var count__53829 = (0);
var i__53830 = (0);
while(true){
if((i__53830 < count__53829)){
var next_line = chunk__53828.cljs$core$IIndexed$_nth$arity$2(null,i__53830);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__55579 = seq__53827;
var G__55580 = chunk__53828;
var G__55581 = count__53829;
var G__55582 = (i__53830 + (1));
seq__53827 = G__55579;
chunk__53828 = G__55580;
count__53829 = G__55581;
i__53830 = G__55582;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__53827);
if(temp__5804__auto__){
var seq__53827__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53827__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__53827__$1);
var G__55630 = cljs.core.chunk_rest(seq__53827__$1);
var G__55631 = c__5568__auto__;
var G__55632 = cljs.core.count(c__5568__auto__);
var G__55633 = (0);
seq__53827 = G__55630;
chunk__53828 = G__55631;
count__53829 = G__55632;
i__53830 = G__55633;
continue;
} else {
var next_line = cljs.core.first(seq__53827__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__55638 = cljs.core.next(seq__53827__$1);
var G__55639 = null;
var G__55640 = (0);
var G__55641 = (0);
seq__53827 = G__55638;
chunk__53828 = G__55639;
count__53829 = G__55640;
i__53830 = G__55641;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__53840_55642 = cljs.core.seq(docs__$2);
var chunk__53841_55643 = null;
var count__53842_55644 = (0);
var i__53843_55645 = (0);
while(true){
if((i__53843_55645 < count__53842_55644)){
var e_55647 = chunk__53841_55643.cljs$core$IIndexed$_nth$arity$2(null,i__53843_55645);
if(cljs.core.truth_(e_55647)){
print_comment_lines(e_55647);
} else {
}


var G__55648 = seq__53840_55642;
var G__55650 = chunk__53841_55643;
var G__55651 = count__53842_55644;
var G__55652 = (i__53843_55645 + (1));
seq__53840_55642 = G__55648;
chunk__53841_55643 = G__55650;
count__53842_55644 = G__55651;
i__53843_55645 = G__55652;
continue;
} else {
var temp__5804__auto___55653 = cljs.core.seq(seq__53840_55642);
if(temp__5804__auto___55653){
var seq__53840_55654__$1 = temp__5804__auto___55653;
if(cljs.core.chunked_seq_QMARK_(seq__53840_55654__$1)){
var c__5568__auto___55656 = cljs.core.chunk_first(seq__53840_55654__$1);
var G__55657 = cljs.core.chunk_rest(seq__53840_55654__$1);
var G__55658 = c__5568__auto___55656;
var G__55659 = cljs.core.count(c__5568__auto___55656);
var G__55660 = (0);
seq__53840_55642 = G__55657;
chunk__53841_55643 = G__55658;
count__53842_55644 = G__55659;
i__53843_55645 = G__55660;
continue;
} else {
var e_55664 = cljs.core.first(seq__53840_55654__$1);
if(cljs.core.truth_(e_55664)){
print_comment_lines(e_55664);
} else {
}


var G__55665 = cljs.core.next(seq__53840_55654__$1);
var G__55666 = null;
var G__55667 = (0);
var G__55668 = (0);
seq__53840_55642 = G__55665;
chunk__53841_55643 = G__55666;
count__53842_55644 = G__55667;
i__53843_55645 = G__55668;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__5043__auto__ = cljs.core.some((function (p1__53865_SHARP_){
return goog.string.startsWith(p1__53865_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = opts;
if(cljs.core.truth_(and__5043__auto____$1)){
var and__5043__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__5043__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__53873){
var map__53875 = p__53873;
var map__53875__$1 = cljs.core.__destructure_map(map__53875);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53875__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53875__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53875__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53875__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53875__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53875__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53875__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53875__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53875__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53875__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__5045__auto__ = init;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5802__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5802__auto__)){
var define = temp__5802__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return test;
} else {
return and__5043__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__53894){
var map__53897 = p__53894;
var map__53897__$1 = cljs.core.__destructure_map(map__53897);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53897__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53897__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53897__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__53898_55679 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__53899_55680 = null;
var count__53900_55681 = (0);
var i__53901_55682 = (0);
while(true){
if((i__53901_55682 < count__53900_55681)){
var vec__53921_55683 = chunk__53899_55680.cljs$core$IIndexed$_nth$arity$2(null,i__53901_55682);
var i_55684 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53921_55683,(0),null);
var param_55685 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53921_55683,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_55685);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__55687 = seq__53898_55679;
var G__55688 = chunk__53899_55680;
var G__55689 = count__53900_55681;
var G__55690 = (i__53901_55682 + (1));
seq__53898_55679 = G__55687;
chunk__53899_55680 = G__55688;
count__53900_55681 = G__55689;
i__53901_55682 = G__55690;
continue;
} else {
var temp__5804__auto___55691 = cljs.core.seq(seq__53898_55679);
if(temp__5804__auto___55691){
var seq__53898_55692__$1 = temp__5804__auto___55691;
if(cljs.core.chunked_seq_QMARK_(seq__53898_55692__$1)){
var c__5568__auto___55693 = cljs.core.chunk_first(seq__53898_55692__$1);
var G__55694 = cljs.core.chunk_rest(seq__53898_55692__$1);
var G__55695 = c__5568__auto___55693;
var G__55696 = cljs.core.count(c__5568__auto___55693);
var G__55697 = (0);
seq__53898_55679 = G__55694;
chunk__53899_55680 = G__55695;
count__53900_55681 = G__55696;
i__53901_55682 = G__55697;
continue;
} else {
var vec__53935_55698 = cljs.core.first(seq__53898_55692__$1);
var i_55699 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53935_55698,(0),null);
var param_55700 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53935_55698,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_55700);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__55701 = cljs.core.next(seq__53898_55692__$1);
var G__55702 = null;
var G__55703 = (0);
var G__55704 = (0);
seq__53898_55679 = G__55701;
chunk__53899_55680 = G__55702;
count__53900_55681 = G__55703;
i__53901_55682 = G__55704;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__53945_55705 = cljs.core.seq(params);
var chunk__53946_55706 = null;
var count__53947_55707 = (0);
var i__53948_55708 = (0);
while(true){
if((i__53948_55708 < count__53947_55707)){
var param_55709 = chunk__53946_55706.cljs$core$IIndexed$_nth$arity$2(null,i__53948_55708);
cljs.compiler.emit(param_55709);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_55709,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__55710 = seq__53945_55705;
var G__55711 = chunk__53946_55706;
var G__55712 = count__53947_55707;
var G__55713 = (i__53948_55708 + (1));
seq__53945_55705 = G__55710;
chunk__53946_55706 = G__55711;
count__53947_55707 = G__55712;
i__53948_55708 = G__55713;
continue;
} else {
var temp__5804__auto___55714 = cljs.core.seq(seq__53945_55705);
if(temp__5804__auto___55714){
var seq__53945_55715__$1 = temp__5804__auto___55714;
if(cljs.core.chunked_seq_QMARK_(seq__53945_55715__$1)){
var c__5568__auto___55717 = cljs.core.chunk_first(seq__53945_55715__$1);
var G__55718 = cljs.core.chunk_rest(seq__53945_55715__$1);
var G__55719 = c__5568__auto___55717;
var G__55720 = cljs.core.count(c__5568__auto___55717);
var G__55721 = (0);
seq__53945_55705 = G__55718;
chunk__53946_55706 = G__55719;
count__53947_55707 = G__55720;
i__53948_55708 = G__55721;
continue;
} else {
var param_55722 = cljs.core.first(seq__53945_55715__$1);
cljs.compiler.emit(param_55722);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_55722,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__55723 = cljs.core.next(seq__53945_55715__$1);
var G__55724 = null;
var G__55725 = (0);
var G__55726 = (0);
seq__53945_55705 = G__55723;
chunk__53946_55706 = G__55724;
count__53947_55707 = G__55725;
i__53948_55708 = G__55726;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__53965_55728 = cljs.core.seq(params);
var chunk__53966_55729 = null;
var count__53967_55730 = (0);
var i__53968_55731 = (0);
while(true){
if((i__53968_55731 < count__53967_55730)){
var param_55732 = chunk__53966_55729.cljs$core$IIndexed$_nth$arity$2(null,i__53968_55731);
cljs.compiler.emit(param_55732);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_55732,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__55736 = seq__53965_55728;
var G__55737 = chunk__53966_55729;
var G__55738 = count__53967_55730;
var G__55739 = (i__53968_55731 + (1));
seq__53965_55728 = G__55736;
chunk__53966_55729 = G__55737;
count__53967_55730 = G__55738;
i__53968_55731 = G__55739;
continue;
} else {
var temp__5804__auto___55740 = cljs.core.seq(seq__53965_55728);
if(temp__5804__auto___55740){
var seq__53965_55741__$1 = temp__5804__auto___55740;
if(cljs.core.chunked_seq_QMARK_(seq__53965_55741__$1)){
var c__5568__auto___55742 = cljs.core.chunk_first(seq__53965_55741__$1);
var G__55744 = cljs.core.chunk_rest(seq__53965_55741__$1);
var G__55745 = c__5568__auto___55742;
var G__55746 = cljs.core.count(c__5568__auto___55742);
var G__55747 = (0);
seq__53965_55728 = G__55744;
chunk__53966_55729 = G__55745;
count__53967_55730 = G__55746;
i__53968_55731 = G__55747;
continue;
} else {
var param_55749 = cljs.core.first(seq__53965_55741__$1);
cljs.compiler.emit(param_55749);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_55749,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__55750 = cljs.core.next(seq__53965_55741__$1);
var G__55751 = null;
var G__55752 = (0);
var G__55753 = (0);
seq__53965_55728 = G__55750;
chunk__53966_55729 = G__55751;
count__53967_55730 = G__55752;
i__53968_55731 = G__55753;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__53993 = cljs.core.seq(params);
var chunk__53994 = null;
var count__53995 = (0);
var i__53996 = (0);
while(true){
if((i__53996 < count__53995)){
var param = chunk__53994.cljs$core$IIndexed$_nth$arity$2(null,i__53996);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__55756 = seq__53993;
var G__55757 = chunk__53994;
var G__55758 = count__53995;
var G__55759 = (i__53996 + (1));
seq__53993 = G__55756;
chunk__53994 = G__55757;
count__53995 = G__55758;
i__53996 = G__55759;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__53993);
if(temp__5804__auto__){
var seq__53993__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53993__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__53993__$1);
var G__55760 = cljs.core.chunk_rest(seq__53993__$1);
var G__55761 = c__5568__auto__;
var G__55762 = cljs.core.count(c__5568__auto__);
var G__55763 = (0);
seq__53993 = G__55760;
chunk__53994 = G__55761;
count__53995 = G__55762;
i__53996 = G__55763;
continue;
} else {
var param = cljs.core.first(seq__53993__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__55764 = cljs.core.next(seq__53993__$1);
var G__55765 = null;
var G__55766 = (0);
var G__55767 = (0);
seq__53993 = G__55764;
chunk__53994 = G__55765;
count__53995 = G__55766;
i__53996 = G__55767;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__54031){
var map__54036 = p__54031;
var map__54036__$1 = cljs.core.__destructure_map(map__54036);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54036__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54036__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54036__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54036__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54036__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54036__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__54078){
var map__54079 = p__54078;
var map__54079__$1 = cljs.core.__destructure_map(map__54079);
var f = map__54079__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54079__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54079__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54079__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54079__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54079__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54079__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54079__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54079__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_55780__$1 = (function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_55781 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_55780__$1);
var delegate_name_55782 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_55781),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_55782," = function (");

var seq__54089_55784 = cljs.core.seq(params);
var chunk__54090_55785 = null;
var count__54091_55786 = (0);
var i__54092_55787 = (0);
while(true){
if((i__54092_55787 < count__54091_55786)){
var param_55789 = chunk__54090_55785.cljs$core$IIndexed$_nth$arity$2(null,i__54092_55787);
cljs.compiler.emit(param_55789);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_55789,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__55791 = seq__54089_55784;
var G__55792 = chunk__54090_55785;
var G__55793 = count__54091_55786;
var G__55794 = (i__54092_55787 + (1));
seq__54089_55784 = G__55791;
chunk__54090_55785 = G__55792;
count__54091_55786 = G__55793;
i__54092_55787 = G__55794;
continue;
} else {
var temp__5804__auto___55795 = cljs.core.seq(seq__54089_55784);
if(temp__5804__auto___55795){
var seq__54089_55796__$1 = temp__5804__auto___55795;
if(cljs.core.chunked_seq_QMARK_(seq__54089_55796__$1)){
var c__5568__auto___55799 = cljs.core.chunk_first(seq__54089_55796__$1);
var G__55800 = cljs.core.chunk_rest(seq__54089_55796__$1);
var G__55801 = c__5568__auto___55799;
var G__55802 = cljs.core.count(c__5568__auto___55799);
var G__55803 = (0);
seq__54089_55784 = G__55800;
chunk__54090_55785 = G__55801;
count__54091_55786 = G__55802;
i__54092_55787 = G__55803;
continue;
} else {
var param_55804 = cljs.core.first(seq__54089_55796__$1);
cljs.compiler.emit(param_55804);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_55804,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__55807 = cljs.core.next(seq__54089_55796__$1);
var G__55808 = null;
var G__55809 = (0);
var G__55810 = (0);
seq__54089_55784 = G__55807;
chunk__54090_55785 = G__55808;
count__54091_55786 = G__55809;
i__54092_55787 = G__55810;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_55781," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_55813 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_55813,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_55782,".call(this,");

var seq__54130_55817 = cljs.core.seq(params);
var chunk__54131_55818 = null;
var count__54132_55819 = (0);
var i__54133_55820 = (0);
while(true){
if((i__54133_55820 < count__54132_55819)){
var param_55821 = chunk__54131_55818.cljs$core$IIndexed$_nth$arity$2(null,i__54133_55820);
cljs.compiler.emit(param_55821);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_55821,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__55822 = seq__54130_55817;
var G__55823 = chunk__54131_55818;
var G__55824 = count__54132_55819;
var G__55825 = (i__54133_55820 + (1));
seq__54130_55817 = G__55822;
chunk__54131_55818 = G__55823;
count__54132_55819 = G__55824;
i__54133_55820 = G__55825;
continue;
} else {
var temp__5804__auto___55826 = cljs.core.seq(seq__54130_55817);
if(temp__5804__auto___55826){
var seq__54130_55827__$1 = temp__5804__auto___55826;
if(cljs.core.chunked_seq_QMARK_(seq__54130_55827__$1)){
var c__5568__auto___55832 = cljs.core.chunk_first(seq__54130_55827__$1);
var G__55833 = cljs.core.chunk_rest(seq__54130_55827__$1);
var G__55834 = c__5568__auto___55832;
var G__55835 = cljs.core.count(c__5568__auto___55832);
var G__55836 = (0);
seq__54130_55817 = G__55833;
chunk__54131_55818 = G__55834;
count__54132_55819 = G__55835;
i__54133_55820 = G__55836;
continue;
} else {
var param_55837 = cljs.core.first(seq__54130_55827__$1);
cljs.compiler.emit(param_55837);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_55837,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__55842 = cljs.core.next(seq__54130_55827__$1);
var G__55843 = null;
var G__55844 = (0);
var G__55845 = (0);
seq__54130_55817 = G__55842;
chunk__54131_55818 = G__55843;
count__54132_55819 = G__55844;
i__54133_55820 = G__55845;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_55781,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_55781,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_55780__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_55781,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_55782,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_55781,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__54168){
var map__54170 = p__54168;
var map__54170__$1 = cljs.core.__destructure_map(map__54170);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54170__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54170__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54170__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54170__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54170__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54170__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54170__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54170__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__54162_SHARP_){
var and__5043__auto__ = p1__54162_SHARP_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__54162_SHARP_));
} else {
return and__5043__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__5045__auto__ = in_loop;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_55858__$1 = (function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_55859 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_55858__$1);
var maxparams_55860 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_55861 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_55859),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_55862 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__54163_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__54163_SHARP_)));
}),cljs.core.seq(mmap_55861));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_55859," = null;");

var seq__54214_55868 = cljs.core.seq(ms_55862);
var chunk__54215_55869 = null;
var count__54216_55870 = (0);
var i__54217_55871 = (0);
while(true){
if((i__54217_55871 < count__54216_55870)){
var vec__54232_55872 = chunk__54215_55869.cljs$core$IIndexed$_nth$arity$2(null,i__54217_55871);
var n_55873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54232_55872,(0),null);
var meth_55874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54232_55872,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_55873," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_55874))){
cljs.compiler.emit_variadic_fn_method(meth_55874);
} else {
cljs.compiler.emit_fn_method(meth_55874);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__55876 = seq__54214_55868;
var G__55877 = chunk__54215_55869;
var G__55878 = count__54216_55870;
var G__55879 = (i__54217_55871 + (1));
seq__54214_55868 = G__55876;
chunk__54215_55869 = G__55877;
count__54216_55870 = G__55878;
i__54217_55871 = G__55879;
continue;
} else {
var temp__5804__auto___55880 = cljs.core.seq(seq__54214_55868);
if(temp__5804__auto___55880){
var seq__54214_55881__$1 = temp__5804__auto___55880;
if(cljs.core.chunked_seq_QMARK_(seq__54214_55881__$1)){
var c__5568__auto___55882 = cljs.core.chunk_first(seq__54214_55881__$1);
var G__55883 = cljs.core.chunk_rest(seq__54214_55881__$1);
var G__55884 = c__5568__auto___55882;
var G__55885 = cljs.core.count(c__5568__auto___55882);
var G__55886 = (0);
seq__54214_55868 = G__55883;
chunk__54215_55869 = G__55884;
count__54216_55870 = G__55885;
i__54217_55871 = G__55886;
continue;
} else {
var vec__54237_55887 = cljs.core.first(seq__54214_55881__$1);
var n_55888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54237_55887,(0),null);
var meth_55889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54237_55887,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_55888," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_55889))){
cljs.compiler.emit_variadic_fn_method(meth_55889);
} else {
cljs.compiler.emit_fn_method(meth_55889);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__55891 = cljs.core.next(seq__54214_55881__$1);
var G__55892 = null;
var G__55893 = (0);
var G__55894 = (0);
seq__54214_55868 = G__55891;
chunk__54215_55869 = G__55892;
count__54216_55870 = G__55893;
i__54217_55871 = G__55894;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_55859," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_55860),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_55860)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_55860));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__54252_55896 = cljs.core.seq(ms_55862);
var chunk__54253_55897 = null;
var count__54254_55898 = (0);
var i__54255_55899 = (0);
while(true){
if((i__54255_55899 < count__54254_55898)){
var vec__54294_55900 = chunk__54253_55897.cljs$core$IIndexed$_nth$arity$2(null,i__54255_55899);
var n_55901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54294_55900,(0),null);
var meth_55902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54294_55900,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_55902))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_55903 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_55903," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_55904 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_55903," = new cljs.core.IndexedSeq(",a_55904,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_55901,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_55860)),(((cljs.core.count(maxparams_55860) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_55903,");"], 0));
} else {
var pcnt_55909 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_55902));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_55909,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_55901,".call(this",(((pcnt_55909 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_55909,maxparams_55860)),null,(1),null)),(2),null))),");");
}


var G__55912 = seq__54252_55896;
var G__55913 = chunk__54253_55897;
var G__55914 = count__54254_55898;
var G__55915 = (i__54255_55899 + (1));
seq__54252_55896 = G__55912;
chunk__54253_55897 = G__55913;
count__54254_55898 = G__55914;
i__54255_55899 = G__55915;
continue;
} else {
var temp__5804__auto___55917 = cljs.core.seq(seq__54252_55896);
if(temp__5804__auto___55917){
var seq__54252_55918__$1 = temp__5804__auto___55917;
if(cljs.core.chunked_seq_QMARK_(seq__54252_55918__$1)){
var c__5568__auto___55919 = cljs.core.chunk_first(seq__54252_55918__$1);
var G__55920 = cljs.core.chunk_rest(seq__54252_55918__$1);
var G__55921 = c__5568__auto___55919;
var G__55922 = cljs.core.count(c__5568__auto___55919);
var G__55923 = (0);
seq__54252_55896 = G__55920;
chunk__54253_55897 = G__55921;
count__54254_55898 = G__55922;
i__54255_55899 = G__55923;
continue;
} else {
var vec__54308_55924 = cljs.core.first(seq__54252_55918__$1);
var n_55925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54308_55924,(0),null);
var meth_55926 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54308_55924,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_55926))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_55927 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_55927," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_55928 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_55927," = new cljs.core.IndexedSeq(",a_55928,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_55925,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_55860)),(((cljs.core.count(maxparams_55860) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_55927,");"], 0));
} else {
var pcnt_55930 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_55926));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_55930,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_55925,".call(this",(((pcnt_55930 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_55930,maxparams_55860)),null,(1),null)),(2),null))),");");
}


var G__55932 = cljs.core.next(seq__54252_55918__$1);
var G__55933 = null;
var G__55934 = (0);
var G__55935 = (0);
seq__54252_55896 = G__55932;
chunk__54253_55897 = G__55933;
count__54254_55898 = G__55934;
i__54255_55899 = G__55935;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_55936 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_55862)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_55936,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_55859,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_55859,".cljs$lang$applyTo = ",cljs.core.some((function (p1__54165_SHARP_){
var vec__54321 = p1__54165_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54321,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54321,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_55862),".cljs$lang$applyTo;");
} else {
}

var seq__54326_55941 = cljs.core.seq(ms_55862);
var chunk__54327_55942 = null;
var count__54328_55943 = (0);
var i__54329_55944 = (0);
while(true){
if((i__54329_55944 < count__54328_55943)){
var vec__54342_55945 = chunk__54327_55942.cljs$core$IIndexed$_nth$arity$2(null,i__54329_55944);
var n_55946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54342_55945,(0),null);
var meth_55947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54342_55945,(1),null);
var c_55948 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_55947));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_55947))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_55859,".cljs$core$IFn$_invoke$arity$variadic = ",n_55946,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_55859,".cljs$core$IFn$_invoke$arity$",c_55948," = ",n_55946,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__55949 = seq__54326_55941;
var G__55950 = chunk__54327_55942;
var G__55951 = count__54328_55943;
var G__55952 = (i__54329_55944 + (1));
seq__54326_55941 = G__55949;
chunk__54327_55942 = G__55950;
count__54328_55943 = G__55951;
i__54329_55944 = G__55952;
continue;
} else {
var temp__5804__auto___55954 = cljs.core.seq(seq__54326_55941);
if(temp__5804__auto___55954){
var seq__54326_55956__$1 = temp__5804__auto___55954;
if(cljs.core.chunked_seq_QMARK_(seq__54326_55956__$1)){
var c__5568__auto___55957 = cljs.core.chunk_first(seq__54326_55956__$1);
var G__55958 = cljs.core.chunk_rest(seq__54326_55956__$1);
var G__55959 = c__5568__auto___55957;
var G__55960 = cljs.core.count(c__5568__auto___55957);
var G__55961 = (0);
seq__54326_55941 = G__55958;
chunk__54327_55942 = G__55959;
count__54328_55943 = G__55960;
i__54329_55944 = G__55961;
continue;
} else {
var vec__54348_55962 = cljs.core.first(seq__54326_55956__$1);
var n_55963 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54348_55962,(0),null);
var meth_55964 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54348_55962,(1),null);
var c_55966 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_55964));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_55964))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_55859,".cljs$core$IFn$_invoke$arity$variadic = ",n_55963,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_55859,".cljs$core$IFn$_invoke$arity$",c_55966," = ",n_55963,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__55971 = cljs.core.next(seq__54326_55956__$1);
var G__55972 = null;
var G__55973 = (0);
var G__55974 = (0);
seq__54326_55941 = G__55971;
chunk__54327_55942 = G__55972;
count__54328_55943 = G__55973;
i__54329_55944 = G__55974;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_55859,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__54352){
var map__54353 = p__54352;
var map__54353__$1 = cljs.core.__destructure_map(map__54353);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54353__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54353__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54353__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__54359_55975 = cljs.core.seq(statements);
var chunk__54360_55976 = null;
var count__54361_55977 = (0);
var i__54362_55978 = (0);
while(true){
if((i__54362_55978 < count__54361_55977)){
var s_55979 = chunk__54360_55976.cljs$core$IIndexed$_nth$arity$2(null,i__54362_55978);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_55979);


var G__55980 = seq__54359_55975;
var G__55981 = chunk__54360_55976;
var G__55982 = count__54361_55977;
var G__55983 = (i__54362_55978 + (1));
seq__54359_55975 = G__55980;
chunk__54360_55976 = G__55981;
count__54361_55977 = G__55982;
i__54362_55978 = G__55983;
continue;
} else {
var temp__5804__auto___55984 = cljs.core.seq(seq__54359_55975);
if(temp__5804__auto___55984){
var seq__54359_55985__$1 = temp__5804__auto___55984;
if(cljs.core.chunked_seq_QMARK_(seq__54359_55985__$1)){
var c__5568__auto___55986 = cljs.core.chunk_first(seq__54359_55985__$1);
var G__55987 = cljs.core.chunk_rest(seq__54359_55985__$1);
var G__55988 = c__5568__auto___55986;
var G__55989 = cljs.core.count(c__5568__auto___55986);
var G__55990 = (0);
seq__54359_55975 = G__55987;
chunk__54360_55976 = G__55988;
count__54361_55977 = G__55989;
i__54362_55978 = G__55990;
continue;
} else {
var s_55991 = cljs.core.first(seq__54359_55985__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_55991);


var G__55992 = cljs.core.next(seq__54359_55985__$1);
var G__55993 = null;
var G__55994 = (0);
var G__55995 = (0);
seq__54359_55975 = G__55992;
chunk__54360_55976 = G__55993;
count__54361_55977 = G__55994;
i__54362_55978 = G__55995;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__54382){
var map__54383 = p__54382;
var map__54383__$1 = cljs.core.__destructure_map(map__54383);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54383__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54383__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54383__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54383__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54383__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__54398,is_loop){
var map__54407 = p__54398;
var map__54407__$1 = cljs.core.__destructure_map(map__54407);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54407__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54407__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54407__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__54414_55998 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__54415_55999 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__54415_55999);

try{var seq__54422_56002 = cljs.core.seq(bindings);
var chunk__54423_56003 = null;
var count__54424_56004 = (0);
var i__54425_56005 = (0);
while(true){
if((i__54425_56005 < count__54424_56004)){
var map__54444_56006 = chunk__54423_56003.cljs$core$IIndexed$_nth$arity$2(null,i__54425_56005);
var map__54444_56007__$1 = cljs.core.__destructure_map(map__54444_56006);
var binding_56008 = map__54444_56007__$1;
var init_56009 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54444_56007__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_56008);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_56009,";");


var G__56010 = seq__54422_56002;
var G__56011 = chunk__54423_56003;
var G__56012 = count__54424_56004;
var G__56013 = (i__54425_56005 + (1));
seq__54422_56002 = G__56010;
chunk__54423_56003 = G__56011;
count__54424_56004 = G__56012;
i__54425_56005 = G__56013;
continue;
} else {
var temp__5804__auto___56014 = cljs.core.seq(seq__54422_56002);
if(temp__5804__auto___56014){
var seq__54422_56016__$1 = temp__5804__auto___56014;
if(cljs.core.chunked_seq_QMARK_(seq__54422_56016__$1)){
var c__5568__auto___56018 = cljs.core.chunk_first(seq__54422_56016__$1);
var G__56019 = cljs.core.chunk_rest(seq__54422_56016__$1);
var G__56020 = c__5568__auto___56018;
var G__56021 = cljs.core.count(c__5568__auto___56018);
var G__56022 = (0);
seq__54422_56002 = G__56019;
chunk__54423_56003 = G__56020;
count__54424_56004 = G__56021;
i__54425_56005 = G__56022;
continue;
} else {
var map__54452_56023 = cljs.core.first(seq__54422_56016__$1);
var map__54452_56024__$1 = cljs.core.__destructure_map(map__54452_56023);
var binding_56025 = map__54452_56024__$1;
var init_56026 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54452_56024__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_56025);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_56026,";");


var G__56029 = cljs.core.next(seq__54422_56016__$1);
var G__56031 = null;
var G__56032 = (0);
var G__56033 = (0);
seq__54422_56002 = G__56029;
chunk__54423_56003 = G__56031;
count__54424_56004 = G__56032;
i__54425_56005 = G__56033;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__54414_55998);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__54462){
var map__54466 = p__54462;
var map__54466__$1 = cljs.core.__destructure_map(map__54466);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54466__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54466__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54466__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__5636__auto___56045 = cljs.core.count(exprs);
var i_56049 = (0);
while(true){
if((i_56049 < n__5636__auto___56045)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_56049) : temps.call(null,i_56049))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_56049) : exprs.call(null,i_56049)),";");

var G__56051 = (i_56049 + (1));
i_56049 = G__56051;
continue;
} else {
}
break;
}

var n__5636__auto___56053 = cljs.core.count(exprs);
var i_56054 = (0);
while(true){
if((i_56054 < n__5636__auto___56053)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_56054) : params.call(null,i_56054)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_56054) : temps.call(null,i_56054)),";");

var G__56055 = (i_56054 + (1));
i_56054 = G__56055;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__54473){
var map__54475 = p__54473;
var map__54475__$1 = cljs.core.__destructure_map(map__54475);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54475__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54475__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54475__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__54482_56063 = cljs.core.seq(bindings);
var chunk__54483_56064 = null;
var count__54484_56065 = (0);
var i__54485_56066 = (0);
while(true){
if((i__54485_56066 < count__54484_56065)){
var map__54493_56069 = chunk__54483_56064.cljs$core$IIndexed$_nth$arity$2(null,i__54485_56066);
var map__54493_56070__$1 = cljs.core.__destructure_map(map__54493_56069);
var binding_56071 = map__54493_56070__$1;
var init_56072 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54493_56070__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_56071)," = ",init_56072,";");


var G__56079 = seq__54482_56063;
var G__56080 = chunk__54483_56064;
var G__56081 = count__54484_56065;
var G__56082 = (i__54485_56066 + (1));
seq__54482_56063 = G__56079;
chunk__54483_56064 = G__56080;
count__54484_56065 = G__56081;
i__54485_56066 = G__56082;
continue;
} else {
var temp__5804__auto___56085 = cljs.core.seq(seq__54482_56063);
if(temp__5804__auto___56085){
var seq__54482_56088__$1 = temp__5804__auto___56085;
if(cljs.core.chunked_seq_QMARK_(seq__54482_56088__$1)){
var c__5568__auto___56091 = cljs.core.chunk_first(seq__54482_56088__$1);
var G__56092 = cljs.core.chunk_rest(seq__54482_56088__$1);
var G__56093 = c__5568__auto___56091;
var G__56094 = cljs.core.count(c__5568__auto___56091);
var G__56095 = (0);
seq__54482_56063 = G__56092;
chunk__54483_56064 = G__56093;
count__54484_56065 = G__56094;
i__54485_56066 = G__56095;
continue;
} else {
var map__54497_56099 = cljs.core.first(seq__54482_56088__$1);
var map__54497_56100__$1 = cljs.core.__destructure_map(map__54497_56099);
var binding_56101 = map__54497_56100__$1;
var init_56102 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54497_56100__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_56101)," = ",init_56102,";");


var G__56113 = cljs.core.next(seq__54482_56088__$1);
var G__56114 = null;
var G__56115 = (0);
var G__56116 = (0);
seq__54482_56063 = G__56113;
chunk__54483_56064 = G__56114;
count__54484_56065 = G__56115;
i__54485_56066 = G__56116;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__54518){
var map__54519 = p__54518;
var map__54519__$1 = cljs.core.__destructure_map(map__54519);
var expr = map__54519__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54519__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54519__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54519__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__5043__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__5043__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__5043__auto__ = protocol;
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = tag;
if(cljs.core.truth_(and__5043__auto____$1)){
var or__5045__auto__ = (function (){var and__5043__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto____$2)){
var and__5043__auto____$3 = protocol;
if(cljs.core.truth_(and__5043__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__5043__auto____$3;
}
} else {
return and__5043__auto____$2;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto____$2 = (function (){var or__5045__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__5043__auto____$2)){
var or__5045__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
var and__5043__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__5043__auto____$3){
var and__5043__auto____$4 = cljs.core.not((function (){var fexpr__54525 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__54525.cljs$core$IFn$_invoke$arity$1 ? fexpr__54525.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__54525.call(null,tag));
})());
if(and__5043__auto____$4){
var temp__5804__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5804__auto__)){
var ps = temp__5804__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__5043__auto____$4;
}
} else {
return and__5043__auto____$3;
}
}
} else {
return and__5043__auto____$2;
}
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__54527 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__54527.cljs$core$IFn$_invoke$arity$1 ? fexpr__54527.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__54527.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__5045__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__5045__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = (function (){var temp__5804__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5804__auto__)){
var ns_str = temp__5804__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__5045__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__5045__auto__){
return or__5045__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__54521 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (arity > mfa);
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__54511_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__54511_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__54512_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__54512_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54521,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54521,(1),null);
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_56175 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_56175,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_56179 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_56179,args)),(((mfa_56179 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_56179,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
var G__54607 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__54606 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__54606.cljs$core$IFn$_invoke$arity$1 ? fexpr__54606.cljs$core$IFn$_invoke$arity$1(G__54607) : fexpr__54606.call(null,G__54607));
} else {
return and__5043__auto__;
}
})())){
var fprop_56184 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_56184," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_56184,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_56184," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_56184,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__54619){
var map__54621 = p__54619;
var map__54621__$1 = cljs.core.__destructure_map(map__54621);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54621__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54621__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54621__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__54623){
var map__54625 = p__54623;
var map__54625__$1 = cljs.core.__destructure_map(map__54625);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54625__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54625__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54625__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__54628_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__54628_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__54644 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54644,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54644,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__54685 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__54685__$1 = cljs.core.__destructure_map(map__54685);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54685__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54685__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__54687 = options;
var map__54687__$1 = cljs.core.__destructure_map(map__54687);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54687__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54687__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54687__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__54688 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__54715 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__54715__$1 = cljs.core.__destructure_map(map__54715);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54715__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54715__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54688,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54688,(1),null);
var vec__54691 = (function (){var map__54727 = cljs.core.group_by(cljs.analyzer.goog_module_dep_QMARK_,libs_to_load);
var map__54727__$1 = cljs.core.__destructure_map(map__54727);
var goog_modules = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54727__$1,true);
var libs_to_load__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54727__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goog_modules,libs_to_load__$1], null);
})();
var goog_modules = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54691,(0),null);
var libs_to_load__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54691,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load__$1);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__54736_56192 = cljs.core.seq(libs_to_load__$1);
var chunk__54740_56193 = null;
var count__54741_56194 = (0);
var i__54742_56195 = (0);
while(true){
if((i__54742_56195 < count__54741_56194)){
var lib_56196 = chunk__54740_56193.cljs$core$IIndexed$_nth$arity$2(null,i__54742_56195);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_56196)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_56196),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_56196),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_56196),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_56196),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_56196,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_56196),"');");
}

}
}
}


var G__56197 = seq__54736_56192;
var G__56198 = chunk__54740_56193;
var G__56199 = count__54741_56194;
var G__56200 = (i__54742_56195 + (1));
seq__54736_56192 = G__56197;
chunk__54740_56193 = G__56198;
count__54741_56194 = G__56199;
i__54742_56195 = G__56200;
continue;
} else {
var temp__5804__auto___56201 = cljs.core.seq(seq__54736_56192);
if(temp__5804__auto___56201){
var seq__54736_56202__$1 = temp__5804__auto___56201;
if(cljs.core.chunked_seq_QMARK_(seq__54736_56202__$1)){
var c__5568__auto___56203 = cljs.core.chunk_first(seq__54736_56202__$1);
var G__56204 = cljs.core.chunk_rest(seq__54736_56202__$1);
var G__56205 = c__5568__auto___56203;
var G__56206 = cljs.core.count(c__5568__auto___56203);
var G__56207 = (0);
seq__54736_56192 = G__56204;
chunk__54740_56193 = G__56205;
count__54741_56194 = G__56206;
i__54742_56195 = G__56207;
continue;
} else {
var lib_56208 = cljs.core.first(seq__54736_56202__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_56208)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_56208),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_56208),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_56208),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_56208),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_56208,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_56208),"');");
}

}
}
}


var G__56210 = cljs.core.next(seq__54736_56202__$1);
var G__56211 = null;
var G__56212 = (0);
var G__56213 = (0);
seq__54736_56192 = G__56210;
chunk__54740_56193 = G__56211;
count__54741_56194 = G__56212;
i__54742_56195 = G__56213;
continue;
}
} else {
}
}
break;
}

var seq__54781_56216 = cljs.core.seq(node_libs);
var chunk__54782_56217 = null;
var count__54783_56218 = (0);
var i__54784_56219 = (0);
while(true){
if((i__54784_56219 < count__54783_56218)){
var lib_56221 = chunk__54782_56217.cljs$core$IIndexed$_nth$arity$2(null,i__54784_56219);
var vec__54799_56222 = cljs.analyzer.lib_AMPERSAND_sublib(lib_56221);
var lib_SINGLEQUOTE__56223 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54799_56222,(0),null);
var sublib_56224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54799_56222,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_56221)," = require('",lib_SINGLEQUOTE__56223,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_56224),";"], 0));


var G__56225 = seq__54781_56216;
var G__56226 = chunk__54782_56217;
var G__56227 = count__54783_56218;
var G__56228 = (i__54784_56219 + (1));
seq__54781_56216 = G__56225;
chunk__54782_56217 = G__56226;
count__54783_56218 = G__56227;
i__54784_56219 = G__56228;
continue;
} else {
var temp__5804__auto___56229 = cljs.core.seq(seq__54781_56216);
if(temp__5804__auto___56229){
var seq__54781_56230__$1 = temp__5804__auto___56229;
if(cljs.core.chunked_seq_QMARK_(seq__54781_56230__$1)){
var c__5568__auto___56231 = cljs.core.chunk_first(seq__54781_56230__$1);
var G__56232 = cljs.core.chunk_rest(seq__54781_56230__$1);
var G__56233 = c__5568__auto___56231;
var G__56234 = cljs.core.count(c__5568__auto___56231);
var G__56235 = (0);
seq__54781_56216 = G__56232;
chunk__54782_56217 = G__56233;
count__54783_56218 = G__56234;
i__54784_56219 = G__56235;
continue;
} else {
var lib_56236 = cljs.core.first(seq__54781_56230__$1);
var vec__54808_56237 = cljs.analyzer.lib_AMPERSAND_sublib(lib_56236);
var lib_SINGLEQUOTE__56238 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54808_56237,(0),null);
var sublib_56239 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54808_56237,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_56236)," = require('",lib_SINGLEQUOTE__56238,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_56239),";"], 0));


var G__56240 = cljs.core.next(seq__54781_56230__$1);
var G__56241 = null;
var G__56242 = (0);
var G__56243 = (0);
seq__54781_56216 = G__56240;
chunk__54782_56217 = G__56241;
count__54783_56218 = G__56242;
i__54784_56219 = G__56243;
continue;
}
} else {
}
}
break;
}

var seq__54812_56244 = cljs.core.seq(goog_modules);
var chunk__54813_56245 = null;
var count__54814_56246 = (0);
var i__54815_56247 = (0);
while(true){
if((i__54815_56247 < count__54814_56246)){
var lib_56248 = chunk__54813_56245.cljs$core$IIndexed$_nth$arity$2(null,i__54815_56247);
var vec__54832_56249 = cljs.analyzer.lib_AMPERSAND_sublib(lib_56248);
var lib_SINGLEQUOTE__56250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54832_56249,(0),null);
var sublib_56251 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54832_56249,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",lib_SINGLEQUOTE__56250,"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.scope(function(){");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_goog_module_lib.cljs$core$IFn$_invoke$arity$1(lib_56248)," = goog.module.get('",lib_SINGLEQUOTE__56250,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_56251),";"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");


var G__56253 = seq__54812_56244;
var G__56254 = chunk__54813_56245;
var G__56255 = count__54814_56246;
var G__56256 = (i__54815_56247 + (1));
seq__54812_56244 = G__56253;
chunk__54813_56245 = G__56254;
count__54814_56246 = G__56255;
i__54815_56247 = G__56256;
continue;
} else {
var temp__5804__auto___56257 = cljs.core.seq(seq__54812_56244);
if(temp__5804__auto___56257){
var seq__54812_56258__$1 = temp__5804__auto___56257;
if(cljs.core.chunked_seq_QMARK_(seq__54812_56258__$1)){
var c__5568__auto___56259 = cljs.core.chunk_first(seq__54812_56258__$1);
var G__56260 = cljs.core.chunk_rest(seq__54812_56258__$1);
var G__56261 = c__5568__auto___56259;
var G__56262 = cljs.core.count(c__5568__auto___56259);
var G__56263 = (0);
seq__54812_56244 = G__56260;
chunk__54813_56245 = G__56261;
count__54814_56246 = G__56262;
i__54815_56247 = G__56263;
continue;
} else {
var lib_56264 = cljs.core.first(seq__54812_56258__$1);
var vec__54836_56265 = cljs.analyzer.lib_AMPERSAND_sublib(lib_56264);
var lib_SINGLEQUOTE__56266 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54836_56265,(0),null);
var sublib_56267 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54836_56265,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",lib_SINGLEQUOTE__56266,"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.scope(function(){");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_goog_module_lib.cljs$core$IFn$_invoke$arity$1(lib_56264)," = goog.module.get('",lib_SINGLEQUOTE__56266,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_56267),";"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");


var G__56269 = cljs.core.next(seq__54812_56258__$1);
var G__56270 = null;
var G__56271 = (0);
var G__56272 = (0);
seq__54812_56244 = G__56269;
chunk__54813_56245 = G__56270;
count__54814_56246 = G__56271;
i__54815_56247 = G__56272;
continue;
}
} else {
}
}
break;
}

var seq__54843_56274 = cljs.core.seq(global_exports_libs);
var chunk__54844_56275 = null;
var count__54845_56276 = (0);
var i__54846_56277 = (0);
while(true){
if((i__54846_56277 < count__54845_56276)){
var lib_56278 = chunk__54844_56275.cljs$core$IIndexed$_nth$arity$2(null,i__54846_56277);
var map__54854_56279 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_56278))));
var map__54854_56280__$1 = cljs.core.__destructure_map(map__54854_56279);
var global_exports_56281 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54854_56280__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_56281,lib_56278);


var G__56282 = seq__54843_56274;
var G__56283 = chunk__54844_56275;
var G__56284 = count__54845_56276;
var G__56285 = (i__54846_56277 + (1));
seq__54843_56274 = G__56282;
chunk__54844_56275 = G__56283;
count__54845_56276 = G__56284;
i__54846_56277 = G__56285;
continue;
} else {
var temp__5804__auto___56286 = cljs.core.seq(seq__54843_56274);
if(temp__5804__auto___56286){
var seq__54843_56288__$1 = temp__5804__auto___56286;
if(cljs.core.chunked_seq_QMARK_(seq__54843_56288__$1)){
var c__5568__auto___56290 = cljs.core.chunk_first(seq__54843_56288__$1);
var G__56291 = cljs.core.chunk_rest(seq__54843_56288__$1);
var G__56292 = c__5568__auto___56290;
var G__56293 = cljs.core.count(c__5568__auto___56290);
var G__56294 = (0);
seq__54843_56274 = G__56291;
chunk__54844_56275 = G__56292;
count__54845_56276 = G__56293;
i__54846_56277 = G__56294;
continue;
} else {
var lib_56295 = cljs.core.first(seq__54843_56288__$1);
var map__54860_56296 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_56295))));
var map__54860_56297__$1 = cljs.core.__destructure_map(map__54860_56296);
var global_exports_56298 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54860_56297__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_56298,lib_56295);


var G__56300 = cljs.core.next(seq__54843_56288__$1);
var G__56301 = null;
var G__56302 = (0);
var G__56303 = (0);
seq__54843_56274 = G__56300;
chunk__54844_56275 = G__56301;
count__54845_56276 = G__56302;
i__54846_56277 = G__56303;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__54864){
var map__54865 = p__54864;
var map__54865__$1 = cljs.core.__destructure_map(map__54865);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54865__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54865__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54865__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54865__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54865__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54865__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54865__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__54867){
var map__54874 = p__54867;
var map__54874__$1 = cljs.core.__destructure_map(map__54874);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54874__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54874__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54874__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54874__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54874__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54874__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54874__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__54876){
var map__54877 = p__54876;
var map__54877__$1 = cljs.core.__destructure_map(map__54877);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54877__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54877__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54877__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54877__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54877__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__54878_56313 = cljs.core.seq(protocols);
var chunk__54879_56314 = null;
var count__54880_56315 = (0);
var i__54881_56316 = (0);
while(true){
if((i__54881_56316 < count__54880_56315)){
var protocol_56318 = chunk__54879_56314.cljs$core$IIndexed$_nth$arity$2(null,i__54881_56316);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_56318)),"}");


var G__56320 = seq__54878_56313;
var G__56321 = chunk__54879_56314;
var G__56322 = count__54880_56315;
var G__56323 = (i__54881_56316 + (1));
seq__54878_56313 = G__56320;
chunk__54879_56314 = G__56321;
count__54880_56315 = G__56322;
i__54881_56316 = G__56323;
continue;
} else {
var temp__5804__auto___56324 = cljs.core.seq(seq__54878_56313);
if(temp__5804__auto___56324){
var seq__54878_56325__$1 = temp__5804__auto___56324;
if(cljs.core.chunked_seq_QMARK_(seq__54878_56325__$1)){
var c__5568__auto___56328 = cljs.core.chunk_first(seq__54878_56325__$1);
var G__56329 = cljs.core.chunk_rest(seq__54878_56325__$1);
var G__56330 = c__5568__auto___56328;
var G__56331 = cljs.core.count(c__5568__auto___56328);
var G__56332 = (0);
seq__54878_56313 = G__56329;
chunk__54879_56314 = G__56330;
count__54880_56315 = G__56331;
i__54881_56316 = G__56332;
continue;
} else {
var protocol_56333 = cljs.core.first(seq__54878_56325__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_56333)),"}");


var G__56334 = cljs.core.next(seq__54878_56325__$1);
var G__56335 = null;
var G__56336 = (0);
var G__56337 = (0);
seq__54878_56313 = G__56334;
chunk__54879_56314 = G__56335;
count__54880_56315 = G__56336;
i__54881_56316 = G__56337;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__54884_56338 = cljs.core.seq(fields__$1);
var chunk__54885_56339 = null;
var count__54886_56340 = (0);
var i__54887_56341 = (0);
while(true){
if((i__54887_56341 < count__54886_56340)){
var fld_56342 = chunk__54885_56339.cljs$core$IIndexed$_nth$arity$2(null,i__54887_56341);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_56342," = ",fld_56342,";");


var G__56343 = seq__54884_56338;
var G__56344 = chunk__54885_56339;
var G__56345 = count__54886_56340;
var G__56346 = (i__54887_56341 + (1));
seq__54884_56338 = G__56343;
chunk__54885_56339 = G__56344;
count__54886_56340 = G__56345;
i__54887_56341 = G__56346;
continue;
} else {
var temp__5804__auto___56347 = cljs.core.seq(seq__54884_56338);
if(temp__5804__auto___56347){
var seq__54884_56348__$1 = temp__5804__auto___56347;
if(cljs.core.chunked_seq_QMARK_(seq__54884_56348__$1)){
var c__5568__auto___56349 = cljs.core.chunk_first(seq__54884_56348__$1);
var G__56350 = cljs.core.chunk_rest(seq__54884_56348__$1);
var G__56351 = c__5568__auto___56349;
var G__56352 = cljs.core.count(c__5568__auto___56349);
var G__56353 = (0);
seq__54884_56338 = G__56350;
chunk__54885_56339 = G__56351;
count__54886_56340 = G__56352;
i__54887_56341 = G__56353;
continue;
} else {
var fld_56354 = cljs.core.first(seq__54884_56348__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_56354," = ",fld_56354,";");


var G__56359 = cljs.core.next(seq__54884_56348__$1);
var G__56360 = null;
var G__56361 = (0);
var G__56362 = (0);
seq__54884_56338 = G__56359;
chunk__54885_56339 = G__56360;
count__54886_56340 = G__56361;
i__54887_56341 = G__56362;
continue;
}
} else {
}
}
break;
}

var seq__54892_56363 = cljs.core.seq(pmasks);
var chunk__54893_56364 = null;
var count__54894_56365 = (0);
var i__54895_56366 = (0);
while(true){
if((i__54895_56366 < count__54894_56365)){
var vec__54915_56367 = chunk__54893_56364.cljs$core$IIndexed$_nth$arity$2(null,i__54895_56366);
var pno_56368 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54915_56367,(0),null);
var pmask_56369 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54915_56367,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_56368,"$ = ",pmask_56369,";");


var G__56371 = seq__54892_56363;
var G__56372 = chunk__54893_56364;
var G__56373 = count__54894_56365;
var G__56374 = (i__54895_56366 + (1));
seq__54892_56363 = G__56371;
chunk__54893_56364 = G__56372;
count__54894_56365 = G__56373;
i__54895_56366 = G__56374;
continue;
} else {
var temp__5804__auto___56375 = cljs.core.seq(seq__54892_56363);
if(temp__5804__auto___56375){
var seq__54892_56377__$1 = temp__5804__auto___56375;
if(cljs.core.chunked_seq_QMARK_(seq__54892_56377__$1)){
var c__5568__auto___56381 = cljs.core.chunk_first(seq__54892_56377__$1);
var G__56382 = cljs.core.chunk_rest(seq__54892_56377__$1);
var G__56383 = c__5568__auto___56381;
var G__56384 = cljs.core.count(c__5568__auto___56381);
var G__56385 = (0);
seq__54892_56363 = G__56382;
chunk__54893_56364 = G__56383;
count__54894_56365 = G__56384;
i__54895_56366 = G__56385;
continue;
} else {
var vec__54936_56386 = cljs.core.first(seq__54892_56377__$1);
var pno_56387 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54936_56386,(0),null);
var pmask_56388 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54936_56386,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_56387,"$ = ",pmask_56388,";");


var G__56391 = cljs.core.next(seq__54892_56377__$1);
var G__56392 = null;
var G__56393 = (0);
var G__56394 = (0);
seq__54892_56363 = G__56391;
chunk__54893_56364 = G__56392;
count__54894_56365 = G__56393;
i__54895_56366 = G__56394;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__54948){
var map__54949 = p__54948;
var map__54949__$1 = cljs.core.__destructure_map(map__54949);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54949__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54949__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54949__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54949__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54949__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__54957_56411 = cljs.core.seq(protocols);
var chunk__54958_56412 = null;
var count__54959_56413 = (0);
var i__54960_56414 = (0);
while(true){
if((i__54960_56414 < count__54959_56413)){
var protocol_56415 = chunk__54958_56412.cljs$core$IIndexed$_nth$arity$2(null,i__54960_56414);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_56415)),"}");


var G__56416 = seq__54957_56411;
var G__56417 = chunk__54958_56412;
var G__56418 = count__54959_56413;
var G__56419 = (i__54960_56414 + (1));
seq__54957_56411 = G__56416;
chunk__54958_56412 = G__56417;
count__54959_56413 = G__56418;
i__54960_56414 = G__56419;
continue;
} else {
var temp__5804__auto___56420 = cljs.core.seq(seq__54957_56411);
if(temp__5804__auto___56420){
var seq__54957_56421__$1 = temp__5804__auto___56420;
if(cljs.core.chunked_seq_QMARK_(seq__54957_56421__$1)){
var c__5568__auto___56422 = cljs.core.chunk_first(seq__54957_56421__$1);
var G__56423 = cljs.core.chunk_rest(seq__54957_56421__$1);
var G__56424 = c__5568__auto___56422;
var G__56425 = cljs.core.count(c__5568__auto___56422);
var G__56426 = (0);
seq__54957_56411 = G__56423;
chunk__54958_56412 = G__56424;
count__54959_56413 = G__56425;
i__54960_56414 = G__56426;
continue;
} else {
var protocol_56427 = cljs.core.first(seq__54957_56421__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_56427)),"}");


var G__56428 = cljs.core.next(seq__54957_56421__$1);
var G__56429 = null;
var G__56430 = (0);
var G__56431 = (0);
seq__54957_56411 = G__56428;
chunk__54958_56412 = G__56429;
count__54959_56413 = G__56430;
i__54960_56414 = G__56431;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__54963_56432 = cljs.core.seq(fields__$1);
var chunk__54964_56433 = null;
var count__54965_56434 = (0);
var i__54966_56435 = (0);
while(true){
if((i__54966_56435 < count__54965_56434)){
var fld_56440 = chunk__54964_56433.cljs$core$IIndexed$_nth$arity$2(null,i__54966_56435);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_56440," = ",fld_56440,";");


var G__56441 = seq__54963_56432;
var G__56442 = chunk__54964_56433;
var G__56443 = count__54965_56434;
var G__56444 = (i__54966_56435 + (1));
seq__54963_56432 = G__56441;
chunk__54964_56433 = G__56442;
count__54965_56434 = G__56443;
i__54966_56435 = G__56444;
continue;
} else {
var temp__5804__auto___56445 = cljs.core.seq(seq__54963_56432);
if(temp__5804__auto___56445){
var seq__54963_56446__$1 = temp__5804__auto___56445;
if(cljs.core.chunked_seq_QMARK_(seq__54963_56446__$1)){
var c__5568__auto___56447 = cljs.core.chunk_first(seq__54963_56446__$1);
var G__56449 = cljs.core.chunk_rest(seq__54963_56446__$1);
var G__56450 = c__5568__auto___56447;
var G__56451 = cljs.core.count(c__5568__auto___56447);
var G__56452 = (0);
seq__54963_56432 = G__56449;
chunk__54964_56433 = G__56450;
count__54965_56434 = G__56451;
i__54966_56435 = G__56452;
continue;
} else {
var fld_56453 = cljs.core.first(seq__54963_56446__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_56453," = ",fld_56453,";");


var G__56455 = cljs.core.next(seq__54963_56446__$1);
var G__56456 = null;
var G__56457 = (0);
var G__56458 = (0);
seq__54963_56432 = G__56455;
chunk__54964_56433 = G__56456;
count__54965_56434 = G__56457;
i__54966_56435 = G__56458;
continue;
}
} else {
}
}
break;
}

var seq__54970_56459 = cljs.core.seq(pmasks);
var chunk__54971_56460 = null;
var count__54972_56461 = (0);
var i__54973_56462 = (0);
while(true){
if((i__54973_56462 < count__54972_56461)){
var vec__54986_56464 = chunk__54971_56460.cljs$core$IIndexed$_nth$arity$2(null,i__54973_56462);
var pno_56465 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54986_56464,(0),null);
var pmask_56466 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54986_56464,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_56465,"$ = ",pmask_56466,";");


var G__56469 = seq__54970_56459;
var G__56470 = chunk__54971_56460;
var G__56471 = count__54972_56461;
var G__56472 = (i__54973_56462 + (1));
seq__54970_56459 = G__56469;
chunk__54971_56460 = G__56470;
count__54972_56461 = G__56471;
i__54973_56462 = G__56472;
continue;
} else {
var temp__5804__auto___56473 = cljs.core.seq(seq__54970_56459);
if(temp__5804__auto___56473){
var seq__54970_56474__$1 = temp__5804__auto___56473;
if(cljs.core.chunked_seq_QMARK_(seq__54970_56474__$1)){
var c__5568__auto___56476 = cljs.core.chunk_first(seq__54970_56474__$1);
var G__56477 = cljs.core.chunk_rest(seq__54970_56474__$1);
var G__56478 = c__5568__auto___56476;
var G__56479 = cljs.core.count(c__5568__auto___56476);
var G__56480 = (0);
seq__54970_56459 = G__56477;
chunk__54971_56460 = G__56478;
count__54972_56461 = G__56479;
i__54973_56462 = G__56480;
continue;
} else {
var vec__54990_56481 = cljs.core.first(seq__54970_56474__$1);
var pno_56482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54990_56481,(0),null);
var pmask_56483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54990_56481,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_56482,"$ = ",pmask_56483,";");


var G__56484 = cljs.core.next(seq__54970_56474__$1);
var G__56485 = null;
var G__56486 = (0);
var G__56487 = (0);
seq__54970_56459 = G__56484;
chunk__54971_56460 = G__56485;
count__54972_56461 = G__56486;
i__54973_56462 = G__56487;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__54994){
var map__54995 = p__54994;
var map__54995__$1 = cljs.core.__destructure_map(map__54995);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54995__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54995__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54995__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54995__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54995__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__55001){
var map__55002 = p__55001;
var map__55002__$1 = cljs.core.__destructure_map(map__55002);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55002__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55002__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55002__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55002__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55002__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__5043__auto__ = code;
if(cljs.core.truth_(and__5043__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__5043__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__55025 = cljs.core.seq(table);
var chunk__55026 = null;
var count__55027 = (0);
var i__55028 = (0);
while(true){
if((i__55028 < count__55027)){
var vec__55036 = chunk__55026.cljs$core$IIndexed$_nth$arity$2(null,i__55028);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55036,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55036,(1),null);
var ns_56504 = cljs.core.namespace(sym);
var name_56505 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__56511 = seq__55025;
var G__56513 = chunk__55026;
var G__56515 = count__55027;
var G__56516 = (i__55028 + (1));
seq__55025 = G__56511;
chunk__55026 = G__56513;
count__55027 = G__56515;
i__55028 = G__56516;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__55025);
if(temp__5804__auto__){
var seq__55025__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__55025__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__55025__$1);
var G__56517 = cljs.core.chunk_rest(seq__55025__$1);
var G__56518 = c__5568__auto__;
var G__56519 = cljs.core.count(c__5568__auto__);
var G__56520 = (0);
seq__55025 = G__56517;
chunk__55026 = G__56518;
count__55027 = G__56519;
i__55028 = G__56520;
continue;
} else {
var vec__55040 = cljs.core.first(seq__55025__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55040,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55040,(1),null);
var ns_56521 = cljs.core.namespace(sym);
var name_56522 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__56523 = cljs.core.next(seq__55025__$1);
var G__56524 = null;
var G__56525 = (0);
var G__56526 = (0);
seq__55025 = G__56523;
chunk__55026 = G__56524;
count__55027 = G__56525;
i__55028 = G__56526;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__55044 = arguments.length;
switch (G__55044) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_56533 = cljs.core.first(ks);
var vec__55048_56534 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_56533);
var top_56535 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55048_56534,(0),null);
var prefix_SINGLEQUOTE__56536 = vec__55048_56534;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_56533)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__56536) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_56535)) || (cljs.core.contains_QMARK_(known_externs,top_56535)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__56536)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_56535);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__56536)),";");
}
} else {
}

var m_56539 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_56533);
if(cljs.core.empty_QMARK_(m_56539)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__56536,m_56539,top_level,known_externs);
}

var G__56540 = cljs.core.next(ks);
ks = G__56540;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=cljs.compiler.js.map
