goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__44850 = arguments.length;
switch (G__44850) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44851 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44851 = (function (f,blockable,meta44852){
this.f = f;
this.blockable = blockable;
this.meta44852 = meta44852;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44851.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44853,meta44852__$1){
var self__ = this;
var _44853__$1 = this;
return (new cljs.core.async.t_cljs$core$async44851(self__.f,self__.blockable,meta44852__$1));
}));

(cljs.core.async.t_cljs$core$async44851.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44853){
var self__ = this;
var _44853__$1 = this;
return self__.meta44852;
}));

(cljs.core.async.t_cljs$core$async44851.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44851.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44851.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async44851.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async44851.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta44852","meta44852",1869499764,null)], null);
}));

(cljs.core.async.t_cljs$core$async44851.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44851.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44851");

(cljs.core.async.t_cljs$core$async44851.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async44851");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44851.
 */
cljs.core.async.__GT_t_cljs$core$async44851 = (function cljs$core$async$__GT_t_cljs$core$async44851(f__$1,blockable__$1,meta44852){
return (new cljs.core.async.t_cljs$core$async44851(f__$1,blockable__$1,meta44852));
});

}

return (new cljs.core.async.t_cljs$core$async44851(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__44872 = arguments.length;
switch (G__44872) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__44877 = arguments.length;
switch (G__44877) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__44881 = arguments.length;
switch (G__44881) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_47590 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_47590) : fn1.call(null,val_47590));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_47590) : fn1.call(null,val_47590));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__44883 = arguments.length;
switch (G__44883) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___47600 = n;
var x_47601 = (0);
while(true){
if((x_47601 < n__5636__auto___47600)){
(a[x_47601] = x_47601);

var G__47602 = (x_47601 + (1));
x_47601 = G__47602;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44886 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44886 = (function (flag,meta44887){
this.flag = flag;
this.meta44887 = meta44887;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44886.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44888,meta44887__$1){
var self__ = this;
var _44888__$1 = this;
return (new cljs.core.async.t_cljs$core$async44886(self__.flag,meta44887__$1));
}));

(cljs.core.async.t_cljs$core$async44886.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44888){
var self__ = this;
var _44888__$1 = this;
return self__.meta44887;
}));

(cljs.core.async.t_cljs$core$async44886.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44886.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44886.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44886.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async44886.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta44887","meta44887",-1996488608,null)], null);
}));

(cljs.core.async.t_cljs$core$async44886.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44886.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44886");

(cljs.core.async.t_cljs$core$async44886.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async44886");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44886.
 */
cljs.core.async.__GT_t_cljs$core$async44886 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async44886(flag__$1,meta44887){
return (new cljs.core.async.t_cljs$core$async44886(flag__$1,meta44887));
});

}

return (new cljs.core.async.t_cljs$core$async44886(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44889 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44889 = (function (flag,cb,meta44890){
this.flag = flag;
this.cb = cb;
this.meta44890 = meta44890;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44889.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44891,meta44890__$1){
var self__ = this;
var _44891__$1 = this;
return (new cljs.core.async.t_cljs$core$async44889(self__.flag,self__.cb,meta44890__$1));
}));

(cljs.core.async.t_cljs$core$async44889.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44891){
var self__ = this;
var _44891__$1 = this;
return self__.meta44890;
}));

(cljs.core.async.t_cljs$core$async44889.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44889.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44889.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44889.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async44889.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta44890","meta44890",-1261220224,null)], null);
}));

(cljs.core.async.t_cljs$core$async44889.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44889.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44889");

(cljs.core.async.t_cljs$core$async44889.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async44889");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44889.
 */
cljs.core.async.__GT_t_cljs$core$async44889 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async44889(flag__$1,cb__$1,meta44890){
return (new cljs.core.async.t_cljs$core$async44889(flag__$1,cb__$1,meta44890));
});

}

return (new cljs.core.async.t_cljs$core$async44889(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44894_SHARP_){
var G__44896 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44894_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44896) : fret.call(null,G__44896));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44895_SHARP_){
var G__44897 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44895_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44897) : fret.call(null,G__44897));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__47607 = (i + (1));
i = G__47607;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___47610 = arguments.length;
var i__5770__auto___47611 = (0);
while(true){
if((i__5770__auto___47611 < len__5769__auto___47610)){
args__5775__auto__.push((arguments[i__5770__auto___47611]));

var G__47612 = (i__5770__auto___47611 + (1));
i__5770__auto___47611 = G__47612;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__44907){
var map__44908 = p__44907;
var map__44908__$1 = cljs.core.__destructure_map(map__44908);
var opts = map__44908__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq44904){
var G__44905 = cljs.core.first(seq44904);
var seq44904__$1 = cljs.core.next(seq44904);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44905,seq44904__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__44915 = arguments.length;
switch (G__44915) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__44773__auto___47617 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_44944){
var state_val_44945 = (state_44944[(1)]);
if((state_val_44945 === (7))){
var inst_44939 = (state_44944[(2)]);
var state_44944__$1 = state_44944;
var statearr_44946_47620 = state_44944__$1;
(statearr_44946_47620[(2)] = inst_44939);

(statearr_44946_47620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44945 === (1))){
var state_44944__$1 = state_44944;
var statearr_44947_47622 = state_44944__$1;
(statearr_44947_47622[(2)] = null);

(statearr_44947_47622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44945 === (4))){
var inst_44922 = (state_44944[(7)]);
var inst_44922__$1 = (state_44944[(2)]);
var inst_44923 = (inst_44922__$1 == null);
var state_44944__$1 = (function (){var statearr_44948 = state_44944;
(statearr_44948[(7)] = inst_44922__$1);

return statearr_44948;
})();
if(cljs.core.truth_(inst_44923)){
var statearr_44949_47624 = state_44944__$1;
(statearr_44949_47624[(1)] = (5));

} else {
var statearr_44950_47625 = state_44944__$1;
(statearr_44950_47625[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44945 === (13))){
var state_44944__$1 = state_44944;
var statearr_44951_47626 = state_44944__$1;
(statearr_44951_47626[(2)] = null);

(statearr_44951_47626[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44945 === (6))){
var inst_44922 = (state_44944[(7)]);
var state_44944__$1 = state_44944;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44944__$1,(11),to,inst_44922);
} else {
if((state_val_44945 === (3))){
var inst_44941 = (state_44944[(2)]);
var state_44944__$1 = state_44944;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44944__$1,inst_44941);
} else {
if((state_val_44945 === (12))){
var state_44944__$1 = state_44944;
var statearr_44952_47627 = state_44944__$1;
(statearr_44952_47627[(2)] = null);

(statearr_44952_47627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44945 === (2))){
var state_44944__$1 = state_44944;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44944__$1,(4),from);
} else {
if((state_val_44945 === (11))){
var inst_44932 = (state_44944[(2)]);
var state_44944__$1 = state_44944;
if(cljs.core.truth_(inst_44932)){
var statearr_44954_47628 = state_44944__$1;
(statearr_44954_47628[(1)] = (12));

} else {
var statearr_44956_47629 = state_44944__$1;
(statearr_44956_47629[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44945 === (9))){
var state_44944__$1 = state_44944;
var statearr_44957_47631 = state_44944__$1;
(statearr_44957_47631[(2)] = null);

(statearr_44957_47631[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44945 === (5))){
var state_44944__$1 = state_44944;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44958_47635 = state_44944__$1;
(statearr_44958_47635[(1)] = (8));

} else {
var statearr_44959_47638 = state_44944__$1;
(statearr_44959_47638[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44945 === (14))){
var inst_44937 = (state_44944[(2)]);
var state_44944__$1 = state_44944;
var statearr_44960_47639 = state_44944__$1;
(statearr_44960_47639[(2)] = inst_44937);

(statearr_44960_47639[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44945 === (10))){
var inst_44929 = (state_44944[(2)]);
var state_44944__$1 = state_44944;
var statearr_44961_47640 = state_44944__$1;
(statearr_44961_47640[(2)] = inst_44929);

(statearr_44961_47640[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44945 === (8))){
var inst_44926 = cljs.core.async.close_BANG_(to);
var state_44944__$1 = state_44944;
var statearr_44962_47641 = state_44944__$1;
(statearr_44962_47641[(2)] = inst_44926);

(statearr_44962_47641[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44577__auto__ = null;
var cljs$core$async$state_machine__44577__auto____0 = (function (){
var statearr_44963 = [null,null,null,null,null,null,null,null];
(statearr_44963[(0)] = cljs$core$async$state_machine__44577__auto__);

(statearr_44963[(1)] = (1));

return statearr_44963;
});
var cljs$core$async$state_machine__44577__auto____1 = (function (state_44944){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_44944);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e44964){var ex__44580__auto__ = e44964;
var statearr_44965_47642 = state_44944;
(statearr_44965_47642[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_44944[(4)]))){
var statearr_44967_47644 = state_44944;
(statearr_44967_47644[(1)] = cljs.core.first((state_44944[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47648 = state_44944;
state_44944 = G__47648;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$state_machine__44577__auto__ = function(state_44944){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44577__auto____1.call(this,state_44944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44577__auto____0;
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44577__auto____1;
return cljs$core$async$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_44969 = f__44774__auto__();
(statearr_44969[(6)] = c__44773__auto___47617);

return statearr_44969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__44970){
var vec__44971 = p__44970;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44971,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44971,(1),null);
var job = vec__44971;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__44773__auto___47651 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_44981){
var state_val_44982 = (state_44981[(1)]);
if((state_val_44982 === (1))){
var state_44981__$1 = state_44981;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44981__$1,(2),res,v);
} else {
if((state_val_44982 === (2))){
var inst_44975 = (state_44981[(2)]);
var inst_44976 = cljs.core.async.close_BANG_(res);
var state_44981__$1 = (function (){var statearr_44983 = state_44981;
(statearr_44983[(7)] = inst_44975);

return statearr_44983;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44981__$1,inst_44976);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0 = (function (){
var statearr_44984 = [null,null,null,null,null,null,null,null];
(statearr_44984[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__);

(statearr_44984[(1)] = (1));

return statearr_44984;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1 = (function (state_44981){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_44981);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e44989){var ex__44580__auto__ = e44989;
var statearr_44990_47658 = state_44981;
(statearr_44990_47658[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_44981[(4)]))){
var statearr_44991_47659 = state_44981;
(statearr_44991_47659[(1)] = cljs.core.first((state_44981[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47661 = state_44981;
state_44981 = G__47661;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__ = function(state_44981){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1.call(this,state_44981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_44995 = f__44774__auto__();
(statearr_44995[(6)] = c__44773__auto___47651);

return statearr_44995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__45000){
var vec__45004 = p__45000;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45004,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45004,(1),null);
var job = vec__45004;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5636__auto___47664 = n;
var __47665 = (0);
while(true){
if((__47665 < n__5636__auto___47664)){
var G__45007_47668 = type;
var G__45007_47669__$1 = (((G__45007_47668 instanceof cljs.core.Keyword))?G__45007_47668.fqn:null);
switch (G__45007_47669__$1) {
case "compute":
var c__44773__auto___47671 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__47665,c__44773__auto___47671,G__45007_47668,G__45007_47669__$1,n__5636__auto___47664,jobs,results,process__$1,async){
return (function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = ((function (__47665,c__44773__auto___47671,G__45007_47668,G__45007_47669__$1,n__5636__auto___47664,jobs,results,process__$1,async){
return (function (state_45023){
var state_val_45027 = (state_45023[(1)]);
if((state_val_45027 === (1))){
var state_45023__$1 = state_45023;
var statearr_45034_47672 = state_45023__$1;
(statearr_45034_47672[(2)] = null);

(statearr_45034_47672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (2))){
var state_45023__$1 = state_45023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45023__$1,(4),jobs);
} else {
if((state_val_45027 === (3))){
var inst_45021 = (state_45023[(2)]);
var state_45023__$1 = state_45023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45023__$1,inst_45021);
} else {
if((state_val_45027 === (4))){
var inst_45010 = (state_45023[(2)]);
var inst_45014 = process__$1(inst_45010);
var state_45023__$1 = state_45023;
if(cljs.core.truth_(inst_45014)){
var statearr_45036_47677 = state_45023__$1;
(statearr_45036_47677[(1)] = (5));

} else {
var statearr_45037_47678 = state_45023__$1;
(statearr_45037_47678[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (5))){
var state_45023__$1 = state_45023;
var statearr_45038_47679 = state_45023__$1;
(statearr_45038_47679[(2)] = null);

(statearr_45038_47679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (6))){
var state_45023__$1 = state_45023;
var statearr_45039_47680 = state_45023__$1;
(statearr_45039_47680[(2)] = null);

(statearr_45039_47680[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45027 === (7))){
var inst_45019 = (state_45023[(2)]);
var state_45023__$1 = state_45023;
var statearr_45040_47681 = state_45023__$1;
(statearr_45040_47681[(2)] = inst_45019);

(statearr_45040_47681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47665,c__44773__auto___47671,G__45007_47668,G__45007_47669__$1,n__5636__auto___47664,jobs,results,process__$1,async))
;
return ((function (__47665,switch__44576__auto__,c__44773__auto___47671,G__45007_47668,G__45007_47669__$1,n__5636__auto___47664,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0 = (function (){
var statearr_45041 = [null,null,null,null,null,null,null];
(statearr_45041[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__);

(statearr_45041[(1)] = (1));

return statearr_45041;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1 = (function (state_45023){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_45023);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e45042){var ex__44580__auto__ = e45042;
var statearr_45044_47686 = state_45023;
(statearr_45044_47686[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_45023[(4)]))){
var statearr_45048_47687 = state_45023;
(statearr_45048_47687[(1)] = cljs.core.first((state_45023[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47688 = state_45023;
state_45023 = G__47688;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__ = function(state_45023){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1.call(this,state_45023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__;
})()
;})(__47665,switch__44576__auto__,c__44773__auto___47671,G__45007_47668,G__45007_47669__$1,n__5636__auto___47664,jobs,results,process__$1,async))
})();
var state__44775__auto__ = (function (){var statearr_45053 = f__44774__auto__();
(statearr_45053[(6)] = c__44773__auto___47671);

return statearr_45053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
});})(__47665,c__44773__auto___47671,G__45007_47668,G__45007_47669__$1,n__5636__auto___47664,jobs,results,process__$1,async))
);


break;
case "async":
var c__44773__auto___47689 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__47665,c__44773__auto___47689,G__45007_47668,G__45007_47669__$1,n__5636__auto___47664,jobs,results,process__$1,async){
return (function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = ((function (__47665,c__44773__auto___47689,G__45007_47668,G__45007_47669__$1,n__5636__auto___47664,jobs,results,process__$1,async){
return (function (state_45066){
var state_val_45067 = (state_45066[(1)]);
if((state_val_45067 === (1))){
var state_45066__$1 = state_45066;
var statearr_45068_47692 = state_45066__$1;
(statearr_45068_47692[(2)] = null);

(statearr_45068_47692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (2))){
var state_45066__$1 = state_45066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45066__$1,(4),jobs);
} else {
if((state_val_45067 === (3))){
var inst_45064 = (state_45066[(2)]);
var state_45066__$1 = state_45066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45066__$1,inst_45064);
} else {
if((state_val_45067 === (4))){
var inst_45056 = (state_45066[(2)]);
var inst_45057 = async(inst_45056);
var state_45066__$1 = state_45066;
if(cljs.core.truth_(inst_45057)){
var statearr_45073_47695 = state_45066__$1;
(statearr_45073_47695[(1)] = (5));

} else {
var statearr_45074_47696 = state_45066__$1;
(statearr_45074_47696[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (5))){
var state_45066__$1 = state_45066;
var statearr_45075_47697 = state_45066__$1;
(statearr_45075_47697[(2)] = null);

(statearr_45075_47697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (6))){
var state_45066__$1 = state_45066;
var statearr_45076_47698 = state_45066__$1;
(statearr_45076_47698[(2)] = null);

(statearr_45076_47698[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45067 === (7))){
var inst_45062 = (state_45066[(2)]);
var state_45066__$1 = state_45066;
var statearr_45077_47699 = state_45066__$1;
(statearr_45077_47699[(2)] = inst_45062);

(statearr_45077_47699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47665,c__44773__auto___47689,G__45007_47668,G__45007_47669__$1,n__5636__auto___47664,jobs,results,process__$1,async))
;
return ((function (__47665,switch__44576__auto__,c__44773__auto___47689,G__45007_47668,G__45007_47669__$1,n__5636__auto___47664,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0 = (function (){
var statearr_45079 = [null,null,null,null,null,null,null];
(statearr_45079[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__);

(statearr_45079[(1)] = (1));

return statearr_45079;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1 = (function (state_45066){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_45066);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e45080){var ex__44580__auto__ = e45080;
var statearr_45081_47700 = state_45066;
(statearr_45081_47700[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_45066[(4)]))){
var statearr_45082_47704 = state_45066;
(statearr_45082_47704[(1)] = cljs.core.first((state_45066[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47705 = state_45066;
state_45066 = G__47705;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__ = function(state_45066){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1.call(this,state_45066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__;
})()
;})(__47665,switch__44576__auto__,c__44773__auto___47689,G__45007_47668,G__45007_47669__$1,n__5636__auto___47664,jobs,results,process__$1,async))
})();
var state__44775__auto__ = (function (){var statearr_45083 = f__44774__auto__();
(statearr_45083[(6)] = c__44773__auto___47689);

return statearr_45083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
});})(__47665,c__44773__auto___47689,G__45007_47668,G__45007_47669__$1,n__5636__auto___47664,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__45007_47669__$1)].join('')));

}

var G__47706 = (__47665 + (1));
__47665 = G__47706;
continue;
} else {
}
break;
}

var c__44773__auto___47708 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_45109){
var state_val_45110 = (state_45109[(1)]);
if((state_val_45110 === (7))){
var inst_45105 = (state_45109[(2)]);
var state_45109__$1 = state_45109;
var statearr_45120_47710 = state_45109__$1;
(statearr_45120_47710[(2)] = inst_45105);

(statearr_45120_47710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45110 === (1))){
var state_45109__$1 = state_45109;
var statearr_45121_47711 = state_45109__$1;
(statearr_45121_47711[(2)] = null);

(statearr_45121_47711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45110 === (4))){
var inst_45086 = (state_45109[(7)]);
var inst_45086__$1 = (state_45109[(2)]);
var inst_45087 = (inst_45086__$1 == null);
var state_45109__$1 = (function (){var statearr_45125 = state_45109;
(statearr_45125[(7)] = inst_45086__$1);

return statearr_45125;
})();
if(cljs.core.truth_(inst_45087)){
var statearr_45126_47712 = state_45109__$1;
(statearr_45126_47712[(1)] = (5));

} else {
var statearr_45127_47713 = state_45109__$1;
(statearr_45127_47713[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45110 === (6))){
var inst_45086 = (state_45109[(7)]);
var inst_45091 = (state_45109[(8)]);
var inst_45091__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_45093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45094 = [inst_45086,inst_45091__$1];
var inst_45095 = (new cljs.core.PersistentVector(null,2,(5),inst_45093,inst_45094,null));
var state_45109__$1 = (function (){var statearr_45128 = state_45109;
(statearr_45128[(8)] = inst_45091__$1);

return statearr_45128;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45109__$1,(8),jobs,inst_45095);
} else {
if((state_val_45110 === (3))){
var inst_45107 = (state_45109[(2)]);
var state_45109__$1 = state_45109;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45109__$1,inst_45107);
} else {
if((state_val_45110 === (2))){
var state_45109__$1 = state_45109;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45109__$1,(4),from);
} else {
if((state_val_45110 === (9))){
var inst_45102 = (state_45109[(2)]);
var state_45109__$1 = (function (){var statearr_45129 = state_45109;
(statearr_45129[(9)] = inst_45102);

return statearr_45129;
})();
var statearr_45130_47718 = state_45109__$1;
(statearr_45130_47718[(2)] = null);

(statearr_45130_47718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45110 === (5))){
var inst_45089 = cljs.core.async.close_BANG_(jobs);
var state_45109__$1 = state_45109;
var statearr_45131_47719 = state_45109__$1;
(statearr_45131_47719[(2)] = inst_45089);

(statearr_45131_47719[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45110 === (8))){
var inst_45091 = (state_45109[(8)]);
var inst_45100 = (state_45109[(2)]);
var state_45109__$1 = (function (){var statearr_45132 = state_45109;
(statearr_45132[(10)] = inst_45100);

return statearr_45132;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45109__$1,(9),results,inst_45091);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0 = (function (){
var statearr_45133 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45133[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__);

(statearr_45133[(1)] = (1));

return statearr_45133;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1 = (function (state_45109){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_45109);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e45139){var ex__44580__auto__ = e45139;
var statearr_45143_47720 = state_45109;
(statearr_45143_47720[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_45109[(4)]))){
var statearr_45144_47723 = state_45109;
(statearr_45144_47723[(1)] = cljs.core.first((state_45109[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47726 = state_45109;
state_45109 = G__47726;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__ = function(state_45109){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1.call(this,state_45109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_45145 = f__44774__auto__();
(statearr_45145[(6)] = c__44773__auto___47708);

return statearr_45145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


var c__44773__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_45187){
var state_val_45188 = (state_45187[(1)]);
if((state_val_45188 === (7))){
var inst_45183 = (state_45187[(2)]);
var state_45187__$1 = state_45187;
var statearr_45193_47728 = state_45187__$1;
(statearr_45193_47728[(2)] = inst_45183);

(statearr_45193_47728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (20))){
var state_45187__$1 = state_45187;
var statearr_45194_47729 = state_45187__$1;
(statearr_45194_47729[(2)] = null);

(statearr_45194_47729[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (1))){
var state_45187__$1 = state_45187;
var statearr_45195_47730 = state_45187__$1;
(statearr_45195_47730[(2)] = null);

(statearr_45195_47730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (4))){
var inst_45152 = (state_45187[(7)]);
var inst_45152__$1 = (state_45187[(2)]);
var inst_45153 = (inst_45152__$1 == null);
var state_45187__$1 = (function (){var statearr_45196 = state_45187;
(statearr_45196[(7)] = inst_45152__$1);

return statearr_45196;
})();
if(cljs.core.truth_(inst_45153)){
var statearr_45197_47731 = state_45187__$1;
(statearr_45197_47731[(1)] = (5));

} else {
var statearr_45198_47732 = state_45187__$1;
(statearr_45198_47732[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (15))){
var inst_45165 = (state_45187[(8)]);
var state_45187__$1 = state_45187;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45187__$1,(18),to,inst_45165);
} else {
if((state_val_45188 === (21))){
var inst_45178 = (state_45187[(2)]);
var state_45187__$1 = state_45187;
var statearr_45199_47735 = state_45187__$1;
(statearr_45199_47735[(2)] = inst_45178);

(statearr_45199_47735[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (13))){
var inst_45180 = (state_45187[(2)]);
var state_45187__$1 = (function (){var statearr_45200 = state_45187;
(statearr_45200[(9)] = inst_45180);

return statearr_45200;
})();
var statearr_45201_47739 = state_45187__$1;
(statearr_45201_47739[(2)] = null);

(statearr_45201_47739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (6))){
var inst_45152 = (state_45187[(7)]);
var state_45187__$1 = state_45187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45187__$1,(11),inst_45152);
} else {
if((state_val_45188 === (17))){
var inst_45173 = (state_45187[(2)]);
var state_45187__$1 = state_45187;
if(cljs.core.truth_(inst_45173)){
var statearr_45202_47741 = state_45187__$1;
(statearr_45202_47741[(1)] = (19));

} else {
var statearr_45203_47742 = state_45187__$1;
(statearr_45203_47742[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (3))){
var inst_45185 = (state_45187[(2)]);
var state_45187__$1 = state_45187;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45187__$1,inst_45185);
} else {
if((state_val_45188 === (12))){
var inst_45162 = (state_45187[(10)]);
var state_45187__$1 = state_45187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45187__$1,(14),inst_45162);
} else {
if((state_val_45188 === (2))){
var state_45187__$1 = state_45187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45187__$1,(4),results);
} else {
if((state_val_45188 === (19))){
var state_45187__$1 = state_45187;
var statearr_45204_47752 = state_45187__$1;
(statearr_45204_47752[(2)] = null);

(statearr_45204_47752[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (11))){
var inst_45162 = (state_45187[(2)]);
var state_45187__$1 = (function (){var statearr_45205 = state_45187;
(statearr_45205[(10)] = inst_45162);

return statearr_45205;
})();
var statearr_45206_47753 = state_45187__$1;
(statearr_45206_47753[(2)] = null);

(statearr_45206_47753[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (9))){
var state_45187__$1 = state_45187;
var statearr_45211_47756 = state_45187__$1;
(statearr_45211_47756[(2)] = null);

(statearr_45211_47756[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (5))){
var state_45187__$1 = state_45187;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45212_47759 = state_45187__$1;
(statearr_45212_47759[(1)] = (8));

} else {
var statearr_45213_47761 = state_45187__$1;
(statearr_45213_47761[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (14))){
var inst_45165 = (state_45187[(8)]);
var inst_45167 = (state_45187[(11)]);
var inst_45165__$1 = (state_45187[(2)]);
var inst_45166 = (inst_45165__$1 == null);
var inst_45167__$1 = cljs.core.not(inst_45166);
var state_45187__$1 = (function (){var statearr_45214 = state_45187;
(statearr_45214[(8)] = inst_45165__$1);

(statearr_45214[(11)] = inst_45167__$1);

return statearr_45214;
})();
if(inst_45167__$1){
var statearr_45215_47763 = state_45187__$1;
(statearr_45215_47763[(1)] = (15));

} else {
var statearr_45216_47767 = state_45187__$1;
(statearr_45216_47767[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (16))){
var inst_45167 = (state_45187[(11)]);
var state_45187__$1 = state_45187;
var statearr_45217_47770 = state_45187__$1;
(statearr_45217_47770[(2)] = inst_45167);

(statearr_45217_47770[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (10))){
var inst_45159 = (state_45187[(2)]);
var state_45187__$1 = state_45187;
var statearr_45218_47772 = state_45187__$1;
(statearr_45218_47772[(2)] = inst_45159);

(statearr_45218_47772[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (18))){
var inst_45170 = (state_45187[(2)]);
var state_45187__$1 = state_45187;
var statearr_45222_47777 = state_45187__$1;
(statearr_45222_47777[(2)] = inst_45170);

(statearr_45222_47777[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45188 === (8))){
var inst_45156 = cljs.core.async.close_BANG_(to);
var state_45187__$1 = state_45187;
var statearr_45223_47778 = state_45187__$1;
(statearr_45223_47778[(2)] = inst_45156);

(statearr_45223_47778[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0 = (function (){
var statearr_45230 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45230[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__);

(statearr_45230[(1)] = (1));

return statearr_45230;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1 = (function (state_45187){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_45187);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e45236){var ex__44580__auto__ = e45236;
var statearr_45237_47790 = state_45187;
(statearr_45237_47790[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_45187[(4)]))){
var statearr_45238_47791 = state_45187;
(statearr_45238_47791[(1)] = cljs.core.first((state_45187[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47792 = state_45187;
state_45187 = G__47792;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__ = function(state_45187){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1.call(this,state_45187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44577__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_45239 = f__44774__auto__();
(statearr_45239[(6)] = c__44773__auto__);

return statearr_45239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));

return c__44773__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__45244 = arguments.length;
switch (G__45244) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__45246 = arguments.length;
switch (G__45246) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__45250 = arguments.length;
switch (G__45250) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__44773__auto___47821 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_45279){
var state_val_45280 = (state_45279[(1)]);
if((state_val_45280 === (7))){
var inst_45275 = (state_45279[(2)]);
var state_45279__$1 = state_45279;
var statearr_45283_47823 = state_45279__$1;
(statearr_45283_47823[(2)] = inst_45275);

(statearr_45283_47823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45280 === (1))){
var state_45279__$1 = state_45279;
var statearr_45284_47825 = state_45279__$1;
(statearr_45284_47825[(2)] = null);

(statearr_45284_47825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45280 === (4))){
var inst_45255 = (state_45279[(7)]);
var inst_45255__$1 = (state_45279[(2)]);
var inst_45256 = (inst_45255__$1 == null);
var state_45279__$1 = (function (){var statearr_45285 = state_45279;
(statearr_45285[(7)] = inst_45255__$1);

return statearr_45285;
})();
if(cljs.core.truth_(inst_45256)){
var statearr_45286_47830 = state_45279__$1;
(statearr_45286_47830[(1)] = (5));

} else {
var statearr_45287_47831 = state_45279__$1;
(statearr_45287_47831[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45280 === (13))){
var state_45279__$1 = state_45279;
var statearr_45288_47833 = state_45279__$1;
(statearr_45288_47833[(2)] = null);

(statearr_45288_47833[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45280 === (6))){
var inst_45255 = (state_45279[(7)]);
var inst_45262 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_45255) : p.call(null,inst_45255));
var state_45279__$1 = state_45279;
if(cljs.core.truth_(inst_45262)){
var statearr_45289_47838 = state_45279__$1;
(statearr_45289_47838[(1)] = (9));

} else {
var statearr_45290_47839 = state_45279__$1;
(statearr_45290_47839[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45280 === (3))){
var inst_45277 = (state_45279[(2)]);
var state_45279__$1 = state_45279;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45279__$1,inst_45277);
} else {
if((state_val_45280 === (12))){
var state_45279__$1 = state_45279;
var statearr_45291_47840 = state_45279__$1;
(statearr_45291_47840[(2)] = null);

(statearr_45291_47840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45280 === (2))){
var state_45279__$1 = state_45279;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45279__$1,(4),ch);
} else {
if((state_val_45280 === (11))){
var inst_45255 = (state_45279[(7)]);
var inst_45266 = (state_45279[(2)]);
var state_45279__$1 = state_45279;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45279__$1,(8),inst_45266,inst_45255);
} else {
if((state_val_45280 === (9))){
var state_45279__$1 = state_45279;
var statearr_45294_47841 = state_45279__$1;
(statearr_45294_47841[(2)] = tc);

(statearr_45294_47841[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45280 === (5))){
var inst_45258 = cljs.core.async.close_BANG_(tc);
var inst_45259 = cljs.core.async.close_BANG_(fc);
var state_45279__$1 = (function (){var statearr_45295 = state_45279;
(statearr_45295[(8)] = inst_45258);

return statearr_45295;
})();
var statearr_45296_47842 = state_45279__$1;
(statearr_45296_47842[(2)] = inst_45259);

(statearr_45296_47842[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45280 === (14))){
var inst_45273 = (state_45279[(2)]);
var state_45279__$1 = state_45279;
var statearr_45297_47846 = state_45279__$1;
(statearr_45297_47846[(2)] = inst_45273);

(statearr_45297_47846[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45280 === (10))){
var state_45279__$1 = state_45279;
var statearr_45300_47847 = state_45279__$1;
(statearr_45300_47847[(2)] = fc);

(statearr_45300_47847[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45280 === (8))){
var inst_45268 = (state_45279[(2)]);
var state_45279__$1 = state_45279;
if(cljs.core.truth_(inst_45268)){
var statearr_45301_47848 = state_45279__$1;
(statearr_45301_47848[(1)] = (12));

} else {
var statearr_45302_47849 = state_45279__$1;
(statearr_45302_47849[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44577__auto__ = null;
var cljs$core$async$state_machine__44577__auto____0 = (function (){
var statearr_45303 = [null,null,null,null,null,null,null,null,null];
(statearr_45303[(0)] = cljs$core$async$state_machine__44577__auto__);

(statearr_45303[(1)] = (1));

return statearr_45303;
});
var cljs$core$async$state_machine__44577__auto____1 = (function (state_45279){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_45279);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e45304){var ex__44580__auto__ = e45304;
var statearr_45305_47854 = state_45279;
(statearr_45305_47854[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_45279[(4)]))){
var statearr_45306_47855 = state_45279;
(statearr_45306_47855[(1)] = cljs.core.first((state_45279[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47856 = state_45279;
state_45279 = G__47856;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$state_machine__44577__auto__ = function(state_45279){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44577__auto____1.call(this,state_45279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44577__auto____0;
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44577__auto____1;
return cljs$core$async$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_45307 = f__44774__auto__();
(statearr_45307[(6)] = c__44773__auto___47821);

return statearr_45307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__44773__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_45329){
var state_val_45330 = (state_45329[(1)]);
if((state_val_45330 === (7))){
var inst_45325 = (state_45329[(2)]);
var state_45329__$1 = state_45329;
var statearr_45335_47867 = state_45329__$1;
(statearr_45335_47867[(2)] = inst_45325);

(statearr_45335_47867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (1))){
var inst_45308 = init;
var inst_45309 = inst_45308;
var state_45329__$1 = (function (){var statearr_45336 = state_45329;
(statearr_45336[(7)] = inst_45309);

return statearr_45336;
})();
var statearr_45337_47872 = state_45329__$1;
(statearr_45337_47872[(2)] = null);

(statearr_45337_47872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (4))){
var inst_45312 = (state_45329[(8)]);
var inst_45312__$1 = (state_45329[(2)]);
var inst_45313 = (inst_45312__$1 == null);
var state_45329__$1 = (function (){var statearr_45338 = state_45329;
(statearr_45338[(8)] = inst_45312__$1);

return statearr_45338;
})();
if(cljs.core.truth_(inst_45313)){
var statearr_45354_47873 = state_45329__$1;
(statearr_45354_47873[(1)] = (5));

} else {
var statearr_45355_47874 = state_45329__$1;
(statearr_45355_47874[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (6))){
var inst_45316 = (state_45329[(9)]);
var inst_45309 = (state_45329[(7)]);
var inst_45312 = (state_45329[(8)]);
var inst_45316__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_45309,inst_45312) : f.call(null,inst_45309,inst_45312));
var inst_45317 = cljs.core.reduced_QMARK_(inst_45316__$1);
var state_45329__$1 = (function (){var statearr_45356 = state_45329;
(statearr_45356[(9)] = inst_45316__$1);

return statearr_45356;
})();
if(inst_45317){
var statearr_45357_47879 = state_45329__$1;
(statearr_45357_47879[(1)] = (8));

} else {
var statearr_45358_47880 = state_45329__$1;
(statearr_45358_47880[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (3))){
var inst_45327 = (state_45329[(2)]);
var state_45329__$1 = state_45329;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45329__$1,inst_45327);
} else {
if((state_val_45330 === (2))){
var state_45329__$1 = state_45329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45329__$1,(4),ch);
} else {
if((state_val_45330 === (9))){
var inst_45316 = (state_45329[(9)]);
var inst_45309 = inst_45316;
var state_45329__$1 = (function (){var statearr_45362 = state_45329;
(statearr_45362[(7)] = inst_45309);

return statearr_45362;
})();
var statearr_45363_47881 = state_45329__$1;
(statearr_45363_47881[(2)] = null);

(statearr_45363_47881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (5))){
var inst_45309 = (state_45329[(7)]);
var state_45329__$1 = state_45329;
var statearr_45364_47882 = state_45329__$1;
(statearr_45364_47882[(2)] = inst_45309);

(statearr_45364_47882[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (10))){
var inst_45323 = (state_45329[(2)]);
var state_45329__$1 = state_45329;
var statearr_45365_47883 = state_45329__$1;
(statearr_45365_47883[(2)] = inst_45323);

(statearr_45365_47883[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45330 === (8))){
var inst_45316 = (state_45329[(9)]);
var inst_45319 = cljs.core.deref(inst_45316);
var state_45329__$1 = state_45329;
var statearr_45366_47884 = state_45329__$1;
(statearr_45366_47884[(2)] = inst_45319);

(statearr_45366_47884[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__44577__auto__ = null;
var cljs$core$async$reduce_$_state_machine__44577__auto____0 = (function (){
var statearr_45371 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45371[(0)] = cljs$core$async$reduce_$_state_machine__44577__auto__);

(statearr_45371[(1)] = (1));

return statearr_45371;
});
var cljs$core$async$reduce_$_state_machine__44577__auto____1 = (function (state_45329){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_45329);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e45372){var ex__44580__auto__ = e45372;
var statearr_45373_47886 = state_45329;
(statearr_45373_47886[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_45329[(4)]))){
var statearr_45374_47887 = state_45329;
(statearr_45374_47887[(1)] = cljs.core.first((state_45329[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47888 = state_45329;
state_45329 = G__47888;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__44577__auto__ = function(state_45329){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__44577__auto____1.call(this,state_45329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__44577__auto____0;
cljs$core$async$reduce_$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__44577__auto____1;
return cljs$core$async$reduce_$_state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_45375 = f__44774__auto__();
(statearr_45375[(6)] = c__44773__auto__);

return statearr_45375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));

return c__44773__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__44773__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_45381){
var state_val_45382 = (state_45381[(1)]);
if((state_val_45382 === (1))){
var inst_45376 = cljs.core.async.reduce(f__$1,init,ch);
var state_45381__$1 = state_45381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45381__$1,(2),inst_45376);
} else {
if((state_val_45382 === (2))){
var inst_45378 = (state_45381[(2)]);
var inst_45379 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_45378) : f__$1.call(null,inst_45378));
var state_45381__$1 = state_45381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45381__$1,inst_45379);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__44577__auto__ = null;
var cljs$core$async$transduce_$_state_machine__44577__auto____0 = (function (){
var statearr_45388 = [null,null,null,null,null,null,null];
(statearr_45388[(0)] = cljs$core$async$transduce_$_state_machine__44577__auto__);

(statearr_45388[(1)] = (1));

return statearr_45388;
});
var cljs$core$async$transduce_$_state_machine__44577__auto____1 = (function (state_45381){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_45381);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e45390){var ex__44580__auto__ = e45390;
var statearr_45391_47889 = state_45381;
(statearr_45391_47889[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_45381[(4)]))){
var statearr_45392_47890 = state_45381;
(statearr_45392_47890[(1)] = cljs.core.first((state_45381[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47891 = state_45381;
state_45381 = G__47891;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__44577__auto__ = function(state_45381){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__44577__auto____1.call(this,state_45381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__44577__auto____0;
cljs$core$async$transduce_$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__44577__auto____1;
return cljs$core$async$transduce_$_state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_45393 = f__44774__auto__();
(statearr_45393[(6)] = c__44773__auto__);

return statearr_45393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));

return c__44773__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__45395 = arguments.length;
switch (G__45395) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__44773__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_45420){
var state_val_45421 = (state_45420[(1)]);
if((state_val_45421 === (7))){
var inst_45402 = (state_45420[(2)]);
var state_45420__$1 = state_45420;
var statearr_45424_47893 = state_45420__$1;
(statearr_45424_47893[(2)] = inst_45402);

(statearr_45424_47893[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45421 === (1))){
var inst_45396 = cljs.core.seq(coll);
var inst_45397 = inst_45396;
var state_45420__$1 = (function (){var statearr_45425 = state_45420;
(statearr_45425[(7)] = inst_45397);

return statearr_45425;
})();
var statearr_45426_47894 = state_45420__$1;
(statearr_45426_47894[(2)] = null);

(statearr_45426_47894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45421 === (4))){
var inst_45397 = (state_45420[(7)]);
var inst_45400 = cljs.core.first(inst_45397);
var state_45420__$1 = state_45420;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45420__$1,(7),ch,inst_45400);
} else {
if((state_val_45421 === (13))){
var inst_45414 = (state_45420[(2)]);
var state_45420__$1 = state_45420;
var statearr_45429_47895 = state_45420__$1;
(statearr_45429_47895[(2)] = inst_45414);

(statearr_45429_47895[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45421 === (6))){
var inst_45405 = (state_45420[(2)]);
var state_45420__$1 = state_45420;
if(cljs.core.truth_(inst_45405)){
var statearr_45430_47896 = state_45420__$1;
(statearr_45430_47896[(1)] = (8));

} else {
var statearr_45431_47897 = state_45420__$1;
(statearr_45431_47897[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45421 === (3))){
var inst_45418 = (state_45420[(2)]);
var state_45420__$1 = state_45420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45420__$1,inst_45418);
} else {
if((state_val_45421 === (12))){
var state_45420__$1 = state_45420;
var statearr_45432_47898 = state_45420__$1;
(statearr_45432_47898[(2)] = null);

(statearr_45432_47898[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45421 === (2))){
var inst_45397 = (state_45420[(7)]);
var state_45420__$1 = state_45420;
if(cljs.core.truth_(inst_45397)){
var statearr_45433_47899 = state_45420__$1;
(statearr_45433_47899[(1)] = (4));

} else {
var statearr_45435_47900 = state_45420__$1;
(statearr_45435_47900[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45421 === (11))){
var inst_45411 = cljs.core.async.close_BANG_(ch);
var state_45420__$1 = state_45420;
var statearr_45440_47901 = state_45420__$1;
(statearr_45440_47901[(2)] = inst_45411);

(statearr_45440_47901[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45421 === (9))){
var state_45420__$1 = state_45420;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45443_47902 = state_45420__$1;
(statearr_45443_47902[(1)] = (11));

} else {
var statearr_45444_47903 = state_45420__$1;
(statearr_45444_47903[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45421 === (5))){
var inst_45397 = (state_45420[(7)]);
var state_45420__$1 = state_45420;
var statearr_45445_47904 = state_45420__$1;
(statearr_45445_47904[(2)] = inst_45397);

(statearr_45445_47904[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45421 === (10))){
var inst_45416 = (state_45420[(2)]);
var state_45420__$1 = state_45420;
var statearr_45446_47905 = state_45420__$1;
(statearr_45446_47905[(2)] = inst_45416);

(statearr_45446_47905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45421 === (8))){
var inst_45397 = (state_45420[(7)]);
var inst_45407 = cljs.core.next(inst_45397);
var inst_45397__$1 = inst_45407;
var state_45420__$1 = (function (){var statearr_45451 = state_45420;
(statearr_45451[(7)] = inst_45397__$1);

return statearr_45451;
})();
var statearr_45452_47906 = state_45420__$1;
(statearr_45452_47906[(2)] = null);

(statearr_45452_47906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44577__auto__ = null;
var cljs$core$async$state_machine__44577__auto____0 = (function (){
var statearr_45454 = [null,null,null,null,null,null,null,null];
(statearr_45454[(0)] = cljs$core$async$state_machine__44577__auto__);

(statearr_45454[(1)] = (1));

return statearr_45454;
});
var cljs$core$async$state_machine__44577__auto____1 = (function (state_45420){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_45420);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e45456){var ex__44580__auto__ = e45456;
var statearr_45458_47907 = state_45420;
(statearr_45458_47907[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_45420[(4)]))){
var statearr_45459_47908 = state_45420;
(statearr_45459_47908[(1)] = cljs.core.first((state_45420[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47909 = state_45420;
state_45420 = G__47909;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$state_machine__44577__auto__ = function(state_45420){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44577__auto____1.call(this,state_45420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44577__auto____0;
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44577__auto____1;
return cljs$core$async$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_45460 = f__44774__auto__();
(statearr_45460[(6)] = c__44773__auto__);

return statearr_45460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));

return c__44773__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__45480 = arguments.length;
switch (G__45480) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_47916 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5394__auto__.call(null,_));
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5392__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_47916(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_47918 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5394__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5392__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_47918(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_47921 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_47921(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_47922 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_47922(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45491 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45491 = (function (ch,cs,meta45492){
this.ch = ch;
this.cs = cs;
this.meta45492 = meta45492;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45491.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45493,meta45492__$1){
var self__ = this;
var _45493__$1 = this;
return (new cljs.core.async.t_cljs$core$async45491(self__.ch,self__.cs,meta45492__$1));
}));

(cljs.core.async.t_cljs$core$async45491.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45493){
var self__ = this;
var _45493__$1 = this;
return self__.meta45492;
}));

(cljs.core.async.t_cljs$core$async45491.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45491.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45491.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45491.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async45491.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async45491.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async45491.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta45492","meta45492",734095855,null)], null);
}));

(cljs.core.async.t_cljs$core$async45491.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45491.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45491");

(cljs.core.async.t_cljs$core$async45491.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async45491");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45491.
 */
cljs.core.async.__GT_t_cljs$core$async45491 = (function cljs$core$async$mult_$___GT_t_cljs$core$async45491(ch__$1,cs__$1,meta45492){
return (new cljs.core.async.t_cljs$core$async45491(ch__$1,cs__$1,meta45492));
});

}

return (new cljs.core.async.t_cljs$core$async45491(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__44773__auto___47930 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_45662){
var state_val_45663 = (state_45662[(1)]);
if((state_val_45663 === (7))){
var inst_45654 = (state_45662[(2)]);
var state_45662__$1 = state_45662;
var statearr_45664_47934 = state_45662__$1;
(statearr_45664_47934[(2)] = inst_45654);

(statearr_45664_47934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (20))){
var inst_45543 = (state_45662[(7)]);
var inst_45559 = cljs.core.first(inst_45543);
var inst_45560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45559,(0),null);
var inst_45563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45559,(1),null);
var state_45662__$1 = (function (){var statearr_45669 = state_45662;
(statearr_45669[(8)] = inst_45560);

return statearr_45669;
})();
if(cljs.core.truth_(inst_45563)){
var statearr_45670_47935 = state_45662__$1;
(statearr_45670_47935[(1)] = (22));

} else {
var statearr_45671_47936 = state_45662__$1;
(statearr_45671_47936[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (27))){
var inst_45508 = (state_45662[(9)]);
var inst_45596 = (state_45662[(10)]);
var inst_45604 = (state_45662[(11)]);
var inst_45598 = (state_45662[(12)]);
var inst_45604__$1 = cljs.core._nth(inst_45596,inst_45598);
var inst_45605 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45604__$1,inst_45508,done);
var state_45662__$1 = (function (){var statearr_45678 = state_45662;
(statearr_45678[(11)] = inst_45604__$1);

return statearr_45678;
})();
if(cljs.core.truth_(inst_45605)){
var statearr_45681_47937 = state_45662__$1;
(statearr_45681_47937[(1)] = (30));

} else {
var statearr_45683_47938 = state_45662__$1;
(statearr_45683_47938[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (1))){
var state_45662__$1 = state_45662;
var statearr_45684_47939 = state_45662__$1;
(statearr_45684_47939[(2)] = null);

(statearr_45684_47939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (24))){
var inst_45543 = (state_45662[(7)]);
var inst_45570 = (state_45662[(2)]);
var inst_45571 = cljs.core.next(inst_45543);
var inst_45517 = inst_45571;
var inst_45518 = null;
var inst_45519 = (0);
var inst_45520 = (0);
var state_45662__$1 = (function (){var statearr_45685 = state_45662;
(statearr_45685[(13)] = inst_45518);

(statearr_45685[(14)] = inst_45519);

(statearr_45685[(15)] = inst_45570);

(statearr_45685[(16)] = inst_45517);

(statearr_45685[(17)] = inst_45520);

return statearr_45685;
})();
var statearr_45686_47943 = state_45662__$1;
(statearr_45686_47943[(2)] = null);

(statearr_45686_47943[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (39))){
var state_45662__$1 = state_45662;
var statearr_45691_47948 = state_45662__$1;
(statearr_45691_47948[(2)] = null);

(statearr_45691_47948[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (4))){
var inst_45508 = (state_45662[(9)]);
var inst_45508__$1 = (state_45662[(2)]);
var inst_45509 = (inst_45508__$1 == null);
var state_45662__$1 = (function (){var statearr_45692 = state_45662;
(statearr_45692[(9)] = inst_45508__$1);

return statearr_45692;
})();
if(cljs.core.truth_(inst_45509)){
var statearr_45693_47950 = state_45662__$1;
(statearr_45693_47950[(1)] = (5));

} else {
var statearr_45694_47951 = state_45662__$1;
(statearr_45694_47951[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (15))){
var inst_45518 = (state_45662[(13)]);
var inst_45519 = (state_45662[(14)]);
var inst_45517 = (state_45662[(16)]);
var inst_45520 = (state_45662[(17)]);
var inst_45539 = (state_45662[(2)]);
var inst_45540 = (inst_45520 + (1));
var tmp45688 = inst_45518;
var tmp45689 = inst_45519;
var tmp45690 = inst_45517;
var inst_45517__$1 = tmp45690;
var inst_45518__$1 = tmp45688;
var inst_45519__$1 = tmp45689;
var inst_45520__$1 = inst_45540;
var state_45662__$1 = (function (){var statearr_45695 = state_45662;
(statearr_45695[(18)] = inst_45539);

(statearr_45695[(13)] = inst_45518__$1);

(statearr_45695[(14)] = inst_45519__$1);

(statearr_45695[(16)] = inst_45517__$1);

(statearr_45695[(17)] = inst_45520__$1);

return statearr_45695;
})();
var statearr_45697_47959 = state_45662__$1;
(statearr_45697_47959[(2)] = null);

(statearr_45697_47959[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (21))){
var inst_45574 = (state_45662[(2)]);
var state_45662__$1 = state_45662;
var statearr_45702_47960 = state_45662__$1;
(statearr_45702_47960[(2)] = inst_45574);

(statearr_45702_47960[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (31))){
var inst_45604 = (state_45662[(11)]);
var inst_45608 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45604);
var state_45662__$1 = state_45662;
var statearr_45708_47961 = state_45662__$1;
(statearr_45708_47961[(2)] = inst_45608);

(statearr_45708_47961[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (32))){
var inst_45595 = (state_45662[(19)]);
var inst_45597 = (state_45662[(20)]);
var inst_45596 = (state_45662[(10)]);
var inst_45598 = (state_45662[(12)]);
var inst_45610 = (state_45662[(2)]);
var inst_45611 = (inst_45598 + (1));
var tmp45699 = inst_45595;
var tmp45700 = inst_45597;
var tmp45701 = inst_45596;
var inst_45595__$1 = tmp45699;
var inst_45596__$1 = tmp45701;
var inst_45597__$1 = tmp45700;
var inst_45598__$1 = inst_45611;
var state_45662__$1 = (function (){var statearr_45712 = state_45662;
(statearr_45712[(19)] = inst_45595__$1);

(statearr_45712[(20)] = inst_45597__$1);

(statearr_45712[(10)] = inst_45596__$1);

(statearr_45712[(12)] = inst_45598__$1);

(statearr_45712[(21)] = inst_45610);

return statearr_45712;
})();
var statearr_45713_47962 = state_45662__$1;
(statearr_45713_47962[(2)] = null);

(statearr_45713_47962[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (40))){
var inst_45623 = (state_45662[(22)]);
var inst_45627 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45623);
var state_45662__$1 = state_45662;
var statearr_45717_47964 = state_45662__$1;
(statearr_45717_47964[(2)] = inst_45627);

(statearr_45717_47964[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (33))){
var inst_45614 = (state_45662[(23)]);
var inst_45616 = cljs.core.chunked_seq_QMARK_(inst_45614);
var state_45662__$1 = state_45662;
if(inst_45616){
var statearr_45718_47965 = state_45662__$1;
(statearr_45718_47965[(1)] = (36));

} else {
var statearr_45719_47966 = state_45662__$1;
(statearr_45719_47966[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (13))){
var inst_45531 = (state_45662[(24)]);
var inst_45536 = cljs.core.async.close_BANG_(inst_45531);
var state_45662__$1 = state_45662;
var statearr_45723_47967 = state_45662__$1;
(statearr_45723_47967[(2)] = inst_45536);

(statearr_45723_47967[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (22))){
var inst_45560 = (state_45662[(8)]);
var inst_45567 = cljs.core.async.close_BANG_(inst_45560);
var state_45662__$1 = state_45662;
var statearr_45724_47968 = state_45662__$1;
(statearr_45724_47968[(2)] = inst_45567);

(statearr_45724_47968[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (36))){
var inst_45614 = (state_45662[(23)]);
var inst_45618 = cljs.core.chunk_first(inst_45614);
var inst_45619 = cljs.core.chunk_rest(inst_45614);
var inst_45620 = cljs.core.count(inst_45618);
var inst_45595 = inst_45619;
var inst_45596 = inst_45618;
var inst_45597 = inst_45620;
var inst_45598 = (0);
var state_45662__$1 = (function (){var statearr_45725 = state_45662;
(statearr_45725[(19)] = inst_45595);

(statearr_45725[(20)] = inst_45597);

(statearr_45725[(10)] = inst_45596);

(statearr_45725[(12)] = inst_45598);

return statearr_45725;
})();
var statearr_45726_47969 = state_45662__$1;
(statearr_45726_47969[(2)] = null);

(statearr_45726_47969[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (41))){
var inst_45614 = (state_45662[(23)]);
var inst_45630 = (state_45662[(2)]);
var inst_45633 = cljs.core.next(inst_45614);
var inst_45595 = inst_45633;
var inst_45596 = null;
var inst_45597 = (0);
var inst_45598 = (0);
var state_45662__$1 = (function (){var statearr_45727 = state_45662;
(statearr_45727[(25)] = inst_45630);

(statearr_45727[(19)] = inst_45595);

(statearr_45727[(20)] = inst_45597);

(statearr_45727[(10)] = inst_45596);

(statearr_45727[(12)] = inst_45598);

return statearr_45727;
})();
var statearr_45728_47971 = state_45662__$1;
(statearr_45728_47971[(2)] = null);

(statearr_45728_47971[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (43))){
var state_45662__$1 = state_45662;
var statearr_45729_47972 = state_45662__$1;
(statearr_45729_47972[(2)] = null);

(statearr_45729_47972[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (29))){
var inst_45641 = (state_45662[(2)]);
var state_45662__$1 = state_45662;
var statearr_45730_47973 = state_45662__$1;
(statearr_45730_47973[(2)] = inst_45641);

(statearr_45730_47973[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (44))){
var inst_45651 = (state_45662[(2)]);
var state_45662__$1 = (function (){var statearr_45731 = state_45662;
(statearr_45731[(26)] = inst_45651);

return statearr_45731;
})();
var statearr_45732_47974 = state_45662__$1;
(statearr_45732_47974[(2)] = null);

(statearr_45732_47974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (6))){
var inst_45586 = (state_45662[(27)]);
var inst_45585 = cljs.core.deref(cs);
var inst_45586__$1 = cljs.core.keys(inst_45585);
var inst_45587 = cljs.core.count(inst_45586__$1);
var inst_45588 = cljs.core.reset_BANG_(dctr,inst_45587);
var inst_45594 = cljs.core.seq(inst_45586__$1);
var inst_45595 = inst_45594;
var inst_45596 = null;
var inst_45597 = (0);
var inst_45598 = (0);
var state_45662__$1 = (function (){var statearr_45733 = state_45662;
(statearr_45733[(27)] = inst_45586__$1);

(statearr_45733[(19)] = inst_45595);

(statearr_45733[(20)] = inst_45597);

(statearr_45733[(10)] = inst_45596);

(statearr_45733[(12)] = inst_45598);

(statearr_45733[(28)] = inst_45588);

return statearr_45733;
})();
var statearr_45734_47981 = state_45662__$1;
(statearr_45734_47981[(2)] = null);

(statearr_45734_47981[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (28))){
var inst_45595 = (state_45662[(19)]);
var inst_45614 = (state_45662[(23)]);
var inst_45614__$1 = cljs.core.seq(inst_45595);
var state_45662__$1 = (function (){var statearr_45738 = state_45662;
(statearr_45738[(23)] = inst_45614__$1);

return statearr_45738;
})();
if(inst_45614__$1){
var statearr_45739_47986 = state_45662__$1;
(statearr_45739_47986[(1)] = (33));

} else {
var statearr_45740_47987 = state_45662__$1;
(statearr_45740_47987[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (25))){
var inst_45597 = (state_45662[(20)]);
var inst_45598 = (state_45662[(12)]);
var inst_45601 = (inst_45598 < inst_45597);
var inst_45602 = inst_45601;
var state_45662__$1 = state_45662;
if(cljs.core.truth_(inst_45602)){
var statearr_45741_47988 = state_45662__$1;
(statearr_45741_47988[(1)] = (27));

} else {
var statearr_45742_47989 = state_45662__$1;
(statearr_45742_47989[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (34))){
var state_45662__$1 = state_45662;
var statearr_45743_47990 = state_45662__$1;
(statearr_45743_47990[(2)] = null);

(statearr_45743_47990[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (17))){
var state_45662__$1 = state_45662;
var statearr_45744_47991 = state_45662__$1;
(statearr_45744_47991[(2)] = null);

(statearr_45744_47991[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (3))){
var inst_45657 = (state_45662[(2)]);
var state_45662__$1 = state_45662;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45662__$1,inst_45657);
} else {
if((state_val_45663 === (12))){
var inst_45580 = (state_45662[(2)]);
var state_45662__$1 = state_45662;
var statearr_45751_47992 = state_45662__$1;
(statearr_45751_47992[(2)] = inst_45580);

(statearr_45751_47992[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (2))){
var state_45662__$1 = state_45662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45662__$1,(4),ch);
} else {
if((state_val_45663 === (23))){
var state_45662__$1 = state_45662;
var statearr_45753_47993 = state_45662__$1;
(statearr_45753_47993[(2)] = null);

(statearr_45753_47993[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (35))){
var inst_45639 = (state_45662[(2)]);
var state_45662__$1 = state_45662;
var statearr_45758_47994 = state_45662__$1;
(statearr_45758_47994[(2)] = inst_45639);

(statearr_45758_47994[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (19))){
var inst_45543 = (state_45662[(7)]);
var inst_45547 = cljs.core.chunk_first(inst_45543);
var inst_45550 = cljs.core.chunk_rest(inst_45543);
var inst_45551 = cljs.core.count(inst_45547);
var inst_45517 = inst_45550;
var inst_45518 = inst_45547;
var inst_45519 = inst_45551;
var inst_45520 = (0);
var state_45662__$1 = (function (){var statearr_45760 = state_45662;
(statearr_45760[(13)] = inst_45518);

(statearr_45760[(14)] = inst_45519);

(statearr_45760[(16)] = inst_45517);

(statearr_45760[(17)] = inst_45520);

return statearr_45760;
})();
var statearr_45761_48002 = state_45662__$1;
(statearr_45761_48002[(2)] = null);

(statearr_45761_48002[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (11))){
var inst_45543 = (state_45662[(7)]);
var inst_45517 = (state_45662[(16)]);
var inst_45543__$1 = cljs.core.seq(inst_45517);
var state_45662__$1 = (function (){var statearr_45766 = state_45662;
(statearr_45766[(7)] = inst_45543__$1);

return statearr_45766;
})();
if(inst_45543__$1){
var statearr_45769_48003 = state_45662__$1;
(statearr_45769_48003[(1)] = (16));

} else {
var statearr_45770_48004 = state_45662__$1;
(statearr_45770_48004[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (9))){
var inst_45582 = (state_45662[(2)]);
var state_45662__$1 = state_45662;
var statearr_45771_48005 = state_45662__$1;
(statearr_45771_48005[(2)] = inst_45582);

(statearr_45771_48005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (5))){
var inst_45515 = cljs.core.deref(cs);
var inst_45516 = cljs.core.seq(inst_45515);
var inst_45517 = inst_45516;
var inst_45518 = null;
var inst_45519 = (0);
var inst_45520 = (0);
var state_45662__$1 = (function (){var statearr_45773 = state_45662;
(statearr_45773[(13)] = inst_45518);

(statearr_45773[(14)] = inst_45519);

(statearr_45773[(16)] = inst_45517);

(statearr_45773[(17)] = inst_45520);

return statearr_45773;
})();
var statearr_45774_48012 = state_45662__$1;
(statearr_45774_48012[(2)] = null);

(statearr_45774_48012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (14))){
var state_45662__$1 = state_45662;
var statearr_45775_48013 = state_45662__$1;
(statearr_45775_48013[(2)] = null);

(statearr_45775_48013[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (45))){
var inst_45648 = (state_45662[(2)]);
var state_45662__$1 = state_45662;
var statearr_45777_48014 = state_45662__$1;
(statearr_45777_48014[(2)] = inst_45648);

(statearr_45777_48014[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (26))){
var inst_45586 = (state_45662[(27)]);
var inst_45643 = (state_45662[(2)]);
var inst_45644 = cljs.core.seq(inst_45586);
var state_45662__$1 = (function (){var statearr_45778 = state_45662;
(statearr_45778[(29)] = inst_45643);

return statearr_45778;
})();
if(inst_45644){
var statearr_45779_48015 = state_45662__$1;
(statearr_45779_48015[(1)] = (42));

} else {
var statearr_45780_48016 = state_45662__$1;
(statearr_45780_48016[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (16))){
var inst_45543 = (state_45662[(7)]);
var inst_45545 = cljs.core.chunked_seq_QMARK_(inst_45543);
var state_45662__$1 = state_45662;
if(inst_45545){
var statearr_45781_48017 = state_45662__$1;
(statearr_45781_48017[(1)] = (19));

} else {
var statearr_45782_48018 = state_45662__$1;
(statearr_45782_48018[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (38))){
var inst_45636 = (state_45662[(2)]);
var state_45662__$1 = state_45662;
var statearr_45783_48019 = state_45662__$1;
(statearr_45783_48019[(2)] = inst_45636);

(statearr_45783_48019[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (30))){
var state_45662__$1 = state_45662;
var statearr_45787_48028 = state_45662__$1;
(statearr_45787_48028[(2)] = null);

(statearr_45787_48028[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (10))){
var inst_45518 = (state_45662[(13)]);
var inst_45520 = (state_45662[(17)]);
var inst_45530 = cljs.core._nth(inst_45518,inst_45520);
var inst_45531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45530,(0),null);
var inst_45533 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45530,(1),null);
var state_45662__$1 = (function (){var statearr_45791 = state_45662;
(statearr_45791[(24)] = inst_45531);

return statearr_45791;
})();
if(cljs.core.truth_(inst_45533)){
var statearr_45792_48033 = state_45662__$1;
(statearr_45792_48033[(1)] = (13));

} else {
var statearr_45793_48034 = state_45662__$1;
(statearr_45793_48034[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (18))){
var inst_45578 = (state_45662[(2)]);
var state_45662__$1 = state_45662;
var statearr_45794_48035 = state_45662__$1;
(statearr_45794_48035[(2)] = inst_45578);

(statearr_45794_48035[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (42))){
var state_45662__$1 = state_45662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45662__$1,(45),dchan);
} else {
if((state_val_45663 === (37))){
var inst_45623 = (state_45662[(22)]);
var inst_45508 = (state_45662[(9)]);
var inst_45614 = (state_45662[(23)]);
var inst_45623__$1 = cljs.core.first(inst_45614);
var inst_45624 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45623__$1,inst_45508,done);
var state_45662__$1 = (function (){var statearr_45796 = state_45662;
(statearr_45796[(22)] = inst_45623__$1);

return statearr_45796;
})();
if(cljs.core.truth_(inst_45624)){
var statearr_45797_48043 = state_45662__$1;
(statearr_45797_48043[(1)] = (39));

} else {
var statearr_45798_48044 = state_45662__$1;
(statearr_45798_48044[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45663 === (8))){
var inst_45519 = (state_45662[(14)]);
var inst_45520 = (state_45662[(17)]);
var inst_45523 = (inst_45520 < inst_45519);
var inst_45524 = inst_45523;
var state_45662__$1 = state_45662;
if(cljs.core.truth_(inst_45524)){
var statearr_45799_48045 = state_45662__$1;
(statearr_45799_48045[(1)] = (10));

} else {
var statearr_45800_48046 = state_45662__$1;
(statearr_45800_48046[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__44577__auto__ = null;
var cljs$core$async$mult_$_state_machine__44577__auto____0 = (function (){
var statearr_45801 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45801[(0)] = cljs$core$async$mult_$_state_machine__44577__auto__);

(statearr_45801[(1)] = (1));

return statearr_45801;
});
var cljs$core$async$mult_$_state_machine__44577__auto____1 = (function (state_45662){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_45662);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e45802){var ex__44580__auto__ = e45802;
var statearr_45803_48047 = state_45662;
(statearr_45803_48047[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_45662[(4)]))){
var statearr_45804_48048 = state_45662;
(statearr_45804_48048[(1)] = cljs.core.first((state_45662[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48050 = state_45662;
state_45662 = G__48050;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__44577__auto__ = function(state_45662){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__44577__auto____1.call(this,state_45662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__44577__auto____0;
cljs$core$async$mult_$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__44577__auto____1;
return cljs$core$async$mult_$_state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_45805 = f__44774__auto__();
(statearr_45805[(6)] = c__44773__auto___47930);

return statearr_45805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__45807 = arguments.length;
switch (G__45807) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_48064 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_48064(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_48066 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_48066(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_48067 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_48067(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_48073 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5394__auto__.call(null,m,state_map));
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5392__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_48073(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_48077 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5394__auto__.call(null,m,mode));
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5392__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_48077(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___48087 = arguments.length;
var i__5770__auto___48088 = (0);
while(true){
if((i__5770__auto___48088 < len__5769__auto___48087)){
args__5775__auto__.push((arguments[i__5770__auto___48088]));

var G__48089 = (i__5770__auto___48088 + (1));
i__5770__auto___48088 = G__48089;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__45829){
var map__45836 = p__45829;
var map__45836__$1 = cljs.core.__destructure_map(map__45836);
var opts = map__45836__$1;
var statearr_45837_48093 = state;
(statearr_45837_48093[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_45838_48094 = state;
(statearr_45838_48094[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_45840_48095 = state;
(statearr_45840_48095[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq45825){
var G__45826 = cljs.core.first(seq45825);
var seq45825__$1 = cljs.core.next(seq45825);
var G__45827 = cljs.core.first(seq45825__$1);
var seq45825__$2 = cljs.core.next(seq45825__$1);
var G__45828 = cljs.core.first(seq45825__$2);
var seq45825__$3 = cljs.core.next(seq45825__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45826,G__45827,G__45828,seq45825__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45847 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45847 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta45848){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta45848 = meta45848;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45849,meta45848__$1){
var self__ = this;
var _45849__$1 = this;
return (new cljs.core.async.t_cljs$core$async45847(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta45848__$1));
}));

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45849){
var self__ = this;
var _45849__$1 = this;
return self__.meta45848;
}));

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45847.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45847.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta45848","meta45848",-2107567665,null)], null);
}));

(cljs.core.async.t_cljs$core$async45847.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45847.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45847");

(cljs.core.async.t_cljs$core$async45847.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async45847");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45847.
 */
cljs.core.async.__GT_t_cljs$core$async45847 = (function cljs$core$async$mix_$___GT_t_cljs$core$async45847(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45848){
return (new cljs.core.async.t_cljs$core$async45847(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45848));
});

}

return (new cljs.core.async.t_cljs$core$async45847(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44773__auto___48124 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_45941){
var state_val_45942 = (state_45941[(1)]);
if((state_val_45942 === (7))){
var inst_45891 = (state_45941[(2)]);
var state_45941__$1 = state_45941;
if(cljs.core.truth_(inst_45891)){
var statearr_45944_48132 = state_45941__$1;
(statearr_45944_48132[(1)] = (8));

} else {
var statearr_45945_48133 = state_45941__$1;
(statearr_45945_48133[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (20))){
var inst_45884 = (state_45941[(7)]);
var state_45941__$1 = state_45941;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45941__$1,(23),out,inst_45884);
} else {
if((state_val_45942 === (1))){
var inst_45863 = calc_state();
var inst_45864 = cljs.core.__destructure_map(inst_45863);
var inst_45865 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45864,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45866 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45864,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45867 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45864,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_45868 = inst_45863;
var state_45941__$1 = (function (){var statearr_45946 = state_45941;
(statearr_45946[(8)] = inst_45868);

(statearr_45946[(9)] = inst_45865);

(statearr_45946[(10)] = inst_45866);

(statearr_45946[(11)] = inst_45867);

return statearr_45946;
})();
var statearr_45947_48134 = state_45941__$1;
(statearr_45947_48134[(2)] = null);

(statearr_45947_48134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (24))){
var inst_45871 = (state_45941[(12)]);
var inst_45868 = inst_45871;
var state_45941__$1 = (function (){var statearr_45948 = state_45941;
(statearr_45948[(8)] = inst_45868);

return statearr_45948;
})();
var statearr_45949_48136 = state_45941__$1;
(statearr_45949_48136[(2)] = null);

(statearr_45949_48136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (4))){
var inst_45886 = (state_45941[(13)]);
var inst_45884 = (state_45941[(7)]);
var inst_45883 = (state_45941[(2)]);
var inst_45884__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45883,(0),null);
var inst_45885 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45883,(1),null);
var inst_45886__$1 = (inst_45884__$1 == null);
var state_45941__$1 = (function (){var statearr_45950 = state_45941;
(statearr_45950[(14)] = inst_45885);

(statearr_45950[(13)] = inst_45886__$1);

(statearr_45950[(7)] = inst_45884__$1);

return statearr_45950;
})();
if(cljs.core.truth_(inst_45886__$1)){
var statearr_45951_48144 = state_45941__$1;
(statearr_45951_48144[(1)] = (5));

} else {
var statearr_45952_48146 = state_45941__$1;
(statearr_45952_48146[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (15))){
var inst_45915 = (state_45941[(15)]);
var inst_45872 = (state_45941[(16)]);
var inst_45915__$1 = cljs.core.empty_QMARK_(inst_45872);
var state_45941__$1 = (function (){var statearr_45955 = state_45941;
(statearr_45955[(15)] = inst_45915__$1);

return statearr_45955;
})();
if(inst_45915__$1){
var statearr_45956_48148 = state_45941__$1;
(statearr_45956_48148[(1)] = (17));

} else {
var statearr_45957_48149 = state_45941__$1;
(statearr_45957_48149[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (21))){
var inst_45871 = (state_45941[(12)]);
var inst_45868 = inst_45871;
var state_45941__$1 = (function (){var statearr_45958 = state_45941;
(statearr_45958[(8)] = inst_45868);

return statearr_45958;
})();
var statearr_45959_48150 = state_45941__$1;
(statearr_45959_48150[(2)] = null);

(statearr_45959_48150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (13))){
var inst_45902 = (state_45941[(2)]);
var inst_45905 = calc_state();
var inst_45868 = inst_45905;
var state_45941__$1 = (function (){var statearr_45960 = state_45941;
(statearr_45960[(17)] = inst_45902);

(statearr_45960[(8)] = inst_45868);

return statearr_45960;
})();
var statearr_45961_48160 = state_45941__$1;
(statearr_45961_48160[(2)] = null);

(statearr_45961_48160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (22))){
var inst_45935 = (state_45941[(2)]);
var state_45941__$1 = state_45941;
var statearr_45962_48163 = state_45941__$1;
(statearr_45962_48163[(2)] = inst_45935);

(statearr_45962_48163[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (6))){
var inst_45885 = (state_45941[(14)]);
var inst_45889 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45885,change);
var state_45941__$1 = state_45941;
var statearr_45963_48169 = state_45941__$1;
(statearr_45963_48169[(2)] = inst_45889);

(statearr_45963_48169[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (25))){
var state_45941__$1 = state_45941;
var statearr_45964_48171 = state_45941__$1;
(statearr_45964_48171[(2)] = null);

(statearr_45964_48171[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (17))){
var inst_45885 = (state_45941[(14)]);
var inst_45873 = (state_45941[(18)]);
var inst_45917 = (inst_45873.cljs$core$IFn$_invoke$arity$1 ? inst_45873.cljs$core$IFn$_invoke$arity$1(inst_45885) : inst_45873.call(null,inst_45885));
var inst_45918 = cljs.core.not(inst_45917);
var state_45941__$1 = state_45941;
var statearr_45965_48172 = state_45941__$1;
(statearr_45965_48172[(2)] = inst_45918);

(statearr_45965_48172[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (3))){
var inst_45939 = (state_45941[(2)]);
var state_45941__$1 = state_45941;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45941__$1,inst_45939);
} else {
if((state_val_45942 === (12))){
var state_45941__$1 = state_45941;
var statearr_45972_48175 = state_45941__$1;
(statearr_45972_48175[(2)] = null);

(statearr_45972_48175[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (2))){
var inst_45868 = (state_45941[(8)]);
var inst_45871 = (state_45941[(12)]);
var inst_45871__$1 = cljs.core.__destructure_map(inst_45868);
var inst_45872 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45871__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45873 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45871__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45874 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45871__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_45941__$1 = (function (){var statearr_45974 = state_45941;
(statearr_45974[(16)] = inst_45872);

(statearr_45974[(18)] = inst_45873);

(statearr_45974[(12)] = inst_45871__$1);

return statearr_45974;
})();
return cljs.core.async.ioc_alts_BANG_(state_45941__$1,(4),inst_45874);
} else {
if((state_val_45942 === (23))){
var inst_45926 = (state_45941[(2)]);
var state_45941__$1 = state_45941;
if(cljs.core.truth_(inst_45926)){
var statearr_45975_48178 = state_45941__$1;
(statearr_45975_48178[(1)] = (24));

} else {
var statearr_45976_48179 = state_45941__$1;
(statearr_45976_48179[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (19))){
var inst_45921 = (state_45941[(2)]);
var state_45941__$1 = state_45941;
var statearr_45977_48180 = state_45941__$1;
(statearr_45977_48180[(2)] = inst_45921);

(statearr_45977_48180[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (11))){
var inst_45885 = (state_45941[(14)]);
var inst_45899 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_45885);
var state_45941__$1 = state_45941;
var statearr_45980_48182 = state_45941__$1;
(statearr_45980_48182[(2)] = inst_45899);

(statearr_45980_48182[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (9))){
var inst_45885 = (state_45941[(14)]);
var inst_45872 = (state_45941[(16)]);
var inst_45910 = (state_45941[(19)]);
var inst_45910__$1 = (inst_45872.cljs$core$IFn$_invoke$arity$1 ? inst_45872.cljs$core$IFn$_invoke$arity$1(inst_45885) : inst_45872.call(null,inst_45885));
var state_45941__$1 = (function (){var statearr_45981 = state_45941;
(statearr_45981[(19)] = inst_45910__$1);

return statearr_45981;
})();
if(cljs.core.truth_(inst_45910__$1)){
var statearr_45988_48183 = state_45941__$1;
(statearr_45988_48183[(1)] = (14));

} else {
var statearr_45989_48184 = state_45941__$1;
(statearr_45989_48184[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (5))){
var inst_45886 = (state_45941[(13)]);
var state_45941__$1 = state_45941;
var statearr_45990_48185 = state_45941__$1;
(statearr_45990_48185[(2)] = inst_45886);

(statearr_45990_48185[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (14))){
var inst_45910 = (state_45941[(19)]);
var state_45941__$1 = state_45941;
var statearr_45992_48186 = state_45941__$1;
(statearr_45992_48186[(2)] = inst_45910);

(statearr_45992_48186[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (26))){
var inst_45931 = (state_45941[(2)]);
var state_45941__$1 = state_45941;
var statearr_45993_48188 = state_45941__$1;
(statearr_45993_48188[(2)] = inst_45931);

(statearr_45993_48188[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (16))){
var inst_45923 = (state_45941[(2)]);
var state_45941__$1 = state_45941;
if(cljs.core.truth_(inst_45923)){
var statearr_45994_48192 = state_45941__$1;
(statearr_45994_48192[(1)] = (20));

} else {
var statearr_45995_48193 = state_45941__$1;
(statearr_45995_48193[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (10))){
var inst_45937 = (state_45941[(2)]);
var state_45941__$1 = state_45941;
var statearr_45998_48195 = state_45941__$1;
(statearr_45998_48195[(2)] = inst_45937);

(statearr_45998_48195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (18))){
var inst_45915 = (state_45941[(15)]);
var state_45941__$1 = state_45941;
var statearr_45999_48199 = state_45941__$1;
(statearr_45999_48199[(2)] = inst_45915);

(statearr_45999_48199[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45942 === (8))){
var inst_45884 = (state_45941[(7)]);
var inst_45893 = (inst_45884 == null);
var state_45941__$1 = state_45941;
if(cljs.core.truth_(inst_45893)){
var statearr_46000_48203 = state_45941__$1;
(statearr_46000_48203[(1)] = (11));

} else {
var statearr_46001_48204 = state_45941__$1;
(statearr_46001_48204[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__44577__auto__ = null;
var cljs$core$async$mix_$_state_machine__44577__auto____0 = (function (){
var statearr_46008 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46008[(0)] = cljs$core$async$mix_$_state_machine__44577__auto__);

(statearr_46008[(1)] = (1));

return statearr_46008;
});
var cljs$core$async$mix_$_state_machine__44577__auto____1 = (function (state_45941){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_45941);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e46009){var ex__44580__auto__ = e46009;
var statearr_46010_48207 = state_45941;
(statearr_46010_48207[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_45941[(4)]))){
var statearr_46012_48208 = state_45941;
(statearr_46012_48208[(1)] = cljs.core.first((state_45941[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48209 = state_45941;
state_45941 = G__48209;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__44577__auto__ = function(state_45941){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__44577__auto____1.call(this,state_45941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__44577__auto____0;
cljs$core$async$mix_$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__44577__auto____1;
return cljs$core$async$mix_$_state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_46017 = f__44774__auto__();
(statearr_46017[(6)] = c__44773__auto___48124);

return statearr_46017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_48214 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5394__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5392__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_48214(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_48215 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5394__auto__.call(null,p,v,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5392__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_48215(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_48220 = (function() {
var G__48221 = null;
var G__48221__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5394__auto__.call(null,p));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5392__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__48221__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5394__auto__.call(null,p,v));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5392__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__48221 = function(p,v){
switch(arguments.length){
case 1:
return G__48221__1.call(this,p);
case 2:
return G__48221__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48221.cljs$core$IFn$_invoke$arity$1 = G__48221__1;
G__48221.cljs$core$IFn$_invoke$arity$2 = G__48221__2;
return G__48221;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__46032 = arguments.length;
switch (G__46032) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_48220(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_48220(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__46037 = arguments.length;
switch (G__46037) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__46035_SHARP_){
if(cljs.core.truth_((p1__46035_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__46035_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__46035_SHARP_.call(null,topic)))){
return p1__46035_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__46035_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46038 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46038 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta46039){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta46039 = meta46039;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46038.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46040,meta46039__$1){
var self__ = this;
var _46040__$1 = this;
return (new cljs.core.async.t_cljs$core$async46038(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta46039__$1));
}));

(cljs.core.async.t_cljs$core$async46038.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46040){
var self__ = this;
var _46040__$1 = this;
return self__.meta46039;
}));

(cljs.core.async.t_cljs$core$async46038.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46038.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async46038.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46038.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async46038.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async46038.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async46038.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async46038.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta46039","meta46039",2031641048,null)], null);
}));

(cljs.core.async.t_cljs$core$async46038.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46038.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46038");

(cljs.core.async.t_cljs$core$async46038.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async46038");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46038.
 */
cljs.core.async.__GT_t_cljs$core$async46038 = (function cljs$core$async$__GT_t_cljs$core$async46038(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46039){
return (new cljs.core.async.t_cljs$core$async46038(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46039));
});

}

return (new cljs.core.async.t_cljs$core$async46038(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44773__auto___48245 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_46174){
var state_val_46185 = (state_46174[(1)]);
if((state_val_46185 === (7))){
var inst_46169 = (state_46174[(2)]);
var state_46174__$1 = state_46174;
var statearr_46197_48249 = state_46174__$1;
(statearr_46197_48249[(2)] = inst_46169);

(statearr_46197_48249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (20))){
var state_46174__$1 = state_46174;
var statearr_46198_48250 = state_46174__$1;
(statearr_46198_48250[(2)] = null);

(statearr_46198_48250[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (1))){
var state_46174__$1 = state_46174;
var statearr_46209_48255 = state_46174__$1;
(statearr_46209_48255[(2)] = null);

(statearr_46209_48255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (24))){
var inst_46142 = (state_46174[(7)]);
var inst_46161 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_46142);
var state_46174__$1 = state_46174;
var statearr_46220_48257 = state_46174__$1;
(statearr_46220_48257[(2)] = inst_46161);

(statearr_46220_48257[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (4))){
var inst_46063 = (state_46174[(8)]);
var inst_46063__$1 = (state_46174[(2)]);
var inst_46064 = (inst_46063__$1 == null);
var state_46174__$1 = (function (){var statearr_46228 = state_46174;
(statearr_46228[(8)] = inst_46063__$1);

return statearr_46228;
})();
if(cljs.core.truth_(inst_46064)){
var statearr_46229_48260 = state_46174__$1;
(statearr_46229_48260[(1)] = (5));

} else {
var statearr_46240_48261 = state_46174__$1;
(statearr_46240_48261[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (15))){
var inst_46136 = (state_46174[(2)]);
var state_46174__$1 = state_46174;
var statearr_46241_48265 = state_46174__$1;
(statearr_46241_48265[(2)] = inst_46136);

(statearr_46241_48265[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (21))){
var inst_46166 = (state_46174[(2)]);
var state_46174__$1 = (function (){var statearr_46253 = state_46174;
(statearr_46253[(9)] = inst_46166);

return statearr_46253;
})();
var statearr_46254_48266 = state_46174__$1;
(statearr_46254_48266[(2)] = null);

(statearr_46254_48266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (13))){
var inst_46097 = (state_46174[(10)]);
var inst_46103 = cljs.core.chunked_seq_QMARK_(inst_46097);
var state_46174__$1 = state_46174;
if(inst_46103){
var statearr_46255_48267 = state_46174__$1;
(statearr_46255_48267[(1)] = (16));

} else {
var statearr_46266_48268 = state_46174__$1;
(statearr_46266_48268[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (22))){
var inst_46158 = (state_46174[(2)]);
var state_46174__$1 = state_46174;
if(cljs.core.truth_(inst_46158)){
var statearr_46267_48269 = state_46174__$1;
(statearr_46267_48269[(1)] = (23));

} else {
var statearr_46268_48270 = state_46174__$1;
(statearr_46268_48270[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (6))){
var inst_46144 = (state_46174[(11)]);
var inst_46142 = (state_46174[(7)]);
var inst_46063 = (state_46174[(8)]);
var inst_46142__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_46063) : topic_fn.call(null,inst_46063));
var inst_46143 = cljs.core.deref(mults);
var inst_46144__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46143,inst_46142__$1);
var state_46174__$1 = (function (){var statearr_46279 = state_46174;
(statearr_46279[(11)] = inst_46144__$1);

(statearr_46279[(7)] = inst_46142__$1);

return statearr_46279;
})();
if(cljs.core.truth_(inst_46144__$1)){
var statearr_46290_48272 = state_46174__$1;
(statearr_46290_48272[(1)] = (19));

} else {
var statearr_46291_48273 = state_46174__$1;
(statearr_46291_48273[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (25))){
var inst_46163 = (state_46174[(2)]);
var state_46174__$1 = state_46174;
var statearr_46304_48274 = state_46174__$1;
(statearr_46304_48274[(2)] = inst_46163);

(statearr_46304_48274[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (17))){
var inst_46097 = (state_46174[(10)]);
var inst_46126 = cljs.core.first(inst_46097);
var inst_46128 = cljs.core.async.muxch_STAR_(inst_46126);
var inst_46129 = cljs.core.async.close_BANG_(inst_46128);
var inst_46130 = cljs.core.next(inst_46097);
var inst_46073 = inst_46130;
var inst_46074 = null;
var inst_46075 = (0);
var inst_46076 = (0);
var state_46174__$1 = (function (){var statearr_46320 = state_46174;
(statearr_46320[(12)] = inst_46075);

(statearr_46320[(13)] = inst_46076);

(statearr_46320[(14)] = inst_46129);

(statearr_46320[(15)] = inst_46074);

(statearr_46320[(16)] = inst_46073);

return statearr_46320;
})();
var statearr_46324_48278 = state_46174__$1;
(statearr_46324_48278[(2)] = null);

(statearr_46324_48278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (3))){
var inst_46171 = (state_46174[(2)]);
var state_46174__$1 = state_46174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46174__$1,inst_46171);
} else {
if((state_val_46185 === (12))){
var inst_46138 = (state_46174[(2)]);
var state_46174__$1 = state_46174;
var statearr_46328_48280 = state_46174__$1;
(statearr_46328_48280[(2)] = inst_46138);

(statearr_46328_48280[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (2))){
var state_46174__$1 = state_46174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46174__$1,(4),ch);
} else {
if((state_val_46185 === (23))){
var state_46174__$1 = state_46174;
var statearr_46331_48283 = state_46174__$1;
(statearr_46331_48283[(2)] = null);

(statearr_46331_48283[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (19))){
var inst_46144 = (state_46174[(11)]);
var inst_46063 = (state_46174[(8)]);
var inst_46156 = cljs.core.async.muxch_STAR_(inst_46144);
var state_46174__$1 = state_46174;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46174__$1,(22),inst_46156,inst_46063);
} else {
if((state_val_46185 === (11))){
var inst_46097 = (state_46174[(10)]);
var inst_46073 = (state_46174[(16)]);
var inst_46097__$1 = cljs.core.seq(inst_46073);
var state_46174__$1 = (function (){var statearr_46352 = state_46174;
(statearr_46352[(10)] = inst_46097__$1);

return statearr_46352;
})();
if(inst_46097__$1){
var statearr_46353_48284 = state_46174__$1;
(statearr_46353_48284[(1)] = (13));

} else {
var statearr_46354_48285 = state_46174__$1;
(statearr_46354_48285[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (9))){
var inst_46140 = (state_46174[(2)]);
var state_46174__$1 = state_46174;
var statearr_46355_48286 = state_46174__$1;
(statearr_46355_48286[(2)] = inst_46140);

(statearr_46355_48286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (5))){
var inst_46070 = cljs.core.deref(mults);
var inst_46071 = cljs.core.vals(inst_46070);
var inst_46072 = cljs.core.seq(inst_46071);
var inst_46073 = inst_46072;
var inst_46074 = null;
var inst_46075 = (0);
var inst_46076 = (0);
var state_46174__$1 = (function (){var statearr_46366 = state_46174;
(statearr_46366[(12)] = inst_46075);

(statearr_46366[(13)] = inst_46076);

(statearr_46366[(15)] = inst_46074);

(statearr_46366[(16)] = inst_46073);

return statearr_46366;
})();
var statearr_46367_48287 = state_46174__$1;
(statearr_46367_48287[(2)] = null);

(statearr_46367_48287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (14))){
var state_46174__$1 = state_46174;
var statearr_46382_48288 = state_46174__$1;
(statearr_46382_48288[(2)] = null);

(statearr_46382_48288[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (16))){
var inst_46097 = (state_46174[(10)]);
var inst_46111 = cljs.core.chunk_first(inst_46097);
var inst_46112 = cljs.core.chunk_rest(inst_46097);
var inst_46113 = cljs.core.count(inst_46111);
var inst_46073 = inst_46112;
var inst_46074 = inst_46111;
var inst_46075 = inst_46113;
var inst_46076 = (0);
var state_46174__$1 = (function (){var statearr_46404 = state_46174;
(statearr_46404[(12)] = inst_46075);

(statearr_46404[(13)] = inst_46076);

(statearr_46404[(15)] = inst_46074);

(statearr_46404[(16)] = inst_46073);

return statearr_46404;
})();
var statearr_46417_48296 = state_46174__$1;
(statearr_46417_48296[(2)] = null);

(statearr_46417_48296[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (10))){
var inst_46075 = (state_46174[(12)]);
var inst_46076 = (state_46174[(13)]);
var inst_46074 = (state_46174[(15)]);
var inst_46073 = (state_46174[(16)]);
var inst_46081 = cljs.core._nth(inst_46074,inst_46076);
var inst_46092 = cljs.core.async.muxch_STAR_(inst_46081);
var inst_46093 = cljs.core.async.close_BANG_(inst_46092);
var inst_46094 = (inst_46076 + (1));
var tmp46369 = inst_46075;
var tmp46370 = inst_46074;
var tmp46371 = inst_46073;
var inst_46073__$1 = tmp46371;
var inst_46074__$1 = tmp46370;
var inst_46075__$1 = tmp46369;
var inst_46076__$1 = inst_46094;
var state_46174__$1 = (function (){var statearr_46429 = state_46174;
(statearr_46429[(12)] = inst_46075__$1);

(statearr_46429[(17)] = inst_46093);

(statearr_46429[(13)] = inst_46076__$1);

(statearr_46429[(15)] = inst_46074__$1);

(statearr_46429[(16)] = inst_46073__$1);

return statearr_46429;
})();
var statearr_46430_48297 = state_46174__$1;
(statearr_46430_48297[(2)] = null);

(statearr_46430_48297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (18))){
var inst_46133 = (state_46174[(2)]);
var state_46174__$1 = state_46174;
var statearr_46441_48304 = state_46174__$1;
(statearr_46441_48304[(2)] = inst_46133);

(statearr_46441_48304[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46185 === (8))){
var inst_46075 = (state_46174[(12)]);
var inst_46076 = (state_46174[(13)]);
var inst_46078 = (inst_46076 < inst_46075);
var inst_46079 = inst_46078;
var state_46174__$1 = state_46174;
if(cljs.core.truth_(inst_46079)){
var statearr_46442_48322 = state_46174__$1;
(statearr_46442_48322[(1)] = (10));

} else {
var statearr_46443_48323 = state_46174__$1;
(statearr_46443_48323[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44577__auto__ = null;
var cljs$core$async$state_machine__44577__auto____0 = (function (){
var statearr_46462 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46462[(0)] = cljs$core$async$state_machine__44577__auto__);

(statearr_46462[(1)] = (1));

return statearr_46462;
});
var cljs$core$async$state_machine__44577__auto____1 = (function (state_46174){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_46174);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e46464){var ex__44580__auto__ = e46464;
var statearr_46465_48325 = state_46174;
(statearr_46465_48325[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_46174[(4)]))){
var statearr_46466_48326 = state_46174;
(statearr_46466_48326[(1)] = cljs.core.first((state_46174[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48327 = state_46174;
state_46174 = G__48327;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$state_machine__44577__auto__ = function(state_46174){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44577__auto____1.call(this,state_46174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44577__auto____0;
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44577__auto____1;
return cljs$core$async$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_46469 = f__44774__auto__();
(statearr_46469[(6)] = c__44773__auto___48245);

return statearr_46469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__46473 = arguments.length;
switch (G__46473) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__46479 = arguments.length;
switch (G__46479) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__46489 = arguments.length;
switch (G__46489) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__44773__auto___48365 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_46578){
var state_val_46579 = (state_46578[(1)]);
if((state_val_46579 === (7))){
var state_46578__$1 = state_46578;
var statearr_46583_48367 = state_46578__$1;
(statearr_46583_48367[(2)] = null);

(statearr_46583_48367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (1))){
var state_46578__$1 = state_46578;
var statearr_46588_48369 = state_46578__$1;
(statearr_46588_48369[(2)] = null);

(statearr_46588_48369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (4))){
var inst_46517 = (state_46578[(7)]);
var inst_46516 = (state_46578[(8)]);
var inst_46525 = (inst_46517 < inst_46516);
var state_46578__$1 = state_46578;
if(cljs.core.truth_(inst_46525)){
var statearr_46590_48378 = state_46578__$1;
(statearr_46590_48378[(1)] = (6));

} else {
var statearr_46591_48379 = state_46578__$1;
(statearr_46591_48379[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (15))){
var inst_46564 = (state_46578[(9)]);
var inst_46569 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_46564);
var state_46578__$1 = state_46578;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46578__$1,(17),out,inst_46569);
} else {
if((state_val_46579 === (13))){
var inst_46564 = (state_46578[(9)]);
var inst_46564__$1 = (state_46578[(2)]);
var inst_46565 = cljs.core.some(cljs.core.nil_QMARK_,inst_46564__$1);
var state_46578__$1 = (function (){var statearr_46595 = state_46578;
(statearr_46595[(9)] = inst_46564__$1);

return statearr_46595;
})();
if(cljs.core.truth_(inst_46565)){
var statearr_46596_48382 = state_46578__$1;
(statearr_46596_48382[(1)] = (14));

} else {
var statearr_46597_48383 = state_46578__$1;
(statearr_46597_48383[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (6))){
var state_46578__$1 = state_46578;
var statearr_46598_48385 = state_46578__$1;
(statearr_46598_48385[(2)] = null);

(statearr_46598_48385[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (17))){
var inst_46571 = (state_46578[(2)]);
var state_46578__$1 = (function (){var statearr_46603 = state_46578;
(statearr_46603[(10)] = inst_46571);

return statearr_46603;
})();
var statearr_46605_48386 = state_46578__$1;
(statearr_46605_48386[(2)] = null);

(statearr_46605_48386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (3))){
var inst_46576 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46578__$1,inst_46576);
} else {
if((state_val_46579 === (12))){
var _ = (function (){var statearr_46608 = state_46578;
(statearr_46608[(4)] = cljs.core.rest((state_46578[(4)])));

return statearr_46608;
})();
var state_46578__$1 = state_46578;
var ex46602 = (state_46578__$1[(2)]);
var statearr_46610_48387 = state_46578__$1;
(statearr_46610_48387[(5)] = ex46602);


if((ex46602 instanceof Object)){
var statearr_46611_48388 = state_46578__$1;
(statearr_46611_48388[(1)] = (11));

(statearr_46611_48388[(5)] = null);

} else {
throw ex46602;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (2))){
var inst_46512 = cljs.core.reset_BANG_(dctr,cnt);
var inst_46516 = cnt;
var inst_46517 = (0);
var state_46578__$1 = (function (){var statearr_46614 = state_46578;
(statearr_46614[(11)] = inst_46512);

(statearr_46614[(7)] = inst_46517);

(statearr_46614[(8)] = inst_46516);

return statearr_46614;
})();
var statearr_46615_48391 = state_46578__$1;
(statearr_46615_48391[(2)] = null);

(statearr_46615_48391[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (11))){
var inst_46537 = (state_46578[(2)]);
var inst_46538 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_46578__$1 = (function (){var statearr_46616 = state_46578;
(statearr_46616[(12)] = inst_46537);

return statearr_46616;
})();
var statearr_46620_48393 = state_46578__$1;
(statearr_46620_48393[(2)] = inst_46538);

(statearr_46620_48393[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (9))){
var inst_46517 = (state_46578[(7)]);
var _ = (function (){var statearr_46621 = state_46578;
(statearr_46621[(4)] = cljs.core.cons((12),(state_46578[(4)])));

return statearr_46621;
})();
var inst_46544 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_46517) : chs__$1.call(null,inst_46517));
var inst_46545 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_46517) : done.call(null,inst_46517));
var inst_46546 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_46544,inst_46545);
var ___$1 = (function (){var statearr_46622 = state_46578;
(statearr_46622[(4)] = cljs.core.rest((state_46578[(4)])));

return statearr_46622;
})();
var state_46578__$1 = state_46578;
var statearr_46623_48398 = state_46578__$1;
(statearr_46623_48398[(2)] = inst_46546);

(statearr_46623_48398[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (5))){
var inst_46560 = (state_46578[(2)]);
var state_46578__$1 = (function (){var statearr_46624 = state_46578;
(statearr_46624[(13)] = inst_46560);

return statearr_46624;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46578__$1,(13),dchan);
} else {
if((state_val_46579 === (14))){
var inst_46567 = cljs.core.async.close_BANG_(out);
var state_46578__$1 = state_46578;
var statearr_46626_48399 = state_46578__$1;
(statearr_46626_48399[(2)] = inst_46567);

(statearr_46626_48399[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (16))){
var inst_46574 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
var statearr_46627_48401 = state_46578__$1;
(statearr_46627_48401[(2)] = inst_46574);

(statearr_46627_48401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (10))){
var inst_46517 = (state_46578[(7)]);
var inst_46549 = (state_46578[(2)]);
var inst_46550 = (inst_46517 + (1));
var inst_46517__$1 = inst_46550;
var state_46578__$1 = (function (){var statearr_46628 = state_46578;
(statearr_46628[(14)] = inst_46549);

(statearr_46628[(7)] = inst_46517__$1);

return statearr_46628;
})();
var statearr_46629_48406 = state_46578__$1;
(statearr_46629_48406[(2)] = null);

(statearr_46629_48406[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (8))){
var inst_46557 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
var statearr_46630_48408 = state_46578__$1;
(statearr_46630_48408[(2)] = inst_46557);

(statearr_46630_48408[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44577__auto__ = null;
var cljs$core$async$state_machine__44577__auto____0 = (function (){
var statearr_46631 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46631[(0)] = cljs$core$async$state_machine__44577__auto__);

(statearr_46631[(1)] = (1));

return statearr_46631;
});
var cljs$core$async$state_machine__44577__auto____1 = (function (state_46578){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_46578);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e46632){var ex__44580__auto__ = e46632;
var statearr_46633_48412 = state_46578;
(statearr_46633_48412[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_46578[(4)]))){
var statearr_46634_48413 = state_46578;
(statearr_46634_48413[(1)] = cljs.core.first((state_46578[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48414 = state_46578;
state_46578 = G__48414;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$state_machine__44577__auto__ = function(state_46578){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44577__auto____1.call(this,state_46578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44577__auto____0;
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44577__auto____1;
return cljs$core$async$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_46635 = f__44774__auto__();
(statearr_46635[(6)] = c__44773__auto___48365);

return statearr_46635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__46653 = arguments.length;
switch (G__46653) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44773__auto___48421 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_46707){
var state_val_46708 = (state_46707[(1)]);
if((state_val_46708 === (7))){
var inst_46682 = (state_46707[(7)]);
var inst_46680 = (state_46707[(8)]);
var inst_46680__$1 = (state_46707[(2)]);
var inst_46682__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46680__$1,(0),null);
var inst_46683 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46680__$1,(1),null);
var inst_46687 = (inst_46682__$1 == null);
var state_46707__$1 = (function (){var statearr_46731 = state_46707;
(statearr_46731[(7)] = inst_46682__$1);

(statearr_46731[(8)] = inst_46680__$1);

(statearr_46731[(9)] = inst_46683);

return statearr_46731;
})();
if(cljs.core.truth_(inst_46687)){
var statearr_46732_48422 = state_46707__$1;
(statearr_46732_48422[(1)] = (8));

} else {
var statearr_46733_48424 = state_46707__$1;
(statearr_46733_48424[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46708 === (1))){
var inst_46667 = cljs.core.vec(chs);
var inst_46668 = inst_46667;
var state_46707__$1 = (function (){var statearr_46734 = state_46707;
(statearr_46734[(10)] = inst_46668);

return statearr_46734;
})();
var statearr_46735_48428 = state_46707__$1;
(statearr_46735_48428[(2)] = null);

(statearr_46735_48428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46708 === (4))){
var inst_46668 = (state_46707[(10)]);
var state_46707__$1 = state_46707;
return cljs.core.async.ioc_alts_BANG_(state_46707__$1,(7),inst_46668);
} else {
if((state_val_46708 === (6))){
var inst_46703 = (state_46707[(2)]);
var state_46707__$1 = state_46707;
var statearr_46748_48429 = state_46707__$1;
(statearr_46748_48429[(2)] = inst_46703);

(statearr_46748_48429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46708 === (3))){
var inst_46705 = (state_46707[(2)]);
var state_46707__$1 = state_46707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46707__$1,inst_46705);
} else {
if((state_val_46708 === (2))){
var inst_46668 = (state_46707[(10)]);
var inst_46670 = cljs.core.count(inst_46668);
var inst_46671 = (inst_46670 > (0));
var state_46707__$1 = state_46707;
if(cljs.core.truth_(inst_46671)){
var statearr_46760_48430 = state_46707__$1;
(statearr_46760_48430[(1)] = (4));

} else {
var statearr_46761_48431 = state_46707__$1;
(statearr_46761_48431[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46708 === (11))){
var inst_46668 = (state_46707[(10)]);
var inst_46696 = (state_46707[(2)]);
var tmp46755 = inst_46668;
var inst_46668__$1 = tmp46755;
var state_46707__$1 = (function (){var statearr_46773 = state_46707;
(statearr_46773[(11)] = inst_46696);

(statearr_46773[(10)] = inst_46668__$1);

return statearr_46773;
})();
var statearr_46780_48432 = state_46707__$1;
(statearr_46780_48432[(2)] = null);

(statearr_46780_48432[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46708 === (9))){
var inst_46682 = (state_46707[(7)]);
var state_46707__$1 = state_46707;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46707__$1,(11),out,inst_46682);
} else {
if((state_val_46708 === (5))){
var inst_46701 = cljs.core.async.close_BANG_(out);
var state_46707__$1 = state_46707;
var statearr_46786_48433 = state_46707__$1;
(statearr_46786_48433[(2)] = inst_46701);

(statearr_46786_48433[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46708 === (10))){
var inst_46699 = (state_46707[(2)]);
var state_46707__$1 = state_46707;
var statearr_46787_48434 = state_46707__$1;
(statearr_46787_48434[(2)] = inst_46699);

(statearr_46787_48434[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46708 === (8))){
var inst_46682 = (state_46707[(7)]);
var inst_46668 = (state_46707[(10)]);
var inst_46680 = (state_46707[(8)]);
var inst_46683 = (state_46707[(9)]);
var inst_46691 = (function (){var cs = inst_46668;
var vec__46675 = inst_46680;
var v = inst_46682;
var c = inst_46683;
return (function (p1__46639_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__46639_SHARP_);
});
})();
var inst_46692 = cljs.core.filterv(inst_46691,inst_46668);
var inst_46668__$1 = inst_46692;
var state_46707__$1 = (function (){var statearr_46789 = state_46707;
(statearr_46789[(10)] = inst_46668__$1);

return statearr_46789;
})();
var statearr_46790_48436 = state_46707__$1;
(statearr_46790_48436[(2)] = null);

(statearr_46790_48436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44577__auto__ = null;
var cljs$core$async$state_machine__44577__auto____0 = (function (){
var statearr_46792 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46792[(0)] = cljs$core$async$state_machine__44577__auto__);

(statearr_46792[(1)] = (1));

return statearr_46792;
});
var cljs$core$async$state_machine__44577__auto____1 = (function (state_46707){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_46707);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e46794){var ex__44580__auto__ = e46794;
var statearr_46796_48437 = state_46707;
(statearr_46796_48437[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_46707[(4)]))){
var statearr_46797_48438 = state_46707;
(statearr_46797_48438[(1)] = cljs.core.first((state_46707[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48442 = state_46707;
state_46707 = G__48442;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$state_machine__44577__auto__ = function(state_46707){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44577__auto____1.call(this,state_46707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44577__auto____0;
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44577__auto____1;
return cljs$core$async$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_46801 = f__44774__auto__();
(statearr_46801[(6)] = c__44773__auto___48421);

return statearr_46801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__46815 = arguments.length;
switch (G__46815) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44773__auto___48444 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_46844){
var state_val_46845 = (state_46844[(1)]);
if((state_val_46845 === (7))){
var inst_46825 = (state_46844[(7)]);
var inst_46825__$1 = (state_46844[(2)]);
var inst_46826 = (inst_46825__$1 == null);
var inst_46827 = cljs.core.not(inst_46826);
var state_46844__$1 = (function (){var statearr_46848 = state_46844;
(statearr_46848[(7)] = inst_46825__$1);

return statearr_46848;
})();
if(inst_46827){
var statearr_46849_48448 = state_46844__$1;
(statearr_46849_48448[(1)] = (8));

} else {
var statearr_46850_48449 = state_46844__$1;
(statearr_46850_48449[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46845 === (1))){
var inst_46819 = (0);
var state_46844__$1 = (function (){var statearr_46851 = state_46844;
(statearr_46851[(8)] = inst_46819);

return statearr_46851;
})();
var statearr_46852_48450 = state_46844__$1;
(statearr_46852_48450[(2)] = null);

(statearr_46852_48450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46845 === (4))){
var state_46844__$1 = state_46844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46844__$1,(7),ch);
} else {
if((state_val_46845 === (6))){
var inst_46838 = (state_46844[(2)]);
var state_46844__$1 = state_46844;
var statearr_46853_48451 = state_46844__$1;
(statearr_46853_48451[(2)] = inst_46838);

(statearr_46853_48451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46845 === (3))){
var inst_46840 = (state_46844[(2)]);
var inst_46841 = cljs.core.async.close_BANG_(out);
var state_46844__$1 = (function (){var statearr_46854 = state_46844;
(statearr_46854[(9)] = inst_46840);

return statearr_46854;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46844__$1,inst_46841);
} else {
if((state_val_46845 === (2))){
var inst_46819 = (state_46844[(8)]);
var inst_46822 = (inst_46819 < n);
var state_46844__$1 = state_46844;
if(cljs.core.truth_(inst_46822)){
var statearr_46855_48453 = state_46844__$1;
(statearr_46855_48453[(1)] = (4));

} else {
var statearr_46856_48454 = state_46844__$1;
(statearr_46856_48454[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46845 === (11))){
var inst_46819 = (state_46844[(8)]);
var inst_46830 = (state_46844[(2)]);
var inst_46831 = (inst_46819 + (1));
var inst_46819__$1 = inst_46831;
var state_46844__$1 = (function (){var statearr_46860 = state_46844;
(statearr_46860[(10)] = inst_46830);

(statearr_46860[(8)] = inst_46819__$1);

return statearr_46860;
})();
var statearr_46861_48456 = state_46844__$1;
(statearr_46861_48456[(2)] = null);

(statearr_46861_48456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46845 === (9))){
var state_46844__$1 = state_46844;
var statearr_46862_48457 = state_46844__$1;
(statearr_46862_48457[(2)] = null);

(statearr_46862_48457[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46845 === (5))){
var state_46844__$1 = state_46844;
var statearr_46863_48458 = state_46844__$1;
(statearr_46863_48458[(2)] = null);

(statearr_46863_48458[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46845 === (10))){
var inst_46835 = (state_46844[(2)]);
var state_46844__$1 = state_46844;
var statearr_46864_48460 = state_46844__$1;
(statearr_46864_48460[(2)] = inst_46835);

(statearr_46864_48460[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46845 === (8))){
var inst_46825 = (state_46844[(7)]);
var state_46844__$1 = state_46844;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46844__$1,(11),out,inst_46825);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44577__auto__ = null;
var cljs$core$async$state_machine__44577__auto____0 = (function (){
var statearr_46866 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46866[(0)] = cljs$core$async$state_machine__44577__auto__);

(statearr_46866[(1)] = (1));

return statearr_46866;
});
var cljs$core$async$state_machine__44577__auto____1 = (function (state_46844){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_46844);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e46868){var ex__44580__auto__ = e46868;
var statearr_46869_48462 = state_46844;
(statearr_46869_48462[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_46844[(4)]))){
var statearr_46870_48463 = state_46844;
(statearr_46870_48463[(1)] = cljs.core.first((state_46844[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48465 = state_46844;
state_46844 = G__48465;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$state_machine__44577__auto__ = function(state_46844){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44577__auto____1.call(this,state_46844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44577__auto____0;
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44577__auto____1;
return cljs$core$async$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_46871 = f__44774__auto__();
(statearr_46871[(6)] = c__44773__auto___48444);

return statearr_46871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46873 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46873 = (function (f,ch,meta46874){
this.f = f;
this.ch = ch;
this.meta46874 = meta46874;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46873.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46875,meta46874__$1){
var self__ = this;
var _46875__$1 = this;
return (new cljs.core.async.t_cljs$core$async46873(self__.f,self__.ch,meta46874__$1));
}));

(cljs.core.async.t_cljs$core$async46873.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46875){
var self__ = this;
var _46875__$1 = this;
return self__.meta46874;
}));

(cljs.core.async.t_cljs$core$async46873.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46873.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46873.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46873.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46873.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46877 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46877 = (function (f,ch,meta46874,_,fn1,meta46878){
this.f = f;
this.ch = ch;
this.meta46874 = meta46874;
this._ = _;
this.fn1 = fn1;
this.meta46878 = meta46878;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46877.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46879,meta46878__$1){
var self__ = this;
var _46879__$1 = this;
return (new cljs.core.async.t_cljs$core$async46877(self__.f,self__.ch,self__.meta46874,self__._,self__.fn1,meta46878__$1));
}));

(cljs.core.async.t_cljs$core$async46877.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46879){
var self__ = this;
var _46879__$1 = this;
return self__.meta46878;
}));

(cljs.core.async.t_cljs$core$async46877.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46877.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async46877.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async46877.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__46872_SHARP_){
var G__46880 = (((p1__46872_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__46872_SHARP_) : self__.f.call(null,p1__46872_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__46880) : f1.call(null,G__46880));
});
}));

(cljs.core.async.t_cljs$core$async46877.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46874","meta46874",-106235652,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async46873","cljs.core.async/t_cljs$core$async46873",-223224912,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta46878","meta46878",-1632441,null)], null);
}));

(cljs.core.async.t_cljs$core$async46877.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46877.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46877");

(cljs.core.async.t_cljs$core$async46877.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async46877");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46877.
 */
cljs.core.async.__GT_t_cljs$core$async46877 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async46877(f__$1,ch__$1,meta46874__$1,___$2,fn1__$1,meta46878){
return (new cljs.core.async.t_cljs$core$async46877(f__$1,ch__$1,meta46874__$1,___$2,fn1__$1,meta46878));
});

}

return (new cljs.core.async.t_cljs$core$async46877(self__.f,self__.ch,self__.meta46874,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__46881 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__46881) : self__.f.call(null,G__46881));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async46873.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46873.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async46873.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46874","meta46874",-106235652,null)], null);
}));

(cljs.core.async.t_cljs$core$async46873.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46873.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46873");

(cljs.core.async.t_cljs$core$async46873.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async46873");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46873.
 */
cljs.core.async.__GT_t_cljs$core$async46873 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async46873(f__$1,ch__$1,meta46874){
return (new cljs.core.async.t_cljs$core$async46873(f__$1,ch__$1,meta46874));
});

}

return (new cljs.core.async.t_cljs$core$async46873(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46882 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46882 = (function (f,ch,meta46883){
this.f = f;
this.ch = ch;
this.meta46883 = meta46883;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46882.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46884,meta46883__$1){
var self__ = this;
var _46884__$1 = this;
return (new cljs.core.async.t_cljs$core$async46882(self__.f,self__.ch,meta46883__$1));
}));

(cljs.core.async.t_cljs$core$async46882.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46884){
var self__ = this;
var _46884__$1 = this;
return self__.meta46883;
}));

(cljs.core.async.t_cljs$core$async46882.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46882.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46882.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46882.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async46882.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46882.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async46882.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46883","meta46883",-1506923976,null)], null);
}));

(cljs.core.async.t_cljs$core$async46882.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46882.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46882");

(cljs.core.async.t_cljs$core$async46882.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async46882");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46882.
 */
cljs.core.async.__GT_t_cljs$core$async46882 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async46882(f__$1,ch__$1,meta46883){
return (new cljs.core.async.t_cljs$core$async46882(f__$1,ch__$1,meta46883));
});

}

return (new cljs.core.async.t_cljs$core$async46882(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46885 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46885 = (function (p,ch,meta46886){
this.p = p;
this.ch = ch;
this.meta46886 = meta46886;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46885.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46887,meta46886__$1){
var self__ = this;
var _46887__$1 = this;
return (new cljs.core.async.t_cljs$core$async46885(self__.p,self__.ch,meta46886__$1));
}));

(cljs.core.async.t_cljs$core$async46885.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46887){
var self__ = this;
var _46887__$1 = this;
return self__.meta46886;
}));

(cljs.core.async.t_cljs$core$async46885.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46885.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46885.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46885.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46885.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async46885.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46885.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async46885.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46886","meta46886",550950204,null)], null);
}));

(cljs.core.async.t_cljs$core$async46885.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46885.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46885");

(cljs.core.async.t_cljs$core$async46885.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async46885");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46885.
 */
cljs.core.async.__GT_t_cljs$core$async46885 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async46885(p__$1,ch__$1,meta46886){
return (new cljs.core.async.t_cljs$core$async46885(p__$1,ch__$1,meta46886));
});

}

return (new cljs.core.async.t_cljs$core$async46885(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__46889 = arguments.length;
switch (G__46889) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44773__auto___48516 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_46913){
var state_val_46914 = (state_46913[(1)]);
if((state_val_46914 === (7))){
var inst_46909 = (state_46913[(2)]);
var state_46913__$1 = state_46913;
var statearr_46917_48517 = state_46913__$1;
(statearr_46917_48517[(2)] = inst_46909);

(statearr_46917_48517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46914 === (1))){
var state_46913__$1 = state_46913;
var statearr_46918_48518 = state_46913__$1;
(statearr_46918_48518[(2)] = null);

(statearr_46918_48518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46914 === (4))){
var inst_46895 = (state_46913[(7)]);
var inst_46895__$1 = (state_46913[(2)]);
var inst_46896 = (inst_46895__$1 == null);
var state_46913__$1 = (function (){var statearr_46919 = state_46913;
(statearr_46919[(7)] = inst_46895__$1);

return statearr_46919;
})();
if(cljs.core.truth_(inst_46896)){
var statearr_46920_48523 = state_46913__$1;
(statearr_46920_48523[(1)] = (5));

} else {
var statearr_46921_48524 = state_46913__$1;
(statearr_46921_48524[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46914 === (6))){
var inst_46895 = (state_46913[(7)]);
var inst_46900 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_46895) : p.call(null,inst_46895));
var state_46913__$1 = state_46913;
if(cljs.core.truth_(inst_46900)){
var statearr_46924_48526 = state_46913__$1;
(statearr_46924_48526[(1)] = (8));

} else {
var statearr_46925_48527 = state_46913__$1;
(statearr_46925_48527[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46914 === (3))){
var inst_46911 = (state_46913[(2)]);
var state_46913__$1 = state_46913;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46913__$1,inst_46911);
} else {
if((state_val_46914 === (2))){
var state_46913__$1 = state_46913;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46913__$1,(4),ch);
} else {
if((state_val_46914 === (11))){
var inst_46903 = (state_46913[(2)]);
var state_46913__$1 = state_46913;
var statearr_46931_48531 = state_46913__$1;
(statearr_46931_48531[(2)] = inst_46903);

(statearr_46931_48531[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46914 === (9))){
var state_46913__$1 = state_46913;
var statearr_46932_48532 = state_46913__$1;
(statearr_46932_48532[(2)] = null);

(statearr_46932_48532[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46914 === (5))){
var inst_46898 = cljs.core.async.close_BANG_(out);
var state_46913__$1 = state_46913;
var statearr_46933_48533 = state_46913__$1;
(statearr_46933_48533[(2)] = inst_46898);

(statearr_46933_48533[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46914 === (10))){
var inst_46906 = (state_46913[(2)]);
var state_46913__$1 = (function (){var statearr_46937 = state_46913;
(statearr_46937[(8)] = inst_46906);

return statearr_46937;
})();
var statearr_46950_48534 = state_46913__$1;
(statearr_46950_48534[(2)] = null);

(statearr_46950_48534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46914 === (8))){
var inst_46895 = (state_46913[(7)]);
var state_46913__$1 = state_46913;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46913__$1,(11),out,inst_46895);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44577__auto__ = null;
var cljs$core$async$state_machine__44577__auto____0 = (function (){
var statearr_46951 = [null,null,null,null,null,null,null,null,null];
(statearr_46951[(0)] = cljs$core$async$state_machine__44577__auto__);

(statearr_46951[(1)] = (1));

return statearr_46951;
});
var cljs$core$async$state_machine__44577__auto____1 = (function (state_46913){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_46913);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e46952){var ex__44580__auto__ = e46952;
var statearr_46953_48537 = state_46913;
(statearr_46953_48537[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_46913[(4)]))){
var statearr_46954_48538 = state_46913;
(statearr_46954_48538[(1)] = cljs.core.first((state_46913[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48539 = state_46913;
state_46913 = G__48539;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$state_machine__44577__auto__ = function(state_46913){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44577__auto____1.call(this,state_46913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44577__auto____0;
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44577__auto____1;
return cljs$core$async$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_46955 = f__44774__auto__();
(statearr_46955[(6)] = c__44773__auto___48516);

return statearr_46955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__46957 = arguments.length;
switch (G__46957) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__44773__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_47052){
var state_val_47053 = (state_47052[(1)]);
if((state_val_47053 === (7))){
var inst_47044 = (state_47052[(2)]);
var state_47052__$1 = state_47052;
var statearr_47054_48543 = state_47052__$1;
(statearr_47054_48543[(2)] = inst_47044);

(statearr_47054_48543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (20))){
var inst_47008 = (state_47052[(7)]);
var inst_47025 = (state_47052[(2)]);
var inst_47026 = cljs.core.next(inst_47008);
var inst_46989 = inst_47026;
var inst_46990 = null;
var inst_46991 = (0);
var inst_46992 = (0);
var state_47052__$1 = (function (){var statearr_47055 = state_47052;
(statearr_47055[(8)] = inst_47025);

(statearr_47055[(9)] = inst_46991);

(statearr_47055[(10)] = inst_46990);

(statearr_47055[(11)] = inst_46989);

(statearr_47055[(12)] = inst_46992);

return statearr_47055;
})();
var statearr_47060_48544 = state_47052__$1;
(statearr_47060_48544[(2)] = null);

(statearr_47060_48544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (1))){
var state_47052__$1 = state_47052;
var statearr_47061_48545 = state_47052__$1;
(statearr_47061_48545[(2)] = null);

(statearr_47061_48545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (4))){
var inst_46977 = (state_47052[(13)]);
var inst_46977__$1 = (state_47052[(2)]);
var inst_46978 = (inst_46977__$1 == null);
var state_47052__$1 = (function (){var statearr_47062 = state_47052;
(statearr_47062[(13)] = inst_46977__$1);

return statearr_47062;
})();
if(cljs.core.truth_(inst_46978)){
var statearr_47063_48547 = state_47052__$1;
(statearr_47063_48547[(1)] = (5));

} else {
var statearr_47064_48548 = state_47052__$1;
(statearr_47064_48548[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (15))){
var state_47052__$1 = state_47052;
var statearr_47068_48549 = state_47052__$1;
(statearr_47068_48549[(2)] = null);

(statearr_47068_48549[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (21))){
var state_47052__$1 = state_47052;
var statearr_47069_48551 = state_47052__$1;
(statearr_47069_48551[(2)] = null);

(statearr_47069_48551[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (13))){
var inst_46991 = (state_47052[(9)]);
var inst_46990 = (state_47052[(10)]);
var inst_46989 = (state_47052[(11)]);
var inst_46992 = (state_47052[(12)]);
var inst_47004 = (state_47052[(2)]);
var inst_47005 = (inst_46992 + (1));
var tmp47065 = inst_46991;
var tmp47066 = inst_46990;
var tmp47067 = inst_46989;
var inst_46989__$1 = tmp47067;
var inst_46990__$1 = tmp47066;
var inst_46991__$1 = tmp47065;
var inst_46992__$1 = inst_47005;
var state_47052__$1 = (function (){var statearr_47077 = state_47052;
(statearr_47077[(14)] = inst_47004);

(statearr_47077[(9)] = inst_46991__$1);

(statearr_47077[(10)] = inst_46990__$1);

(statearr_47077[(11)] = inst_46989__$1);

(statearr_47077[(12)] = inst_46992__$1);

return statearr_47077;
})();
var statearr_47078_48554 = state_47052__$1;
(statearr_47078_48554[(2)] = null);

(statearr_47078_48554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (22))){
var state_47052__$1 = state_47052;
var statearr_47079_48562 = state_47052__$1;
(statearr_47079_48562[(2)] = null);

(statearr_47079_48562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (6))){
var inst_46977 = (state_47052[(13)]);
var inst_46986 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_46977) : f.call(null,inst_46977));
var inst_46987 = cljs.core.seq(inst_46986);
var inst_46989 = inst_46987;
var inst_46990 = null;
var inst_46991 = (0);
var inst_46992 = (0);
var state_47052__$1 = (function (){var statearr_47080 = state_47052;
(statearr_47080[(9)] = inst_46991);

(statearr_47080[(10)] = inst_46990);

(statearr_47080[(11)] = inst_46989);

(statearr_47080[(12)] = inst_46992);

return statearr_47080;
})();
var statearr_47081_48565 = state_47052__$1;
(statearr_47081_48565[(2)] = null);

(statearr_47081_48565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (17))){
var inst_47008 = (state_47052[(7)]);
var inst_47012 = cljs.core.chunk_first(inst_47008);
var inst_47014 = cljs.core.chunk_rest(inst_47008);
var inst_47019 = cljs.core.count(inst_47012);
var inst_46989 = inst_47014;
var inst_46990 = inst_47012;
var inst_46991 = inst_47019;
var inst_46992 = (0);
var state_47052__$1 = (function (){var statearr_47082 = state_47052;
(statearr_47082[(9)] = inst_46991);

(statearr_47082[(10)] = inst_46990);

(statearr_47082[(11)] = inst_46989);

(statearr_47082[(12)] = inst_46992);

return statearr_47082;
})();
var statearr_47083_48566 = state_47052__$1;
(statearr_47083_48566[(2)] = null);

(statearr_47083_48566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (3))){
var inst_47046 = (state_47052[(2)]);
var state_47052__$1 = state_47052;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47052__$1,inst_47046);
} else {
if((state_val_47053 === (12))){
var inst_47034 = (state_47052[(2)]);
var state_47052__$1 = state_47052;
var statearr_47088_48569 = state_47052__$1;
(statearr_47088_48569[(2)] = inst_47034);

(statearr_47088_48569[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (2))){
var state_47052__$1 = state_47052;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47052__$1,(4),in$);
} else {
if((state_val_47053 === (23))){
var inst_47042 = (state_47052[(2)]);
var state_47052__$1 = state_47052;
var statearr_47093_48572 = state_47052__$1;
(statearr_47093_48572[(2)] = inst_47042);

(statearr_47093_48572[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (19))){
var inst_47029 = (state_47052[(2)]);
var state_47052__$1 = state_47052;
var statearr_47094_48574 = state_47052__$1;
(statearr_47094_48574[(2)] = inst_47029);

(statearr_47094_48574[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (11))){
var inst_47008 = (state_47052[(7)]);
var inst_46989 = (state_47052[(11)]);
var inst_47008__$1 = cljs.core.seq(inst_46989);
var state_47052__$1 = (function (){var statearr_47098 = state_47052;
(statearr_47098[(7)] = inst_47008__$1);

return statearr_47098;
})();
if(inst_47008__$1){
var statearr_47099_48575 = state_47052__$1;
(statearr_47099_48575[(1)] = (14));

} else {
var statearr_47100_48576 = state_47052__$1;
(statearr_47100_48576[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (9))){
var inst_47036 = (state_47052[(2)]);
var inst_47037 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_47052__$1 = (function (){var statearr_47103 = state_47052;
(statearr_47103[(15)] = inst_47036);

return statearr_47103;
})();
if(cljs.core.truth_(inst_47037)){
var statearr_47104_48577 = state_47052__$1;
(statearr_47104_48577[(1)] = (21));

} else {
var statearr_47106_48578 = state_47052__$1;
(statearr_47106_48578[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (5))){
var inst_46980 = cljs.core.async.close_BANG_(out);
var state_47052__$1 = state_47052;
var statearr_47107_48583 = state_47052__$1;
(statearr_47107_48583[(2)] = inst_46980);

(statearr_47107_48583[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (14))){
var inst_47008 = (state_47052[(7)]);
var inst_47010 = cljs.core.chunked_seq_QMARK_(inst_47008);
var state_47052__$1 = state_47052;
if(inst_47010){
var statearr_47114_48588 = state_47052__$1;
(statearr_47114_48588[(1)] = (17));

} else {
var statearr_47115_48589 = state_47052__$1;
(statearr_47115_48589[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (16))){
var inst_47032 = (state_47052[(2)]);
var state_47052__$1 = state_47052;
var statearr_47116_48594 = state_47052__$1;
(statearr_47116_48594[(2)] = inst_47032);

(statearr_47116_48594[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (10))){
var inst_46990 = (state_47052[(10)]);
var inst_46992 = (state_47052[(12)]);
var inst_47002 = cljs.core._nth(inst_46990,inst_46992);
var state_47052__$1 = state_47052;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47052__$1,(13),out,inst_47002);
} else {
if((state_val_47053 === (18))){
var inst_47008 = (state_47052[(7)]);
var inst_47023 = cljs.core.first(inst_47008);
var state_47052__$1 = state_47052;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47052__$1,(20),out,inst_47023);
} else {
if((state_val_47053 === (8))){
var inst_46991 = (state_47052[(9)]);
var inst_46992 = (state_47052[(12)]);
var inst_46995 = (inst_46992 < inst_46991);
var inst_46999 = inst_46995;
var state_47052__$1 = state_47052;
if(cljs.core.truth_(inst_46999)){
var statearr_47127_48597 = state_47052__$1;
(statearr_47127_48597[(1)] = (10));

} else {
var statearr_47128_48598 = state_47052__$1;
(statearr_47128_48598[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__44577__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__44577__auto____0 = (function (){
var statearr_47133 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47133[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__44577__auto__);

(statearr_47133[(1)] = (1));

return statearr_47133;
});
var cljs$core$async$mapcat_STAR__$_state_machine__44577__auto____1 = (function (state_47052){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_47052);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e47135){var ex__44580__auto__ = e47135;
var statearr_47137_48599 = state_47052;
(statearr_47137_48599[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_47052[(4)]))){
var statearr_47139_48600 = state_47052;
(statearr_47139_48600[(1)] = cljs.core.first((state_47052[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48601 = state_47052;
state_47052 = G__48601;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__44577__auto__ = function(state_47052){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__44577__auto____1.call(this,state_47052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__44577__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__44577__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_47141 = f__44774__auto__();
(statearr_47141[(6)] = c__44773__auto__);

return statearr_47141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));

return c__44773__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__47144 = arguments.length;
switch (G__47144) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__47154 = arguments.length;
switch (G__47154) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__47185 = arguments.length;
switch (G__47185) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44773__auto___48606 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_47232){
var state_val_47233 = (state_47232[(1)]);
if((state_val_47233 === (7))){
var inst_47227 = (state_47232[(2)]);
var state_47232__$1 = state_47232;
var statearr_47239_48607 = state_47232__$1;
(statearr_47239_48607[(2)] = inst_47227);

(statearr_47239_48607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47233 === (1))){
var inst_47201 = null;
var state_47232__$1 = (function (){var statearr_47240 = state_47232;
(statearr_47240[(7)] = inst_47201);

return statearr_47240;
})();
var statearr_47241_48608 = state_47232__$1;
(statearr_47241_48608[(2)] = null);

(statearr_47241_48608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47233 === (4))){
var inst_47204 = (state_47232[(8)]);
var inst_47204__$1 = (state_47232[(2)]);
var inst_47209 = (inst_47204__$1 == null);
var inst_47210 = cljs.core.not(inst_47209);
var state_47232__$1 = (function (){var statearr_47242 = state_47232;
(statearr_47242[(8)] = inst_47204__$1);

return statearr_47242;
})();
if(inst_47210){
var statearr_47243_48609 = state_47232__$1;
(statearr_47243_48609[(1)] = (5));

} else {
var statearr_47244_48610 = state_47232__$1;
(statearr_47244_48610[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47233 === (6))){
var state_47232__$1 = state_47232;
var statearr_47245_48611 = state_47232__$1;
(statearr_47245_48611[(2)] = null);

(statearr_47245_48611[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47233 === (3))){
var inst_47229 = (state_47232[(2)]);
var inst_47230 = cljs.core.async.close_BANG_(out);
var state_47232__$1 = (function (){var statearr_47246 = state_47232;
(statearr_47246[(9)] = inst_47229);

return statearr_47246;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47232__$1,inst_47230);
} else {
if((state_val_47233 === (2))){
var state_47232__$1 = state_47232;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47232__$1,(4),ch);
} else {
if((state_val_47233 === (11))){
var inst_47204 = (state_47232[(8)]);
var inst_47217 = (state_47232[(2)]);
var inst_47201 = inst_47204;
var state_47232__$1 = (function (){var statearr_47247 = state_47232;
(statearr_47247[(10)] = inst_47217);

(statearr_47247[(7)] = inst_47201);

return statearr_47247;
})();
var statearr_47248_48612 = state_47232__$1;
(statearr_47248_48612[(2)] = null);

(statearr_47248_48612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47233 === (9))){
var inst_47204 = (state_47232[(8)]);
var state_47232__$1 = state_47232;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47232__$1,(11),out,inst_47204);
} else {
if((state_val_47233 === (5))){
var inst_47201 = (state_47232[(7)]);
var inst_47204 = (state_47232[(8)]);
var inst_47212 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47204,inst_47201);
var state_47232__$1 = state_47232;
if(inst_47212){
var statearr_47254_48613 = state_47232__$1;
(statearr_47254_48613[(1)] = (8));

} else {
var statearr_47255_48614 = state_47232__$1;
(statearr_47255_48614[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47233 === (10))){
var inst_47222 = (state_47232[(2)]);
var state_47232__$1 = state_47232;
var statearr_47262_48615 = state_47232__$1;
(statearr_47262_48615[(2)] = inst_47222);

(statearr_47262_48615[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47233 === (8))){
var inst_47201 = (state_47232[(7)]);
var tmp47249 = inst_47201;
var inst_47201__$1 = tmp47249;
var state_47232__$1 = (function (){var statearr_47270 = state_47232;
(statearr_47270[(7)] = inst_47201__$1);

return statearr_47270;
})();
var statearr_47275_48616 = state_47232__$1;
(statearr_47275_48616[(2)] = null);

(statearr_47275_48616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44577__auto__ = null;
var cljs$core$async$state_machine__44577__auto____0 = (function (){
var statearr_47281 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47281[(0)] = cljs$core$async$state_machine__44577__auto__);

(statearr_47281[(1)] = (1));

return statearr_47281;
});
var cljs$core$async$state_machine__44577__auto____1 = (function (state_47232){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_47232);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e47286){var ex__44580__auto__ = e47286;
var statearr_47287_48618 = state_47232;
(statearr_47287_48618[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_47232[(4)]))){
var statearr_47296_48622 = state_47232;
(statearr_47296_48622[(1)] = cljs.core.first((state_47232[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48623 = state_47232;
state_47232 = G__48623;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$state_machine__44577__auto__ = function(state_47232){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44577__auto____1.call(this,state_47232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44577__auto____0;
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44577__auto____1;
return cljs$core$async$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_47319 = f__44774__auto__();
(statearr_47319[(6)] = c__44773__auto___48606);

return statearr_47319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__47339 = arguments.length;
switch (G__47339) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44773__auto___48631 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_47400){
var state_val_47401 = (state_47400[(1)]);
if((state_val_47401 === (7))){
var inst_47396 = (state_47400[(2)]);
var state_47400__$1 = state_47400;
var statearr_47402_48632 = state_47400__$1;
(statearr_47402_48632[(2)] = inst_47396);

(statearr_47402_48632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47401 === (1))){
var inst_47354 = (new Array(n));
var inst_47359 = inst_47354;
var inst_47360 = (0);
var state_47400__$1 = (function (){var statearr_47404 = state_47400;
(statearr_47404[(7)] = inst_47359);

(statearr_47404[(8)] = inst_47360);

return statearr_47404;
})();
var statearr_47405_48633 = state_47400__$1;
(statearr_47405_48633[(2)] = null);

(statearr_47405_48633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47401 === (4))){
var inst_47366 = (state_47400[(9)]);
var inst_47366__$1 = (state_47400[(2)]);
var inst_47367 = (inst_47366__$1 == null);
var inst_47368 = cljs.core.not(inst_47367);
var state_47400__$1 = (function (){var statearr_47406 = state_47400;
(statearr_47406[(9)] = inst_47366__$1);

return statearr_47406;
})();
if(inst_47368){
var statearr_47407_48635 = state_47400__$1;
(statearr_47407_48635[(1)] = (5));

} else {
var statearr_47408_48636 = state_47400__$1;
(statearr_47408_48636[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47401 === (15))){
var inst_47390 = (state_47400[(2)]);
var state_47400__$1 = state_47400;
var statearr_47409_48637 = state_47400__$1;
(statearr_47409_48637[(2)] = inst_47390);

(statearr_47409_48637[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47401 === (13))){
var state_47400__$1 = state_47400;
var statearr_47410_48639 = state_47400__$1;
(statearr_47410_48639[(2)] = null);

(statearr_47410_48639[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47401 === (6))){
var inst_47360 = (state_47400[(8)]);
var inst_47386 = (inst_47360 > (0));
var state_47400__$1 = state_47400;
if(cljs.core.truth_(inst_47386)){
var statearr_47411_48640 = state_47400__$1;
(statearr_47411_48640[(1)] = (12));

} else {
var statearr_47412_48641 = state_47400__$1;
(statearr_47412_48641[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47401 === (3))){
var inst_47398 = (state_47400[(2)]);
var state_47400__$1 = state_47400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47400__$1,inst_47398);
} else {
if((state_val_47401 === (12))){
var inst_47359 = (state_47400[(7)]);
var inst_47388 = cljs.core.vec(inst_47359);
var state_47400__$1 = state_47400;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47400__$1,(15),out,inst_47388);
} else {
if((state_val_47401 === (2))){
var state_47400__$1 = state_47400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47400__$1,(4),ch);
} else {
if((state_val_47401 === (11))){
var inst_47378 = (state_47400[(2)]);
var inst_47379 = (new Array(n));
var inst_47359 = inst_47379;
var inst_47360 = (0);
var state_47400__$1 = (function (){var statearr_47417 = state_47400;
(statearr_47417[(7)] = inst_47359);

(statearr_47417[(10)] = inst_47378);

(statearr_47417[(8)] = inst_47360);

return statearr_47417;
})();
var statearr_47418_48643 = state_47400__$1;
(statearr_47418_48643[(2)] = null);

(statearr_47418_48643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47401 === (9))){
var inst_47359 = (state_47400[(7)]);
var inst_47376 = cljs.core.vec(inst_47359);
var state_47400__$1 = state_47400;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47400__$1,(11),out,inst_47376);
} else {
if((state_val_47401 === (5))){
var inst_47359 = (state_47400[(7)]);
var inst_47366 = (state_47400[(9)]);
var inst_47360 = (state_47400[(8)]);
var inst_47371 = (state_47400[(11)]);
var inst_47370 = (inst_47359[inst_47360] = inst_47366);
var inst_47371__$1 = (inst_47360 + (1));
var inst_47372 = (inst_47371__$1 < n);
var state_47400__$1 = (function (){var statearr_47424 = state_47400;
(statearr_47424[(12)] = inst_47370);

(statearr_47424[(11)] = inst_47371__$1);

return statearr_47424;
})();
if(cljs.core.truth_(inst_47372)){
var statearr_47425_48644 = state_47400__$1;
(statearr_47425_48644[(1)] = (8));

} else {
var statearr_47426_48645 = state_47400__$1;
(statearr_47426_48645[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47401 === (14))){
var inst_47393 = (state_47400[(2)]);
var inst_47394 = cljs.core.async.close_BANG_(out);
var state_47400__$1 = (function (){var statearr_47428 = state_47400;
(statearr_47428[(13)] = inst_47393);

return statearr_47428;
})();
var statearr_47429_48647 = state_47400__$1;
(statearr_47429_48647[(2)] = inst_47394);

(statearr_47429_48647[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47401 === (10))){
var inst_47384 = (state_47400[(2)]);
var state_47400__$1 = state_47400;
var statearr_47431_48648 = state_47400__$1;
(statearr_47431_48648[(2)] = inst_47384);

(statearr_47431_48648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47401 === (8))){
var inst_47359 = (state_47400[(7)]);
var inst_47371 = (state_47400[(11)]);
var tmp47427 = inst_47359;
var inst_47359__$1 = tmp47427;
var inst_47360 = inst_47371;
var state_47400__$1 = (function (){var statearr_47432 = state_47400;
(statearr_47432[(7)] = inst_47359__$1);

(statearr_47432[(8)] = inst_47360);

return statearr_47432;
})();
var statearr_47435_48649 = state_47400__$1;
(statearr_47435_48649[(2)] = null);

(statearr_47435_48649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44577__auto__ = null;
var cljs$core$async$state_machine__44577__auto____0 = (function (){
var statearr_47438 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47438[(0)] = cljs$core$async$state_machine__44577__auto__);

(statearr_47438[(1)] = (1));

return statearr_47438;
});
var cljs$core$async$state_machine__44577__auto____1 = (function (state_47400){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_47400);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e47439){var ex__44580__auto__ = e47439;
var statearr_47440_48651 = state_47400;
(statearr_47440_48651[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_47400[(4)]))){
var statearr_47441_48654 = state_47400;
(statearr_47441_48654[(1)] = cljs.core.first((state_47400[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48658 = state_47400;
state_47400 = G__48658;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$state_machine__44577__auto__ = function(state_47400){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44577__auto____1.call(this,state_47400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44577__auto____0;
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44577__auto____1;
return cljs$core$async$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_47442 = f__44774__auto__();
(statearr_47442[(6)] = c__44773__auto___48631);

return statearr_47442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__47445 = arguments.length;
switch (G__47445) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44773__auto___48664 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_47496){
var state_val_47497 = (state_47496[(1)]);
if((state_val_47497 === (7))){
var inst_47492 = (state_47496[(2)]);
var state_47496__$1 = state_47496;
var statearr_47500_48665 = state_47496__$1;
(statearr_47500_48665[(2)] = inst_47492);

(statearr_47500_48665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (1))){
var inst_47450 = [];
var inst_47451 = inst_47450;
var inst_47452 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_47496__$1 = (function (){var statearr_47501 = state_47496;
(statearr_47501[(7)] = inst_47451);

(statearr_47501[(8)] = inst_47452);

return statearr_47501;
})();
var statearr_47502_48666 = state_47496__$1;
(statearr_47502_48666[(2)] = null);

(statearr_47502_48666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (4))){
var inst_47455 = (state_47496[(9)]);
var inst_47455__$1 = (state_47496[(2)]);
var inst_47456 = (inst_47455__$1 == null);
var inst_47457 = cljs.core.not(inst_47456);
var state_47496__$1 = (function (){var statearr_47503 = state_47496;
(statearr_47503[(9)] = inst_47455__$1);

return statearr_47503;
})();
if(inst_47457){
var statearr_47504_48667 = state_47496__$1;
(statearr_47504_48667[(1)] = (5));

} else {
var statearr_47505_48668 = state_47496__$1;
(statearr_47505_48668[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (15))){
var inst_47451 = (state_47496[(7)]);
var inst_47484 = cljs.core.vec(inst_47451);
var state_47496__$1 = state_47496;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47496__$1,(18),out,inst_47484);
} else {
if((state_val_47497 === (13))){
var inst_47479 = (state_47496[(2)]);
var state_47496__$1 = state_47496;
var statearr_47506_48669 = state_47496__$1;
(statearr_47506_48669[(2)] = inst_47479);

(statearr_47506_48669[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (6))){
var inst_47451 = (state_47496[(7)]);
var inst_47481 = inst_47451.length;
var inst_47482 = (inst_47481 > (0));
var state_47496__$1 = state_47496;
if(cljs.core.truth_(inst_47482)){
var statearr_47507_48670 = state_47496__$1;
(statearr_47507_48670[(1)] = (15));

} else {
var statearr_47509_48671 = state_47496__$1;
(statearr_47509_48671[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (17))){
var inst_47489 = (state_47496[(2)]);
var inst_47490 = cljs.core.async.close_BANG_(out);
var state_47496__$1 = (function (){var statearr_47510 = state_47496;
(statearr_47510[(10)] = inst_47489);

return statearr_47510;
})();
var statearr_47511_48672 = state_47496__$1;
(statearr_47511_48672[(2)] = inst_47490);

(statearr_47511_48672[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (3))){
var inst_47494 = (state_47496[(2)]);
var state_47496__$1 = state_47496;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47496__$1,inst_47494);
} else {
if((state_val_47497 === (12))){
var inst_47451 = (state_47496[(7)]);
var inst_47471 = cljs.core.vec(inst_47451);
var state_47496__$1 = state_47496;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47496__$1,(14),out,inst_47471);
} else {
if((state_val_47497 === (2))){
var state_47496__$1 = state_47496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47496__$1,(4),ch);
} else {
if((state_val_47497 === (11))){
var inst_47455 = (state_47496[(9)]);
var inst_47451 = (state_47496[(7)]);
var inst_47459 = (state_47496[(11)]);
var inst_47467 = inst_47451.push(inst_47455);
var tmp47513 = inst_47451;
var inst_47451__$1 = tmp47513;
var inst_47452 = inst_47459;
var state_47496__$1 = (function (){var statearr_47514 = state_47496;
(statearr_47514[(7)] = inst_47451__$1);

(statearr_47514[(8)] = inst_47452);

(statearr_47514[(12)] = inst_47467);

return statearr_47514;
})();
var statearr_47515_48677 = state_47496__$1;
(statearr_47515_48677[(2)] = null);

(statearr_47515_48677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (9))){
var inst_47452 = (state_47496[(8)]);
var inst_47463 = cljs.core.keyword_identical_QMARK_(inst_47452,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_47496__$1 = state_47496;
var statearr_47520_48678 = state_47496__$1;
(statearr_47520_48678[(2)] = inst_47463);

(statearr_47520_48678[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (5))){
var inst_47455 = (state_47496[(9)]);
var inst_47460 = (state_47496[(13)]);
var inst_47459 = (state_47496[(11)]);
var inst_47452 = (state_47496[(8)]);
var inst_47459__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_47455) : f.call(null,inst_47455));
var inst_47460__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47459__$1,inst_47452);
var state_47496__$1 = (function (){var statearr_47523 = state_47496;
(statearr_47523[(13)] = inst_47460__$1);

(statearr_47523[(11)] = inst_47459__$1);

return statearr_47523;
})();
if(inst_47460__$1){
var statearr_47524_48679 = state_47496__$1;
(statearr_47524_48679[(1)] = (8));

} else {
var statearr_47525_48680 = state_47496__$1;
(statearr_47525_48680[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (14))){
var inst_47455 = (state_47496[(9)]);
var inst_47459 = (state_47496[(11)]);
var inst_47473 = (state_47496[(2)]);
var inst_47475 = [];
var inst_47476 = inst_47475.push(inst_47455);
var inst_47451 = inst_47475;
var inst_47452 = inst_47459;
var state_47496__$1 = (function (){var statearr_47527 = state_47496;
(statearr_47527[(14)] = inst_47476);

(statearr_47527[(7)] = inst_47451);

(statearr_47527[(15)] = inst_47473);

(statearr_47527[(8)] = inst_47452);

return statearr_47527;
})();
var statearr_47529_48684 = state_47496__$1;
(statearr_47529_48684[(2)] = null);

(statearr_47529_48684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (16))){
var state_47496__$1 = state_47496;
var statearr_47530_48685 = state_47496__$1;
(statearr_47530_48685[(2)] = null);

(statearr_47530_48685[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (10))){
var inst_47465 = (state_47496[(2)]);
var state_47496__$1 = state_47496;
if(cljs.core.truth_(inst_47465)){
var statearr_47532_48686 = state_47496__$1;
(statearr_47532_48686[(1)] = (11));

} else {
var statearr_47534_48687 = state_47496__$1;
(statearr_47534_48687[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (18))){
var inst_47486 = (state_47496[(2)]);
var state_47496__$1 = state_47496;
var statearr_47535_48691 = state_47496__$1;
(statearr_47535_48691[(2)] = inst_47486);

(statearr_47535_48691[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47497 === (8))){
var inst_47460 = (state_47496[(13)]);
var state_47496__$1 = state_47496;
var statearr_47538_48692 = state_47496__$1;
(statearr_47538_48692[(2)] = inst_47460);

(statearr_47538_48692[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44577__auto__ = null;
var cljs$core$async$state_machine__44577__auto____0 = (function (){
var statearr_47540 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47540[(0)] = cljs$core$async$state_machine__44577__auto__);

(statearr_47540[(1)] = (1));

return statearr_47540;
});
var cljs$core$async$state_machine__44577__auto____1 = (function (state_47496){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_47496);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e47542){var ex__44580__auto__ = e47542;
var statearr_47543_48694 = state_47496;
(statearr_47543_48694[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_47496[(4)]))){
var statearr_47544_48698 = state_47496;
(statearr_47544_48698[(1)] = cljs.core.first((state_47496[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48699 = state_47496;
state_47496 = G__48699;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
cljs$core$async$state_machine__44577__auto__ = function(state_47496){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44577__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44577__auto____1.call(this,state_47496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44577__auto____0;
cljs$core$async$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44577__auto____1;
return cljs$core$async$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_47545 = f__44774__auto__();
(statearr_47545[(6)] = c__44773__auto___48664);

return statearr_47545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
