goog.provide('cljs.source_map');
goog.scope(function(){
  cljs.source_map.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__48673){
var vec__48674 = p__48673;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48674,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48674,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__48681 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48681,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48681,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48681,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48681,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48681,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(cljs.source_map.goog$module$goog$object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5804__auto__)){
var name__$1 = temp__5804__auto__;
return (cljs.source_map.goog$module$goog$object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__48703 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48703,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48703,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48703,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48703,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48703,(4),null);
var vec__48706 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48706,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48706,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48706,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48706,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48706,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__5045__auto__ = source;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__5045__auto__ = line;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__5045__auto__ = col;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__48715 = segmap;
var map__48715__$1 = cljs.core.__destructure_map(map__48715);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48715__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48715__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48715__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48715__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48715__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__48721 = arguments.length;
switch (G__48721) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(cljs.source_map.goog$module$goog$object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__48740 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__50246 = cljs.core.next(segs__$1);
var G__50247 = nrelseg;
var G__50248 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__50246;
relseg__$1 = G__50247;
result__$1 = G__50248;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48740,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48740,(1),null);
var G__50249 = (gline + (1));
var G__50251 = cljs.core.next(lines__$1);
var G__50252 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__50253 = result__$1;
gline = G__50249;
lines__$1 = G__50251;
relseg = G__50252;
result = G__50253;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__48744 = segmap;
var map__48744__$1 = cljs.core.__destructure_map(map__48744);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48744__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48744__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48744__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48744__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48744__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__48743_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__48743_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__48752 = arguments.length;
switch (G__48752) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(cljs.source_map.goog$module$goog$object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__48762 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__50262 = cljs.core.next(segs__$1);
var G__50263 = nrelseg;
var G__50264 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__50262;
relseg__$1 = G__50263;
result__$1 = G__50264;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48762,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48762,(1),null);
var G__50265 = (gline + (1));
var G__50266 = cljs.core.next(lines__$1);
var G__50267 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__50268 = result__$1;
gline = G__50265;
lines__$1 = G__50266;
relseg = G__50267;
result = G__50268;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__48783){
var vec__48784 = p__48783;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48784,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48784,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48784,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48784,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48784,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__48788){
var vec__48795 = p__48788;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48795,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48795,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48795,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48795,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48795,(4),null);
var seg = vec__48795;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__48798){
var vec__48799 = p__48798;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48799,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48799,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48799,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48799,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48799,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5802__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5802__auto__)){
var name = temp__5802__auto__;
var idx = (function (){var temp__5802__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5802__auto____$1)){
var idx = temp__5802__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__48819 = cljs.core.seq(infos);
var chunk__48820 = null;
var count__48821 = (0);
var i__48822 = (0);
while(true){
if((i__48822 < count__48821)){
var info = chunk__48820.cljs$core$IIndexed$_nth$arity$2(null,i__48822);
var segv_50275 = info__GT_segv(info,source_idx,line,col);
var gline_50276 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_50277 = cljs.core.count(cljs.core.deref(lines));
if((gline_50276 > (lc_50277 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__48819,chunk__48820,count__48821,i__48822,segv_50275,gline_50276,lc_50277,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_50276 - (lc_50277 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_50275], null));
});})(seq__48819,chunk__48820,count__48821,i__48822,segv_50275,gline_50276,lc_50277,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__48819,chunk__48820,count__48821,i__48822,segv_50275,gline_50276,lc_50277,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_50276], null),cljs.core.conj,segv_50275);
});})(seq__48819,chunk__48820,count__48821,i__48822,segv_50275,gline_50276,lc_50277,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__50283 = seq__48819;
var G__50284 = chunk__48820;
var G__50285 = count__48821;
var G__50286 = (i__48822 + (1));
seq__48819 = G__50283;
chunk__48820 = G__50284;
count__48821 = G__50285;
i__48822 = G__50286;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__48819);
if(temp__5804__auto__){
var seq__48819__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48819__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__48819__$1);
var G__50287 = cljs.core.chunk_rest(seq__48819__$1);
var G__50288 = c__5568__auto__;
var G__50289 = cljs.core.count(c__5568__auto__);
var G__50290 = (0);
seq__48819 = G__50287;
chunk__48820 = G__50288;
count__48821 = G__50289;
i__48822 = G__50290;
continue;
} else {
var info = cljs.core.first(seq__48819__$1);
var segv_50293 = info__GT_segv(info,source_idx,line,col);
var gline_50294 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_50295 = cljs.core.count(cljs.core.deref(lines));
if((gline_50294 > (lc_50295 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__48819,chunk__48820,count__48821,i__48822,segv_50293,gline_50294,lc_50295,info,seq__48819__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_50294 - (lc_50295 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_50293], null));
});})(seq__48819,chunk__48820,count__48821,i__48822,segv_50293,gline_50294,lc_50295,info,seq__48819__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__48819,chunk__48820,count__48821,i__48822,segv_50293,gline_50294,lc_50295,info,seq__48819__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_50294], null),cljs.core.conj,segv_50293);
});})(seq__48819,chunk__48820,count__48821,i__48822,segv_50293,gline_50294,lc_50295,info,seq__48819__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__50297 = cljs.core.next(seq__48819__$1);
var G__50298 = null;
var G__50299 = (0);
var G__50300 = (0);
seq__48819 = G__50297;
chunk__48820 = G__50298;
count__48821 = G__50299;
i__48822 = G__50300;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__48854_50301 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__48855_50302 = null;
var count__48856_50303 = (0);
var i__48857_50304 = (0);
while(true){
if((i__48857_50304 < count__48856_50303)){
var vec__49279_50306 = chunk__48855_50302.cljs$core$IIndexed$_nth$arity$2(null,i__48857_50304);
var source_idx_50307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49279_50306,(0),null);
var vec__49282_50308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49279_50306,(1),null);
var __50309 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49282_50308,(0),null);
var lines_50310__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49282_50308,(1),null);
var seq__49290_50311 = cljs.core.seq(lines_50310__$1);
var chunk__49291_50312 = null;
var count__49292_50313 = (0);
var i__49293_50314 = (0);
while(true){
if((i__49293_50314 < count__49292_50313)){
var vec__49365_50315 = chunk__49291_50312.cljs$core$IIndexed$_nth$arity$2(null,i__49293_50314);
var line_50316 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49365_50315,(0),null);
var cols_50317 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49365_50315,(1),null);
var seq__49368_50319 = cljs.core.seq(cols_50317);
var chunk__49369_50320 = null;
var count__49370_50321 = (0);
var i__49371_50322 = (0);
while(true){
if((i__49371_50322 < count__49370_50321)){
var vec__49388_50323 = chunk__49369_50320.cljs$core$IIndexed$_nth$arity$2(null,i__49371_50322);
var col_50324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49388_50323,(0),null);
var infos_50325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49388_50323,(1),null);
encode_cols(infos_50325,source_idx_50307,line_50316,col_50324);


var G__50329 = seq__49368_50319;
var G__50330 = chunk__49369_50320;
var G__50331 = count__49370_50321;
var G__50332 = (i__49371_50322 + (1));
seq__49368_50319 = G__50329;
chunk__49369_50320 = G__50330;
count__49370_50321 = G__50331;
i__49371_50322 = G__50332;
continue;
} else {
var temp__5804__auto___50333 = cljs.core.seq(seq__49368_50319);
if(temp__5804__auto___50333){
var seq__49368_50334__$1 = temp__5804__auto___50333;
if(cljs.core.chunked_seq_QMARK_(seq__49368_50334__$1)){
var c__5568__auto___50335 = cljs.core.chunk_first(seq__49368_50334__$1);
var G__50336 = cljs.core.chunk_rest(seq__49368_50334__$1);
var G__50337 = c__5568__auto___50335;
var G__50338 = cljs.core.count(c__5568__auto___50335);
var G__50339 = (0);
seq__49368_50319 = G__50336;
chunk__49369_50320 = G__50337;
count__49370_50321 = G__50338;
i__49371_50322 = G__50339;
continue;
} else {
var vec__49392_50340 = cljs.core.first(seq__49368_50334__$1);
var col_50341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49392_50340,(0),null);
var infos_50342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49392_50340,(1),null);
encode_cols(infos_50342,source_idx_50307,line_50316,col_50341);


var G__50343 = cljs.core.next(seq__49368_50334__$1);
var G__50344 = null;
var G__50345 = (0);
var G__50346 = (0);
seq__49368_50319 = G__50343;
chunk__49369_50320 = G__50344;
count__49370_50321 = G__50345;
i__49371_50322 = G__50346;
continue;
}
} else {
}
}
break;
}


var G__50347 = seq__49290_50311;
var G__50348 = chunk__49291_50312;
var G__50349 = count__49292_50313;
var G__50350 = (i__49293_50314 + (1));
seq__49290_50311 = G__50347;
chunk__49291_50312 = G__50348;
count__49292_50313 = G__50349;
i__49293_50314 = G__50350;
continue;
} else {
var temp__5804__auto___50351 = cljs.core.seq(seq__49290_50311);
if(temp__5804__auto___50351){
var seq__49290_50352__$1 = temp__5804__auto___50351;
if(cljs.core.chunked_seq_QMARK_(seq__49290_50352__$1)){
var c__5568__auto___50354 = cljs.core.chunk_first(seq__49290_50352__$1);
var G__50355 = cljs.core.chunk_rest(seq__49290_50352__$1);
var G__50356 = c__5568__auto___50354;
var G__50357 = cljs.core.count(c__5568__auto___50354);
var G__50358 = (0);
seq__49290_50311 = G__50355;
chunk__49291_50312 = G__50356;
count__49292_50313 = G__50357;
i__49293_50314 = G__50358;
continue;
} else {
var vec__49402_50359 = cljs.core.first(seq__49290_50352__$1);
var line_50360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49402_50359,(0),null);
var cols_50361 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49402_50359,(1),null);
var seq__49405_50362 = cljs.core.seq(cols_50361);
var chunk__49406_50363 = null;
var count__49407_50364 = (0);
var i__49408_50365 = (0);
while(true){
if((i__49408_50365 < count__49407_50364)){
var vec__49423_50366 = chunk__49406_50363.cljs$core$IIndexed$_nth$arity$2(null,i__49408_50365);
var col_50367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49423_50366,(0),null);
var infos_50368 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49423_50366,(1),null);
encode_cols(infos_50368,source_idx_50307,line_50360,col_50367);


var G__50370 = seq__49405_50362;
var G__50371 = chunk__49406_50363;
var G__50372 = count__49407_50364;
var G__50373 = (i__49408_50365 + (1));
seq__49405_50362 = G__50370;
chunk__49406_50363 = G__50371;
count__49407_50364 = G__50372;
i__49408_50365 = G__50373;
continue;
} else {
var temp__5804__auto___50374__$1 = cljs.core.seq(seq__49405_50362);
if(temp__5804__auto___50374__$1){
var seq__49405_50375__$1 = temp__5804__auto___50374__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49405_50375__$1)){
var c__5568__auto___50376 = cljs.core.chunk_first(seq__49405_50375__$1);
var G__50377 = cljs.core.chunk_rest(seq__49405_50375__$1);
var G__50378 = c__5568__auto___50376;
var G__50379 = cljs.core.count(c__5568__auto___50376);
var G__50380 = (0);
seq__49405_50362 = G__50377;
chunk__49406_50363 = G__50378;
count__49407_50364 = G__50379;
i__49408_50365 = G__50380;
continue;
} else {
var vec__49430_50381 = cljs.core.first(seq__49405_50375__$1);
var col_50382 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49430_50381,(0),null);
var infos_50383 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49430_50381,(1),null);
encode_cols(infos_50383,source_idx_50307,line_50360,col_50382);


var G__50387 = cljs.core.next(seq__49405_50375__$1);
var G__50388 = null;
var G__50389 = (0);
var G__50390 = (0);
seq__49405_50362 = G__50387;
chunk__49406_50363 = G__50388;
count__49407_50364 = G__50389;
i__49408_50365 = G__50390;
continue;
}
} else {
}
}
break;
}


var G__50396 = cljs.core.next(seq__49290_50352__$1);
var G__50397 = null;
var G__50398 = (0);
var G__50399 = (0);
seq__49290_50311 = G__50396;
chunk__49291_50312 = G__50397;
count__49292_50313 = G__50398;
i__49293_50314 = G__50399;
continue;
}
} else {
}
}
break;
}


var G__50400 = seq__48854_50301;
var G__50401 = chunk__48855_50302;
var G__50402 = count__48856_50303;
var G__50403 = (i__48857_50304 + (1));
seq__48854_50301 = G__50400;
chunk__48855_50302 = G__50401;
count__48856_50303 = G__50402;
i__48857_50304 = G__50403;
continue;
} else {
var temp__5804__auto___50404 = cljs.core.seq(seq__48854_50301);
if(temp__5804__auto___50404){
var seq__48854_50405__$1 = temp__5804__auto___50404;
if(cljs.core.chunked_seq_QMARK_(seq__48854_50405__$1)){
var c__5568__auto___50406 = cljs.core.chunk_first(seq__48854_50405__$1);
var G__50408 = cljs.core.chunk_rest(seq__48854_50405__$1);
var G__50409 = c__5568__auto___50406;
var G__50410 = cljs.core.count(c__5568__auto___50406);
var G__50411 = (0);
seq__48854_50301 = G__50408;
chunk__48855_50302 = G__50409;
count__48856_50303 = G__50410;
i__48857_50304 = G__50411;
continue;
} else {
var vec__49436_50416 = cljs.core.first(seq__48854_50405__$1);
var source_idx_50417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49436_50416,(0),null);
var vec__49439_50418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49436_50416,(1),null);
var __50419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49439_50418,(0),null);
var lines_50420__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49439_50418,(1),null);
var seq__49442_50425 = cljs.core.seq(lines_50420__$1);
var chunk__49443_50426 = null;
var count__49444_50427 = (0);
var i__49445_50428 = (0);
while(true){
if((i__49445_50428 < count__49444_50427)){
var vec__49631_50433 = chunk__49443_50426.cljs$core$IIndexed$_nth$arity$2(null,i__49445_50428);
var line_50434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49631_50433,(0),null);
var cols_50435 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49631_50433,(1),null);
var seq__49636_50436 = cljs.core.seq(cols_50435);
var chunk__49637_50437 = null;
var count__49638_50438 = (0);
var i__49639_50439 = (0);
while(true){
if((i__49639_50439 < count__49638_50438)){
var vec__49658_50444 = chunk__49637_50437.cljs$core$IIndexed$_nth$arity$2(null,i__49639_50439);
var col_50445 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49658_50444,(0),null);
var infos_50446 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49658_50444,(1),null);
encode_cols(infos_50446,source_idx_50417,line_50434,col_50445);


var G__50452 = seq__49636_50436;
var G__50453 = chunk__49637_50437;
var G__50454 = count__49638_50438;
var G__50455 = (i__49639_50439 + (1));
seq__49636_50436 = G__50452;
chunk__49637_50437 = G__50453;
count__49638_50438 = G__50454;
i__49639_50439 = G__50455;
continue;
} else {
var temp__5804__auto___50458__$1 = cljs.core.seq(seq__49636_50436);
if(temp__5804__auto___50458__$1){
var seq__49636_50460__$1 = temp__5804__auto___50458__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49636_50460__$1)){
var c__5568__auto___50465 = cljs.core.chunk_first(seq__49636_50460__$1);
var G__50469 = cljs.core.chunk_rest(seq__49636_50460__$1);
var G__50470 = c__5568__auto___50465;
var G__50471 = cljs.core.count(c__5568__auto___50465);
var G__50472 = (0);
seq__49636_50436 = G__50469;
chunk__49637_50437 = G__50470;
count__49638_50438 = G__50471;
i__49639_50439 = G__50472;
continue;
} else {
var vec__49661_50478 = cljs.core.first(seq__49636_50460__$1);
var col_50479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49661_50478,(0),null);
var infos_50480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49661_50478,(1),null);
encode_cols(infos_50480,source_idx_50417,line_50434,col_50479);


var G__50483 = cljs.core.next(seq__49636_50460__$1);
var G__50484 = null;
var G__50485 = (0);
var G__50486 = (0);
seq__49636_50436 = G__50483;
chunk__49637_50437 = G__50484;
count__49638_50438 = G__50485;
i__49639_50439 = G__50486;
continue;
}
} else {
}
}
break;
}


var G__50488 = seq__49442_50425;
var G__50489 = chunk__49443_50426;
var G__50490 = count__49444_50427;
var G__50491 = (i__49445_50428 + (1));
seq__49442_50425 = G__50488;
chunk__49443_50426 = G__50489;
count__49444_50427 = G__50490;
i__49445_50428 = G__50491;
continue;
} else {
var temp__5804__auto___50494__$1 = cljs.core.seq(seq__49442_50425);
if(temp__5804__auto___50494__$1){
var seq__49442_50495__$1 = temp__5804__auto___50494__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49442_50495__$1)){
var c__5568__auto___50496 = cljs.core.chunk_first(seq__49442_50495__$1);
var G__50498 = cljs.core.chunk_rest(seq__49442_50495__$1);
var G__50499 = c__5568__auto___50496;
var G__50500 = cljs.core.count(c__5568__auto___50496);
var G__50501 = (0);
seq__49442_50425 = G__50498;
chunk__49443_50426 = G__50499;
count__49444_50427 = G__50500;
i__49445_50428 = G__50501;
continue;
} else {
var vec__49669_50502 = cljs.core.first(seq__49442_50495__$1);
var line_50503 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49669_50502,(0),null);
var cols_50505 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49669_50502,(1),null);
var seq__49672_50510 = cljs.core.seq(cols_50505);
var chunk__49673_50511 = null;
var count__49674_50512 = (0);
var i__49675_50513 = (0);
while(true){
if((i__49675_50513 < count__49674_50512)){
var vec__49685_50515 = chunk__49673_50511.cljs$core$IIndexed$_nth$arity$2(null,i__49675_50513);
var col_50516 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49685_50515,(0),null);
var infos_50517 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49685_50515,(1),null);
encode_cols(infos_50517,source_idx_50417,line_50503,col_50516);


var G__50520 = seq__49672_50510;
var G__50521 = chunk__49673_50511;
var G__50522 = count__49674_50512;
var G__50523 = (i__49675_50513 + (1));
seq__49672_50510 = G__50520;
chunk__49673_50511 = G__50521;
count__49674_50512 = G__50522;
i__49675_50513 = G__50523;
continue;
} else {
var temp__5804__auto___50527__$2 = cljs.core.seq(seq__49672_50510);
if(temp__5804__auto___50527__$2){
var seq__49672_50528__$1 = temp__5804__auto___50527__$2;
if(cljs.core.chunked_seq_QMARK_(seq__49672_50528__$1)){
var c__5568__auto___50529 = cljs.core.chunk_first(seq__49672_50528__$1);
var G__50530 = cljs.core.chunk_rest(seq__49672_50528__$1);
var G__50531 = c__5568__auto___50529;
var G__50532 = cljs.core.count(c__5568__auto___50529);
var G__50533 = (0);
seq__49672_50510 = G__50530;
chunk__49673_50511 = G__50531;
count__49674_50512 = G__50532;
i__49675_50513 = G__50533;
continue;
} else {
var vec__49689_50535 = cljs.core.first(seq__49672_50528__$1);
var col_50536 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49689_50535,(0),null);
var infos_50537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49689_50535,(1),null);
encode_cols(infos_50537,source_idx_50417,line_50503,col_50536);


var G__50538 = cljs.core.next(seq__49672_50528__$1);
var G__50539 = null;
var G__50540 = (0);
var G__50541 = (0);
seq__49672_50510 = G__50538;
chunk__49673_50511 = G__50539;
count__49674_50512 = G__50540;
i__49675_50513 = G__50541;
continue;
}
} else {
}
}
break;
}


var G__50543 = cljs.core.next(seq__49442_50495__$1);
var G__50544 = null;
var G__50545 = (0);
var G__50546 = (0);
seq__49442_50425 = G__50543;
chunk__49443_50426 = G__50544;
count__49444_50427 = G__50545;
i__49445_50428 = G__50546;
continue;
}
} else {
}
}
break;
}


var G__50548 = cljs.core.next(seq__48854_50405__$1);
var G__50549 = null;
var G__50550 = (0);
var G__50551 = (0);
seq__48854_50301 = G__50548;
chunk__48855_50302 = G__50549;
count__48856_50303 = G__50550;
i__48857_50304 = G__50551;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__49692 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__48804_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__48804_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__48805_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__48805_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__48806_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__48806_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__49698 = G__49692;
cljs.source_map.goog$module$goog$object.set(G__49698,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__49698;
} else {
return G__49692;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__49699 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49699,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49699,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__49702 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49702,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49702,(1),null);
var G__50559 = cljs.core.next(col_map_seq);
var G__50560 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__49702,col,infos,vec__49699,line,col_map){
return (function (v,p__49706){
var map__49710 = p__49706;
var map__49710__$1 = cljs.core.__destructure_map(map__49710);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49710__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49710__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__49702,col,infos,vec__49699,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__50559;
new_cols = G__50560;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__50566 = cljs.core.next(line_map_seq);
var G__50567 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__50566;
new_lines = G__50567;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__49715_50568 = cljs.core.seq(reverse_map);
var chunk__49716_50569 = null;
var count__49717_50570 = (0);
var i__49718_50571 = (0);
while(true){
if((i__49718_50571 < count__49717_50570)){
var vec__49942_50573 = chunk__49716_50569.cljs$core$IIndexed$_nth$arity$2(null,i__49718_50571);
var line_50574 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49942_50573,(0),null);
var columns_50575 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49942_50573,(1),null);
var seq__49945_50578 = cljs.core.seq(columns_50575);
var chunk__49946_50579 = null;
var count__49947_50580 = (0);
var i__49948_50581 = (0);
while(true){
if((i__49948_50581 < count__49947_50580)){
var vec__50000_50582 = chunk__49946_50579.cljs$core$IIndexed$_nth$arity$2(null,i__49948_50581);
var column_50583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50000_50582,(0),null);
var column_info_50584 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50000_50582,(1),null);
var seq__50003_50591 = cljs.core.seq(column_info_50584);
var chunk__50004_50592 = null;
var count__50005_50593 = (0);
var i__50006_50594 = (0);
while(true){
if((i__50006_50594 < count__50005_50593)){
var map__50022_50599 = chunk__50004_50592.cljs$core$IIndexed$_nth$arity$2(null,i__50006_50594);
var map__50022_50600__$1 = cljs.core.__destructure_map(map__50022_50599);
var gline_50601 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50022_50600__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_50602 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50022_50600__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_50603 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50022_50600__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_50601], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__50003_50591,chunk__50004_50592,count__50005_50593,i__50006_50594,seq__49945_50578,chunk__49946_50579,count__49947_50580,i__49948_50581,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50022_50599,map__50022_50600__$1,gline_50601,gcol_50602,name_50603,vec__50000_50582,column_50583,column_info_50584,vec__49942_50573,line_50574,columns_50575,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_50602], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_50574,new cljs.core.Keyword(null,"col","col",-1959363084),column_50583,new cljs.core.Keyword(null,"name","name",1843675177),name_50603], null));
});})(seq__50003_50591,chunk__50004_50592,count__50005_50593,i__50006_50594,seq__49945_50578,chunk__49946_50579,count__49947_50580,i__49948_50581,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50022_50599,map__50022_50600__$1,gline_50601,gcol_50602,name_50603,vec__50000_50582,column_50583,column_info_50584,vec__49942_50573,line_50574,columns_50575,inverted))
,cljs.core.sorted_map()));


var G__50619 = seq__50003_50591;
var G__50620 = chunk__50004_50592;
var G__50621 = count__50005_50593;
var G__50622 = (i__50006_50594 + (1));
seq__50003_50591 = G__50619;
chunk__50004_50592 = G__50620;
count__50005_50593 = G__50621;
i__50006_50594 = G__50622;
continue;
} else {
var temp__5804__auto___50623 = cljs.core.seq(seq__50003_50591);
if(temp__5804__auto___50623){
var seq__50003_50624__$1 = temp__5804__auto___50623;
if(cljs.core.chunked_seq_QMARK_(seq__50003_50624__$1)){
var c__5568__auto___50625 = cljs.core.chunk_first(seq__50003_50624__$1);
var G__50626 = cljs.core.chunk_rest(seq__50003_50624__$1);
var G__50627 = c__5568__auto___50625;
var G__50628 = cljs.core.count(c__5568__auto___50625);
var G__50629 = (0);
seq__50003_50591 = G__50626;
chunk__50004_50592 = G__50627;
count__50005_50593 = G__50628;
i__50006_50594 = G__50629;
continue;
} else {
var map__50025_50630 = cljs.core.first(seq__50003_50624__$1);
var map__50025_50631__$1 = cljs.core.__destructure_map(map__50025_50630);
var gline_50632 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50025_50631__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_50633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50025_50631__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_50634 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50025_50631__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_50632], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__50003_50591,chunk__50004_50592,count__50005_50593,i__50006_50594,seq__49945_50578,chunk__49946_50579,count__49947_50580,i__49948_50581,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50025_50630,map__50025_50631__$1,gline_50632,gcol_50633,name_50634,seq__50003_50624__$1,temp__5804__auto___50623,vec__50000_50582,column_50583,column_info_50584,vec__49942_50573,line_50574,columns_50575,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_50633], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_50574,new cljs.core.Keyword(null,"col","col",-1959363084),column_50583,new cljs.core.Keyword(null,"name","name",1843675177),name_50634], null));
});})(seq__50003_50591,chunk__50004_50592,count__50005_50593,i__50006_50594,seq__49945_50578,chunk__49946_50579,count__49947_50580,i__49948_50581,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50025_50630,map__50025_50631__$1,gline_50632,gcol_50633,name_50634,seq__50003_50624__$1,temp__5804__auto___50623,vec__50000_50582,column_50583,column_info_50584,vec__49942_50573,line_50574,columns_50575,inverted))
,cljs.core.sorted_map()));


var G__50638 = cljs.core.next(seq__50003_50624__$1);
var G__50639 = null;
var G__50640 = (0);
var G__50641 = (0);
seq__50003_50591 = G__50638;
chunk__50004_50592 = G__50639;
count__50005_50593 = G__50640;
i__50006_50594 = G__50641;
continue;
}
} else {
}
}
break;
}


var G__50642 = seq__49945_50578;
var G__50643 = chunk__49946_50579;
var G__50644 = count__49947_50580;
var G__50645 = (i__49948_50581 + (1));
seq__49945_50578 = G__50642;
chunk__49946_50579 = G__50643;
count__49947_50580 = G__50644;
i__49948_50581 = G__50645;
continue;
} else {
var temp__5804__auto___50646 = cljs.core.seq(seq__49945_50578);
if(temp__5804__auto___50646){
var seq__49945_50649__$1 = temp__5804__auto___50646;
if(cljs.core.chunked_seq_QMARK_(seq__49945_50649__$1)){
var c__5568__auto___50650 = cljs.core.chunk_first(seq__49945_50649__$1);
var G__50651 = cljs.core.chunk_rest(seq__49945_50649__$1);
var G__50652 = c__5568__auto___50650;
var G__50653 = cljs.core.count(c__5568__auto___50650);
var G__50654 = (0);
seq__49945_50578 = G__50651;
chunk__49946_50579 = G__50652;
count__49947_50580 = G__50653;
i__49948_50581 = G__50654;
continue;
} else {
var vec__50034_50655 = cljs.core.first(seq__49945_50649__$1);
var column_50656 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50034_50655,(0),null);
var column_info_50657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50034_50655,(1),null);
var seq__50037_50659 = cljs.core.seq(column_info_50657);
var chunk__50038_50660 = null;
var count__50039_50662 = (0);
var i__50040_50663 = (0);
while(true){
if((i__50040_50663 < count__50039_50662)){
var map__50052_50665 = chunk__50038_50660.cljs$core$IIndexed$_nth$arity$2(null,i__50040_50663);
var map__50052_50666__$1 = cljs.core.__destructure_map(map__50052_50665);
var gline_50667 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50052_50666__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_50668 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50052_50666__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_50669 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50052_50666__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_50667], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__50037_50659,chunk__50038_50660,count__50039_50662,i__50040_50663,seq__49945_50578,chunk__49946_50579,count__49947_50580,i__49948_50581,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50052_50665,map__50052_50666__$1,gline_50667,gcol_50668,name_50669,vec__50034_50655,column_50656,column_info_50657,seq__49945_50649__$1,temp__5804__auto___50646,vec__49942_50573,line_50574,columns_50575,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_50668], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_50574,new cljs.core.Keyword(null,"col","col",-1959363084),column_50656,new cljs.core.Keyword(null,"name","name",1843675177),name_50669], null));
});})(seq__50037_50659,chunk__50038_50660,count__50039_50662,i__50040_50663,seq__49945_50578,chunk__49946_50579,count__49947_50580,i__49948_50581,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50052_50665,map__50052_50666__$1,gline_50667,gcol_50668,name_50669,vec__50034_50655,column_50656,column_info_50657,seq__49945_50649__$1,temp__5804__auto___50646,vec__49942_50573,line_50574,columns_50575,inverted))
,cljs.core.sorted_map()));


var G__50671 = seq__50037_50659;
var G__50672 = chunk__50038_50660;
var G__50673 = count__50039_50662;
var G__50674 = (i__50040_50663 + (1));
seq__50037_50659 = G__50671;
chunk__50038_50660 = G__50672;
count__50039_50662 = G__50673;
i__50040_50663 = G__50674;
continue;
} else {
var temp__5804__auto___50675__$1 = cljs.core.seq(seq__50037_50659);
if(temp__5804__auto___50675__$1){
var seq__50037_50677__$1 = temp__5804__auto___50675__$1;
if(cljs.core.chunked_seq_QMARK_(seq__50037_50677__$1)){
var c__5568__auto___50679 = cljs.core.chunk_first(seq__50037_50677__$1);
var G__50680 = cljs.core.chunk_rest(seq__50037_50677__$1);
var G__50681 = c__5568__auto___50679;
var G__50682 = cljs.core.count(c__5568__auto___50679);
var G__50683 = (0);
seq__50037_50659 = G__50680;
chunk__50038_50660 = G__50681;
count__50039_50662 = G__50682;
i__50040_50663 = G__50683;
continue;
} else {
var map__50057_50684 = cljs.core.first(seq__50037_50677__$1);
var map__50057_50685__$1 = cljs.core.__destructure_map(map__50057_50684);
var gline_50686 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50057_50685__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_50687 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50057_50685__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_50688 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50057_50685__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_50686], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__50037_50659,chunk__50038_50660,count__50039_50662,i__50040_50663,seq__49945_50578,chunk__49946_50579,count__49947_50580,i__49948_50581,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50057_50684,map__50057_50685__$1,gline_50686,gcol_50687,name_50688,seq__50037_50677__$1,temp__5804__auto___50675__$1,vec__50034_50655,column_50656,column_info_50657,seq__49945_50649__$1,temp__5804__auto___50646,vec__49942_50573,line_50574,columns_50575,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_50687], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_50574,new cljs.core.Keyword(null,"col","col",-1959363084),column_50656,new cljs.core.Keyword(null,"name","name",1843675177),name_50688], null));
});})(seq__50037_50659,chunk__50038_50660,count__50039_50662,i__50040_50663,seq__49945_50578,chunk__49946_50579,count__49947_50580,i__49948_50581,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50057_50684,map__50057_50685__$1,gline_50686,gcol_50687,name_50688,seq__50037_50677__$1,temp__5804__auto___50675__$1,vec__50034_50655,column_50656,column_info_50657,seq__49945_50649__$1,temp__5804__auto___50646,vec__49942_50573,line_50574,columns_50575,inverted))
,cljs.core.sorted_map()));


var G__50694 = cljs.core.next(seq__50037_50677__$1);
var G__50695 = null;
var G__50696 = (0);
var G__50697 = (0);
seq__50037_50659 = G__50694;
chunk__50038_50660 = G__50695;
count__50039_50662 = G__50696;
i__50040_50663 = G__50697;
continue;
}
} else {
}
}
break;
}


var G__50698 = cljs.core.next(seq__49945_50649__$1);
var G__50699 = null;
var G__50700 = (0);
var G__50701 = (0);
seq__49945_50578 = G__50698;
chunk__49946_50579 = G__50699;
count__49947_50580 = G__50700;
i__49948_50581 = G__50701;
continue;
}
} else {
}
}
break;
}


var G__50702 = seq__49715_50568;
var G__50703 = chunk__49716_50569;
var G__50704 = count__49717_50570;
var G__50705 = (i__49718_50571 + (1));
seq__49715_50568 = G__50702;
chunk__49716_50569 = G__50703;
count__49717_50570 = G__50704;
i__49718_50571 = G__50705;
continue;
} else {
var temp__5804__auto___50706 = cljs.core.seq(seq__49715_50568);
if(temp__5804__auto___50706){
var seq__49715_50707__$1 = temp__5804__auto___50706;
if(cljs.core.chunked_seq_QMARK_(seq__49715_50707__$1)){
var c__5568__auto___50708 = cljs.core.chunk_first(seq__49715_50707__$1);
var G__50710 = cljs.core.chunk_rest(seq__49715_50707__$1);
var G__50711 = c__5568__auto___50708;
var G__50712 = cljs.core.count(c__5568__auto___50708);
var G__50713 = (0);
seq__49715_50568 = G__50710;
chunk__49716_50569 = G__50711;
count__49717_50570 = G__50712;
i__49718_50571 = G__50713;
continue;
} else {
var vec__50060_50714 = cljs.core.first(seq__49715_50707__$1);
var line_50715 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50060_50714,(0),null);
var columns_50716 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50060_50714,(1),null);
var seq__50063_50717 = cljs.core.seq(columns_50716);
var chunk__50064_50718 = null;
var count__50065_50719 = (0);
var i__50066_50720 = (0);
while(true){
if((i__50066_50720 < count__50065_50719)){
var vec__50123_50721 = chunk__50064_50718.cljs$core$IIndexed$_nth$arity$2(null,i__50066_50720);
var column_50722 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50123_50721,(0),null);
var column_info_50723 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50123_50721,(1),null);
var seq__50126_50727 = cljs.core.seq(column_info_50723);
var chunk__50127_50728 = null;
var count__50128_50729 = (0);
var i__50129_50730 = (0);
while(true){
if((i__50129_50730 < count__50128_50729)){
var map__50143_50732 = chunk__50127_50728.cljs$core$IIndexed$_nth$arity$2(null,i__50129_50730);
var map__50143_50733__$1 = cljs.core.__destructure_map(map__50143_50732);
var gline_50734 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50143_50733__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_50735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50143_50733__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_50736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50143_50733__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_50734], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__50126_50727,chunk__50127_50728,count__50128_50729,i__50129_50730,seq__50063_50717,chunk__50064_50718,count__50065_50719,i__50066_50720,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50143_50732,map__50143_50733__$1,gline_50734,gcol_50735,name_50736,vec__50123_50721,column_50722,column_info_50723,vec__50060_50714,line_50715,columns_50716,seq__49715_50707__$1,temp__5804__auto___50706,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_50735], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_50715,new cljs.core.Keyword(null,"col","col",-1959363084),column_50722,new cljs.core.Keyword(null,"name","name",1843675177),name_50736], null));
});})(seq__50126_50727,chunk__50127_50728,count__50128_50729,i__50129_50730,seq__50063_50717,chunk__50064_50718,count__50065_50719,i__50066_50720,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50143_50732,map__50143_50733__$1,gline_50734,gcol_50735,name_50736,vec__50123_50721,column_50722,column_info_50723,vec__50060_50714,line_50715,columns_50716,seq__49715_50707__$1,temp__5804__auto___50706,inverted))
,cljs.core.sorted_map()));


var G__50743 = seq__50126_50727;
var G__50744 = chunk__50127_50728;
var G__50745 = count__50128_50729;
var G__50746 = (i__50129_50730 + (1));
seq__50126_50727 = G__50743;
chunk__50127_50728 = G__50744;
count__50128_50729 = G__50745;
i__50129_50730 = G__50746;
continue;
} else {
var temp__5804__auto___50747__$1 = cljs.core.seq(seq__50126_50727);
if(temp__5804__auto___50747__$1){
var seq__50126_50748__$1 = temp__5804__auto___50747__$1;
if(cljs.core.chunked_seq_QMARK_(seq__50126_50748__$1)){
var c__5568__auto___50749 = cljs.core.chunk_first(seq__50126_50748__$1);
var G__50750 = cljs.core.chunk_rest(seq__50126_50748__$1);
var G__50751 = c__5568__auto___50749;
var G__50752 = cljs.core.count(c__5568__auto___50749);
var G__50753 = (0);
seq__50126_50727 = G__50750;
chunk__50127_50728 = G__50751;
count__50128_50729 = G__50752;
i__50129_50730 = G__50753;
continue;
} else {
var map__50148_50756 = cljs.core.first(seq__50126_50748__$1);
var map__50148_50757__$1 = cljs.core.__destructure_map(map__50148_50756);
var gline_50758 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50148_50757__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_50759 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50148_50757__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_50760 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50148_50757__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_50758], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__50126_50727,chunk__50127_50728,count__50128_50729,i__50129_50730,seq__50063_50717,chunk__50064_50718,count__50065_50719,i__50066_50720,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50148_50756,map__50148_50757__$1,gline_50758,gcol_50759,name_50760,seq__50126_50748__$1,temp__5804__auto___50747__$1,vec__50123_50721,column_50722,column_info_50723,vec__50060_50714,line_50715,columns_50716,seq__49715_50707__$1,temp__5804__auto___50706,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_50759], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_50715,new cljs.core.Keyword(null,"col","col",-1959363084),column_50722,new cljs.core.Keyword(null,"name","name",1843675177),name_50760], null));
});})(seq__50126_50727,chunk__50127_50728,count__50128_50729,i__50129_50730,seq__50063_50717,chunk__50064_50718,count__50065_50719,i__50066_50720,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50148_50756,map__50148_50757__$1,gline_50758,gcol_50759,name_50760,seq__50126_50748__$1,temp__5804__auto___50747__$1,vec__50123_50721,column_50722,column_info_50723,vec__50060_50714,line_50715,columns_50716,seq__49715_50707__$1,temp__5804__auto___50706,inverted))
,cljs.core.sorted_map()));


var G__50768 = cljs.core.next(seq__50126_50748__$1);
var G__50769 = null;
var G__50770 = (0);
var G__50771 = (0);
seq__50126_50727 = G__50768;
chunk__50127_50728 = G__50769;
count__50128_50729 = G__50770;
i__50129_50730 = G__50771;
continue;
}
} else {
}
}
break;
}


var G__50772 = seq__50063_50717;
var G__50773 = chunk__50064_50718;
var G__50774 = count__50065_50719;
var G__50775 = (i__50066_50720 + (1));
seq__50063_50717 = G__50772;
chunk__50064_50718 = G__50773;
count__50065_50719 = G__50774;
i__50066_50720 = G__50775;
continue;
} else {
var temp__5804__auto___50776__$1 = cljs.core.seq(seq__50063_50717);
if(temp__5804__auto___50776__$1){
var seq__50063_50777__$1 = temp__5804__auto___50776__$1;
if(cljs.core.chunked_seq_QMARK_(seq__50063_50777__$1)){
var c__5568__auto___50778 = cljs.core.chunk_first(seq__50063_50777__$1);
var G__50779 = cljs.core.chunk_rest(seq__50063_50777__$1);
var G__50780 = c__5568__auto___50778;
var G__50781 = cljs.core.count(c__5568__auto___50778);
var G__50782 = (0);
seq__50063_50717 = G__50779;
chunk__50064_50718 = G__50780;
count__50065_50719 = G__50781;
i__50066_50720 = G__50782;
continue;
} else {
var vec__50149_50783 = cljs.core.first(seq__50063_50777__$1);
var column_50784 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50149_50783,(0),null);
var column_info_50785 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50149_50783,(1),null);
var seq__50152_50788 = cljs.core.seq(column_info_50785);
var chunk__50153_50789 = null;
var count__50154_50790 = (0);
var i__50155_50791 = (0);
while(true){
if((i__50155_50791 < count__50154_50790)){
var map__50164_50792 = chunk__50153_50789.cljs$core$IIndexed$_nth$arity$2(null,i__50155_50791);
var map__50164_50793__$1 = cljs.core.__destructure_map(map__50164_50792);
var gline_50794 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50164_50793__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_50795 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50164_50793__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_50796 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50164_50793__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_50794], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__50152_50788,chunk__50153_50789,count__50154_50790,i__50155_50791,seq__50063_50717,chunk__50064_50718,count__50065_50719,i__50066_50720,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50164_50792,map__50164_50793__$1,gline_50794,gcol_50795,name_50796,vec__50149_50783,column_50784,column_info_50785,seq__50063_50777__$1,temp__5804__auto___50776__$1,vec__50060_50714,line_50715,columns_50716,seq__49715_50707__$1,temp__5804__auto___50706,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_50795], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_50715,new cljs.core.Keyword(null,"col","col",-1959363084),column_50784,new cljs.core.Keyword(null,"name","name",1843675177),name_50796], null));
});})(seq__50152_50788,chunk__50153_50789,count__50154_50790,i__50155_50791,seq__50063_50717,chunk__50064_50718,count__50065_50719,i__50066_50720,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50164_50792,map__50164_50793__$1,gline_50794,gcol_50795,name_50796,vec__50149_50783,column_50784,column_info_50785,seq__50063_50777__$1,temp__5804__auto___50776__$1,vec__50060_50714,line_50715,columns_50716,seq__49715_50707__$1,temp__5804__auto___50706,inverted))
,cljs.core.sorted_map()));


var G__50803 = seq__50152_50788;
var G__50804 = chunk__50153_50789;
var G__50805 = count__50154_50790;
var G__50806 = (i__50155_50791 + (1));
seq__50152_50788 = G__50803;
chunk__50153_50789 = G__50804;
count__50154_50790 = G__50805;
i__50155_50791 = G__50806;
continue;
} else {
var temp__5804__auto___50807__$2 = cljs.core.seq(seq__50152_50788);
if(temp__5804__auto___50807__$2){
var seq__50152_50808__$1 = temp__5804__auto___50807__$2;
if(cljs.core.chunked_seq_QMARK_(seq__50152_50808__$1)){
var c__5568__auto___50809 = cljs.core.chunk_first(seq__50152_50808__$1);
var G__50810 = cljs.core.chunk_rest(seq__50152_50808__$1);
var G__50811 = c__5568__auto___50809;
var G__50812 = cljs.core.count(c__5568__auto___50809);
var G__50813 = (0);
seq__50152_50788 = G__50810;
chunk__50153_50789 = G__50811;
count__50154_50790 = G__50812;
i__50155_50791 = G__50813;
continue;
} else {
var map__50181_50814 = cljs.core.first(seq__50152_50808__$1);
var map__50181_50815__$1 = cljs.core.__destructure_map(map__50181_50814);
var gline_50816 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50181_50815__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_50817 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50181_50815__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_50818 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50181_50815__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_50816], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__50152_50788,chunk__50153_50789,count__50154_50790,i__50155_50791,seq__50063_50717,chunk__50064_50718,count__50065_50719,i__50066_50720,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50181_50814,map__50181_50815__$1,gline_50816,gcol_50817,name_50818,seq__50152_50808__$1,temp__5804__auto___50807__$2,vec__50149_50783,column_50784,column_info_50785,seq__50063_50777__$1,temp__5804__auto___50776__$1,vec__50060_50714,line_50715,columns_50716,seq__49715_50707__$1,temp__5804__auto___50706,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_50817], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_50715,new cljs.core.Keyword(null,"col","col",-1959363084),column_50784,new cljs.core.Keyword(null,"name","name",1843675177),name_50818], null));
});})(seq__50152_50788,chunk__50153_50789,count__50154_50790,i__50155_50791,seq__50063_50717,chunk__50064_50718,count__50065_50719,i__50066_50720,seq__49715_50568,chunk__49716_50569,count__49717_50570,i__49718_50571,map__50181_50814,map__50181_50815__$1,gline_50816,gcol_50817,name_50818,seq__50152_50808__$1,temp__5804__auto___50807__$2,vec__50149_50783,column_50784,column_info_50785,seq__50063_50777__$1,temp__5804__auto___50776__$1,vec__50060_50714,line_50715,columns_50716,seq__49715_50707__$1,temp__5804__auto___50706,inverted))
,cljs.core.sorted_map()));


var G__50835 = cljs.core.next(seq__50152_50808__$1);
var G__50836 = null;
var G__50837 = (0);
var G__50838 = (0);
seq__50152_50788 = G__50835;
chunk__50153_50789 = G__50836;
count__50154_50790 = G__50837;
i__50155_50791 = G__50838;
continue;
}
} else {
}
}
break;
}


var G__50843 = cljs.core.next(seq__50063_50777__$1);
var G__50844 = null;
var G__50845 = (0);
var G__50846 = (0);
seq__50063_50717 = G__50843;
chunk__50064_50718 = G__50844;
count__50065_50719 = G__50845;
i__50066_50720 = G__50846;
continue;
}
} else {
}
}
break;
}


var G__50848 = cljs.core.next(seq__49715_50707__$1);
var G__50849 = null;
var G__50850 = (0);
var G__50851 = (0);
seq__49715_50568 = G__50848;
chunk__49716_50569 = G__50849;
count__49717_50570 = G__50850;
i__49718_50571 = G__50851;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});

//# sourceMappingURL=cljs.source_map.js.map
