goog.provide('re_com.multi_select');
/**
 * Split a list of maps by a group key then return both the group
 */
re_com.multi_select.items_with_group_headings = (function re_com$multi_select$items_with_group_headings(items,group_fn,id_fn){
var groups = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(group_fn,items);
var group_headers = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__55748_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"group","group",582596132)],[new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(group_fn.cljs$core$IFn$_invoke$arity$1 ? group_fn.cljs$core$IFn$_invoke$arity$1(p1__55748_SHARP_) : group_fn.call(null,p1__55748_SHARP_)),(id_fn.cljs$core$IFn$_invoke$arity$1 ? id_fn.cljs$core$IFn$_invoke$arity$1(p1__55748_SHARP_) : id_fn.call(null,p1__55748_SHARP_))], null),(group_fn.cljs$core$IFn$_invoke$arity$1 ? group_fn.cljs$core$IFn$_invoke$arity$1(p1__55748_SHARP_) : group_fn.call(null,p1__55748_SHARP_))]);
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,groups));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [group_headers,groups], null);
});
/**
 * Filter a list of items based on a filter string using plain string searches (case insensitive). Less powerful
 * than regex's but no confusion with reserved characters
 */
re_com.multi_select.filter_items = (function re_com$multi_select$filter_items(group_fn,label_fn,filter_text){
var lower_filter_text = clojure.string.lower_case(filter_text);
return (function (item){
var group = (function (){var or__5045__auto__ = (group_fn.cljs$core$IFn$_invoke$arity$1 ? group_fn.cljs$core$IFn$_invoke$arity$1(item) : group_fn.call(null,item));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "";
}
})();
var label = cljs.core.str.cljs$core$IFn$_invoke$arity$1((label_fn.cljs$core$IFn$_invoke$arity$1 ? label_fn.cljs$core$IFn$_invoke$arity$1(item) : label_fn.call(null,item)));
return ((clojure.string.includes_QMARK_(clojure.string.lower_case(group),lower_filter_text)) || (clojure.string.includes_QMARK_(clojure.string.lower_case(label),lower_filter_text)));
});
});
/**
 * Filter a list of items based on a filter string using regex's (case insensitive). More powerful but can cause
 * confusion for users entering reserved characters such as [ ] * + . ( ) etc.
 */
re_com.multi_select.filter_items_regex = (function re_com$multi_select$filter_items_regex(group_fn,label_fn,filter_text){
var re = (function (){try{return (new RegExp(filter_text,"i"));
}catch (e55779){if((e55779 instanceof Object)){
var e = e55779;
return null;
} else {
throw e55779;

}
}})();
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((function (re__$1,item){
if((re__$1 == null)){
return null;
} else {
var or__5045__auto__ = re__$1.test((group_fn.cljs$core$IFn$_invoke$arity$1 ? group_fn.cljs$core$IFn$_invoke$arity$1(item) : group_fn.call(null,item)));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return re__$1.test((label_fn.cljs$core$IFn$_invoke$arity$1 ? label_fn.cljs$core$IFn$_invoke$arity$1(item) : label_fn.call(null,item)));
}
}
}),re);
});
/**
 * Base function (before lifecycle metadata) to render a filter text box
 */
re_com.multi_select.filter_text_box = (function re_com$multi_select$filter_text_box(_STAR_filter_text,placeholder,_STAR_warning_message,disabled_QMARK_,parts){
return new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.h_box,new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-filter-text-box ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter-text-box","filter-text-box",-1298637056),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter-text-box","filter-text-box",-1298637056),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"width","width",-384071477),"100%",new cljs.core.Keyword(null,"align","align",1964212802),new cljs.core.Keyword(null,"center","center",-748944368),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"position","position",-2011731912),"relative"], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter-text-box","filter-text-box",-1298637056),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0)),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.input_text.input_text,new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-filter-input-text ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter-input-text","filter-input-text",-717594502),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"model","model",331153215),_STAR_filter_text,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),false,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),placeholder,new cljs.core.Keyword(null,"width","width",-384071477),"100%",new cljs.core.Keyword(null,"height","height",1025178622),"28px",new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"padding","padding",1660304693),"3px 4px"], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter-input-text","filter-input-text",-717594502),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter-input-text","filter-input-text",-717594502),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (p1__55783_SHARP_){
cljs.core.reset_BANG_(_STAR_filter_text,p1__55783_SHARP_);

return cljs.core.reset_BANG_(_STAR_warning_message,null);
})], null),new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.close_button.close_button,new cljs.core.Keyword(null,"class","class",-2030961996),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter-reset-button","filter-reset-button",1821484060),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter-reset-button","filter-reset-button",1821484060),new cljs.core.Keyword(null,"style","style",-496642736)], null)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter-reset-button","filter-reset-button",1821484060),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return cljs.core.reset_BANG_(_STAR_filter_text,"");
}),new cljs.core.Keyword(null,"div-size","div-size",1661625995),(0),new cljs.core.Keyword(null,"font-size","font-size",-1847940346),(20),new cljs.core.Keyword(null,"left-offset","left-offset",-331155643),(-13)], null)], null)], null);
});
/**
 * Render a group heading and set up appropriate mouse events
 */
re_com.multi_select.group_heading_item = (function re_com$multi_select$group_heading_item(){
var _STAR_mouse_over_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return (function() { 
var re_com$multi_select$group_heading_item_$_group_heading_render__delegate = function (p__55814){
var map__55815 = p__55814;
var map__55815__$1 = cljs.core.__destructure_map(map__55815);
var heading = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55815__$1,new cljs.core.Keyword(null,"heading","heading",-1312171873));
var disabled_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55815__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var click_callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55815__$1,new cljs.core.Keyword(null,"click-callback","click-callback",-609722293));
var double_click_callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55815__$1,new cljs.core.Keyword(null,"double-click-callback","double-click-callback",-1057568442));
var selected_item_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55815__$1,new cljs.core.Keyword(null,"selected-item-id","selected-item-id",180338113));
var id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(heading);
var selected_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected_item_id,id);
var class$ = ((selected_QMARK_)?"highlighted":(cljs.core.truth_(cljs.core.deref(_STAR_mouse_over_QMARK_))?"mouseover":null));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.group-result","li.group-result",1074686727),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"class","class",-2030961996),class$,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"padding-left","padding-left",-1180879053),"6px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),(cljs.core.truth_(disabled_QMARK_)?null:"pointer"),new cljs.core.Keyword(null,"color","color",1011675173),((selected_QMARK_)?"white":"#444")], null),(cljs.core.truth_(disabled_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pointer-events","pointer-events",-1053858853),"none"], null):null)], 0)),new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),(function (event){
cljs.core.reset_BANG_(_STAR_mouse_over_QMARK_,true);

return null;
}),new cljs.core.Keyword(null,"on-mouse-out","on-mouse-out",643448647),(function (event){
cljs.core.reset_BANG_(_STAR_mouse_over_QMARK_,false);

return null;
}),new cljs.core.Keyword(null,"on-click","on-click",1632826543),(cljs.core.truth_(disabled_QMARK_)?null:(function (event){
(click_callback.cljs$core$IFn$_invoke$arity$2 ? click_callback.cljs$core$IFn$_invoke$arity$2(id,true) : click_callback.call(null,id,true));

return null;
})),new cljs.core.Keyword(null,"on-double-click","on-double-click",1434856980),(cljs.core.truth_(disabled_QMARK_)?null:(function (event){
(double_click_callback.cljs$core$IFn$_invoke$arity$1 ? double_click_callback.cljs$core$IFn$_invoke$arity$1(id) : double_click_callback.call(null,id));

return null;
}))], null),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(heading)], null);
};
var re_com$multi_select$group_heading_item_$_group_heading_render = function (var_args){
var p__55814 = null;
if (arguments.length > 0) {
var G__56740__i = 0, G__56740__a = new Array(arguments.length -  0);
while (G__56740__i < G__56740__a.length) {G__56740__a[G__56740__i] = arguments[G__56740__i + 0]; ++G__56740__i;}
  p__55814 = new cljs.core.IndexedSeq(G__56740__a,0,null);
} 
return re_com$multi_select$group_heading_item_$_group_heading_render__delegate.call(this,p__55814);};
re_com$multi_select$group_heading_item_$_group_heading_render.cljs$lang$maxFixedArity = 0;
re_com$multi_select$group_heading_item_$_group_heading_render.cljs$lang$applyTo = (function (arglist__56742){
var p__55814 = cljs.core.seq(arglist__56742);
return re_com$multi_select$group_heading_item_$_group_heading_render__delegate(p__55814);
});
re_com$multi_select$group_heading_item_$_group_heading_render.cljs$core$IFn$_invoke$arity$variadic = re_com$multi_select$group_heading_item_$_group_heading_render__delegate;
return re_com$multi_select$group_heading_item_$_group_heading_render;
})()
;
});
/**
 * Render a list item and set up appropriate mouse events
 */
re_com.multi_select.list_item = (function re_com$multi_select$list_item(){
var _STAR_mouse_over_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return (function() { 
var re_com$multi_select$list_item_$_list_item_render__delegate = function (p__55863){
var map__55864 = p__55863;
var map__55864__$1 = cljs.core.__destructure_map(map__55864);
var item = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55864__$1,new cljs.core.Keyword(null,"item","item",249373802));
var id_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55864__$1,new cljs.core.Keyword(null,"id-fn","id-fn",316222798));
var label_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55864__$1,new cljs.core.Keyword(null,"label-fn","label-fn",-860923263));
var disabled_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55864__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var click_callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55864__$1,new cljs.core.Keyword(null,"click-callback","click-callback",-609722293));
var double_click_callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55864__$1,new cljs.core.Keyword(null,"double-click-callback","double-click-callback",-1057568442));
var selected_item_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55864__$1,new cljs.core.Keyword(null,"selected-item-id","selected-item-id",180338113));
var group_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55864__$1,new cljs.core.Keyword(null,"group-selected?","group-selected?",-1959240379));
var id = (id_fn.cljs$core$IFn$_invoke$arity$1 ? id_fn.cljs$core$IFn$_invoke$arity$1(item) : id_fn.call(null,item));
var selected_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,selected_item_id);
var class$ = ((((selected_QMARK_) && (cljs.core.not(disabled_QMARK_))))?"highlighted":(cljs.core.truth_(cljs.core.deref(_STAR_mouse_over_QMARK_))?"mouseover":null));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"class","class",-2030961996),["active-result group-option ",class$].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(cljs.core.truth_(group_selected_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"hsl(208, 56%, 92%)"], null):null),(cljs.core.truth_(disabled_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),"default",new cljs.core.Keyword(null,"pointer-events","pointer-events",-1053858853),"none"], null):null)], 0)),new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),(function (event){
cljs.core.reset_BANG_(_STAR_mouse_over_QMARK_,true);

return null;
}),new cljs.core.Keyword(null,"on-mouse-out","on-mouse-out",643448647),(function (event){
cljs.core.reset_BANG_(_STAR_mouse_over_QMARK_,false);

return null;
}),new cljs.core.Keyword(null,"on-click","on-click",1632826543),(cljs.core.truth_(disabled_QMARK_)?null:(function (event){
(click_callback.cljs$core$IFn$_invoke$arity$2 ? click_callback.cljs$core$IFn$_invoke$arity$2(id,false) : click_callback.call(null,id,false));

return null;
})),new cljs.core.Keyword(null,"on-double-click","on-double-click",1434856980),(cljs.core.truth_(disabled_QMARK_)?null:(function (event){
(double_click_callback.cljs$core$IFn$_invoke$arity$1 ? double_click_callback.cljs$core$IFn$_invoke$arity$1(id) : double_click_callback.call(null,id));

return null;
}))], null),(label_fn.cljs$core$IFn$_invoke$arity$1 ? label_fn.cljs$core$IFn$_invoke$arity$1(item) : label_fn.call(null,item))], null);
};
var re_com$multi_select$list_item_$_list_item_render = function (var_args){
var p__55863 = null;
if (arguments.length > 0) {
var G__56748__i = 0, G__56748__a = new Array(arguments.length -  0);
while (G__56748__i < G__56748__a.length) {G__56748__a[G__56748__i] = arguments[G__56748__i + 0]; ++G__56748__i;}
  p__55863 = new cljs.core.IndexedSeq(G__56748__a,0,null);
} 
return re_com$multi_select$list_item_$_list_item_render__delegate.call(this,p__55863);};
re_com$multi_select$list_item_$_list_item_render.cljs$lang$maxFixedArity = 0;
re_com$multi_select$list_item_$_list_item_render.cljs$lang$applyTo = (function (arglist__56749){
var p__55863 = cljs.core.seq(arglist__56749);
return re_com$multi_select$list_item_$_list_item_render__delegate(p__55863);
});
re_com$multi_select$list_item_$_list_item_render.cljs$core$IFn$_invoke$arity$variadic = re_com$multi_select$list_item_$_list_item_render__delegate;
return re_com$multi_select$list_item_$_list_item_render;
})()
;
});
/**
 * Render a list box which can be a single list or a grouped list
 */
re_com.multi_select.list_box = (function re_com$multi_select$list_box(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56750 = arguments.length;
var i__5770__auto___56751 = (0);
while(true){
if((i__5770__auto___56751 < len__5769__auto___56750)){
args__5775__auto__.push((arguments[i__5770__auto___56751]));

var G__56752 = (i__5770__auto___56751 + (1));
i__5770__auto___56751 = G__56752;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return re_com.multi_select.list_box.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(re_com.multi_select.list_box.cljs$core$IFn$_invoke$arity$variadic = (function (p__56142){
var map__56143 = p__56142;
var map__56143__$1 = cljs.core.__destructure_map(map__56143);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56143__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var group_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56143__$1,new cljs.core.Keyword(null,"group-fn","group-fn",129203707));
var disabled_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56143__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var label_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56143__$1,new cljs.core.Keyword(null,"label-fn","label-fn",-860923263));
var double_click_callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56143__$1,new cljs.core.Keyword(null,"double-click-callback","double-click-callback",-1057568442));
var click_callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56143__$1,new cljs.core.Keyword(null,"click-callback","click-callback",-609722293));
var _STAR_current_item_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56143__$1,new cljs.core.Keyword(null,"*current-item-id","*current-item-id",-119097013));
var src = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56143__$1,new cljs.core.Keyword(null,"src","src",-1651076051));
var id_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56143__$1,new cljs.core.Keyword(null,"id-fn","id-fn",316222798));
var filter_choices_text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56143__$1,new cljs.core.Keyword(null,"filter-choices-text","filter-choices-text",-253084589));
var group_heading_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56143__$1,new cljs.core.Keyword(null,"group-heading-selected?","group-heading-selected?",-154747592));
var vec__56146 = re_com.multi_select.items_with_group_headings(items,group_fn,id_fn);
var group_names = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56146,(0),null);
var group_item_lists = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56146,(1),null);
var has_group_names_QMARK_ = (!((((new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(cljs.core.first(group_names)) == null)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(group_item_lists))))));
var make_list_item = (function (item){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.multi_select.list_item,new cljs.core.Keyword(null,"item","item",249373802),item,new cljs.core.Keyword(null,"id-fn","id-fn",316222798),id_fn,new cljs.core.Keyword(null,"label-fn","label-fn",-860923263),label_fn,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),disabled_QMARK_,new cljs.core.Keyword(null,"click-callback","click-callback",-609722293),click_callback,new cljs.core.Keyword(null,"double-click-callback","double-click-callback",-1057568442),double_click_callback,new cljs.core.Keyword(null,"selected-item-id","selected-item-id",180338113),cljs.core.deref(_STAR_current_item_id),new cljs.core.Keyword(null,"group-selected?","group-selected?",-1959240379),(cljs.core.truth_(group_heading_selected_QMARK_)?cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.deref(_STAR_current_item_id)),(group_fn.cljs$core$IFn$_invoke$arity$1 ? group_fn.cljs$core$IFn$_invoke$arity$1(item) : group_fn.call(null,item))):null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.str.cljs$core$IFn$_invoke$arity$1((id_fn.cljs$core$IFn$_invoke$arity$1 ? id_fn.cljs$core$IFn$_invoke$arity$1(item) : id_fn.call(null,item)))], null));
});
var make_items = (function (items__$1){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(make_list_item,items__$1));
});
var make_group_heading_item = (function (heading){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.multi_select.group_heading_item,new cljs.core.Keyword(null,"heading","heading",-1312171873),heading,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),disabled_QMARK_,new cljs.core.Keyword(null,"click-callback","click-callback",-609722293),click_callback,new cljs.core.Keyword(null,"double-click-callback","double-click-callback",-1057568442),double_click_callback,new cljs.core.Keyword(null,"selected-item-id","selected-item-id",180338113),cljs.core.deref(_STAR_current_item_id)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(heading)], null));
});
var make_heading_then_items = (function (heading,items__$1){
return cljs.core.cons(make_group_heading_item(heading),make_items(items__$1));
});
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"src","src",-1651076051),src,new cljs.core.Keyword(null,"size","size",1098693007),"1",new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(disabled_QMARK_)?"bm-multi-select-list-disabled":"bm-multi-select-list"),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"#fafafa",new cljs.core.Keyword(null,"border","border",1444987323),"1px solid #ccc",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px"], null),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul.chosen-results","ul.chosen-results",-932618517),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-height","max-height",-612563804),"none"], null)], null),(((cljs.core.count(items) > (0)))?((has_group_names_QMARK_)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(make_heading_then_items,group_names,group_item_lists))):make_items(cljs.core.first(group_item_lists))):((clojure.string.blank_QMARK_(filter_choices_text))?"":new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.no-results","li.no-results",-717682399),["No results match \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_choices_text),"\""].join('')], null)))], null)], null);
}));

(re_com.multi_select.list_box.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(re_com.multi_select.list_box.cljs$lang$applyTo = (function (seq55916){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq55916));
}));

re_com.multi_select.multi_select_parts_desc = ((re_com.config.include_args_desc_QMARK_)?new cljs.core.PersistentVector(null, 29, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"legacy","legacy",1434943289),new cljs.core.Keyword(null,"level","level",1290497552),(0),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select",new cljs.core.Keyword(null,"impl","impl",1677848700),"[multi-select]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"container","container",-1736937707),new cljs.core.Keyword(null,"level","level",1290497552),(1),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-container",new cljs.core.Keyword(null,"impl","impl",1677848700),"[h-box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"left","left",-399115937),new cljs.core.Keyword(null,"level","level",1290497552),(2),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-left",new cljs.core.Keyword(null,"impl","impl",1677848700),"[v-box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"left-label-container","left-label-container",-834990957),new cljs.core.Keyword(null,"level","level",1290497552),(3),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-left-label-container",new cljs.core.Keyword(null,"impl","impl",1677848700),"[h-box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"left-label","left-label",-1662718913),new cljs.core.Keyword(null,"level","level",1290497552),(4),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-left-label",new cljs.core.Keyword(null,"impl","impl",1677848700),"[:span]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"left-label-item-count","left-label-item-count",-960685406),new cljs.core.Keyword(null,"level","level",1290497552),(4),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-left-label-item-count",new cljs.core.Keyword(null,"impl","impl",1677848700),"[:span]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"left-list-box","left-list-box",1536423030),new cljs.core.Keyword(null,"level","level",1290497552),(3),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-left-list-box",new cljs.core.Keyword(null,"impl","impl",1677848700),"[list-box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"filter-text-box","filter-text-box",-1298637056),new cljs.core.Keyword(null,"level","level",1290497552),(3),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-filter-text-box",new cljs.core.Keyword(null,"impl","impl",1677848700),"[h-box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"filter-input-text","filter-input-text",-717594502),new cljs.core.Keyword(null,"level","level",1290497552),(4),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-filter-input-text",new cljs.core.Keyword(null,"impl","impl",1677848700),"[input-text]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"filter-reset-button","filter-reset-button",1821484060),new cljs.core.Keyword(null,"level","level",1290497552),(4),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-filter-reset-button",new cljs.core.Keyword(null,"impl","impl",1677848700),"[close-button]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"left-filter-result-count","left-filter-result-count",299116355),new cljs.core.Keyword(null,"level","level",1290497552),(3),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-left-filter-result-count",new cljs.core.Keyword(null,"impl","impl",1677848700),"[label]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"middle-container","middle-container",-476160515),new cljs.core.Keyword(null,"level","level",1290497552),(2),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-middle-container",new cljs.core.Keyword(null,"impl","impl",1677848700),"[v-box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"middle-top-spacer","middle-top-spacer",330321818),new cljs.core.Keyword(null,"level","level",1290497552),(3),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-middle-top-spacer",new cljs.core.Keyword(null,"impl","impl",1677848700),"[box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"middle","middle",-701029031),new cljs.core.Keyword(null,"level","level",1290497552),(3),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-middle",new cljs.core.Keyword(null,"impl","impl",1677848700),"[v-box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"include-all-button","include-all-button",-1926507806),new cljs.core.Keyword(null,"level","level",1290497552),(4),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-include-all-button",new cljs.core.Keyword(null,"impl","impl",1677848700),"[button]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"include-selected-button","include-selected-button",82106280),new cljs.core.Keyword(null,"level","level",1290497552),(4),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-include-selected-button",new cljs.core.Keyword(null,"impl","impl",1677848700),"[button]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"exclude-selected-button","exclude-selected-button",-1972647705),new cljs.core.Keyword(null,"level","level",1290497552),(4),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-exclude-selected-button",new cljs.core.Keyword(null,"impl","impl",1677848700),"[button]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"exclude-all-button","exclude-all-button",887045557),new cljs.core.Keyword(null,"level","level",1290497552),(4),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-exclude-all-button",new cljs.core.Keyword(null,"impl","impl",1677848700),"[button]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"middle-bottom-spacer","middle-bottom-spacer",-1387854303),new cljs.core.Keyword(null,"level","level",1290497552),(3),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-middle-bottom-spacer",new cljs.core.Keyword(null,"impl","impl",1677848700),"[box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"level","level",1290497552),(2),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-right",new cljs.core.Keyword(null,"impl","impl",1677848700),"[v-box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"warning-message","warning-message",1341499775),new cljs.core.Keyword(null,"level","level",1290497552),(3),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-warning-message",new cljs.core.Keyword(null,"impl","impl",1677848700),"[label]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"right-label-container","right-label-container",1591591267),new cljs.core.Keyword(null,"level","level",1290497552),(3),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-right-label-container",new cljs.core.Keyword(null,"impl","impl",1677848700),"[h-box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"right-label","right-label",1465344334),new cljs.core.Keyword(null,"level","level",1290497552),(4),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-right-label",new cljs.core.Keyword(null,"impl","impl",1677848700),"[:span]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"right-label-item-count","right-label-item-count",1865750626),new cljs.core.Keyword(null,"level","level",1290497552),(4),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-right-label-item-count",new cljs.core.Keyword(null,"impl","impl",1677848700),"[:span]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"right-list-box","right-list-box",109159631),new cljs.core.Keyword(null,"level","level",1290497552),(3),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-right-list-box",new cljs.core.Keyword(null,"impl","impl",1677848700),"[list-box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"filter-text-box","filter-text-box",-1298637056),new cljs.core.Keyword(null,"level","level",1290497552),(3),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-filter-text-box",new cljs.core.Keyword(null,"impl","impl",1677848700),"[h-box]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"filter-input-text","filter-input-text",-717594502),new cljs.core.Keyword(null,"level","level",1290497552),(4),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-filter-input-text",new cljs.core.Keyword(null,"impl","impl",1677848700),"[input-text]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"filter-reset-button","filter-reset-button",1821484060),new cljs.core.Keyword(null,"level","level",1290497552),(4),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-filter-reset-button",new cljs.core.Keyword(null,"impl","impl",1677848700),"[close-button]"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"right-filter-result-count","right-filter-result-count",1601271062),new cljs.core.Keyword(null,"level","level",1290497552),(3),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-multi-select-right-filter-result-count",new cljs.core.Keyword(null,"impl","impl",1677848700),"[label]"], null)], null):null);
re_com.multi_select.multi_select_parts = ((re_com.config.include_args_desc_QMARK_)?cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177),re_com.multi_select.multi_select_parts_desc)):null);
re_com.multi_select.multi_select_args_desc = ((re_com.config.include_args_desc_QMARK_)?new cljs.core.PersistentVector(null, 25, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"choices","choices",1385611597),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"vector of maps | r/atom",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.vector_of_maps_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"Each map represents a choice. Values corresponding to id, label and, optionally, a group, are extracted by the functions ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":id-fn"], null),", ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":label-fn"], null)," & ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":group-fn"], null),". See below."], null)], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id-fn","id-fn",316222798),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"type","type",1174270348),"map -> anything",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.ifn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"a function taking one argument (a map) and returns the unique identifier for that map. Called for each element in ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":choices"], null)], null)], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"label-fn","label-fn",-860923263),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.Keyword(null,"type","type",1174270348),"map -> string | hiccup",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.ifn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"a function taking one argument (a map) and returns the displayable label for that map. Called for each element in ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":choices"], null)], null)], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"group-fn","group-fn",129203707),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"type","type",1174270348),"map -> string | hiccup",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.ifn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"a function taking one argument (a map) and returns the group identifier for that map. Called for each element in ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":choices"], null)], null)], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"sort-fn","sort-fn",977815011),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),"compare",new cljs.core.Keyword(null,"type","type",1174270348),"map, map -> integer",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.ifn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"The comparator function used with ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"cljs.core/sort-by"], null)," to sort choices."], null)], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"model","model",331153215),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"a set of ids | r/atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"a set of the ids for currently selected choices. If nil, see ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":placeholder"], null),"."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"required?","required?",-872514462),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | r/atom",new cljs.core.Keyword(null,"description","description",-1428560544),"when true, at least one item must be selected"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"max-selected-items","max-selected-items",2143819689),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"integer",new cljs.core.Keyword(null,"description","description",-1428560544),"maximum number of items that can be selected"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"left-label","left-label",-1662718913),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string | hiccup",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.string_or_hiccup_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"label displayed above the left list"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"right-label","right-label",1465344334),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string | hiccup",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.string_or_hiccup_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"label displayed above the right list"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"id -> nil",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"a function that will be called when the selection changes. Passed the set of selected ids. See ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":model"], null),"."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | r/atom",new cljs.core.Keyword(null,"description","description",-1428560544),"if true, no user selection is allowed"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"filter-box?","filter-box?",-1157583688),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | r/atom",new cljs.core.Keyword(null,"description","description",-1428560544),"if true, a filter text field is placed at the bottom of the component"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"regex-filter?","regex-filter?",-824895668),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | r/atom",new cljs.core.Keyword(null,"description","description",-1428560544),"if true, the filter text field will support JavaScript regular expressions. If false, just plain text"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"background text when no selection"], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),"100%",new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"the CSS width. e.g.: \"500px\" or \"20em\""], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"the specific height of the component"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"max-height","max-height",-612563804),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"the maximum height of the component"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"tab-index","tab-index",895755393),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"integer | string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.number_or_string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"component's tabindex. A value of -1 removes from the tab order"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS class names, space separated"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"CSS style map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.css_style_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS styles to add or override"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"HTML attr map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.html_attr_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"HTML attributes, like ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-mouse-move"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"br","br",934104792)], null),"No ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":class"], null)," or ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":style"], null),"allowed"], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"parts","parts",849007691),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.parts_QMARK_(re_com.multi_select.multi_select_parts),new cljs.core.Keyword(null,"description","description",-1428560544),"See Parts section below."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"src","src",-1651076051),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.map_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"Used in dev builds to assist with debugging. Source code coordinates map containing keys",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":file"], null),"and",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":line"], null),". See 'Debugging'."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"debug-as","debug-as",283322354),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.map_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"Used in dev builds to assist with debugging, when one component is used implement another component, and we want the implementation component to masquerade as the original component in debug output, such as component stacks. A map optionally containing keys",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":component"], null),"and",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":args"], null),"."], null)], null)], null):null);
/**
 * Render a multi-select component which emulates the bootstrap-choosen style. Sample choices object:
 *   [{:id "AU" :label "Australia"      :group "Group 1"}
 * {:id "US" :label "United States"  :group "Group 1"}
 * {:id "GB" :label "United Kingdom" :group "Group 1"}
 * {:id "AF" :label "Afghanistan"    :group "Group 2"}]
 */
re_com.multi_select.multi_select = (function re_com$multi_select$multi_select(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56863 = arguments.length;
var i__5770__auto___56864 = (0);
while(true){
if((i__5770__auto___56864 < len__5769__auto___56863)){
args__5775__auto__.push((arguments[i__5770__auto___56864]));

var G__56865 = (i__5770__auto___56864 + (1));
i__5770__auto___56864 = G__56865;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return re_com.multi_select.multi_select.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(re_com.multi_select.multi_select.cljs$core$IFn$_invoke$arity$variadic = (function (p__56494){
var map__56496 = p__56494;
var map__56496__$1 = cljs.core.__destructure_map(map__56496);
var args = map__56496__$1;
var model = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56496__$1,new cljs.core.Keyword(null,"model","model",331153215));
var sort_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__56496__$1,new cljs.core.Keyword(null,"sort-fn","sort-fn",977815011),cljs.core.identity);
var src = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56496__$1,new cljs.core.Keyword(null,"src","src",-1651076051));

var or__5045__auto__ = (((!(goog.DEBUG)))?null:re_com.validate.validate_args(re_com.validate.extract_arg_data(re_com.multi_select.multi_select_args_desc),args));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var _STAR_external_model = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(re_com.util.deref_or_value(model));
var _STAR_internal_model = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(_STAR_external_model));
var _STAR_current_choice_id = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var _STAR_current_selection_id = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var _STAR_choice_group_heading_selected_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var _STAR_selection_group_heading_selected_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var _STAR_warning_message = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var _STAR_filter_choices_text = reagent.core.atom.cljs$core$IFn$_invoke$arity$1("");
var _STAR_filter_selections_text = reagent.core.atom.cljs$core$IFn$_invoke$arity$1("");
var button_style = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"width","width",-384071477),"86px",new cljs.core.Keyword(null,"height","height",1025178622),"24px",new cljs.core.Keyword(null,"padding","padding",1660304693),"0px 8px 2px 8px",new cljs.core.Keyword(null,"margin","margin",-995903681),"8px 6px",new cljs.core.Keyword(null,"text-align","text-align",1786091845),"left",new cljs.core.Keyword(null,"font-variant","font-variant",1251503591),"small-caps",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),(11)], null);
return (function() { 
var re_com$multi_select$multi_select_render__delegate = function (p__56506){
var map__56508 = p__56506;
var map__56508__$1 = cljs.core.__destructure_map(map__56508);
var args__$1 = map__56508__$1;
var group_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__56508__$1,new cljs.core.Keyword(null,"group-fn","group-fn",129203707),new cljs.core.Keyword(null,"group","group",582596132));
var disabled_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var model__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"model","model",331153215));
var attr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"attr","attr",-604132353));
var left_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"left-label","left-label",-1662718913));
var label_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__56508__$1,new cljs.core.Keyword(null,"label-fn","label-fn",-860923263),new cljs.core.Keyword(null,"label","label",1718410804));
var tab_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"tab-index","tab-index",895755393));
var required_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__56508__$1,new cljs.core.Keyword(null,"required?","required?",-872514462),false);
var sort_fn__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__56508__$1,new cljs.core.Keyword(null,"sort-fn","sort-fn",977815011),cljs.core.compare);
var max_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"max-height","max-height",-612563804));
var placeholder = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var max_selected_items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"max-selected-items","max-selected-items",2143819689));
var parts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"parts","parts",849007691));
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var regex_filter_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"regex-filter?","regex-filter?",-824895668));
var src__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"src","src",-1651076051));
var choices = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"choices","choices",1385611597));
var id_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__56508__$1,new cljs.core.Keyword(null,"id-fn","id-fn",316222798),new cljs.core.Keyword(null,"id","id",-1388402092));
var right_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"right-label","right-label",1465344334));
var style = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var filter_box_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56508__$1,new cljs.core.Keyword(null,"filter-box?","filter-box?",-1157583688));
var or__5045__auto____$1 = (((!(goog.DEBUG)))?null:re_com.validate.validate_args(re_com.validate.extract_arg_data(re_com.multi_select.multi_select_args_desc),args__$1));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var required_QMARK___$1 = re_com.util.deref_or_value(required_QMARK_);
var filter_box_QMARK___$1 = re_com.util.deref_or_value(filter_box_QMARK_);
var regex_filter_QMARK___$1 = re_com.util.deref_or_value(regex_filter_QMARK_);
var min_msg = "Must have at least one";
var max_msg = ["Max items allowed is ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_selected_items)].join('');
var group_fn__$1 = (function (){var or__5045__auto____$2 = group_fn;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return new cljs.core.Keyword("re-com.multi-select","$$$","re-com.multi-select/$$$",-567571741);
}
})();
var choices__$1 = cljs.core.set(re_com.util.deref_or_value(choices));
var disabled_QMARK___$1 = re_com.util.deref_or_value(disabled_QMARK_);
var regex_filter_QMARK___$2 = re_com.util.deref_or_value(regex_filter_QMARK___$1);
var _STAR_latest_ext_model = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(re_com.util.deref_or_value(model__$1));
var _ = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(_STAR_external_model),cljs.core.deref(_STAR_latest_ext_model)))?(function (){
cljs.core.reset_BANG_(_STAR_external_model,cljs.core.deref(_STAR_latest_ext_model));

return cljs.core.reset_BANG_(_STAR_internal_model,cljs.core.deref(_STAR_latest_ext_model));
})()
:null);
var changeable_QMARK_ = (function (){var and__5043__auto__ = on_change;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(disabled_QMARK___$1);
} else {
return and__5043__auto__;
}
})();
var excludable_QMARK_ = (function (){var and__5043__auto__ = cljs.core.deref(_STAR_current_selection_id);
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.count(cljs.core.deref(_STAR_internal_model)) > (cljs.core.truth_(required_QMARK___$1)?(1):(0)));
} else {
return and__5043__auto__;
}
})();
var choices_filter_fn = (cljs.core.truth_(regex_filter_QMARK___$2)?re_com.multi_select.filter_items_regex(group_fn__$1,label_fn,cljs.core.deref(_STAR_filter_choices_text)):re_com.multi_select.filter_items(group_fn__$1,label_fn,cljs.core.deref(_STAR_filter_choices_text)));
var filtered_choices = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(sort_fn__$1,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(choices_filter_fn,cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__56186_SHARP_){
return cljs.core.contains_QMARK_(cljs.core.deref(_STAR_internal_model),(id_fn.cljs$core$IFn$_invoke$arity$1 ? id_fn.cljs$core$IFn$_invoke$arity$1(p1__56186_SHARP_) : id_fn.call(null,p1__56186_SHARP_)));
}),choices__$1))));
var selections = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(sort_fn__$1,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__56187_SHARP_){
return re_com.util.item_for_id.cljs$core$IFn$_invoke$arity$variadic(p1__56187_SHARP_,choices__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id-fn","id-fn",316222798),id_fn], 0));
}),cljs.core.deref(_STAR_internal_model))));
var selections_filter_fn = (cljs.core.truth_(regex_filter_QMARK___$2)?re_com.multi_select.filter_items_regex(group_fn__$1,label_fn,cljs.core.deref(_STAR_filter_selections_text)):re_com.multi_select.filter_items(group_fn__$1,label_fn,cljs.core.deref(_STAR_filter_selections_text)));
var filtered_selections = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(sort_fn__$1,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(selections_filter_fn,selections)));
var potential_count = cljs.core.count(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(id_fn,choices__$1)),cljs.core.deref(_STAR_internal_model)));
var chosen_count = cljs.core.count(selections);
var choice_click = (function (id,group_heading_selected_QMARK_){
cljs.core.reset_BANG_(_STAR_current_choice_id,id);

cljs.core.reset_BANG_(_STAR_choice_group_heading_selected_QMARK_,group_heading_selected_QMARK_);

return cljs.core.reset_BANG_(_STAR_warning_message,null);
});
var selection_click = (function (id,group_heading_selected_QMARK_){
cljs.core.reset_BANG_(_STAR_current_selection_id,id);

cljs.core.reset_BANG_(_STAR_selection_group_heading_selected_QMARK_,group_heading_selected_QMARK_);

return cljs.core.reset_BANG_(_STAR_warning_message,null);
});
var include_filtered_click = (function (){
if((((!((max_selected_items == null)))) && (((cljs.core.count(cljs.core.deref(_STAR_internal_model)) + cljs.core.count(filtered_choices)) > max_selected_items)))){
cljs.core.reset_BANG_(_STAR_warning_message,max_msg);
} else {
cljs.core.reset_BANG_(_STAR_internal_model,cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(_STAR_internal_model),cljs.core.map.cljs$core$IFn$_invoke$arity$2(id_fn,filtered_choices))));

cljs.core.reset_BANG_(_STAR_warning_message,null);
}

if(cljs.core.truth_((function (){var and__5043__auto__ = changeable_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(_STAR_internal_model),cljs.core.deref(_STAR_latest_ext_model));
} else {
return and__5043__auto__;
}
})())){
cljs.core.reset_BANG_(_STAR_external_model,cljs.core.deref(_STAR_internal_model));

var G__56551_56889 = cljs.core.deref(_STAR_internal_model);
(on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(G__56551_56889) : on_change.call(null,G__56551_56889));
} else {
}

return cljs.core.reset_BANG_(_STAR_current_choice_id,null);
});
var include_click = (function (){
if(cljs.core.truth_(cljs.core.deref(_STAR_choice_group_heading_selected_QMARK_))){
var choices_to_include_56891 = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(id_fn,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (item){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.deref(_STAR_current_choice_id)),(group_fn__$1.cljs$core$IFn$_invoke$arity$1 ? group_fn__$1.cljs$core$IFn$_invoke$arity$1(item) : group_fn__$1.call(null,item)));
}),filtered_choices)));
if((((!((max_selected_items == null)))) && (((cljs.core.count(cljs.core.deref(_STAR_internal_model)) + cljs.core.count(choices_to_include_56891)) > max_selected_items)))){
cljs.core.reset_BANG_(_STAR_warning_message,max_msg);
} else {
cljs.core.reset_BANG_(_STAR_internal_model,cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(_STAR_internal_model),choices_to_include_56891)));

cljs.core.reset_BANG_(_STAR_choice_group_heading_selected_QMARK_,false);
}
} else {
if((((!((max_selected_items == null)))) && ((cljs.core.count(cljs.core.deref(_STAR_internal_model)) >= max_selected_items)))){
cljs.core.reset_BANG_(_STAR_warning_message,max_msg);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(_STAR_internal_model,cljs.core.conj,cljs.core.deref(_STAR_current_choice_id));

cljs.core.reset_BANG_(_STAR_warning_message,null);
}
}

if(cljs.core.truth_((function (){var and__5043__auto__ = changeable_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(_STAR_internal_model),cljs.core.deref(_STAR_latest_ext_model));
} else {
return and__5043__auto__;
}
})())){
cljs.core.reset_BANG_(_STAR_external_model,cljs.core.deref(_STAR_internal_model));

var G__56553_56894 = cljs.core.deref(_STAR_internal_model);
(on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(G__56553_56894) : on_change.call(null,G__56553_56894));
} else {
}

return cljs.core.reset_BANG_(_STAR_current_choice_id,null);
});
var exclude_click = (function (){
if(cljs.core.truth_(excludable_QMARK_)){
if(cljs.core.truth_(cljs.core.deref(_STAR_selection_group_heading_selected_QMARK_))){
var new_internal_model_56896 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(_STAR_internal_model),cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(id_fn,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (item){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.deref(_STAR_current_selection_id)),(group_fn__$1.cljs$core$IFn$_invoke$arity$1 ? group_fn__$1.cljs$core$IFn$_invoke$arity$1(item) : group_fn__$1.call(null,item)));
}),filtered_selections))));
if(cljs.core.truth_((function (){var and__5043__auto__ = required_QMARK___$1;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.empty_QMARK_(new_internal_model_56896);
} else {
return and__5043__auto__;
}
})())){
cljs.core.reset_BANG_(_STAR_internal_model,cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.first(cljs.core.deref(_STAR_internal_model))]));

cljs.core.reset_BANG_(_STAR_warning_message,min_msg);
} else {
cljs.core.reset_BANG_(_STAR_internal_model,new_internal_model_56896);

cljs.core.reset_BANG_(_STAR_selection_group_heading_selected_QMARK_,false);

cljs.core.reset_BANG_(_STAR_warning_message,null);
}
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(_STAR_internal_model,cljs.core.disj,cljs.core.deref(_STAR_current_selection_id));

cljs.core.reset_BANG_(_STAR_warning_message,null);
}
} else {
cljs.core.reset_BANG_(_STAR_warning_message,min_msg);
}

if(cljs.core.truth_((function (){var and__5043__auto__ = changeable_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(_STAR_internal_model),cljs.core.deref(_STAR_latest_ext_model));
} else {
return and__5043__auto__;
}
})())){
cljs.core.reset_BANG_(_STAR_external_model,cljs.core.deref(_STAR_internal_model));

var G__56559_56904 = cljs.core.deref(_STAR_internal_model);
(on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(G__56559_56904) : on_change.call(null,G__56559_56904));
} else {
}

return cljs.core.reset_BANG_(_STAR_current_selection_id,null);
});
var exclude_filtered_click = (function (){
var new_internal_model = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(_STAR_internal_model),cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(id_fn,filtered_selections)));
if(cljs.core.truth_((function (){var and__5043__auto__ = required_QMARK___$1;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.count(new_internal_model) === (0));
} else {
return and__5043__auto__;
}
})())){
cljs.core.reset_BANG_(_STAR_internal_model,cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.first(cljs.core.deref(_STAR_internal_model))]));

cljs.core.reset_BANG_(_STAR_warning_message,min_msg);
} else {
cljs.core.reset_BANG_(_STAR_internal_model,new_internal_model);

cljs.core.reset_BANG_(_STAR_warning_message,null);
}

if(cljs.core.truth_((function (){var and__5043__auto__ = changeable_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(_STAR_internal_model),cljs.core.deref(_STAR_latest_ext_model));
} else {
return and__5043__auto__;
}
})())){
cljs.core.reset_BANG_(_STAR_external_model,cljs.core.deref(_STAR_internal_model));

var G__56567_56905 = cljs.core.deref(_STAR_internal_model);
(on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(G__56567_56905) : on_change.call(null,G__56567_56905));
} else {
}

return cljs.core.reset_BANG_(_STAR_current_selection_id,null);
});
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select noselect chosen-container chosen-container-single ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([re_com.box.flex_child_style((cljs.core.truth_(width)?"0 0 auto":"auto")),re_com.box.align_style(new cljs.core.Keyword(null,"align-self","align-self",1475936794),new cljs.core.Keyword(null,"start","start",-355208981)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden",new cljs.core.Keyword(null,"width","width",-384071477),width], null),style], 0))], null),re_com.debug.__GT_attr(args__$1),attr], 0)),new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.h_box,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),427], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-container ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"container","container",-1736937707),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"container","container",-1736937707),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"container","container",-1736937707),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"max-height","max-height",-612563804),max_height,new cljs.core.Keyword(null,"gap","gap",80255254),"4px",new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),435], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-left ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left","left",-399115937),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left","left",-399115937),new cljs.core.Keyword(null,"style","style",-496642736)], null)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left","left",-399115937),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"size","size",1098693007),"50%",new cljs.core.Keyword(null,"gap","gap",80255254),"4px",new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(left_label)?((typeof left_label === 'string')?new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.h_box,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),444], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-left-label-container ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-label-container","left-label-container",-834990957),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-label-container","left-label-container",-834990957),new cljs.core.Keyword(null,"style","style",-496642736)], null)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-label-container","left-label-container",-834990957),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"justify","justify",-722524056),new cljs.core.Keyword(null,"between","between",1131099276),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-left-label ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-label","left-label",-1662718913),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"small",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold"], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-label","left-label",-1662718913),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0))], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-label","left-label",-1662718913),new cljs.core.Keyword(null,"attr","attr",-604132353)], null))], 0)),left_label], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-left-label-item-count ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-label-item-count","left-label-item-count",-960685406),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"smaller"], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-label-item-count","left-label-item-count",-960685406),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0))], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-label-item-count","left-label-item-count",-960685406),new cljs.core.Keyword(null,"attr","attr",-604132353)], null))], 0)),((clojure.string.blank_QMARK_(cljs.core.deref(_STAR_filter_choices_text)))?re_com.util.pluralize(potential_count,"item"):["showing ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(filtered_choices))," of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(potential_count)].join(''))], null)], null)], null):left_label):null),new cljs.core.PersistentVector(null, 25, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.multi_select.list_box,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),468], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-left-list-box ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-list-box","left-list-box",1536423030),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"items","items",1031954938),filtered_choices,new cljs.core.Keyword(null,"id-fn","id-fn",316222798),id_fn,new cljs.core.Keyword(null,"label-fn","label-fn",-860923263),label_fn,new cljs.core.Keyword(null,"group-fn","group-fn",129203707),group_fn__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),disabled_QMARK___$1,new cljs.core.Keyword(null,"*current-item-id","*current-item-id",-119097013),_STAR_current_choice_id,new cljs.core.Keyword(null,"group-heading-selected?","group-heading-selected?",-154747592),cljs.core.deref(_STAR_choice_group_heading_selected_QMARK_),new cljs.core.Keyword(null,"click-callback","click-callback",-609722293),choice_click,new cljs.core.Keyword(null,"double-click-callback","double-click-callback",-1057568442),include_click,new cljs.core.Keyword(null,"filter-choices-text","filter-choices-text",-253084589),cljs.core.deref(_STAR_filter_choices_text)], null),(cljs.core.truth_(filter_box_QMARK___$1)?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.gap,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),483], null)),new cljs.core.Keyword(null,"size","size",1098693007),"4px"], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.multi_select.filter_text_box,_STAR_filter_choices_text,placeholder,_STAR_warning_message,disabled_QMARK___$1,parts], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.gap,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),487], null)),new cljs.core.Keyword(null,"size","size",1098693007),"4px"], null),((clojure.string.blank_QMARK_(cljs.core.deref(_STAR_filter_choices_text)))?new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.text.label,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),491], null)),new cljs.core.Keyword(null,"label","label",1718410804),goog.string.unescapeEntities("&nbsp;"),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"smaller"], null)], null):new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.text.label,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),495], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-left-filter-result-count ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-filter-result-count","left-filter-result-count",299116355),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"smaller"], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-filter-result-count","left-filter-result-count",299116355),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-filter-result-count","left-filter-result-count",299116355),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"Found ",re_com.util.pluralize.cljs$core$IFn$_invoke$arity$variadic(cljs.core.count(filtered_choices),"match",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["matches"], 0))," containing ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),cljs.core.deref(_STAR_filter_choices_text)], null)], null)], null))], null):null)], null)], null),new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),503], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-middle-container ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"middle-container","middle-container",-476160515),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"middle-container","middle-container",-476160515),new cljs.core.Keyword(null,"style","style",-496642736)], null)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"middle-container","middle-container",-476160515),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"justify","justify",-722524056),new cljs.core.Keyword(null,"between","between",1131099276),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),509], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-middle-spacer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"middle-spacer","middle-spacer",2062831011),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"middle-spacer","middle-spacer",2062831011),new cljs.core.Keyword(null,"style","style",-496642736)], null)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"middle-spacer","middle-spacer",2062831011),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"size","size",1098693007),"0 1 22px",new cljs.core.Keyword(null,"child","child",623967545),""], null),new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),516], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-middle ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"middle","middle",-701029031),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"middle","middle",-701029031),new cljs.core.Keyword(null,"style","style",-496642736)], null)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"middle","middle",-701029031),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"justify","justify",-722524056),new cljs.core.Keyword(null,"center","center",-748944368),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.buttons.button,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),522], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-include-all-button ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"include-all-button","include-all-button",-1926507806),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"zmdi zmdi-hc-fw-rc zmdi-fast-forward"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"position","position",-2011731912),"relative",new cljs.core.Keyword(null,"top","top",-1856271961),"-1px"], null)], null),[" include ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((clojure.string.blank_QMARK_(cljs.core.deref(_STAR_filter_choices_text)))?potential_count:cljs.core.count(filtered_choices)))].join('')], null)], null),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),(function (){var or__5045__auto____$2 = disabled_QMARK___$1;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return (cljs.core.count(filtered_choices) === (0));
}
})(),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([button_style,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"include-all-button","include-all-button",-1926507806),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"include-all-button","include-all-button",-1926507806),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"on-click","on-click",1632826543),include_filtered_click], null),new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.buttons.button,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),535], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-include-selected-button ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"include-selected-button","include-selected-button",82106280),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"zmdi zmdi-hc-fw-rc zmdi-play"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"position","position",-2011731912),"relative",new cljs.core.Keyword(null,"top","top",-1856271961),"-1px"], null)], null),[" include ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(cljs.core.deref(_STAR_choice_group_heading_selected_QMARK_))?cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (item){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.deref(_STAR_current_choice_id)),(group_fn__$1.cljs$core$IFn$_invoke$arity$1 ? group_fn__$1.cljs$core$IFn$_invoke$arity$1(item) : group_fn__$1.call(null,item)));
}),filtered_choices)):null))].join('')], null)], null),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),(function (){var or__5045__auto____$2 = disabled_QMARK___$1;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return cljs.core.not(cljs.core.deref(_STAR_current_choice_id));
}
})(),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([button_style,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"include-selected-button","include-selected-button",82106280),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"include-selected-button","include-selected-button",82106280),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"on-click","on-click",1632826543),include_click], null),new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.buttons.button,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),551], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-exclude-selected-button ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exclude-selected-button","exclude-selected-button",-1972647705),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"zmdi zmdi-hc-fw-rc zmdi-play zmdi-hc-rotate-180"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"position","position",-2011731912),"relative",new cljs.core.Keyword(null,"top","top",-1856271961),"-1px"], null)], null),[" exclude ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(cljs.core.deref(_STAR_selection_group_heading_selected_QMARK_))?cljs.core.count(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (item){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.deref(_STAR_current_selection_id)),(group_fn__$1.cljs$core$IFn$_invoke$arity$1 ? group_fn__$1.cljs$core$IFn$_invoke$arity$1(item) : group_fn__$1.call(null,item)));
}),filtered_selections)):null))].join('')], null)], null),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),(function (){var or__5045__auto____$2 = disabled_QMARK___$1;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return cljs.core.not(excludable_QMARK_);
}
})(),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([button_style,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exclude-selected-button","exclude-selected-button",-1972647705),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exclude-selected-button","exclude-selected-button",-1972647705),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"on-click","on-click",1632826543),exclude_click], null),new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.buttons.button,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),567], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-exclude-all-button ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exclude-all-button","exclude-all-button",887045557),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"zmdi zmdi-hc-fw-rc zmdi-fast-rewind"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"position","position",-2011731912),"relative",new cljs.core.Keyword(null,"top","top",-1856271961),"-1px"], null)], null),[" exclude ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((clojure.string.blank_QMARK_(cljs.core.deref(_STAR_filter_selections_text)))?chosen_count:cljs.core.count(filtered_selections)))].join('')], null)], null),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),(function (){var or__5045__auto____$2 = disabled_QMARK___$1;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return (((cljs.core.count(filtered_selections) === (0))) || ((!((cljs.core.count(cljs.core.deref(_STAR_internal_model)) > (cljs.core.truth_(required_QMARK___$1)?(1):(0)))))));
}
})(),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([button_style,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exclude-all-button","exclude-all-button",887045557),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"exclude-all-button","exclude-all-button",887045557),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"on-click","on-click",1632826543),exclude_filtered_click], null)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),580], null)),new cljs.core.Keyword(null,"size","size",1098693007),["0 2 ",(cljs.core.truth_(filter_box_QMARK___$1)?"55px":"0px")].join(''),new cljs.core.Keyword(null,"child","child",623967545),""], null)], null)], null),new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),585], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-right ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"size","size",1098693007),"50%",new cljs.core.Keyword(null,"gap","gap",80255254),"4px",new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"position","position",-2011731912),"relative"], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.text.label,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),594], null)),new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.deref(_STAR_warning_message),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-warning-message ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"warning-message","warning-message",1341499775),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),(cljs.core.truth_(cljs.core.deref(_STAR_warning_message))?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"background-color","background-color",570434026),new cljs.core.Keyword(null,"z-index","z-index",1892827090),new cljs.core.Keyword(null,"opacity","opacity",397153780),new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"animation-duration","animation-duration",-1261077706),new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"animation-name","animation-name",-302195330),new cljs.core.Keyword(null,"height","height",1025178622)],["white","green",(1),"0","3px 6px","5000ms","0px","absolute","0px","rc-multi-select-fade-warning-msg","25px"]),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"warning-message","warning-message",1341499775),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0)):null),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"warning-message","warning-message",1341499775),new cljs.core.Keyword(null,"attr","attr",-604132353)], null))], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.gensym.cljs$core$IFn$_invoke$arity$0()], null)),(cljs.core.truth_(right_label)?((typeof right_label === 'string')?new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.h_box,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),615], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-right-label-container ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-label-container","right-label-container",1591591267),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-label-container","right-label-container",1591591267),new cljs.core.Keyword(null,"style","style",-496642736)], null)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-label-container","right-label-container",1591591267),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"justify","justify",-722524056),new cljs.core.Keyword(null,"between","between",1131099276),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-right-label ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-label","right-label",1465344334),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"small",new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold"], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-label","right-label",1465344334),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0))], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-label","right-label",1465344334),new cljs.core.Keyword(null,"attr","attr",-604132353)], null))], 0)),right_label], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-right-label-item-count ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-label-item-count","right-label-item-count",1865750626),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"smaller"], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-label-item-count","right-label-item-count",1865750626),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0))], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-label-item-count","right-label-item-count",1865750626),new cljs.core.Keyword(null,"attr","attr",-604132353)], null))], 0)),((clojure.string.blank_QMARK_(cljs.core.deref(_STAR_filter_selections_text)))?re_com.util.pluralize(chosen_count,"item"):["showing ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(filtered_selections))," of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(chosen_count)].join(''))], null)], null)], null):right_label):null),new cljs.core.PersistentVector(null, 29, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.multi_select.list_box,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),639], null)),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-right-list-box ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-list-box","right-list-box",109159631),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-list-box","right-list-box",109159631),new cljs.core.Keyword(null,"style","style",-496642736)], null)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-list-box","right-list-box",109159631),new cljs.core.Keyword(null,"attr","attr",-604132353)], null)),new cljs.core.Keyword(null,"items","items",1031954938),filtered_selections,new cljs.core.Keyword(null,"id-fn","id-fn",316222798),id_fn,new cljs.core.Keyword(null,"label-fn","label-fn",-860923263),label_fn,new cljs.core.Keyword(null,"group-fn","group-fn",129203707),group_fn__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),disabled_QMARK___$1,new cljs.core.Keyword(null,"*current-item-id","*current-item-id",-119097013),_STAR_current_selection_id,new cljs.core.Keyword(null,"group-heading-selected?","group-heading-selected?",-154747592),cljs.core.deref(_STAR_selection_group_heading_selected_QMARK_),new cljs.core.Keyword(null,"click-callback","click-callback",-609722293),selection_click,new cljs.core.Keyword(null,"double-click-callback","double-click-callback",-1057568442),exclude_click,new cljs.core.Keyword(null,"filter-choices-text","filter-choices-text",-253084589),cljs.core.deref(_STAR_filter_selections_text)], null),(cljs.core.truth_(filter_box_QMARK___$1)?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.gap,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),656], null)),new cljs.core.Keyword(null,"size","size",1098693007),"4px"], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.multi_select.filter_text_box,_STAR_filter_selections_text,placeholder,_STAR_warning_message,disabled_QMARK___$1,parts], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.gap,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),660], null)),new cljs.core.Keyword(null,"size","size",1098693007),"4px"], null),((clojure.string.blank_QMARK_(cljs.core.deref(_STAR_filter_selections_text)))?new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.text.label,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),664], null)),new cljs.core.Keyword(null,"label","label",1718410804),goog.string.unescapeEntities("&nbsp;"),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"smaller"], null)], null):new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.text.label,new cljs.core.Keyword(null,"src","src",-1651076051),(((!(goog.DEBUG)))?null:new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file","file",-1269645878),"re_com/multi_select.cljs",new cljs.core.Keyword(null,"line","line",212345235),668], null)),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"Found ",re_com.util.pluralize.cljs$core$IFn$_invoke$arity$variadic(cljs.core.count(filtered_selections),"match",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["matches"], 0))," containing ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),cljs.core.deref(_STAR_filter_selections_text)], null)], null),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-multi-select-right-filter-result-count ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-filter-result-count","right-filter-result-count",1601271062),new cljs.core.Keyword(null,"class","class",-2030961996)], null)))].join(''),new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"smaller"], null),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-filter-result-count","right-filter-result-count",1601271062),new cljs.core.Keyword(null,"style","style",-496642736)], null))], 0)),new cljs.core.Keyword(null,"attr","attr",-604132353),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(parts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"right-filter-result-count","right-filter-result-count",1601271062),new cljs.core.Keyword(null,"attr","attr",-604132353)], null))], null))], null):null)], null)], null)], null)], null)], null);
}
};
var re_com$multi_select$multi_select_render = function (var_args){
var p__56506 = null;
if (arguments.length > 0) {
var G__56994__i = 0, G__56994__a = new Array(arguments.length -  0);
while (G__56994__i < G__56994__a.length) {G__56994__a[G__56994__i] = arguments[G__56994__i + 0]; ++G__56994__i;}
  p__56506 = new cljs.core.IndexedSeq(G__56994__a,0,null);
} 
return re_com$multi_select$multi_select_render__delegate.call(this,p__56506);};
re_com$multi_select$multi_select_render.cljs$lang$maxFixedArity = 0;
re_com$multi_select$multi_select_render.cljs$lang$applyTo = (function (arglist__56995){
var p__56506 = cljs.core.seq(arglist__56995);
return re_com$multi_select$multi_select_render__delegate(p__56506);
});
re_com$multi_select$multi_select_render.cljs$core$IFn$_invoke$arity$variadic = re_com$multi_select$multi_select_render__delegate;
return re_com$multi_select$multi_select_render;
})()
;
}
}));

(re_com.multi_select.multi_select.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(re_com.multi_select.multi_select.cljs$lang$applyTo = (function (seq56475){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56475));
}));


//# sourceMappingURL=re_com.multi_select.js.map
