goog.provide('re_frame.fx');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed, other than that
 *   `:db` is guaranteed to be executed first.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__20363 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__20364 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__20364);

try{try{var effects = new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context);
var effects_without_db = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(effects,new cljs.core.Keyword(null,"db","db",993250759));
var temp__5804__auto___20518 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(effects);
if(cljs.core.truth_(temp__5804__auto___20518)){
var new_db_20519 = temp__5804__auto___20518;
var fexpr__20367_20521 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,new cljs.core.Keyword(null,"db","db",993250759),false);
(fexpr__20367_20521.cljs$core$IFn$_invoke$arity$1 ? fexpr__20367_20521.cljs$core$IFn$_invoke$arity$1(new_db_20519) : fexpr__20367_20521.call(null,new_db_20519));
} else {
}

var seq__20369 = cljs.core.seq(effects_without_db);
var chunk__20370 = null;
var count__20371 = (0);
var i__20372 = (0);
while(true){
if((i__20372 < count__20371)){
var vec__20382 = chunk__20370.cljs$core$IIndexed$_nth$arity$2(null,i__20372);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20382,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20382,(1),null);
var temp__5802__auto___20522 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5802__auto___20522)){
var effect_fn_20523 = temp__5802__auto___20522;
(effect_fn_20523.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20523.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20523.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20524 = seq__20369;
var G__20525 = chunk__20370;
var G__20526 = count__20371;
var G__20527 = (i__20372 + (1));
seq__20369 = G__20524;
chunk__20370 = G__20525;
count__20371 = G__20526;
i__20372 = G__20527;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__20369);
if(temp__5804__auto__){
var seq__20369__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20369__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__20369__$1);
var G__20530 = cljs.core.chunk_rest(seq__20369__$1);
var G__20531 = c__5568__auto__;
var G__20532 = cljs.core.count(c__5568__auto__);
var G__20533 = (0);
seq__20369 = G__20530;
chunk__20370 = G__20531;
count__20371 = G__20532;
i__20372 = G__20533;
continue;
} else {
var vec__20385 = cljs.core.first(seq__20369__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20385,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20385,(1),null);
var temp__5802__auto___20534 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5802__auto___20534)){
var effect_fn_20536 = temp__5802__auto___20534;
(effect_fn_20536.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20536.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20536.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20537 = cljs.core.next(seq__20369__$1);
var G__20538 = null;
var G__20539 = (0);
var G__20540 = (0);
seq__20369 = G__20537;
chunk__20370 = G__20538;
count__20371 = G__20539;
i__20372 = G__20540;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__19880__auto___20541 = re_frame.interop.now();
var duration__19881__auto___20542 = (end__19880__auto___20541 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__19881__auto___20542,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__19880__auto___20541);
} else {
}
}}finally {(re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__20363);
}} else {
var effects = new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context);
var effects_without_db = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(effects,new cljs.core.Keyword(null,"db","db",993250759));
var temp__5804__auto___20544 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(effects);
if(cljs.core.truth_(temp__5804__auto___20544)){
var new_db_20545 = temp__5804__auto___20544;
var fexpr__20388_20546 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,new cljs.core.Keyword(null,"db","db",993250759),false);
(fexpr__20388_20546.cljs$core$IFn$_invoke$arity$1 ? fexpr__20388_20546.cljs$core$IFn$_invoke$arity$1(new_db_20545) : fexpr__20388_20546.call(null,new_db_20545));
} else {
}

var seq__20390 = cljs.core.seq(effects_without_db);
var chunk__20391 = null;
var count__20392 = (0);
var i__20393 = (0);
while(true){
if((i__20393 < count__20392)){
var vec__20409 = chunk__20391.cljs$core$IIndexed$_nth$arity$2(null,i__20393);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20409,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20409,(1),null);
var temp__5802__auto___20547 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5802__auto___20547)){
var effect_fn_20548 = temp__5802__auto___20547;
(effect_fn_20548.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20548.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20548.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20549 = seq__20390;
var G__20550 = chunk__20391;
var G__20551 = count__20392;
var G__20552 = (i__20393 + (1));
seq__20390 = G__20549;
chunk__20391 = G__20550;
count__20392 = G__20551;
i__20393 = G__20552;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__20390);
if(temp__5804__auto__){
var seq__20390__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20390__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__20390__$1);
var G__20553 = cljs.core.chunk_rest(seq__20390__$1);
var G__20554 = c__5568__auto__;
var G__20555 = cljs.core.count(c__5568__auto__);
var G__20556 = (0);
seq__20390 = G__20553;
chunk__20391 = G__20554;
count__20392 = G__20555;
i__20393 = G__20556;
continue;
} else {
var vec__20424 = cljs.core.first(seq__20390__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20424,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20424,(1),null);
var temp__5802__auto___20557 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5802__auto___20557)){
var effect_fn_20558 = temp__5802__auto___20557;
(effect_fn_20558.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20558.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20558.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__20559 = cljs.core.next(seq__20390__$1);
var G__20560 = null;
var G__20561 = (0);
var G__20562 = (0);
seq__20390 = G__20559;
chunk__20391 = G__20560;
count__20392 = G__20561;
i__20393 = G__20562;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.dispatch_later = (function re_frame$fx$dispatch_later(p__20432){
var map__20434 = p__20432;
var map__20434__$1 = cljs.core.__destructure_map(map__20434);
var effect = map__20434__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20434__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20434__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
return re_frame.interop.set_timeout_BANG_((function (){
return re_frame.router.dispatch(dispatch);
}),ms);
}
});
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
if(cljs.core.map_QMARK_(value)){
return re_frame.fx.dispatch_later(value);
} else {
var seq__20435 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__20436 = null;
var count__20437 = (0);
var i__20438 = (0);
while(true){
if((i__20438 < count__20437)){
var effect = chunk__20436.cljs$core$IIndexed$_nth$arity$2(null,i__20438);
re_frame.fx.dispatch_later(effect);


var G__20563 = seq__20435;
var G__20564 = chunk__20436;
var G__20565 = count__20437;
var G__20566 = (i__20438 + (1));
seq__20435 = G__20563;
chunk__20436 = G__20564;
count__20437 = G__20565;
i__20438 = G__20566;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__20435);
if(temp__5804__auto__){
var seq__20435__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20435__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__20435__$1);
var G__20567 = cljs.core.chunk_rest(seq__20435__$1);
var G__20568 = c__5568__auto__;
var G__20569 = cljs.core.count(c__5568__auto__);
var G__20570 = (0);
seq__20435 = G__20567;
chunk__20436 = G__20568;
count__20437 = G__20569;
i__20438 = G__20570;
continue;
} else {
var effect = cljs.core.first(seq__20435__$1);
re_frame.fx.dispatch_later(effect);


var G__20571 = cljs.core.next(seq__20435__$1);
var G__20572 = null;
var G__20573 = (0);
var G__20574 = (0);
seq__20435 = G__20571;
chunk__20436 = G__20572;
count__20437 = G__20573;
i__20438 = G__20574;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"fx","fx",-1237829572),(function (seq_of_effects){
if((!(cljs.core.sequential_QMARK_(seq_of_effects)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect expects a seq, but was given ",cljs.core.type(seq_of_effects)], 0));
} else {
var seq__20451 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,seq_of_effects));
var chunk__20452 = null;
var count__20453 = (0);
var i__20454 = (0);
while(true){
if((i__20454 < count__20453)){
var vec__20467 = chunk__20452.cljs$core$IIndexed$_nth$arity$2(null,i__20454);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20467,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20467,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"db","db",993250759),effect_key)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect should not contain a :db effect"], 0));
} else {
}

var temp__5802__auto___20575 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5802__auto___20575)){
var effect_fn_20576 = temp__5802__auto___20575;
(effect_fn_20576.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20576.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20576.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: in \":fx\" effect found ",effect_key," which has no associated handler. Ignoring."], 0));
}


var G__20577 = seq__20451;
var G__20578 = chunk__20452;
var G__20579 = count__20453;
var G__20580 = (i__20454 + (1));
seq__20451 = G__20577;
chunk__20452 = G__20578;
count__20453 = G__20579;
i__20454 = G__20580;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__20451);
if(temp__5804__auto__){
var seq__20451__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20451__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__20451__$1);
var G__20581 = cljs.core.chunk_rest(seq__20451__$1);
var G__20582 = c__5568__auto__;
var G__20583 = cljs.core.count(c__5568__auto__);
var G__20584 = (0);
seq__20451 = G__20581;
chunk__20452 = G__20582;
count__20453 = G__20583;
i__20454 = G__20584;
continue;
} else {
var vec__20475 = cljs.core.first(seq__20451__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20475,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20475,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"db","db",993250759),effect_key)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: \":fx\" effect should not contain a :db effect"], 0));
} else {
}

var temp__5802__auto___20587 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5802__auto___20587)){
var effect_fn_20588 = temp__5802__auto___20587;
(effect_fn_20588.cljs$core$IFn$_invoke$arity$1 ? effect_fn_20588.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_20588.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: in \":fx\" effect found ",effect_key," which has no associated handler. Ignoring."], 0));
}


var G__20589 = cljs.core.next(seq__20451__$1);
var G__20590 = null;
var G__20591 = (0);
var G__20592 = (0);
seq__20451 = G__20589;
chunk__20452 = G__20590;
count__20453 = G__20591;
i__20454 = G__20592;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__20486 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__20487 = null;
var count__20488 = (0);
var i__20489 = (0);
while(true){
if((i__20489 < count__20488)){
var event = chunk__20487.cljs$core$IIndexed$_nth$arity$2(null,i__20489);
re_frame.router.dispatch(event);


var G__20595 = seq__20486;
var G__20596 = chunk__20487;
var G__20597 = count__20488;
var G__20598 = (i__20489 + (1));
seq__20486 = G__20595;
chunk__20487 = G__20596;
count__20488 = G__20597;
i__20489 = G__20598;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__20486);
if(temp__5804__auto__){
var seq__20486__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20486__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__20486__$1);
var G__20599 = cljs.core.chunk_rest(seq__20486__$1);
var G__20600 = c__5568__auto__;
var G__20601 = cljs.core.count(c__5568__auto__);
var G__20602 = (0);
seq__20486 = G__20599;
chunk__20487 = G__20600;
count__20488 = G__20601;
i__20489 = G__20602;
continue;
} else {
var event = cljs.core.first(seq__20486__$1);
re_frame.router.dispatch(event);


var G__20603 = cljs.core.next(seq__20486__$1);
var G__20604 = null;
var G__20605 = (0);
var G__20606 = (0);
seq__20486 = G__20603;
chunk__20487 = G__20604;
count__20488 = G__20605;
i__20489 = G__20606;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__20504 = cljs.core.seq(value);
var chunk__20505 = null;
var count__20506 = (0);
var i__20507 = (0);
while(true){
if((i__20507 < count__20506)){
var event = chunk__20505.cljs$core$IIndexed$_nth$arity$2(null,i__20507);
clear_event(event);


var G__20608 = seq__20504;
var G__20609 = chunk__20505;
var G__20610 = count__20506;
var G__20611 = (i__20507 + (1));
seq__20504 = G__20608;
chunk__20505 = G__20609;
count__20506 = G__20610;
i__20507 = G__20611;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__20504);
if(temp__5804__auto__){
var seq__20504__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__20504__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__20504__$1);
var G__20613 = cljs.core.chunk_rest(seq__20504__$1);
var G__20614 = c__5568__auto__;
var G__20615 = cljs.core.count(c__5568__auto__);
var G__20616 = (0);
seq__20504 = G__20613;
chunk__20505 = G__20614;
count__20506 = G__20615;
i__20507 = G__20616;
continue;
} else {
var event = cljs.core.first(seq__20504__$1);
clear_event(event);


var G__20617 = cljs.core.next(seq__20504__$1);
var G__20618 = null;
var G__20619 = (0);
var G__20620 = (0);
seq__20504 = G__20617;
chunk__20505 = G__20618;
count__20506 = G__20619;
i__20507 = G__20620;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
