goog.provide('re_frame.trace');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});
/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__19902){
var map__19903 = p__19902;
var map__19903__$1 = cljs.core.__destructure_map(map__19903);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19903__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19903__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19903__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19903__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__5045__auto__ = child_of;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__19906_19935 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__19907_19936 = null;
var count__19908_19937 = (0);
var i__19909_19938 = (0);
while(true){
if((i__19909_19938 < count__19908_19937)){
var vec__19921_19939 = chunk__19907_19936.cljs$core$IIndexed$_nth$arity$2(null,i__19909_19938);
var k_19940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19921_19939,(0),null);
var cb_19941 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19921_19939,(1),null);
try{var G__19925_19942 = cljs.core.deref(re_frame.trace.traces);
(cb_19941.cljs$core$IFn$_invoke$arity$1 ? cb_19941.cljs$core$IFn$_invoke$arity$1(G__19925_19942) : cb_19941.call(null,G__19925_19942));
}catch (e19924){var e_19943 = e19924;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_19940,"while storing",cljs.core.deref(re_frame.trace.traces),e_19943], 0));
}

var G__19944 = seq__19906_19935;
var G__19945 = chunk__19907_19936;
var G__19946 = count__19908_19937;
var G__19947 = (i__19909_19938 + (1));
seq__19906_19935 = G__19944;
chunk__19907_19936 = G__19945;
count__19908_19937 = G__19946;
i__19909_19938 = G__19947;
continue;
} else {
var temp__5804__auto___19948 = cljs.core.seq(seq__19906_19935);
if(temp__5804__auto___19948){
var seq__19906_19949__$1 = temp__5804__auto___19948;
if(cljs.core.chunked_seq_QMARK_(seq__19906_19949__$1)){
var c__5568__auto___19950 = cljs.core.chunk_first(seq__19906_19949__$1);
var G__19951 = cljs.core.chunk_rest(seq__19906_19949__$1);
var G__19952 = c__5568__auto___19950;
var G__19953 = cljs.core.count(c__5568__auto___19950);
var G__19954 = (0);
seq__19906_19935 = G__19951;
chunk__19907_19936 = G__19952;
count__19908_19937 = G__19953;
i__19909_19938 = G__19954;
continue;
} else {
var vec__19926_19955 = cljs.core.first(seq__19906_19949__$1);
var k_19956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19926_19955,(0),null);
var cb_19957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19926_19955,(1),null);
try{var G__19931_19958 = cljs.core.deref(re_frame.trace.traces);
(cb_19957.cljs$core$IFn$_invoke$arity$1 ? cb_19957.cljs$core$IFn$_invoke$arity$1(G__19931_19958) : cb_19957.call(null,G__19931_19958));
}catch (e19929){var e_19959 = e19929;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_19956,"while storing",cljs.core.deref(re_frame.trace.traces),e_19959], 0));
}

var G__19960 = cljs.core.next(seq__19906_19949__$1);
var G__19961 = null;
var G__19962 = (0);
var G__19963 = (0);
seq__19906_19935 = G__19960;
chunk__19907_19936 = G__19961;
count__19908_19937 = G__19962;
i__19909_19938 = G__19963;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
