goog.provide('websocket_fx.core');
if((typeof websocket_fx !== 'undefined') && (typeof websocket_fx.core !== 'undefined') && (typeof websocket_fx.core.CONNECTIONS !== 'undefined')){
} else {
websocket_fx.core.CONNECTIONS = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
}
websocket_fx.core.get_websocket_port = (function websocket_fx$core$get_websocket_port(){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((window["location"]["port"]));
});
websocket_fx.core.get_websocket_host = (function websocket_fx$core$get_websocket_host(){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((window["location"]["hostname"]));
});
websocket_fx.core.get_websocket_proto = (function websocket_fx$core$get_websocket_proto(){
var proto = cljs.core.str.cljs$core$IFn$_invoke$arity$1((window["location"]["protocol"]));
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 2, ["http:","ws","https:","wss"], null),proto);
});
websocket_fx.core.websocket_url = (function websocket_fx$core$websocket_url(){
var proto = websocket_fx.core.get_websocket_proto();
var host = websocket_fx.core.get_websocket_host();
var port = websocket_fx.core.get_websocket_port();
var path = "/ws";
if(clojure.string.blank_QMARK_(port)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(proto),"://",host,path].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(proto),"://",host,":",port,path].join('');
}
});
websocket_fx.core.dissoc_in = (function websocket_fx$core$dissoc_in(m,p__57499){
var vec__57500 = p__57499;
var seq__57501 = cljs.core.seq(vec__57500);
var first__57502 = cljs.core.first(seq__57501);
var seq__57501__$1 = cljs.core.next(seq__57501);
var k = first__57502;
var ks = seq__57501__$1;
if(ks){
if(cljs.core.map_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k))){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(m,k,(function (p1__57496_SHARP_){
return (websocket_fx.core.dissoc_in.cljs$core$IFn$_invoke$arity$2 ? websocket_fx.core.dissoc_in.cljs$core$IFn$_invoke$arity$2(p1__57496_SHARP_,ks) : websocket_fx.core.dissoc_in.call(null,p1__57496_SHARP_,ks));
}));
} else {
return m;
}
} else {
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,k);
}
});
websocket_fx.core.concatv = (function websocket_fx$core$concatv(var_args){
var args__5775__auto__ = [];
var len__5769__auto___58289 = arguments.length;
var i__5770__auto___58290 = (0);
while(true){
if((i__5770__auto___58290 < len__5769__auto___58289)){
args__5775__auto__.push((arguments[i__5770__auto___58290]));

var G__58291 = (i__5770__auto___58290 + (1));
i__5770__auto___58290 = G__58291;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return websocket_fx.core.concatv.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(websocket_fx.core.concatv.cljs$core$IFn$_invoke$arity$variadic = (function (more){
return cljs.core.vec(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,more));
}));

(websocket_fx.core.concatv.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(websocket_fx.core.concatv.cljs$lang$applyTo = (function (seq57505){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq57505));
}));

websocket_fx.core.keyword__GT_format = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"edn","edn",1317840885),haslett.format.edn,new cljs.core.Keyword(null,"json","json",1279968570),haslett.format.json,new cljs.core.Keyword(null,"transit-json","transit-json",1168016579),haslett.format.transit,new cljs.core.Keyword(null,"transit-json-verbose","transit-json-verbose",2127200557),haslett.format.transit], null);
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("websocket-fx.core","connect","websocket-fx.core/connect",-1719352170),(function (p__57514,p__57515){
var map__57518 = p__57514;
var map__57518__$1 = cljs.core.__destructure_map(map__57518);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57518__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__57519 = p__57515;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57519,(0),null);
var socket_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57519,(1),null);
var command = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57519,(2),null);
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"pending","pending",-220036727),new cljs.core.Keyword(null,"options","options",99638489),command], null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id], null),data),new cljs.core.Keyword("websocket-fx.core","connect","websocket-fx.core/connect",-1719352170),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),socket_id,new cljs.core.Keyword(null,"options","options",99638489),command], null)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("websocket-fx.core","disconnect","websocket-fx.core/disconnect",1210384580),(function (p__57528,p__57529){
var map__57530 = p__57528;
var map__57530__$1 = cljs.core.__destructure_map(map__57530);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57530__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__57531 = p__57529;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57531,(0),null);
var socket_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57531,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),websocket_fx.core.dissoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id], null)),new cljs.core.Keyword("websocket-fx.core","disconnect","websocket-fx.core/disconnect",1210384580),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),socket_id], null)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("websocket-fx.core","connected","websocket-fx.core/connected",-2070989576),(function (p__57535,p__57536){
var map__57538 = p__57535;
var map__57538__$1 = cljs.core.__destructure_map(map__57538);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57538__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__57539 = p__57536;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57539,(0),null);
var socket_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57539,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"status","status",-1997798413)], null),new cljs.core.Keyword(null,"connected","connected",-169833045)),new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),cljs.core.vec((function (){var iter__5523__auto__ = (function websocket_fx$core$iter__57544(s__57545){
return (new cljs.core.LazySeq(null,(function (){
var s__57545__$1 = s__57545;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__57545__$1);
if(temp__5804__auto__){
var s__57545__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__57545__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__57545__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__57547 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__57546 = (0);
while(true){
if((i__57546 < size__5522__auto__)){
var sub = cljs.core._nth(c__5521__auto__,i__57546);
cljs.core.chunk_append(b__57547,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","subscribe","websocket-fx.core/subscribe",-927248639),socket_id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(sub,new cljs.core.Keyword(null,"id","id",-1388402092)),sub], null));

var G__58295 = (i__57546 + (1));
i__57546 = G__58295;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__57547),websocket_fx$core$iter__57544(cljs.core.chunk_rest(s__57545__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__57547),null);
}
} else {
var sub = cljs.core.first(s__57545__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","subscribe","websocket-fx.core/subscribe",-927248639),socket_id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(sub,new cljs.core.Keyword(null,"id","id",-1388402092)),sub], null),websocket_fx$core$iter__57544(cljs.core.rest(s__57545__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(cljs.core.vals(cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"subscriptions","subscriptions",1250949776)], null),cljs.core.PersistentArrayMap.EMPTY)));
})())], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("websocket-fx.core","disconnected","websocket-fx.core/disconnected",-1639781829),(function (p__57553,p__57554){
var map__57555 = p__57553;
var map__57555__$1 = cljs.core.__destructure_map(map__57555);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57555__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__57556 = p__57554;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57556,(0),null);
var socket_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57556,(1),null);
var cause = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57556,(2),null);
var options = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"options","options",99638489)], null));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"status","status",-1997798413)], null),new cljs.core.Keyword(null,"reconnecting","reconnecting",-172463711)),new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),cljs.core.vec((function (){var iter__5523__auto__ = (function websocket_fx$core$iter__57559(s__57560){
return (new cljs.core.LazySeq(null,(function (){
var s__57560__$1 = s__57560;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__57560__$1);
if(temp__5804__auto__){
var s__57560__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__57560__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__57560__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__57562 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__57561 = (0);
while(true){
if((i__57561 < size__5522__auto__)){
var request_id = cljs.core._nth(c__5521__auto__,i__57561);
cljs.core.chunk_append(b__57562,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","request-timeout","websocket-fx.core/request-timeout",1441765950),socket_id,request_id,cause], null));

var G__58298 = (i__57561 + (1));
i__57561 = G__58298;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__57562),websocket_fx$core$iter__57559(cljs.core.chunk_rest(s__57560__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__57562),null);
}
} else {
var request_id = cljs.core.first(s__57560__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","request-timeout","websocket-fx.core/request-timeout",1441765950),socket_id,request_id,cause], null),websocket_fx$core$iter__57559(cljs.core.rest(s__57560__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(cljs.core.keys(cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"requests","requests",-733055638)], null),cljs.core.PersistentArrayMap.EMPTY)));
})()),new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ms","ms",-1152709733),(2000),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","connect","websocket-fx.core/connect",-1719352170),socket_id,options], null)], null)], null)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("websocket-fx.core","request","websocket-fx.core/request",430619552),(function (p__57571,p__57572){
var map__57573 = p__57571;
var map__57573__$1 = cljs.core.__destructure_map(map__57573);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57573__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__57574 = p__57572;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57574,(0),null);
var socket_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57574,(1),null);
var map__57577 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57574,(2),null);
var map__57577__$1 = cljs.core.__destructure_map(map__57577);
var command = map__57577__$1;
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57577__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57577__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318));
var payload = (function (){var G__57578 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.random_uuid(),new cljs.core.Keyword(null,"proto","proto",811784976),new cljs.core.Keyword(null,"request","request",1772954723),new cljs.core.Keyword(null,"data","data",-232669377),message], null);
if((!((timeout == null)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__57578,new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout);
} else {
return G__57578;
}
})();
var path = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"requests","requests",-733055638),cljs.core.get.cljs$core$IFn$_invoke$arity$2(payload,new cljs.core.Keyword(null,"id","id",-1388402092))], null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in(db,path,command),new cljs.core.Keyword("websocket-fx.core","ws-message","websocket-fx.core/ws-message",413406340),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),socket_id,new cljs.core.Keyword(null,"message","message",-406056002),payload], null)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("websocket-fx.core","request-response","websocket-fx.core/request-response",1132952098),(function (p__57583,p__57584){
var map__57587 = p__57583;
var map__57587__$1 = cljs.core.__destructure_map(map__57587);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57587__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__57588 = p__57584;
var seq__57589 = cljs.core.seq(vec__57588);
var first__57590 = cljs.core.first(seq__57589);
var seq__57589__$1 = cljs.core.next(seq__57589);
var _ = first__57590;
var first__57590__$1 = cljs.core.first(seq__57589__$1);
var seq__57589__$2 = cljs.core.next(seq__57589__$1);
var socket_id = first__57590__$1;
var first__57590__$2 = cljs.core.first(seq__57589__$2);
var seq__57589__$3 = cljs.core.next(seq__57589__$2);
var request_id = first__57590__$2;
var more = seq__57589__$3;
var path = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"requests","requests",-733055638),request_id], null);
var request = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,path);
var G__57592 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),websocket_fx.core.dissoc_in(db,path)], null);
if(cljs.core.contains_QMARK_(request,new cljs.core.Keyword(null,"on-response","on-response",-1635376834))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__57592,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),websocket_fx.core.concatv.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"on-response","on-response",-1635376834).cljs$core$IFn$_invoke$arity$1(request),more], 0)));
} else {
return G__57592;
}
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("websocket-fx.core","request-timeout","websocket-fx.core/request-timeout",1441765950),(function (p__57596,p__57597){
var map__57598 = p__57596;
var map__57598__$1 = cljs.core.__destructure_map(map__57598);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57598__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__57599 = p__57597;
var seq__57600 = cljs.core.seq(vec__57599);
var first__57601 = cljs.core.first(seq__57600);
var seq__57600__$1 = cljs.core.next(seq__57600);
var _ = first__57601;
var first__57601__$1 = cljs.core.first(seq__57600__$1);
var seq__57600__$2 = cljs.core.next(seq__57600__$1);
var socket_id = first__57601__$1;
var first__57601__$2 = cljs.core.first(seq__57600__$2);
var seq__57600__$3 = cljs.core.next(seq__57600__$2);
var request_id = first__57601__$2;
var more = seq__57600__$3;
var path = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"requests","requests",-733055638),request_id], null);
var request = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,path);
var G__57603 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),websocket_fx.core.dissoc_in(db,path)], null);
if(cljs.core.contains_QMARK_(request,new cljs.core.Keyword(null,"on-timeout","on-timeout",-672710385))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__57603,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),websocket_fx.core.concatv.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"on-timeout","on-timeout",-672710385).cljs$core$IFn$_invoke$arity$1(request),more], 0)));
} else {
return G__57603;
}
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("websocket-fx.core","subscribe","websocket-fx.core/subscribe",-927248639),(function (p__57609,p__57610){
var map__57611 = p__57609;
var map__57611__$1 = cljs.core.__destructure_map(map__57611);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57611__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__57612 = p__57610;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57612,(0),null);
var socket_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57612,(1),null);
var topic = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57612,(2),null);
var map__57615 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57612,(3),null);
var map__57615__$1 = cljs.core.__destructure_map(map__57615);
var command = map__57615__$1;
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57615__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var path = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"subscriptions","subscriptions",1250949776),topic], null);
var payload = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),topic,new cljs.core.Keyword(null,"proto","proto",811784976),new cljs.core.Keyword(null,"subscription","subscription",1949009182),new cljs.core.Keyword(null,"data","data",-232669377),message], null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in(db,path,command),new cljs.core.Keyword("websocket-fx.core","ws-message","websocket-fx.core/ws-message",413406340),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),socket_id,new cljs.core.Keyword(null,"message","message",-406056002),payload], null)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("websocket-fx.core","subscription-message","websocket-fx.core/subscription-message",-580707945),(function (p__57617,p__57618){
var map__57619 = p__57617;
var map__57619__$1 = cljs.core.__destructure_map(map__57619);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57619__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__57620 = p__57618;
var seq__57621 = cljs.core.seq(vec__57620);
var first__57622 = cljs.core.first(seq__57621);
var seq__57621__$1 = cljs.core.next(seq__57621);
var _ = first__57622;
var first__57622__$1 = cljs.core.first(seq__57621__$1);
var seq__57621__$2 = cljs.core.next(seq__57621__$1);
var socket_id = first__57622__$1;
var first__57622__$2 = cljs.core.first(seq__57621__$2);
var seq__57621__$3 = cljs.core.next(seq__57621__$2);
var subscription_id = first__57622__$2;
var more = seq__57621__$3;
var path = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"subscriptions","subscriptions",1250949776),subscription_id], null);
var subscription = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,path);
var G__57624 = cljs.core.PersistentArrayMap.EMPTY;
if(cljs.core.contains_QMARK_(subscription,new cljs.core.Keyword(null,"on-message","on-message",1662987808))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__57624,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),websocket_fx.core.concatv.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"on-message","on-message",1662987808).cljs$core$IFn$_invoke$arity$1(subscription),more], 0)));
} else {
return G__57624;
}
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("websocket-fx.core","unsubscribe","websocket-fx.core/unsubscribe",364040416),(function (p__57628,p__57629){
var map__57634 = p__57628;
var map__57634__$1 = cljs.core.__destructure_map(map__57634);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57634__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__57635 = p__57629;
var seq__57636 = cljs.core.seq(vec__57635);
var first__57637 = cljs.core.first(seq__57636);
var seq__57636__$1 = cljs.core.next(seq__57636);
var _ = first__57637;
var first__57637__$1 = cljs.core.first(seq__57636__$1);
var seq__57636__$2 = cljs.core.next(seq__57636__$1);
var socket_id = first__57637__$1;
var first__57637__$2 = cljs.core.first(seq__57636__$2);
var seq__57636__$3 = cljs.core.next(seq__57636__$2);
var subscription_id = first__57637__$2;
var more = seq__57636__$3;
var path = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"subscriptions","subscriptions",1250949776),subscription_id], null);
var payload = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),subscription_id,new cljs.core.Keyword(null,"proto","proto",811784976),new cljs.core.Keyword(null,"subscription","subscription",1949009182),new cljs.core.Keyword(null,"close","close",1835149582),true], null);
var subscription = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,path);
var G__57643 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),websocket_fx.core.dissoc_in(db,path)], null);
var G__57643__$1 = (((!((subscription == null))))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__57643,new cljs.core.Keyword("websocket-fx.core","ws-message","websocket-fx.core/ws-message",413406340),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),socket_id,new cljs.core.Keyword(null,"message","message",-406056002),payload], null)):G__57643);
if(cljs.core.contains_QMARK_(subscription,new cljs.core.Keyword(null,"on-close","on-close",-761178394))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__57643__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),websocket_fx.core.concatv.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"on-close","on-close",-761178394).cljs$core$IFn$_invoke$arity$1(subscription),more], 0)));
} else {
return G__57643__$1;
}
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("websocket-fx.core","subscription-closed","websocket-fx.core/subscription-closed",-1831119820),(function (p__57649,p__57650){
var map__57652 = p__57649;
var map__57652__$1 = cljs.core.__destructure_map(map__57652);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57652__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__57653 = p__57650;
var seq__57654 = cljs.core.seq(vec__57653);
var first__57655 = cljs.core.first(seq__57654);
var seq__57654__$1 = cljs.core.next(seq__57654);
var _ = first__57655;
var first__57655__$1 = cljs.core.first(seq__57654__$1);
var seq__57654__$2 = cljs.core.next(seq__57654__$1);
var socket_id = first__57655__$1;
var first__57655__$2 = cljs.core.first(seq__57654__$2);
var seq__57654__$3 = cljs.core.next(seq__57654__$2);
var subscription_id = first__57655__$2;
var more = seq__57654__$3;
var path = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"subscriptions","subscriptions",1250949776),subscription_id], null);
var temp__5806__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,path);
if((temp__5806__auto__ == null)){
return null;
} else {
var subscription = temp__5806__auto__;
var G__57657 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),websocket_fx.core.dissoc_in(db,path)], null);
if(cljs.core.contains_QMARK_(subscription,new cljs.core.Keyword(null,"on-close","on-close",-761178394))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__57657,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),websocket_fx.core.concatv.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"on-close","on-close",-761178394).cljs$core$IFn$_invoke$arity$1(subscription),more], 0)));
} else {
return G__57657;
}
}
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("websocket-fx.core","push","websocket-fx.core/push",1604923786),(function (_,p__57659){
var vec__57660 = p__57659;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57660,(0),null);
var socket_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57660,(1),null);
var command = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57660,(2),null);
var payload = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.random_uuid(),new cljs.core.Keyword(null,"proto","proto",811784976),new cljs.core.Keyword(null,"push","push",799791267),new cljs.core.Keyword(null,"data","data",-232669377),command], null);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("websocket-fx.core","ws-message","websocket-fx.core/ws-message",413406340),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),socket_id,new cljs.core.Keyword(null,"message","message",-406056002),payload], null)], null);
}));
re_frame.core.reg_fx(new cljs.core.Keyword("websocket-fx.core","connect","websocket-fx.core/connect",-1719352170),(function (p__57668){
var map__57669 = p__57668;
var map__57669__$1 = cljs.core.__destructure_map(map__57669);
var socket_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57669__$1,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280));
var map__57670 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57669__$1,new cljs.core.Keyword(null,"options","options",99638489));
var map__57670__$1 = cljs.core.__destructure_map(map__57670);
var url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__57670__$1,new cljs.core.Keyword(null,"url","url",276297046),websocket_fx.core.websocket_url());
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__57670__$1,new cljs.core.Keyword(null,"format","format",-1306924766),new cljs.core.Keyword(null,"edn","edn",1317840885));
var on_connect = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57670__$1,new cljs.core.Keyword(null,"on-connect","on-connect",-1148973056));
var on_disconnect = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57670__$1,new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814));
var sink_proxy = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((100));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(websocket_fx.core.CONNECTIONS,cljs.core.assoc,socket_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"sink","sink",186835933),sink_proxy], null));

var c__44773__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_57886){
var state_val_57887 = (state_57886[(1)]);
if((state_val_57887 === (1))){
var inst_57674 = [new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_57675 = (websocket_fx.core.keyword__GT_format.cljs$core$IFn$_invoke$arity$1 ? websocket_fx.core.keyword__GT_format.cljs$core$IFn$_invoke$arity$1(format) : websocket_fx.core.keyword__GT_format.call(null,format));
var inst_57676 = [inst_57675];
var inst_57677 = cljs.core.PersistentHashMap.fromArrays(inst_57674,inst_57676);
var inst_57678 = haslett.client.connect.cljs$core$IFn$_invoke$arity$2(url,inst_57677);
var state_57886__$1 = state_57886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57886__$1,(2),inst_57678);
} else {
if((state_val_57887 === (2))){
var inst_57682 = (state_57886[(7)]);
var inst_57681 = (state_57886[(8)]);
var inst_57686 = (state_57886[(9)]);
var inst_57684 = (state_57886[(10)]);
var inst_57685 = (state_57886[(11)]);
var inst_57683 = (state_57886[(12)]);
var inst_57680 = (state_57886[(2)]);
var inst_57681__$1 = cljs.core.__destructure_map(inst_57680);
var inst_57682__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57681__$1,new cljs.core.Keyword(null,"socket","socket",59137063));
var inst_57683__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57681__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var inst_57684__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57681__$1,new cljs.core.Keyword(null,"sink","sink",186835933));
var inst_57685__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57681__$1,new cljs.core.Keyword(null,"close-status","close-status",-239776180));
var inst_57686__$1 = cljs.core.async.mult(inst_57683__$1);
var inst_57687 = [new cljs.core.Keyword(null,"sink","sink",186835933),new cljs.core.Keyword(null,"source","source",-433931539),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_57688 = [sink_proxy,inst_57683__$1,inst_57682__$1];
var inst_57689 = cljs.core.PersistentHashMap.fromArrays(inst_57687,inst_57688);
var inst_57690 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(websocket_fx.core.CONNECTIONS,cljs.core.assoc,socket_id,inst_57689);
var inst_57712 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_57714 = (function (){var map__57673 = inst_57681__$1;
var socket = inst_57682__$1;
var source = inst_57683__$1;
var sink = inst_57684__$1;
var close_status = inst_57685__$1;
var mult = inst_57686__$1;
var c__44773__auto____$1 = inst_57712;
return (function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_57710){
var state_val_57711 = (state_57710[(1)]);
if((state_val_57711 === (1))){
var state_57710__$1 = state_57710;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57710__$1,(2),close_status);
} else {
if((state_val_57711 === (2))){
var inst_57692 = (state_57710[(7)]);
var inst_57692__$1 = (state_57710[(2)]);
var inst_57693 = (inst_57692__$1 == null);
var state_57710__$1 = (function (){var statearr_57929 = state_57710;
(statearr_57929[(7)] = inst_57692__$1);

return statearr_57929;
})();
if(cljs.core.truth_(inst_57693)){
var statearr_57930_58323 = state_57710__$1;
(statearr_57930_58323[(1)] = (3));

} else {
var statearr_57931_58324 = state_57710__$1;
(statearr_57931_58324[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57711 === (3))){
var state_57710__$1 = state_57710;
var statearr_57932_58325 = state_57710__$1;
(statearr_57932_58325[(2)] = null);

(statearr_57932_58325[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57711 === (4))){
var inst_57692 = (state_57710[(7)]);
var inst_57696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57697 = [new cljs.core.Keyword("websocket-fx.core","disconnected","websocket-fx.core/disconnected",-1639781829),socket_id,inst_57692];
var inst_57698 = (new cljs.core.PersistentVector(null,3,(5),inst_57696,inst_57697,null));
var inst_57699 = re_frame.core.dispatch(inst_57698);
var inst_57700 = (on_disconnect == null);
var inst_57701 = cljs.core.not(inst_57700);
var state_57710__$1 = (function (){var statearr_57935 = state_57710;
(statearr_57935[(8)] = inst_57699);

return statearr_57935;
})();
if(inst_57701){
var statearr_57939_58326 = state_57710__$1;
(statearr_57939_58326[(1)] = (6));

} else {
var statearr_57940_58327 = state_57710__$1;
(statearr_57940_58327[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57711 === (5))){
var inst_57708 = (state_57710[(2)]);
var state_57710__$1 = state_57710;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57710__$1,inst_57708);
} else {
if((state_val_57711 === (6))){
var inst_57703 = re_frame.core.dispatch(on_disconnect);
var state_57710__$1 = state_57710;
var statearr_57946_58328 = state_57710__$1;
(statearr_57946_58328[(2)] = inst_57703);

(statearr_57946_58328[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57711 === (7))){
var state_57710__$1 = state_57710;
var statearr_57947_58330 = state_57710__$1;
(statearr_57947_58330[(2)] = null);

(statearr_57947_58330[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57711 === (8))){
var inst_57706 = (state_57710[(2)]);
var state_57710__$1 = state_57710;
var statearr_57948_58332 = state_57710__$1;
(statearr_57948_58332[(2)] = inst_57706);

(statearr_57948_58332[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var websocket_fx$core$state_machine__44577__auto__ = null;
var websocket_fx$core$state_machine__44577__auto____0 = (function (){
var statearr_57955 = [null,null,null,null,null,null,null,null,null];
(statearr_57955[(0)] = websocket_fx$core$state_machine__44577__auto__);

(statearr_57955[(1)] = (1));

return statearr_57955;
});
var websocket_fx$core$state_machine__44577__auto____1 = (function (state_57710){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_57710);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e57973){var ex__44580__auto__ = e57973;
var statearr_57975_58334 = state_57710;
(statearr_57975_58334[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_57710[(4)]))){
var statearr_57977_58335 = state_57710;
(statearr_57977_58335[(1)] = cljs.core.first((state_57710[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58336 = state_57710;
state_57710 = G__58336;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
websocket_fx$core$state_machine__44577__auto__ = function(state_57710){
switch(arguments.length){
case 0:
return websocket_fx$core$state_machine__44577__auto____0.call(this);
case 1:
return websocket_fx$core$state_machine__44577__auto____1.call(this,state_57710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
websocket_fx$core$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = websocket_fx$core$state_machine__44577__auto____0;
websocket_fx$core$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = websocket_fx$core$state_machine__44577__auto____1;
return websocket_fx$core$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_57981 = f__44774__auto__();
(statearr_57981[(6)] = c__44773__auto____$1);

return statearr_57981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
});
})();
var inst_57715 = cljs.core.async.impl.dispatch.run(inst_57714);
var inst_57717 = cljs.core.async.poll_BANG_(inst_57685__$1);
var state_57886__$1 = (function (){var statearr_57991 = state_57886;
(statearr_57991[(13)] = inst_57715);

(statearr_57991[(7)] = inst_57682__$1);

(statearr_57991[(8)] = inst_57681__$1);

(statearr_57991[(9)] = inst_57686__$1);

(statearr_57991[(10)] = inst_57684__$1);

(statearr_57991[(11)] = inst_57685__$1);

(statearr_57991[(14)] = inst_57690);

(statearr_57991[(12)] = inst_57683__$1);

return statearr_57991;
})();
if(cljs.core.truth_(inst_57717)){
var statearr_57992_58338 = state_57886__$1;
(statearr_57992_58338[(1)] = (3));

} else {
var statearr_57993_58339 = state_57886__$1;
(statearr_57993_58339[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57887 === (3))){
var state_57886__$1 = state_57886;
var statearr_57994_58340 = state_57886__$1;
(statearr_57994_58340[(2)] = null);

(statearr_57994_58340[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57887 === (4))){
var inst_57682 = (state_57886[(7)]);
var inst_57681 = (state_57886[(8)]);
var inst_57686 = (state_57886[(9)]);
var inst_57684 = (state_57886[(10)]);
var inst_57685 = (state_57886[(11)]);
var inst_57683 = (state_57886[(12)]);
var inst_57864 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_57865 = (function (){var map__57673 = inst_57681;
var socket = inst_57682;
var source = inst_57683;
var sink = inst_57684;
var close_status = inst_57685;
var mult = inst_57686;
var c__44773__auto____$1 = inst_57864;
return (function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_57862){
var state_val_57863 = (state_57862[(1)]);
if((state_val_57863 === (7))){
var inst_57858 = (state_57862[(2)]);
var state_57862__$1 = state_57862;
var statearr_57999_58344 = state_57862__$1;
(statearr_57999_58344[(2)] = inst_57858);

(statearr_57999_58344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (20))){
var state_57862__$1 = state_57862;
var statearr_58000_58346 = state_57862__$1;
(statearr_58000_58346[(2)] = null);

(statearr_58000_58346[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (1))){
var state_57862__$1 = state_57862;
var statearr_58005_58349 = state_57862__$1;
(statearr_58005_58349[(2)] = null);

(statearr_58005_58349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (4))){
var inst_57724 = (state_57862[(7)]);
var inst_57724__$1 = (state_57862[(2)]);
var inst_57725 = (inst_57724__$1 == null);
var state_57862__$1 = (function (){var statearr_58007 = state_57862;
(statearr_58007[(7)] = inst_57724__$1);

return statearr_58007;
})();
if(cljs.core.truth_(inst_57725)){
var statearr_58008_58350 = state_57862__$1;
(statearr_58008_58350[(1)] = (5));

} else {
var statearr_58009_58351 = state_57862__$1;
(statearr_58009_58351[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (15))){
var inst_57733 = (state_57862[(8)]);
var inst_57731 = (state_57862[(9)]);
var inst_57732 = (state_57862[(10)]);
var inst_57843 = [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"proto","proto",811784976),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_57844 = [inst_57731,inst_57732,inst_57733];
var inst_57845 = cljs.core.PersistentHashMap.fromArrays(inst_57843,inst_57844);
var state_57862__$1 = state_57862;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_57862__$1,(18),sink,inst_57845);
} else {
if((state_val_57863 === (21))){
var inst_57855 = (state_57862[(2)]);
var state_57862__$1 = state_57862;
var statearr_58010_58352 = state_57862__$1;
(statearr_58010_58352[(2)] = inst_57855);

(statearr_58010_58352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (13))){
var inst_57831 = (state_57862[(2)]);
var state_57862__$1 = state_57862;
var statearr_58013_58353 = state_57862__$1;
(statearr_58013_58353[(2)] = inst_57831);

(statearr_58013_58353[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (6))){
var inst_57732 = (state_57862[(10)]);
var inst_57724 = (state_57862[(7)]);
var inst_57730 = (state_57862[(11)]);
var inst_57730__$1 = cljs.core.__destructure_map(inst_57724);
var inst_57731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57730__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var inst_57732__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57730__$1,new cljs.core.Keyword(null,"proto","proto",811784976));
var inst_57733 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57730__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_57734 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57730__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var inst_57735 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_57730__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(10000));
var inst_57738 = [new cljs.core.Keyword(null,"request","request",1772954723),null];
var inst_57739 = (new cljs.core.PersistentArrayMap(null,1,inst_57738,null));
var inst_57740 = (new cljs.core.PersistentHashSet(null,inst_57739,null));
var inst_57741 = (inst_57740.cljs$core$IFn$_invoke$arity$1 ? inst_57740.cljs$core$IFn$_invoke$arity$1(inst_57732__$1) : inst_57740.call(null,inst_57732__$1));
var state_57862__$1 = (function (){var statearr_58014 = state_57862;
(statearr_58014[(8)] = inst_57733);

(statearr_58014[(9)] = inst_57731);

(statearr_58014[(12)] = inst_57735);

(statearr_58014[(10)] = inst_57732__$1);

(statearr_58014[(11)] = inst_57730__$1);

(statearr_58014[(13)] = inst_57734);

return statearr_58014;
})();
if(cljs.core.truth_(inst_57741)){
var statearr_58016_58359 = state_57862__$1;
(statearr_58016_58359[(1)] = (8));

} else {
var statearr_58017_58360 = state_57862__$1;
(statearr_58017_58360[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (17))){
var inst_57841 = (state_57862[(2)]);
var state_57862__$1 = state_57862;
var statearr_58018_58361 = state_57862__$1;
(statearr_58018_58361[(2)] = inst_57841);

(statearr_58018_58361[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (3))){
var inst_57860 = (state_57862[(2)]);
var state_57862__$1 = state_57862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57862__$1,inst_57860);
} else {
if((state_val_57863 === (12))){
var state_57862__$1 = state_57862;
var statearr_58019_58364 = state_57862__$1;
(statearr_58019_58364[(2)] = null);

(statearr_58019_58364[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (2))){
var state_57862__$1 = state_57862;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57862__$1,(4),sink_proxy);
} else {
if((state_val_57863 === (19))){
var state_57862__$1 = state_57862;
var statearr_58020_58365 = state_57862__$1;
(statearr_58020_58365[(2)] = null);

(statearr_58020_58365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (11))){
var inst_57733 = (state_57862[(8)]);
var inst_57731 = (state_57862[(9)]);
var inst_57735 = (state_57862[(12)]);
var inst_57732 = (state_57862[(10)]);
var inst_57724 = (state_57862[(7)]);
var inst_57730 = (state_57862[(11)]);
var inst_57734 = (state_57862[(13)]);
var inst_57786 = (function (){var temp__5808__auto__ = inst_57724;
var map__57728 = inst_57730;
var id = inst_57731;
var proto = inst_57732;
var data = inst_57733;
var close = inst_57734;
var timeout = inst_57735;
return (function (msg){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(msg),id);
});
})();
var inst_57787 = cljs.core.filter.cljs$core$IFn$_invoke$arity$1(inst_57786);
var inst_57788 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),inst_57787);
var inst_57789 = cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(mult,inst_57788);
var inst_57826 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_57827 = (function (){var response_chan = inst_57789;
var timeout = inst_57735;
var map__57728 = inst_57730;
var data = inst_57733;
var temp__5808__auto__ = inst_57724;
var xform = inst_57787;
var close = inst_57734;
var proto = inst_57732;
var c__44773__auto____$2 = inst_57826;
var id = inst_57731;
return (function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_57824){
var state_val_57825 = (state_57824[(1)]);
if((state_val_57825 === (7))){
var inst_57819 = (state_57824[(2)]);
var state_57824__$1 = state_57824;
var statearr_58025_58367 = state_57824__$1;
(statearr_58025_58367[(2)] = inst_57819);

(statearr_58025_58367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57825 === (1))){
var state_57824__$1 = state_57824;
var statearr_58026_58368 = state_57824__$1;
(statearr_58026_58368[(2)] = null);

(statearr_58026_58368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57825 === (4))){
var inst_57793 = (state_57824[(7)]);
var inst_57793__$1 = (state_57824[(2)]);
var inst_57794 = (inst_57793__$1 == null);
var state_57824__$1 = (function (){var statearr_58027 = state_57824;
(statearr_58027[(7)] = inst_57793__$1);

return statearr_58027;
})();
if(cljs.core.truth_(inst_57794)){
var statearr_58028_58369 = state_57824__$1;
(statearr_58028_58369[(1)] = (5));

} else {
var statearr_58029_58370 = state_57824__$1;
(statearr_58029_58370[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57825 === (6))){
var inst_57793 = (state_57824[(7)]);
var inst_57799 = cljs.core.__destructure_map(inst_57793);
var inst_57800 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57799,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_57801 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_57799,new cljs.core.Keyword(null,"close","close",1835149582));
var inst_57802 = inst_57801 === true;
var state_57824__$1 = (function (){var statearr_58030 = state_57824;
(statearr_58030[(8)] = inst_57800);

return statearr_58030;
})();
if(cljs.core.truth_(inst_57802)){
var statearr_58032_58372 = state_57824__$1;
(statearr_58032_58372[(1)] = (8));

} else {
var statearr_58033_58373 = state_57824__$1;
(statearr_58033_58373[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57825 === (3))){
var inst_57821 = (state_57824[(2)]);
var state_57824__$1 = state_57824;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57824__$1,inst_57821);
} else {
if((state_val_57825 === (2))){
var state_57824__$1 = state_57824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57824__$1,(4),response_chan);
} else {
if((state_val_57825 === (9))){
var inst_57800 = (state_57824[(8)]);
var inst_57811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57812 = [new cljs.core.Keyword("websocket-fx.core","subscription-message","websocket-fx.core/subscription-message",-580707945),socket_id,id,inst_57800];
var inst_57813 = (new cljs.core.PersistentVector(null,4,(5),inst_57811,inst_57812,null));
var inst_57814 = re_frame.core.dispatch(inst_57813);
var state_57824__$1 = (function (){var statearr_58044 = state_57824;
(statearr_58044[(9)] = inst_57814);

return statearr_58044;
})();
var statearr_58045_58376 = state_57824__$1;
(statearr_58045_58376[(2)] = null);

(statearr_58045_58376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57825 === (5))){
var state_57824__$1 = state_57824;
var statearr_58048_58377 = state_57824__$1;
(statearr_58048_58377[(2)] = null);

(statearr_58048_58377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57825 === (10))){
var inst_57817 = (state_57824[(2)]);
var state_57824__$1 = state_57824;
var statearr_58056_58378 = state_57824__$1;
(statearr_58056_58378[(2)] = inst_57817);

(statearr_58056_58378[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57825 === (8))){
var inst_57804 = cljs.core.async.close_BANG_(response_chan);
var inst_57805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57806 = [new cljs.core.Keyword("websocket-fx.core","subscription-closed","websocket-fx.core/subscription-closed",-1831119820),socket_id,id];
var inst_57807 = (new cljs.core.PersistentVector(null,3,(5),inst_57805,inst_57806,null));
var inst_57808 = re_frame.core.dispatch(inst_57807);
var state_57824__$1 = (function (){var statearr_58057 = state_57824;
(statearr_58057[(10)] = inst_57804);

return statearr_58057;
})();
var statearr_58058_58380 = state_57824__$1;
(statearr_58058_58380[(2)] = inst_57808);

(statearr_58058_58380[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var websocket_fx$core$state_machine__44577__auto__ = null;
var websocket_fx$core$state_machine__44577__auto____0 = (function (){
var statearr_58059 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_58059[(0)] = websocket_fx$core$state_machine__44577__auto__);

(statearr_58059[(1)] = (1));

return statearr_58059;
});
var websocket_fx$core$state_machine__44577__auto____1 = (function (state_57824){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_57824);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e58060){var ex__44580__auto__ = e58060;
var statearr_58061_58381 = state_57824;
(statearr_58061_58381[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_57824[(4)]))){
var statearr_58063_58382 = state_57824;
(statearr_58063_58382[(1)] = cljs.core.first((state_57824[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58383 = state_57824;
state_57824 = G__58383;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
websocket_fx$core$state_machine__44577__auto__ = function(state_57824){
switch(arguments.length){
case 0:
return websocket_fx$core$state_machine__44577__auto____0.call(this);
case 1:
return websocket_fx$core$state_machine__44577__auto____1.call(this,state_57824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
websocket_fx$core$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = websocket_fx$core$state_machine__44577__auto____0;
websocket_fx$core$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = websocket_fx$core$state_machine__44577__auto____1;
return websocket_fx$core$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_58065 = f__44774__auto__();
(statearr_58065[(6)] = c__44773__auto____$2);

return statearr_58065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
});
})();
var inst_57828 = cljs.core.async.impl.dispatch.run(inst_57827);
var state_57862__$1 = (function (){var statearr_58068 = state_57862;
(statearr_58068[(14)] = inst_57828);

return statearr_58068;
})();
var statearr_58073_58385 = state_57862__$1;
(statearr_58073_58385[(2)] = inst_57826);

(statearr_58073_58385[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (9))){
var inst_57732 = (state_57862[(10)]);
var inst_57781 = [new cljs.core.Keyword(null,"subscription","subscription",1949009182),null];
var inst_57782 = (new cljs.core.PersistentArrayMap(null,1,inst_57781,null));
var inst_57783 = (new cljs.core.PersistentHashSet(null,inst_57782,null));
var inst_57784 = (inst_57783.cljs$core$IFn$_invoke$arity$1 ? inst_57783.cljs$core$IFn$_invoke$arity$1(inst_57732) : inst_57783.call(null,inst_57732));
var state_57862__$1 = state_57862;
if(cljs.core.truth_(inst_57784)){
var statearr_58093_58389 = state_57862__$1;
(statearr_58093_58389[(1)] = (11));

} else {
var statearr_58094_58390 = state_57862__$1;
(statearr_58094_58390[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (5))){
var state_57862__$1 = state_57862;
var statearr_58097_58392 = state_57862__$1;
(statearr_58097_58392[(2)] = null);

(statearr_58097_58392[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (14))){
var inst_57731 = (state_57862[(9)]);
var inst_57732 = (state_57862[(10)]);
var inst_57734 = (state_57862[(13)]);
var inst_57837 = [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"proto","proto",811784976),new cljs.core.Keyword(null,"close","close",1835149582)];
var inst_57838 = [inst_57731,inst_57732,inst_57734];
var inst_57839 = cljs.core.PersistentHashMap.fromArrays(inst_57837,inst_57838);
var state_57862__$1 = state_57862;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_57862__$1,(17),sink,inst_57839);
} else {
if((state_val_57863 === (16))){
var inst_57850 = (state_57862[(2)]);
var state_57862__$1 = state_57862;
if(cljs.core.truth_(inst_57850)){
var statearr_58116_58394 = state_57862__$1;
(statearr_58116_58394[(1)] = (19));

} else {
var statearr_58121_58395 = state_57862__$1;
(statearr_58121_58395[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (10))){
var inst_57734 = (state_57862[(13)]);
var inst_57833 = (state_57862[(2)]);
var inst_57834 = (inst_57734 == null);
var inst_57835 = cljs.core.not(inst_57834);
var state_57862__$1 = (function (){var statearr_58133 = state_57862;
(statearr_58133[(15)] = inst_57833);

return statearr_58133;
})();
if(inst_57835){
var statearr_58134_58397 = state_57862__$1;
(statearr_58134_58397[(1)] = (14));

} else {
var statearr_58135_58398 = state_57862__$1;
(statearr_58135_58398[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (18))){
var inst_57847 = (state_57862[(2)]);
var state_57862__$1 = state_57862;
var statearr_58136_58399 = state_57862__$1;
(statearr_58136_58399[(2)] = inst_57847);

(statearr_58136_58399[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57863 === (8))){
var inst_57733 = (state_57862[(8)]);
var inst_57731 = (state_57862[(9)]);
var inst_57735 = (state_57862[(12)]);
var inst_57732 = (state_57862[(10)]);
var inst_57724 = (state_57862[(7)]);
var inst_57730 = (state_57862[(11)]);
var inst_57734 = (state_57862[(13)]);
var inst_57744 = (function (){var temp__5808__auto__ = inst_57724;
var map__57728 = inst_57730;
var id = inst_57731;
var proto = inst_57732;
var data = inst_57733;
var close = inst_57734;
var timeout = inst_57735;
return (function (msg){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(msg),id);
});
})();
var inst_57745 = cljs.core.filter.cljs$core$IFn$_invoke$arity$1(inst_57744);
var inst_57746 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),inst_57745);
var inst_57747 = cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(mult,inst_57746);
var inst_57748 = cljs.core.async.timeout(inst_57735);
var inst_57777 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_57778 = (function (){var response_chan = inst_57747;
var timeout = inst_57735;
var map__57728 = inst_57730;
var data = inst_57733;
var temp__5808__auto__ = inst_57724;
var xform = inst_57745;
var close = inst_57734;
var proto = inst_57732;
var timeout_chan = inst_57748;
var c__44773__auto____$2 = inst_57777;
var id = inst_57731;
return (function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_57775){
var state_val_57776 = (state_57775[(1)]);
if((state_val_57776 === (1))){
var inst_57752 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57753 = [timeout_chan,response_chan];
var inst_57754 = (new cljs.core.PersistentVector(null,2,(5),inst_57752,inst_57753,null));
var state_57775__$1 = state_57775;
return cljs.core.async.ioc_alts_BANG_(state_57775__$1,(2),inst_57754);
} else {
if((state_val_57776 === (2))){
var inst_57757 = (state_57775[(7)]);
var inst_57756 = (state_57775[(2)]);
var inst_57757__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57756,(0),null);
var inst_57758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57756,(1),null);
var inst_57759 = (inst_57757__$1 == null);
var inst_57760 = cljs.core.not(inst_57759);
var state_57775__$1 = (function (){var statearr_58159 = state_57775;
(statearr_58159[(7)] = inst_57757__$1);

(statearr_58159[(8)] = inst_57758);

return statearr_58159;
})();
if(inst_57760){
var statearr_58160_58406 = state_57775__$1;
(statearr_58160_58406[(1)] = (3));

} else {
var statearr_58161_58407 = state_57775__$1;
(statearr_58161_58407[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57776 === (3))){
var inst_57757 = (state_57775[(7)]);
var inst_57762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57763 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(inst_57757);
var inst_57764 = [new cljs.core.Keyword("websocket-fx.core","request-response","websocket-fx.core/request-response",1132952098),socket_id,id,inst_57763];
var inst_57765 = (new cljs.core.PersistentVector(null,4,(5),inst_57762,inst_57764,null));
var inst_57766 = re_frame.core.dispatch(inst_57765);
var state_57775__$1 = state_57775;
var statearr_58164_58408 = state_57775__$1;
(statearr_58164_58408[(2)] = inst_57766);

(statearr_58164_58408[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57776 === (4))){
var inst_57768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57769 = [new cljs.core.Keyword("websocket-fx.core","request-timeout","websocket-fx.core/request-timeout",1441765950),socket_id,id,new cljs.core.Keyword(null,"timeout","timeout",-318625318)];
var inst_57770 = (new cljs.core.PersistentVector(null,4,(5),inst_57768,inst_57769,null));
var inst_57771 = re_frame.core.dispatch(inst_57770);
var state_57775__$1 = state_57775;
var statearr_58167_58414 = state_57775__$1;
(statearr_58167_58414[(2)] = inst_57771);

(statearr_58167_58414[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57776 === (5))){
var inst_57773 = (state_57775[(2)]);
var state_57775__$1 = state_57775;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57775__$1,inst_57773);
} else {
return null;
}
}
}
}
}
});
return (function() {
var websocket_fx$core$state_machine__44577__auto__ = null;
var websocket_fx$core$state_machine__44577__auto____0 = (function (){
var statearr_58170 = [null,null,null,null,null,null,null,null,null];
(statearr_58170[(0)] = websocket_fx$core$state_machine__44577__auto__);

(statearr_58170[(1)] = (1));

return statearr_58170;
});
var websocket_fx$core$state_machine__44577__auto____1 = (function (state_57775){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_57775);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e58171){var ex__44580__auto__ = e58171;
var statearr_58173_58416 = state_57775;
(statearr_58173_58416[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_57775[(4)]))){
var statearr_58176_58417 = state_57775;
(statearr_58176_58417[(1)] = cljs.core.first((state_57775[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58418 = state_57775;
state_57775 = G__58418;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
websocket_fx$core$state_machine__44577__auto__ = function(state_57775){
switch(arguments.length){
case 0:
return websocket_fx$core$state_machine__44577__auto____0.call(this);
case 1:
return websocket_fx$core$state_machine__44577__auto____1.call(this,state_57775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
websocket_fx$core$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = websocket_fx$core$state_machine__44577__auto____0;
websocket_fx$core$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = websocket_fx$core$state_machine__44577__auto____1;
return websocket_fx$core$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_58178 = f__44774__auto__();
(statearr_58178[(6)] = c__44773__auto____$2);

return statearr_58178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
});
})();
var inst_57779 = cljs.core.async.impl.dispatch.run(inst_57778);
var state_57862__$1 = (function (){var statearr_58181 = state_57862;
(statearr_58181[(16)] = inst_57779);

return statearr_58181;
})();
var statearr_58182_58419 = state_57862__$1;
(statearr_58182_58419[(2)] = inst_57777);

(statearr_58182_58419[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var websocket_fx$core$state_machine__44577__auto__ = null;
var websocket_fx$core$state_machine__44577__auto____0 = (function (){
var statearr_58184 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58184[(0)] = websocket_fx$core$state_machine__44577__auto__);

(statearr_58184[(1)] = (1));

return statearr_58184;
});
var websocket_fx$core$state_machine__44577__auto____1 = (function (state_57862){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_57862);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e58185){var ex__44580__auto__ = e58185;
var statearr_58186_58421 = state_57862;
(statearr_58186_58421[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_57862[(4)]))){
var statearr_58189_58422 = state_57862;
(statearr_58189_58422[(1)] = cljs.core.first((state_57862[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58423 = state_57862;
state_57862 = G__58423;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
websocket_fx$core$state_machine__44577__auto__ = function(state_57862){
switch(arguments.length){
case 0:
return websocket_fx$core$state_machine__44577__auto____0.call(this);
case 1:
return websocket_fx$core$state_machine__44577__auto____1.call(this,state_57862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
websocket_fx$core$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = websocket_fx$core$state_machine__44577__auto____0;
websocket_fx$core$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = websocket_fx$core$state_machine__44577__auto____1;
return websocket_fx$core$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_58195 = f__44774__auto__();
(statearr_58195[(6)] = c__44773__auto____$1);

return statearr_58195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
});
})();
var inst_57866 = cljs.core.async.impl.dispatch.run(inst_57865);
var inst_57868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57870 = [new cljs.core.Keyword("websocket-fx.core","connected","websocket-fx.core/connected",-2070989576),socket_id];
var inst_57871 = (new cljs.core.PersistentVector(null,2,(5),inst_57868,inst_57870,null));
var inst_57872 = re_frame.core.dispatch(inst_57871);
var inst_57876 = (on_connect == null);
var inst_57877 = cljs.core.not(inst_57876);
var state_57886__$1 = (function (){var statearr_58199 = state_57886;
(statearr_58199[(15)] = inst_57872);

(statearr_58199[(16)] = inst_57866);

return statearr_58199;
})();
if(inst_57877){
var statearr_58200_58424 = state_57886__$1;
(statearr_58200_58424[(1)] = (6));

} else {
var statearr_58202_58425 = state_57886__$1;
(statearr_58202_58425[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57887 === (5))){
var inst_57884 = (state_57886[(2)]);
var state_57886__$1 = state_57886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57886__$1,inst_57884);
} else {
if((state_val_57887 === (6))){
var inst_57879 = re_frame.core.dispatch(on_connect);
var state_57886__$1 = state_57886;
var statearr_58203_58431 = state_57886__$1;
(statearr_58203_58431[(2)] = inst_57879);

(statearr_58203_58431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57887 === (7))){
var state_57886__$1 = state_57886;
var statearr_58206_58432 = state_57886__$1;
(statearr_58206_58432[(2)] = null);

(statearr_58206_58432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57887 === (8))){
var inst_57882 = (state_57886[(2)]);
var state_57886__$1 = state_57886;
var statearr_58208_58433 = state_57886__$1;
(statearr_58208_58433[(2)] = inst_57882);

(statearr_58208_58433[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var websocket_fx$core$state_machine__44577__auto__ = null;
var websocket_fx$core$state_machine__44577__auto____0 = (function (){
var statearr_58212 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58212[(0)] = websocket_fx$core$state_machine__44577__auto__);

(statearr_58212[(1)] = (1));

return statearr_58212;
});
var websocket_fx$core$state_machine__44577__auto____1 = (function (state_57886){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_57886);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e58218){var ex__44580__auto__ = e58218;
var statearr_58219_58435 = state_57886;
(statearr_58219_58435[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_57886[(4)]))){
var statearr_58221_58436 = state_57886;
(statearr_58221_58436[(1)] = cljs.core.first((state_57886[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58438 = state_57886;
state_57886 = G__58438;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
websocket_fx$core$state_machine__44577__auto__ = function(state_57886){
switch(arguments.length){
case 0:
return websocket_fx$core$state_machine__44577__auto____0.call(this);
case 1:
return websocket_fx$core$state_machine__44577__auto____1.call(this,state_57886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
websocket_fx$core$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = websocket_fx$core$state_machine__44577__auto____0;
websocket_fx$core$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = websocket_fx$core$state_machine__44577__auto____1;
return websocket_fx$core$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_58228 = f__44774__auto__();
(statearr_58228[(6)] = c__44773__auto__);

return statearr_58228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));

return c__44773__auto__;
}));
re_frame.core.reg_fx(new cljs.core.Keyword("websocket-fx.core","disconnect","websocket-fx.core/disconnect",1210384580),(function (p__58231){
var map__58232 = p__58231;
var map__58232__$1 = cljs.core.__destructure_map(map__58232);
var socket_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__58232__$1,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280));
var map__58235 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3(websocket_fx.core.CONNECTIONS,cljs.core.dissoc,socket_id)),socket_id);
var map__58235__$1 = cljs.core.__destructure_map(map__58235);
var socket = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__58235__$1,new cljs.core.Keyword(null,"socket","socket",59137063));
if((!((socket == null)))){
return socket.close();
} else {
return null;
}
}));
re_frame.core.reg_fx(new cljs.core.Keyword("websocket-fx.core","ws-message","websocket-fx.core/ws-message",413406340),(function (p__58236){
var map__58238 = p__58236;
var map__58238__$1 = cljs.core.__destructure_map(map__58238);
var socket_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__58238__$1,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280));
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__58238__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var temp__5806__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(websocket_fx.core.CONNECTIONS),socket_id);
if((temp__5806__auto__ == null)){
return console.error("Socket with id ",socket_id," does not exist.");
} else {
var map__58241 = temp__5806__auto__;
var map__58241__$1 = cljs.core.__destructure_map(map__58241);
var sink = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__58241__$1,new cljs.core.Keyword(null,"sink","sink",186835933));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sink,message);
}
}));
re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("websocket-fx.core","pending-requests","websocket-fx.core/pending-requests",-563577824),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(function (db,p__58243){
var vec__58245 = p__58243;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__58245,(0),null);
var socket_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__58245,(1),null);
return cljs.core.vals(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"requests","requests",-733055638)], null)));
})], 0));
re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("websocket-fx.core","open-subscriptions","websocket-fx.core/open-subscriptions",1589463562),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(function (db,p__58250){
var vec__58253 = p__58250;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__58253,(0),null);
var socket_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__58253,(1),null);
return cljs.core.vals(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"subscriptions","subscriptions",1250949776)], null)));
})], 0));
re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("websocket-fx.core","status","websocket-fx.core/status",1401081242),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(function (db,p__58258){
var vec__58259 = p__58258;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__58259,(0),null);
var socket_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__58259,(1),null);
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("websocket-fx.core","sockets","websocket-fx.core/sockets",879219385),socket_id,new cljs.core.Keyword(null,"status","status",-1997798413)], null));
})], 0));

//# sourceMappingURL=websocket_fx.core.js.map
