(ns s-exp.mina
  (:require [s-exp.mina.handler]
            [s-exp.mina.options :as options])
  (:import (io.helidon.nima.webserver WebServer WebServer$Builder)))

(set! *warn-on-reflection* true)

(def default-options {:connection-provider false})

(defn- server-builder
  ^WebServer$Builder
  [options]
  (reduce (fn [builder [k v]]
            (options/set-server-option! builder k v options))
          (WebServer/builder)
          options))

(defn start!
  "Starts a new server.
  
  `options` can contain:

  * `:host` - host of the default socket
  
  * `:port` - port the server listens to, default to 8080

  * `:default-socket` - map-of :write-queue-length :backlog :max-payload-size :receive-buffer-size `:connection-options`(map-of `:socket-receive-buffer-size` `:socket-send-buffer-size` `:socket-reuse-address` `:socket-keep-alive` `:tcp-no-delay` `:read-timeout` `:connect-timeout`)

  * `:tls` - a `io.helidon.nima.common.tls.Tls` instance"
  ([handler options]
   (start! (assoc options :handler handler)))
  ([options]
   (-> (server-builder (merge default-options options))
       (.start))))

(defn stop!
  "Stops server, noop if already stopped"
  [^WebServer server]
  (.stop server))

;; (def r {})
;; ;; (def r {})
;; (def s (start! (fn [req] r)
;;                {:host "0.0.0.0"
;;                 :port 8080
;;                 :default-socket
;;                 {:backlog 8192
;;                  :receive-buffer-size 6400
;;                  :write-queue-length 1024
;;                  :connection-options
;;                  {:socket-receive-buffer-size 64000
;;                   :socket-reuse-address true
;;                   :socket-keep-alive true
;;                   :tcp-no-delay true
;;                   :socket-send-buffer-size 64000
;;                   :connect-timeout 0
;;                   :read-timeout 0}}}))

;; (stop! s)

;; https://api.github.com/repos/mpenet/mina/commits/main?per_page=1


