/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.hbase.ds;

import com.sematext.hbase.ds.AbstractRowKeyDistributor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

public class WdTableInputFormat
extends TableInputFormat {
    public static final String ROW_KEY_DISTRIBUTOR_CLASS = "hbase.mapreduce.scan.wd.distributor.class";
    public static final String ROW_KEY_DISTRIBUTOR_PARAMS = "hbase.mapreduce.scan.wd.distributor.params";
    private AbstractRowKeyDistributor rowKeyDistributor;

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf.get(ROW_KEY_DISTRIBUTOR_CLASS) != null) {
            String clazz = conf.get(ROW_KEY_DISTRIBUTOR_CLASS);
            try {
                this.rowKeyDistributor = (AbstractRowKeyDistributor)Class.forName(clazz).newInstance();
                if (conf.get(ROW_KEY_DISTRIBUTOR_PARAMS) != null) {
                    this.rowKeyDistributor.init(conf.get(ROW_KEY_DISTRIBUTOR_PARAMS));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create row key distributor, hbase.mapreduce.scan.wd.distributor.class: " + clazz, e);
            }
        }
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        Scan[] scans;
        ArrayList<InputSplit> allSplits = new ArrayList<InputSplit>();
        Scan originalScan = this.getScan();
        for (Scan scan : scans = this.rowKeyDistributor.getDistributedScans(originalScan)) {
            this.setScan(scan);
            List splits = super.getSplits(context);
            allSplits.addAll(splits);
        }
        this.setScan(originalScan);
        return allSplits;
    }
}

