/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fit.krizeji1.edge_betweenness;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;
import java.util.logging.Logger;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeData;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;

public class EdgeBetweenness
implements Statistics,
LongTask {
    public static final String EDGE_BETWEENNESS = "edgebetweenness";
    private double[] edgeBetweenness;
    private double edgeBetwNum;
    private boolean isCancelled;
    private boolean isDirected;
    private boolean isNormalized;
    private ProgressTicket progressTicket;
    private String report = "";
    private static final Logger logger = Logger.getLogger(EdgeBetweenness.class.getName());
    private int N;
    private int E;

    public EdgeBetweenness() {
        GraphController graphCont = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphCont != null && graphCont.getModel() != null) {
            this.isDirected = graphCont.getModel().isDirected();
        }
    }

    @Override
    public void execute(GraphModel gm, AttributeModel am) {
        HierarchicalGraph graph = null;
        graph = this.isDirected ? gm.getHierarchicalDirectedGraph() : gm.getHierarchicalUndirectedGraph();
        this.execute(graph, am);
    }

    public void execute(HierarchicalGraph hGraph, AttributeModel am) {
        this.isCancelled = false;
        hGraph.readLock();
        this.N = hGraph.getNodeCount();
        this.E = hGraph.getEdgeCount();
        long startTime = System.currentTimeMillis();
        this.report = this.report + "Algorithm started \n";
        Progress.start(this.progressTicket, this.N);
        AttributeTable edgeTable = am.getEdgeTable();
        AttributeColumn edgeBetweennessCol = edgeTable.getColumn(EDGE_BETWEENNESS);
        if (edgeBetweennessCol != null) {
            edgeTable.removeColumn(edgeBetweennessCol);
        }
        edgeBetweennessCol = edgeTable.addColumn(EDGE_BETWEENNESS, "EdgeBetweenness", AttributeType.DOUBLE, AttributeOrigin.COMPUTED, (Object)new Double(0.0));
        this.edgeBetweenness = new double[this.E];
        for (int i = 0; i < this.E; ++i) {
            this.edgeBetweenness[i] = 1.0;
        }
        String l = "Creating list of nodes (time: " + (System.currentTimeMillis() - startTime) + ")\n";
        this.report = this.report + l;
        int nodeIndex = 0;
        int edgeIndex = 0;
        HashMap<Node, Integer> nodesIndex = new HashMap<Node, Integer>();
        HashMap<Edge, Integer> edgesIndex = new HashMap<Edge, Integer>();
        for (Node n : hGraph.getNodes()) {
            nodesIndex.put(n, nodeIndex);
            ++nodeIndex;
        }
        for (Object e : hGraph.getEdges()) {
            edgesIndex.put((Edge)e, edgeIndex);
            ++edgeIndex;
        }
        l = "List of nodes and indexes created (time: " + (System.currentTimeMillis() - startTime) + ")\n";
        this.report = this.report + l;
        l = "Creating queue for BFS (time: " + (System.currentTimeMillis() - startTime) + ")\n";
        this.report = this.report + l;
        int count = 0;
        for (Node rootNode : hGraph.getNodes()) {
            Progress.progress(this.progressTicket, ++count);
            if (this.isCancelled) {
                hGraph.readUnlockAll();
                return;
            }
            Stack<Node> stack = new Stack<Node>();
            LinkedList[] predecessorList = new LinkedList[this.N];
            LinkedList[] edgesList = new LinkedList[this.N];
            int[] distance = new int[this.N];
            for (int j = 0; j < this.N; ++j) {
                predecessorList[j] = new LinkedList();
                edgesList[j] = new LinkedList();
                distance[j] = -1;
            }
            int srcIndex = (Integer)nodesIndex.get(rootNode);
            distance[srcIndex] = 0;
            LinkedList<Node> queue = new LinkedList<Node>();
            queue.addLast(rootNode);
            while (!queue.isEmpty()) {
                Node v = (Node)queue.removeFirst();
                stack.push(v);
                int vIndex = (Integer)nodesIndex.get(v);
                for (Edge edge : this.getEdgeIteratorForNode(v, hGraph)) {
                    Node neighNode = hGraph.getOpposite(v, edge);
                    int neighIndex = (Integer)nodesIndex.get(neighNode);
                    if (distance[neighIndex] < 0) {
                        queue.addLast(neighNode);
                        distance[neighIndex] = distance[vIndex] + 1;
                    }
                    if (distance[neighIndex] != distance[vIndex] + 1) continue;
                    predecessorList[neighIndex] = (LinkedList)predecessorList[vIndex].clone();
                    predecessorList[neighIndex].addLast(v);
                    edgesList[neighIndex] = (LinkedList)edgesList[vIndex].clone();
                    edgesList[neighIndex].addLast(edge);
                    for (Edge e : edgesList[neighIndex]) {
                        EdgeData edgeData = e.getEdgeData();
                        if (edgeData == null) continue;
                        AttributeRow row = (AttributeRow)e.getEdgeData().getAttributes();
                        Double val = (Double)row.getValue(edgeBetweennessCol);
                        val = val + 1.0;
                        row.setValue(edgeBetweennessCol, (Object)val);
                    }
                }
            }
        }
        double sumVal = 0.0;
        double maxBetweenness = Double.NEGATIVE_INFINITY;
        if (this.isNormalized) {
            maxBetweenness = this.findMaxBetweenness(hGraph, edgeBetweennessCol);
            if (!this.isDirected) {
                maxBetweenness /= 2.0;
            }
        }
        for (Edge e : hGraph.getEdgesAndMetaEdges()) {
            AttributeRow row = (AttributeRow)e.getEdgeData().getAttributes();
            Double val = (Double)row.getValue(edgeBetweennessCol);
            if (!this.isDirected) {
                val = val / 2.0;
            }
            sumVal += val.doubleValue();
            if (this.isNormalized) {
                val = val / maxBetweenness;
            }
            row.setValue(edgeBetweennessCol, (Object)val);
        }
        this.edgeBetwNum = sumVal;
        hGraph.readUnlockAll();
        Progress.finish(this.progressTicket);
        this.report = this.report + "Algorithm finished (time: " + (System.currentTimeMillis() - startTime) + ")\n";
    }

    @Override
    public boolean cancel() {
        this.isCancelled = true;
        return true;
    }

    @Override
    public void setProgressTicket(ProgressTicket pt) {
        this.progressTicket = pt;
    }

    @Override
    public String getReport() {
        return this.report;
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public boolean getDirected() {
        return this.isDirected;
    }

    public boolean isNormalized() {
        return this.isNormalized;
    }

    public void doNormalize(boolean isNormalized) {
        this.isNormalized = isNormalized;
    }

    double getEdgeBetweenness() {
        return this.edgeBetwNum;
    }

    private String printArr(LinkedList<Node> linkedList, int size) {
        if (size == 1) {
            return "[straight]";
        }
        String result = "[through " + linkedList.size() + " nodes: ";
        for (Node l : linkedList) {
            result = result + l.getId() + " (" + l.getNodeData().getLabel() + ")";
            result = result + ", ";
        }
        result = result + "]";
        return result;
    }

    private String printEdges(LinkedList<Edge> linkedList) {
        String result = "[through " + linkedList.size() + " edges: ";
        for (Edge e : linkedList) {
            result = result + " " + e.getId() + "(" + e.getSource().getNodeData().getLabel() + " to " + e.getTarget().getNodeData().getLabel() + "), ";
        }
        return result;
    }

    private EdgeIterable getEdgeIteratorForNode(Node node, HierarchicalGraph forGraph) {
        EdgeIterable edgeIter = this.isDirected ? ((HierarchicalDirectedGraph)forGraph).getOutEdgesAndMetaOutEdges(node) : forGraph.getEdgesAndMetaEdges(node);
        return edgeIter;
    }

    private double findMaxBetweenness(HierarchicalGraph graph, AttributeColumn column) {
        double max = Double.NEGATIVE_INFINITY;
        for (Edge e : graph.getEdgesAndMetaEdges()) {
            AttributeRow row = (AttributeRow)e.getEdgeData().getAttributes();
            Double val = (Double)row.getValue(column);
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }
}

