/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fit.krizeji1.girvan_newman;

import cz.cvut.fit.krizeji1.edge_betweenness.EdgeBetweenness;
import cz.cvut.fit.krizeji1.girvan_newman.GirvanNewmanClusterImpl;
import cz.cvut.fit.krizeji1.girvan_newman.multicolour.GraphColorizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.gephi.clustering.api.Cluster;
import org.gephi.clustering.spi.Clusterer;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GirvanNewmanClusterer
implements Clusterer,
LongTask {
    private static final int UNSEEN_CLUSTER = -1;
    private List<Cluster> result = new ArrayList<Cluster>();
    public static final String PLUGIN_NAME = "Girvan Newman";
    public static final String PLUGIN_DESCRIPTION = "Girvan Newman Clustering";
    public static final String CLUSTER = "cluster";
    public static final String PREV_CLUSTER = "prev_cluster";
    ProgressTicket progress = null;
    private static final Logger logger = Logger.getLogger(GirvanNewmanClusterer.class.getName());
    private Map<Integer, ArrayList<Cluster>> clusters = new HashMap<Integer, ArrayList<Cluster>>();
    boolean isCancelled = false;
    private GraphModel graphModel = null;
    private AttributeColumn clusterColumn;
    private Graph tempGraph;
    private AttributeColumn prevClusterColumn;
    private int selectedClustersCount;
    private int preferred = -1;
    private Vector<Integer> clusterCounts;

    @Override
    public void execute(GraphModel gm) {
        long startAlg = System.currentTimeMillis();
        this.graphModel = gm;
        this.isCancelled = false;
        if (this.progress != null) {
            this.progress.progress(NbBundle.getMessage(GirvanNewmanClusterer.class, (String)"GirvanNewmanClusterer.setup"));
            this.progress.start();
        }
        GraphView view = this.graphModel.newView();
        this.tempGraph = this.graphModel.getGraph(view);
        long startInnerAlg = System.currentTimeMillis();
        this.clusterCounts = new Vector();
        while (this.tempGraph.getEdgeCount() > 0) {
            AttributeColumn col = this.recalculateBetweenness();
            if (this.isCancelled) {
                return;
            }
            EdgeIterable edges = this.tempGraph.getEdges();
            Double maxBetw = Double.NEGATIVE_INFINITY;
            for (Edge e : edges) {
                Double centrality = (Double)e.getEdgeData().getAttributes().getValue("edgebetweenness");
                if (!(centrality > maxBetw)) continue;
                maxBetw = centrality;
            }
            for (Edge maxEdge : this.findEdgesWithBetweenness(maxBetw)) {
                this.tempGraph.removeEdge(maxEdge);
            }
            int clusterCount = this.findClusters();
            if (!this.getClusterCounts().isEmpty() && this.getClusterCounts().lastElement() == clusterCount) continue;
            this.getClusterCounts().add(clusterCount);
        }
        long endInnerAlg = System.currentTimeMillis() - startInnerAlg;
        System.out.println("endInnerAlg: " + endInnerAlg);
        if (this.preferred <= 0) {
            throw new IllegalStateException("Missing parameter!");
        }
        this.selectedClustersCount = this.findNearest(this.getClusterCounts());
        System.out.println("Cluster counts: " + this.getClusterCounts().toString());
        this.result = this.clusters.get(this.selectedClustersCount);
        AttributeTable nodeTable = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel().getNodeTable();
        GraphColorizer c = new GraphColorizer(nodeTable);
        if (this.result != null && this.result.size() > 0) {
            c.colorizeGraph(this.result.toArray(new Cluster[this.selectedClustersCount]));
        }
        if (this.progress != null) {
            this.progress.finish(NbBundle.getMessage(GirvanNewmanClusterer.class, (String)"GirvanNewmanClusterer.finished"));
        }
        long endAlg = System.currentTimeMillis() - startAlg;
        System.out.println("endAlg: " + endAlg);
    }

    @Override
    public Cluster[] getClusters() {
        if (this.result == null || this.result.isEmpty()) {
            return null;
        }
        return this.result.toArray(new Cluster[this.selectedClustersCount]);
    }

    @Override
    public boolean cancel() {
        this.progress.finish(NbBundle.getMessage(GirvanNewmanClusterer.class, (String)"GirvanNewmanClusterer.cancelled"));
        this.isCancelled = true;
        return true;
    }

    @Override
    public void setProgressTicket(ProgressTicket pt) {
        this.progress = pt;
    }

    private AttributeColumn recalculateBetweenness() {
        if (this.tempGraph == null) {
            throw new IllegalStateException("tempGraph can not be null");
        }
        AttributeModel attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
        return this.recalculateBetweenness(this.tempGraph.getGraphModel());
    }

    private AttributeColumn recalculateBetweenness(GraphModel model) {
        AttributeModel attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
        EdgeBetweenness eb = new EdgeBetweenness();
        eb.execute(model, attributeModel);
        return attributeModel.getNodeTable().getColumn("edgebetweenness");
    }

    private Edge[] findEdgesWithBetweenness(Double maxBetw) {
        if (this.tempGraph == null) {
            throw new IllegalStateException("tempGraph can not be null");
        }
        ArrayList<Edge> res = new ArrayList<Edge>();
        for (Edge e : this.tempGraph.getEdges()) {
            double betw = (Double)e.getEdgeData().getAttributes().getValue("edgebetweenness");
            if (betw != maxBetw) continue;
            res.add(e);
        }
        Edge[] resArr = new Edge[res.size()];
        return res.toArray(resArr);
    }

    private int findClusters() {
        if (this.tempGraph == null) {
            throw new IllegalStateException("tempGraph can not be null");
        }
        this.prevClusterColumn = this.copyClusterToPrev();
        this.clusterColumn = this.prepareClusterColumn(-1);
        int clusterNumber = 0;
        ArrayList<GirvanNewmanClusterImpl> currCluster = new ArrayList<GirvanNewmanClusterImpl>();
        for (Node rootNode : this.tempGraph.getNodes()) {
            int nodeClusterId = this.getNodeClusterId(rootNode);
            if (nodeClusterId != -1) continue;
            GirvanNewmanClusterImpl tmpCluster = this.bfsMarkNodes(rootNode, clusterNumber++);
            currCluster.add(tmpCluster);
        }
        int clustersCount = clusterNumber;
        this.clusters.put(clustersCount, currCluster);
        return clusterNumber;
    }

    private AttributeColumn prepareClusterColumn(int initialValue) {
        AttributeController ac = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
        AttributeTable nodeTable = ac.getModel().getNodeTable();
        AttributeColumn column = nodeTable.getColumn(CLUSTER, AttributeType.INT);
        if (column != null) {
            nodeTable.removeColumn(column);
        }
        return nodeTable.addColumn(CLUSTER, CLUSTER, AttributeType.INT, AttributeOrigin.COMPUTED, (Object)new Integer(initialValue));
    }

    private AttributeColumn copyClusterToPrev() {
        AttributeController ac = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
        AttributeTable nodeTable = ac.getModel().getNodeTable();
        if (nodeTable.hasColumn(CLUSTER)) {
            this.clusterColumn = nodeTable.getColumn(CLUSTER, AttributeType.INT);
            if (nodeTable.hasColumn(PREV_CLUSTER)) {
                nodeTable.removeColumn(nodeTable.getColumn(PREV_CLUSTER));
            }
            AttributeColumn duplicateColumn = ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).duplicateColumn(nodeTable, this.clusterColumn, PREV_CLUSTER, AttributeType.INT);
            return duplicateColumn;
        }
        return null;
    }

    private int getNodeClusterId(Node node) {
        return this.getParamClusterId(node, this.clusterColumn);
    }

    private int getNodeClusterPrevId(Node node) {
        return this.getParamClusterId(node, this.prevClusterColumn);
    }

    private int getParamClusterId(Node node, AttributeColumn attr) {
        if (attr == null) {
            throw new IllegalStateException("cluster Column must be initialized before calling getParamClusterId");
        }
        AttributeRow row = (AttributeRow)node.getNodeData().getAttributes();
        return (Integer)row.getValue(attr);
    }

    private void setNodeClusterId(Node node, int newClusterId) {
        if (this.clusterColumn == null) {
            throw new IllegalStateException("clusterColumn must be initialized before calling setNodeClusterId");
        }
        AttributeRow row = (AttributeRow)node.getNodeData().getAttributes();
        row.setValue(this.clusterColumn, (Object)newClusterId);
    }

    private GirvanNewmanClusterImpl bfsMarkNodes(Node rootNode, int newClusterId) {
        if (this.tempGraph == null) {
            throw new IllegalStateException("tempGraph cannot be null");
        }
        GirvanNewmanClusterImpl cluster = new GirvanNewmanClusterImpl();
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.addLast(rootNode);
        while (!queue.isEmpty()) {
            Node v = (Node)queue.removeFirst();
            if (this.getNodeClusterId(v) == -1) {
                this.setNodeClusterId(v, newClusterId);
                cluster.addNode(v);
                cluster.setName("Cluster " + Integer.toString(newClusterId + 1));
                if (this.prevClusterColumn != null) {
                    int n = this.getNodeClusterPrevId(v);
                }
            }
            for (Node n : this.tempGraph.getNeighbors(v).toArray()) {
                if (this.getNodeClusterId(n) == newClusterId) continue;
                queue.add(n);
                this.setNodeClusterId(n, newClusterId);
                cluster.addNode(n);
            }
        }
        return cluster;
    }

    public void setPreferredNumberOfClusters(int clusters) {
        this.preferred = clusters;
    }

    private int findNearest(Vector<Integer> clusterCounts) {
        if (clusterCounts.contains(this.preferred)) {
            return this.preferred;
        }
        int bestDistance = Integer.MAX_VALUE;
        int nearest = -1;
        for (int i : clusterCounts) {
            int d = Math.abs(this.preferred - i);
            if (d >= bestDistance) continue;
            nearest = i;
            bestDistance = d;
        }
        return nearest;
    }

    public Vector<Integer> getClusterCounts() {
        return this.clusterCounts;
    }
}

