/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fit.krizeji1.girvan_newman.multicolour;

public final class Color {
    private float h = (float)Math.random();
    private float r;
    private float g;
    private float b;
    double golden_ratio_conjugate = 0.618033988749895;

    public Color() {
        this.randomize();
    }

    public Color randomize() {
        this.h = (float)((double)this.h + this.golden_ratio_conjugate);
        this.h %= 1.0f;
        this.hsvToRgb(this.h, 0.95f, 0.99f);
        return this;
    }

    private void hsvToRgb(float h, float s, float v) {
        int hh = (int)(h * 6.0f);
        float f = h * 6.0f - (float)hh;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        switch (hh) {
            case 0: {
                this.r = v;
                this.g = t;
                this.b = p;
                break;
            }
            case 1: {
                this.r = q;
                this.g = v;
                this.b = p;
                break;
            }
            case 2: {
                this.r = p;
                this.g = v;
                this.b = t;
                break;
            }
            case 3: {
                this.r = p;
                this.g = q;
                this.b = v;
                break;
            }
            case 4: {
                this.r = t;
                this.g = p;
                this.b = v;
                break;
            }
            case 5: {
                this.r = v;
                this.g = p;
                this.b = q;
            }
        }
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public int getColorAsInt() {
        int r2 = (int)(this.r * 256.0f);
        int g2 = (int)(this.g * 256.0f) << 8;
        int b2 = (int)(this.b * 256.0f) << 16;
        return r2 + g2 + b2;
    }
}

