/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fit.krizeji1.girvan_newman.multicolour;

import cz.cvut.fit.krizeji1.girvan_newman.multicolour.Color;
import org.gephi.clustering.api.Cluster;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.Node;

public class GraphColorizer {
    private final AttributeTable nodeTable;

    public GraphColorizer(AttributeTable nodeTable) {
        this.nodeTable = nodeTable;
    }

    public void colorizeGraph(Cluster[] result) {
        if (result == null) {
            return;
        }
        AttributeColumn colColours = this.nodeTable.getColumn("colourList");
        if (colColours != null) {
            this.nodeTable.replaceColumn(colColours, "colourList", "colourList", AttributeType.STRING, AttributeOrigin.COMPUTED, "-1");
        } else {
            this.nodeTable.addColumn("colourList", "colourList", AttributeType.STRING, AttributeOrigin.COMPUTED, (Object)"-1");
        }
        Color color = new Color();
        for (Cluster res : result) {
            for (Node n : res.getNodes()) {
                String value = (String)n.getAttributes().getValue("colourList");
                if (value.equals("-1")) {
                    n.getAttributes().setValue("colourList", (Object)color.getColorAsInt());
                } else {
                    n.getAttributes().setValue("colourList", (Object)(value + "," + color.getColorAsInt()));
                }
                n.getNodeData().setColor(color.getR(), color.getG(), color.getB());
            }
            color.randomize();
        }
    }
}

