/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gephi.data.attributes.AttributeFactoryImpl;
import org.gephi.data.attributes.AttributeTableImpl;
import org.gephi.data.attributes.api.AttributeListener;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeRowFactory;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeValueFactory;
import org.gephi.data.attributes.event.AbstractEvent;
import org.gephi.data.attributes.event.AttributeEventManager;
import org.gephi.data.properties.PropertiesColumn;
import org.gephi.project.api.Workspace;
import org.openide.util.NbBundle;

public abstract class AbstractAttributeModel
implements AttributeModel {
    private final Workspace workspace;
    private final ConcurrentMap<String, AttributeTableImpl> tableMap;
    private final AttributeTableImpl nodeTable;
    private final AttributeTableImpl edgeTable;
    private final AttributeTableImpl graphTable;
    private final AttributeFactoryImpl factory;
    protected AttributeEventManager eventManager;

    public AbstractAttributeModel(Workspace workspace) {
        this.workspace = workspace;
        this.tableMap = new ConcurrentHashMap<String, AttributeTableImpl>();
        this.nodeTable = new AttributeTableImpl(this, NbBundle.getMessage(AttributeTableImpl.class, (String)"NodeAttributeTable.name"));
        this.edgeTable = new AttributeTableImpl(this, NbBundle.getMessage(AttributeTableImpl.class, (String)"EdgeAttributeTable.name"));
        this.graphTable = new AttributeTableImpl(this, NbBundle.getMessage(AttributeTableImpl.class, (String)"GraphAttributeTable.name"));
        this.tableMap.put(this.nodeTable.name, this.nodeTable);
        this.tableMap.put(this.edgeTable.name, this.edgeTable);
        this.tableMap.put(this.graphTable.name, this.graphTable);
        this.factory = new AttributeFactoryImpl(this);
    }

    protected void createPropertiesColumn() {
        PropertiesColumn[] columnsForNodeTable = new PropertiesColumn[]{PropertiesColumn.NODE_ID, PropertiesColumn.NODE_LABEL};
        PropertiesColumn[] columnsForEdgeTable = new PropertiesColumn[]{PropertiesColumn.EDGE_ID, PropertiesColumn.EDGE_LABEL, PropertiesColumn.EDGE_WEIGHT};
        PropertiesColumn[] columnsForGraphTable = new PropertiesColumn[]{PropertiesColumn.GRAPH_NAME, PropertiesColumn.GRAPH_DESCRIPTION};
        for (PropertiesColumn columnForNodeTable : columnsForNodeTable) {
            this.nodeTable.addPropertiesColumn(columnForNodeTable);
        }
        for (PropertiesColumn columnForEdgeTable : columnsForEdgeTable) {
            this.edgeTable.addPropertiesColumn(columnForEdgeTable);
        }
        for (PropertiesColumn columnForGraphTable : columnsForGraphTable) {
            this.graphTable.addPropertiesColumn(columnForGraphTable);
        }
    }

    public abstract Object getManagedValue(Object var1, AttributeType var2);

    public void clear() {
    }

    @Override
    public AttributeTableImpl getNodeTable() {
        return this.nodeTable;
    }

    @Override
    public AttributeTableImpl getGraphTable() {
        return this.graphTable;
    }

    @Override
    public AttributeTableImpl getEdgeTable() {
        return this.edgeTable;
    }

    @Override
    public AttributeTableImpl getTable(String name) {
        AttributeTableImpl attTable = (AttributeTableImpl)this.tableMap.get(name);
        if (attTable != null) {
            return attTable;
        }
        return null;
    }

    public AttributeTableImpl[] getTables() {
        return this.tableMap.values().toArray(new AttributeTableImpl[0]);
    }

    @Override
    public AttributeRowFactory rowFactory() {
        return this.factory;
    }

    @Override
    public AttributeValueFactory valueFactory() {
        return this.factory;
    }

    public AttributeFactoryImpl getFactory() {
        return this.factory;
    }

    public void addTable(AttributeTableImpl table) {
        this.tableMap.put(table.getName(), table);
    }

    @Override
    public void addAttributeListener(AttributeListener listener) {
        this.eventManager.addAttributeListener(listener);
    }

    @Override
    public void removeAttributeListener(AttributeListener listener) {
        this.eventManager.removeAttributeListener(listener);
    }

    public void fireAttributeEvent(AbstractEvent event) {
        this.eventManager.fireEvent(event);
    }

    @Override
    public void mergeModel(AttributeModel model) {
        if (model.getNodeTable() != null) {
            this.nodeTable.mergeTable(model.getNodeTable());
        }
        if (model.getEdgeTable() != null) {
            this.edgeTable.mergeTable(model.getEdgeTable());
        }
        for (AttributeTable table : model.getTables()) {
            if (table == model.getNodeTable() || table == model.getEdgeTable()) continue;
            AttributeTable existingTable = (AttributeTable)this.tableMap.get(table.getName());
            if (existingTable != null) {
                ((AttributeTableImpl)existingTable).mergeTable(table);
                continue;
            }
            AttributeTableImpl newTable = new AttributeTableImpl(this, table.getName());
            this.tableMap.put(newTable.getName(), newTable);
            newTable.mergeTable(table);
        }
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }
}

