/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes;

import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.model.IndexedAttributeModel;
import org.gephi.data.attributes.model.TemporaryAttributeModel;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.project.api.WorkspaceProvider;
import org.openide.util.Lookup;

public class AttributeControllerImpl
implements AttributeController {
    private ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);

    public AttributeControllerImpl() {
        this.projectController.addWorkspaceListener(new WorkspaceListener(){

            @Override
            public void initialize(Workspace workspace) {
                AttributeModel m = (AttributeModel)workspace.getLookup().lookup(AttributeModel.class);
                if (m == null) {
                    workspace.add(new IndexedAttributeModel(workspace));
                }
            }

            @Override
            public void select(Workspace workspace) {
            }

            @Override
            public void unselect(Workspace workspace) {
            }

            @Override
            public void close(Workspace workspace) {
            }

            @Override
            public void disable() {
            }
        });
        if (this.projectController.getCurrentProject() != null) {
            for (Workspace workspace : ((WorkspaceProvider)this.projectController.getCurrentProject().getLookup().lookup(WorkspaceProvider.class)).getWorkspaces()) {
                AttributeModel m = (AttributeModel)workspace.getLookup().lookup(AttributeModel.class);
                if (m != null) continue;
                workspace.add(new IndexedAttributeModel(workspace));
            }
        }
    }

    @Override
    public synchronized AttributeModel getModel() {
        Workspace workspace = this.projectController.getCurrentWorkspace();
        if (workspace != null) {
            AttributeModel model = (AttributeModel)workspace.getLookup().lookup(AttributeModel.class);
            if (model != null) {
                return model;
            }
            model = new IndexedAttributeModel(workspace);
            workspace.add(model);
            return model;
        }
        return null;
    }

    @Override
    public synchronized AttributeModel getModel(Workspace workspace) {
        AttributeModel model = (AttributeModel)workspace.getLookup().lookup(AttributeModel.class);
        if (model != null) {
            return model;
        }
        model = new IndexedAttributeModel(workspace);
        workspace.add(model);
        return model;
    }

    @Override
    public AttributeModel newModel() {
        TemporaryAttributeModel model = new TemporaryAttributeModel(null);
        return model;
    }
}

