/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes;

import org.gephi.data.attributes.AbstractAttributeModel;
import org.gephi.data.attributes.AttributeColumnImpl;
import org.gephi.data.attributes.AttributeRowImpl;
import org.gephi.data.attributes.AttributeTableImpl;
import org.gephi.data.attributes.AttributeValueImpl;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeRowFactory;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.data.attributes.api.AttributeValueFactory;
import org.gephi.graph.api.EdgeData;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.NodeData;

public class AttributeFactoryImpl
implements AttributeValueFactory,
AttributeRowFactory {
    private AbstractAttributeModel model;

    public AttributeFactoryImpl(AbstractAttributeModel model) {
        this.model = model;
    }

    @Override
    public AttributeValue newValue(AttributeColumn column, Object value) {
        if (value == null) {
            return new AttributeValueImpl((AttributeColumnImpl)column, null);
        }
        if (!column.getOrigin().equals((Object)AttributeOrigin.DELEGATE)) {
            AttributeType targetType = column.getType();
            if (!value.getClass().equals(targetType.getType())) {
                try {
                    value = targetType.parse(value.toString());
                }
                catch (Exception ex) {
                    return new AttributeValueImpl((AttributeColumnImpl)column, null);
                }
            }
        }
        Object managedValue = value;
        if (!column.getOrigin().equals((Object)AttributeOrigin.PROPERTY)) {
            managedValue = this.model.getManagedValue(value, column.getType());
        }
        return new AttributeValueImpl((AttributeColumnImpl)column, managedValue);
    }

    @Override
    public AttributeRowImpl newNodeRow(NodeData nodeData) {
        return new AttributeRowImpl(this.model.getNodeTable(), nodeData);
    }

    @Override
    public AttributeRowImpl newEdgeRow(EdgeData edgeData) {
        return new AttributeRowImpl(this.model.getEdgeTable(), edgeData);
    }

    @Override
    public AttributeRow newGraphRow(GraphView graphView) {
        return new AttributeRowImpl(this.model.getGraphTable(), graphView);
    }

    @Override
    public AttributeRowImpl newRowForTable(String tableName, Object object) {
        AttributeTableImpl attTable = this.model.getTable(tableName);
        if (attTable != null) {
            return new AttributeRowImpl(attTable, object);
        }
        return null;
    }

    public void setModel(AbstractAttributeModel model) {
        this.model = model;
    }
}

