/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes;

import org.gephi.data.attributes.AttributeColumnImpl;
import org.gephi.data.attributes.AttributeTableImpl;
import org.gephi.data.attributes.AttributeValueImpl;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeEvent;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.data.attributes.event.ValueEvent;

public class AttributeRowImpl
implements AttributeRow {
    protected final Object object;
    protected final AttributeTableImpl attributeTable;
    protected AttributeValueImpl[] values;
    protected int rowVersion = -1;

    public AttributeRowImpl(AttributeTableImpl attributeTable, Object object) {
        this.attributeTable = attributeTable;
        this.object = object;
        this.reset();
    }

    @Override
    public void reset() {
        this.rowVersion = this.attributeTable.getVersion();
        int attSize = this.attributeTable.countColumns();
        if (this.values == null) {
            this.values = new AttributeValueImpl[attSize];
        } else {
            this.updateColumns();
        }
        for (int i = 0; i < attSize; ++i) {
            this.setValue(i, this.attributeTable.getColumn((int)i).defaultValue, false);
        }
    }

    @Override
    public void setValues(AttributeRow attributeRow) {
        if (attributeRow == null) {
            throw new NullPointerException();
        }
        AttributeValue[] attValues = attributeRow.getValues();
        for (int i = 0; i < attValues.length; ++i) {
            this.setValue(attValues[i]);
        }
    }

    @Override
    public void setValue(int index, Object value) {
        AttributeColumnImpl column = this.attributeTable.getColumn(index);
        if (column == null) {
            throw new IllegalArgumentException("The column doesn't exist");
        }
        this.setValue(column, value);
    }

    @Override
    public void setValue(String column, Object value) {
        if (column == null) {
            throw new NullPointerException("Column is null");
        }
        AttributeColumnImpl attributeColumn = this.attributeTable.getColumn(column);
        if (attributeColumn != null) {
            this.setValue(attributeColumn, value);
        } else {
            AttributeType type = AttributeType.parse(value);
            if (type != null) {
                attributeColumn = this.attributeTable.addColumn(column, type);
                this.setValue(attributeColumn, value);
            }
        }
    }

    @Override
    public void setValue(AttributeColumn column, Object value) {
        if (column == null) {
            throw new NullPointerException("Column is null");
        }
        AttributeValue attValue = this.attributeTable.getFactory().newValue(column, value);
        this.setValue(attValue);
    }

    @Override
    public void setValue(AttributeValue value) {
        AttributeColumn column = value.getColumn();
        if (this.attributeTable.getColumn(column.getIndex()) != column) {
            if ((column = this.attributeTable.getColumn(column)) == null) {
                throw new IllegalArgumentException("The " + this.attributeTable.getName() + " value column " + value.getColumn().getId() + " with index " + value.getColumn().getIndex() + " doesn't exist");
            }
            value = this.attributeTable.getFactory().newValue(column, value.getValue());
        }
        this.setValue(column.getIndex(), (AttributeValueImpl)value, true);
    }

    private void setValue(int index, AttributeValueImpl value, boolean doUpdateColumns) {
        if (doUpdateColumns) {
            this.updateColumns();
        }
        AttributeValueImpl oldValue = this.values[index];
        this.values[index] = value;
        if (!(oldValue != null && oldValue.equals(value) || index <= 0 || value.getColumn().getOrigin().equals((Object)AttributeOrigin.COMPUTED))) {
            if (oldValue != null) {
                this.attributeTable.model.fireAttributeEvent(new ValueEvent(AttributeEvent.EventType.UNSET_VALUE, this.attributeTable, this.object, oldValue));
            }
            this.attributeTable.model.fireAttributeEvent(new ValueEvent(AttributeEvent.EventType.SET_VALUE, this.attributeTable, this.object, value));
        }
    }

    @Override
    public Object getValue(AttributeColumn column) {
        AttributeValueImpl val;
        if (column == null) {
            throw new NullPointerException();
        }
        this.updateColumns();
        int index = column.getIndex();
        if (this.checkIndexRange(index) && (val = this.values[index]).getColumn() == column) {
            return val.getValue();
        }
        return null;
    }

    @Override
    public Object getValue(int index) {
        this.updateColumns();
        if (this.checkIndexRange(index)) {
            AttributeColumnImpl attributeColumn = this.attributeTable.getColumn(index);
            return this.getValue(attributeColumn);
        }
        return null;
    }

    @Override
    public Object getValue(String column) {
        this.updateColumns();
        AttributeColumnImpl attributeColumn = this.attributeTable.getColumn(column);
        if (attributeColumn != null) {
            return this.getValue(attributeColumn);
        }
        return null;
    }

    @Override
    public AttributeValue[] getValues() {
        return this.values;
    }

    @Override
    public AttributeValue getAttributeValueAt(int index) {
        if (this.checkIndexRange(index)) {
            return this.values[index];
        }
        return null;
    }

    @Override
    public int countValues() {
        this.updateColumns();
        return this.values.length;
    }

    @Override
    public AttributeColumn getColumnAt(int index) {
        this.updateColumns();
        return this.attributeTable.getColumn(index);
    }

    public Object getObject() {
        return this.object;
    }

    private void updateColumns() {
        int tableVersion = this.attributeTable.getVersion();
        if (this.rowVersion < tableVersion) {
            AttributeColumnImpl[] columns = this.attributeTable.getColumns();
            AttributeValueImpl[] oldValues = this.values;
            this.values = new AttributeValueImpl[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                AttributeColumnImpl tableCol = columns[i];
                boolean found = false;
                int j = 0;
                while (j < oldValues.length) {
                    AttributeValueImpl val;
                    if ((val = oldValues[j++]).getColumn() != tableCol) continue;
                    this.values[i] = val;
                    found = true;
                    break;
                }
                if (found) continue;
                this.setValue(i, tableCol.defaultValue, false);
            }
            this.rowVersion = tableVersion;
        }
    }

    private boolean checkIndexRange(int index) {
        return index < this.values.length && index >= 0;
    }

    public int getRowVersion() {
        return this.rowVersion;
    }

    public void setRowVersion(int rowVersion) {
        this.rowVersion = rowVersion;
    }

    public void setValues(AttributeValueImpl[] values) {
        this.values = values;
    }
}

