/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.data.attributes.AbstractAttributeModel;
import org.gephi.data.attributes.AttributeColumnImpl;
import org.gephi.data.attributes.AttributeFactoryImpl;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeEvent;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.data.attributes.event.ColumnEvent;
import org.gephi.data.attributes.spi.AttributeValueDelegateProvider;
import org.gephi.data.attributes.type.TypeConvertor;
import org.gephi.data.properties.PropertiesColumn;
import org.gephi.graph.api.Attributes;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.openide.util.Lookup;

public class AttributeTableImpl
implements AttributeTable {
    protected String name;
    protected final AbstractAttributeModel model;
    protected final List<AttributeColumnImpl> columns = new ArrayList<AttributeColumnImpl>();
    protected final Map<AttributeColumn, AttributeColumn> columnsSet = new HashMap<AttributeColumn, AttributeColumn>();
    protected final Map<String, AttributeColumnImpl> columnsMap = new HashMap<String, AttributeColumnImpl>();
    protected int version = 0;

    public AttributeTableImpl(AbstractAttributeModel model, String name) {
        this.name = name;
        this.model = model;
    }

    public synchronized AttributeColumnImpl[] getColumns() {
        return this.columns.toArray(new AttributeColumnImpl[0]);
    }

    @Override
    public synchronized int countColumns() {
        return this.columns.size();
    }

    @Override
    public AttributeColumn addPropertiesColumn(PropertiesColumn propertiesColumn) {
        return this.addColumn(propertiesColumn.getId(), propertiesColumn.getTitle(), propertiesColumn.getType(), propertiesColumn.getOrigin(), propertiesColumn.getDefaultValue());
    }

    @Override
    public AttributeColumnImpl addColumn(String id, AttributeType type) {
        return this.addColumn(id, id, type, AttributeOrigin.DATA, null, null);
    }

    @Override
    public AttributeColumnImpl addColumn(String id, AttributeType type, AttributeOrigin origin) {
        return this.addColumn(id, id, type, origin, null, null);
    }

    @Override
    public AttributeColumnImpl addColumn(String id, String title, AttributeType type, AttributeOrigin origin, Object defaultValue) {
        return this.addColumn(id, title, type, origin, defaultValue, null);
    }

    @Override
    public AttributeColumn addColumn(String id, String title, AttributeType type, AttributeValueDelegateProvider attributeValueDelegateProvider, Object defaultValue) {
        return this.addColumn(id, title, type, AttributeOrigin.DELEGATE, defaultValue, attributeValueDelegateProvider);
    }

    private synchronized AttributeColumnImpl addColumn(String id, String title, AttributeType type, AttributeOrigin origin, Object defaultValue, AttributeValueDelegateProvider attributeValueDelegateProvider) {
        if (id == null || id.isEmpty() || this.hasColumn(id)) {
            throw new IllegalArgumentException("The column id can't be null, empty or already existing in the table");
        }
        if (title == null || title.isEmpty() || this.hasColumn(title)) {
            Logger.getLogger(AttributeTableImpl.class.getName()).log(Level.WARNING, "Invalid or repeated column title ({0}), used column id as its title instead", title);
            title = id;
        }
        if (defaultValue != null) {
            if (defaultValue.getClass() != type.getType()) {
                if (defaultValue.getClass() == String.class) {
                    defaultValue = type.parse((String)defaultValue);
                } else {
                    throw new IllegalArgumentException("The default value type cannot be cast to the type");
                }
            }
            defaultValue = this.model.getManagedValue(defaultValue, type);
        }
        AttributeColumnImpl column = new AttributeColumnImpl(this, this.columns.size(), id, title, type, origin, defaultValue, attributeValueDelegateProvider);
        this.columns.add(column);
        this.columnsMap.put(id.toLowerCase(), column);
        if (title != null && !title.equals(id)) {
            this.columnsMap.put(title.toLowerCase(), column);
        }
        this.columnsSet.put(column, column);
        ++this.version;
        this.model.fireAttributeEvent(new ColumnEvent(AttributeEvent.EventType.ADD_COLUMN, column));
        return column;
    }

    private boolean sendUnsetValueEventsForRemovedColumn(AttributeColumn column) {
        int i;
        Attributes[] rows;
        if (this.model.getWorkspace() == null) {
            return false;
        }
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel(this.model.getWorkspace());
        if (AttributeUtils.getDefault().isNodeColumn(column)) {
            Node[] nodes = graphModel.getGraph().getNodes().toArray();
            rows = new Attributes[nodes.length];
            for (i = 0; i < nodes.length; ++i) {
                rows[i] = nodes[i].getAttributes();
            }
        } else if (AttributeUtils.getDefault().isEdgeColumn(column)) {
            Edge[] edges = graphModel.getGraph().getEdges().toArray();
            rows = new Attributes[edges.length];
            for (i = 0; i < edges.length; ++i) {
                rows[i] = edges[i].getAttributes();
            }
        } else if (AttributeUtils.getDefault().isGraphColumn(column)) {
            rows = new Attributes[]{graphModel.getGraph().getAttributes()};
        } else {
            return false;
        }
        int columnIndex = column.getIndex();
        for (Attributes row : rows) {
            row.setValue(columnIndex, null);
        }
        return true;
    }

    @Override
    public synchronized void removeColumn(AttributeColumn column) {
        int index = this.columns.indexOf(column);
        if (index == -1) {
            return;
        }
        this.sendUnsetValueEventsForRemovedColumn(column);
        ++index;
        while (index < this.columns.size()) {
            AttributeColumnImpl c = this.columns.get(index);
            --c.index;
            ++index;
        }
        this.columns.remove((AttributeColumnImpl)column);
        this.columnsMap.remove(column.getId().toLowerCase());
        if (column.getTitle() != null && !column.getTitle().equals(column.getId())) {
            this.columnsMap.remove(column.getTitle().toLowerCase());
        }
        this.columnsSet.remove(column);
        this.model.fireAttributeEvent(new ColumnEvent(AttributeEvent.EventType.REMOVE_COLUMN, (AttributeColumnImpl)column));
        ++this.version;
    }

    public synchronized AttributeColumn replaceColumn(AttributeColumn source, AttributeColumnImpl targetImpl) {
        int index = this.columns.indexOf(source);
        if (index == -1) {
            return null;
        }
        this.sendUnsetValueEventsForRemovedColumn(source);
        this.columnsMap.remove(source.getId().toLowerCase());
        if (source.getTitle() != null && !source.getTitle().equals(source.getId())) {
            this.columnsMap.remove(source.getTitle().toLowerCase());
        }
        this.columnsSet.remove(source);
        targetImpl.index = index;
        this.columns.set(index, targetImpl);
        this.columnsMap.put(targetImpl.id.toLowerCase(), targetImpl);
        if (targetImpl.title != null && !targetImpl.title.equals(targetImpl.id)) {
            this.columnsMap.put(targetImpl.title.toLowerCase(), targetImpl);
        }
        this.columnsSet.put(targetImpl, targetImpl);
        this.model.fireAttributeEvent(new ColumnEvent(AttributeEvent.EventType.REPLACE_COLUMN, (AttributeColumnImpl)source));
        ++this.version;
        return targetImpl;
    }

    @Override
    public synchronized AttributeColumn replaceColumn(AttributeColumn source, String id, String title, AttributeType type, AttributeOrigin origin, Object defaultValue) {
        if (defaultValue != null) {
            if (defaultValue.getClass() != type.getType()) {
                if (defaultValue.getClass() == String.class) {
                    defaultValue = type.parse((String)defaultValue);
                } else {
                    throw new IllegalArgumentException("The default value type cannot be cast to the type");
                }
            }
            defaultValue = this.model.getManagedValue(defaultValue, type);
        }
        AttributeColumnImpl targetImpl = new AttributeColumnImpl(this, this.columns.size(), id, title, type, origin, defaultValue, null);
        return this.replaceColumn(source, targetImpl);
    }

    @Override
    public synchronized AttributeColumnImpl getColumn(int index) {
        if (index >= 0 && index < this.columns.size()) {
            return this.columns.get(index);
        }
        return null;
    }

    @Override
    public synchronized AttributeColumnImpl getColumn(String id) {
        return this.columnsMap.get(id.toLowerCase());
    }

    @Override
    public synchronized AttributeColumnImpl getColumn(String title, AttributeType type) {
        AttributeColumnImpl c = this.columnsMap.get(title.toLowerCase());
        if (c != null && c.getType().equals((Object)type)) {
            return c;
        }
        return null;
    }

    public synchronized AttributeColumn getColumn(AttributeColumn column) {
        return this.columnsSet.get(column);
    }

    @Override
    public synchronized boolean hasColumn(String title) {
        return this.columnsMap.containsKey(title.toLowerCase());
    }

    public synchronized int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AttributeFactoryImpl getFactory() {
        return this.model.getFactory();
    }

    public AbstractAttributeModel getModel() {
        return this.model;
    }

    @Override
    public synchronized void mergeTable(AttributeTable table) {
        for (AttributeColumn column : table.getColumns()) {
            AttributeColumn existingCol = this.getColumn(column);
            if (existingCol == null) {
                existingCol = this.getColumn(column.getTitle());
            }
            if (existingCol == null) {
                this.addColumn(column.getId(), column.getTitle(), column.getType(), column.getOrigin(), column.getDefaultValue());
                continue;
            }
            if (!column.getType().isDynamicType() || !TypeConvertor.getStaticType(column.getType()).equals((Object)existingCol.getType())) continue;
            AttributeColumnImpl newCol = new AttributeColumnImpl(this, existingCol.getIndex(), existingCol.getId(), existingCol.getTitle(), column.getType(), existingCol.getOrigin(), column.getDefaultValue(), null);
            this.replaceColumn(existingCol, newCol);
        }
    }
}

