/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes;

import java.util.ArrayList;
import org.gephi.data.attributes.AttributeColumnImpl;
import org.gephi.data.attributes.AttributeTableImpl;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.data.attributes.type.NumberList;

public class AttributeUtilsImpl
extends AttributeUtils {
    @Override
    public boolean isColumnOfType(AttributeColumn column, AttributeType type) {
        return column.getType() == type;
    }

    @Override
    public boolean areAllColumnsOfType(AttributeColumn[] columns, AttributeType type) {
        for (AttributeColumn column : columns) {
            if (this.isColumnOfType(column, type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areAllColumnsOfSameType(AttributeColumn[] columns) {
        if (columns.length == 0) {
            return false;
        }
        AttributeType type = columns[0].getType();
        return this.areAllColumnsOfType(columns, type);
    }

    @Override
    public boolean isStringColumn(AttributeColumn column) {
        return column.getType().equals((Object)AttributeType.STRING) || column.getType().equals((Object)AttributeType.LIST_STRING);
    }

    @Override
    public boolean areAllStringColumns(AttributeColumn[] columns) {
        for (AttributeColumn column : columns) {
            if (this.isStringColumn(column)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNumberColumn(AttributeColumn column) {
        AttributeType attributeType = column.getType();
        return Number.class.isAssignableFrom(attributeType.getType());
    }

    @Override
    public boolean areAllNumberColumns(AttributeColumn[] columns) {
        for (AttributeColumn column : columns) {
            if (this.isNumberColumn(column)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNumberListColumn(AttributeColumn column) {
        AttributeType attributeType = column.getType();
        return NumberList.class.isAssignableFrom(attributeType.getType());
    }

    @Override
    public boolean areAllNumberListColumns(AttributeColumn[] columns) {
        for (AttributeColumn column : columns) {
            if (this.isNumberListColumn(column)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNumberOrNumberListColumn(AttributeColumn column) {
        return this.isNumberColumn(column) || this.isNumberListColumn(column);
    }

    @Override
    public boolean areAllNumberOrNumberListColumns(AttributeColumn[] columns) {
        for (AttributeColumn column : columns) {
            if (this.isNumberOrNumberListColumn(column)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDynamicNumberColumn(AttributeColumn column) {
        switch (column.getType()) {
            case DYNAMIC_BIGDECIMAL: 
            case DYNAMIC_BIGINTEGER: 
            case DYNAMIC_BYTE: 
            case DYNAMIC_DOUBLE: 
            case DYNAMIC_FLOAT: 
            case DYNAMIC_INT: 
            case DYNAMIC_LONG: 
            case DYNAMIC_SHORT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean areAllDynamicNumberColumns(AttributeColumn[] columns) {
        for (AttributeColumn column : columns) {
            if (this.isDynamicNumberColumn(column)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Comparable getMin(AttributeColumn column, Comparable[] values) {
        if (!this.isNumberColumn(column) && !this.isDynamicNumberColumn(column)) {
            throw new IllegalArgumentException("Colun must be a number column");
        }
        switch (values.length) {
            case 0: {
                return null;
            }
            case 1: {
                return values[0];
            }
        }
        Comparable min = values[0];
        for (int index = 1; index < values.length; ++index) {
            Comparable o = values[index];
            if (o.compareTo(min) >= 0) continue;
            min = o;
        }
        return min;
    }

    @Override
    public Comparable getMax(AttributeColumn column, Comparable[] values) {
        if (!this.isNumberColumn(column) && !this.isDynamicNumberColumn(column)) {
            throw new IllegalArgumentException("Colun must be a number column");
        }
        switch (values.length) {
            case 0: {
                return null;
            }
            case 1: {
                return values[0];
            }
        }
        Comparable max = values[0];
        for (int index = 1; index < values.length; ++index) {
            Comparable o = values[index];
            if (o.compareTo(max) <= 0) continue;
            max = o;
        }
        return max;
    }

    @Override
    public boolean isNodeColumn(AttributeColumn column) {
        if (column == null) {
            throw new NullPointerException();
        }
        AttributeColumnImpl columnImpl = (AttributeColumnImpl)column;
        AttributeTableImpl table = columnImpl.getTable();
        return table == table.getModel().getNodeTable();
    }

    @Override
    public boolean isEdgeColumn(AttributeColumn column) {
        if (column == null) {
            throw new NullPointerException();
        }
        AttributeColumnImpl columnImpl = (AttributeColumnImpl)column;
        AttributeTableImpl table = columnImpl.getTable();
        return table == table.getModel().getEdgeTable();
    }

    @Override
    public boolean isGraphColumn(AttributeColumn column) {
        if (column == null) {
            throw new NullPointerException();
        }
        AttributeColumnImpl columnImpl = (AttributeColumnImpl)column;
        AttributeTableImpl table = columnImpl.getTable();
        return table == table.getModel().getGraphTable();
    }

    @Override
    public AttributeColumn[] getNumberColumns(AttributeTable table) {
        ArrayList<AttributeColumn> res = new ArrayList<AttributeColumn>();
        for (AttributeColumn c : table.getColumns()) {
            if (!this.isNumberColumn(c)) continue;
            res.add(c);
        }
        return res.toArray(new AttributeColumn[0]);
    }

    @Override
    public AttributeColumn[] getStringColumns(AttributeTable table) {
        ArrayList<AttributeColumn> res = new ArrayList<AttributeColumn>();
        for (AttributeColumn c : table.getColumns()) {
            if (!this.isStringColumn(c)) continue;
            res.add(c);
        }
        return res.toArray(new AttributeColumn[0]);
    }

    @Override
    public AttributeColumn[] getAllCollums(AttributeModel model) {
        ArrayList<AttributeColumnImpl> cols = new ArrayList<AttributeColumnImpl>();
        for (AttributeTable t : model.getTables()) {
            AttributeTableImpl tableImpl = (AttributeTableImpl)t;
            cols.addAll(tableImpl.columns);
        }
        return cols.toArray(new AttributeColumn[0]);
    }
}

