/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes;

import org.gephi.data.attributes.AttributeColumnImpl;
import org.gephi.data.attributes.AttributeUtilsImpl;
import org.gephi.data.attributes.ListFactory;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.data.attributes.spi.AttributeValueDelegateProvider;

public final class AttributeValueImpl
implements AttributeValue {
    private final AttributeColumnImpl column;
    private final Object value;

    public AttributeValueImpl(AttributeColumnImpl column, Object value) {
        this.column = column;
        this.value = value;
    }

    @Override
    public AttributeColumnImpl getColumn() {
        return this.column;
    }

    @Override
    public Object getValue() {
        Object convertedValue;
        Object result;
        if (this.column.getOrigin() != AttributeOrigin.DELEGATE) {
            return this.value;
        }
        if (this.value == null) {
            return null;
        }
        AttributeValueDelegateProvider attributeValueDelegateProvider = this.column.getProvider();
        if (AttributeUtilsImpl.getDefault().isEdgeColumn(this.column)) {
            result = attributeValueDelegateProvider.getEdgeAttributeValue(this.value, this.column);
        } else if (AttributeUtilsImpl.getDefault().isNodeColumn(this.column)) {
            result = attributeValueDelegateProvider.getNodeAttributeValue(this.value, this.column);
        } else {
            throw new AssertionError();
        }
        if (result != null && result.getClass() != this.column.getType().getType() && (convertedValue = this.column.getType().parse(this.value.toString())) != null) {
            result = convertedValue;
        }
        if (result != null && result.getClass().isArray()) {
            result = ListFactory.fromArray(result);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof AttributeValue) {
            if (this == obj) {
                return true;
            }
            Object thisVal = this.getValue();
            Object objVal = ((AttributeValue)obj).getValue();
            if (thisVal == null && objVal == null) {
                return true;
            }
            if (thisVal != null && objVal != null && thisVal.equals(objVal)) {
                return true;
            }
        }
        return false;
    }
}

