/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.data.attributes.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.gephi.data.attributes.AbstractAttributeModel;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeEvent;
import org.gephi.data.attributes.api.AttributeListener;
import org.gephi.data.attributes.api.AttributeValue;
import org.gephi.data.attributes.event.AbstractEvent;
import org.gephi.data.attributes.event.AttributeEventDataImpl;
import org.gephi.data.attributes.event.AttributeEventImpl;
import org.gephi.data.attributes.event.ColumnEvent;
import org.gephi.data.attributes.event.ValueEvent;

public class AttributeEventManager
implements Runnable {
    private static final long DELAY = 100L;
    private final AbstractAttributeModel model;
    private final List<AttributeListener> listeners;
    private final AtomicReference<Thread> thread = new AtomicReference();
    private final LinkedBlockingQueue<AbstractEvent> eventQueue;
    private final Object lock = new Object();
    private final LinkedList<Integer> rateList = new LinkedList();
    private double avgRate = 1.0;
    private boolean stop;

    public AttributeEventManager(AbstractAttributeModel model) {
        this.model = model;
        this.eventQueue = new LinkedBlockingQueue();
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int rate = 0;
        while (!this.stop) {
            if (rate == (int)this.avgRate) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                int w = (int)((float)this.eventQueue.size() * 0.1f);
                w = Math.max(1, w);
                this.updateRate(w);
                ++rate;
            }
            ArrayList eventCompress = null;
            ArrayList<Object> eventCompressObjects = null;
            AbstractEvent precEvt = null;
            AbstractEvent evt = null;
            while ((evt = this.eventQueue.peek()) != null) {
                if (precEvt != null) {
                    if (!(evt instanceof ValueEvent) && !(evt instanceof ColumnEvent) || !precEvt.getEventType().equals((Object)evt.getEventType()) || precEvt.getAttributeTable() != evt.getAttributeTable()) break;
                    if (eventCompress == null) {
                        eventCompress = new ArrayList();
                        eventCompress.add(precEvt.getData());
                    }
                    if (evt instanceof ValueEvent) {
                        if (eventCompressObjects == null) {
                            eventCompressObjects = new ArrayList<Object>();
                            eventCompressObjects.add(((ValueEvent)precEvt).getObject());
                        }
                        eventCompressObjects.add(((ValueEvent)evt).getObject());
                    }
                    eventCompress.add(evt.getData());
                }
                this.eventQueue.poll();
                precEvt = evt;
            }
            if (precEvt != null) {
                AttributeEvent event = this.createEvent(precEvt, eventCompress, eventCompressObjects);
                for (AttributeListener l : this.listeners.toArray(new AttributeListener[0])) {
                    l.attributesChanged(event);
                }
            }
            ++rate;
            while (this.eventQueue.isEmpty()) {
                rate = (int)this.avgRate;
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private AttributeEvent createEvent(AbstractEvent event, List<Object> compress, List<Object> compressObjects) {
        AttributeEventDataImpl eventData = new AttributeEventDataImpl();
        AttributeEventImpl attributeEvent = new AttributeEventImpl(event.getEventType(), event.getAttributeTable(), eventData);
        if (event instanceof ValueEvent) {
            Object[] objects;
            AttributeValue[] values;
            if (compress != null) {
                values = compress.toArray(new AttributeValue[0]);
                objects = compressObjects.toArray();
            } else {
                values = new AttributeValue[]{(AttributeValue)event.getData()};
                objects = new Object[]{((ValueEvent)event).getObject()};
            }
            eventData.setValues(values);
            eventData.setObjects(objects);
        } else if (event instanceof ColumnEvent) {
            AttributeColumn[] columns = compress != null ? compress.toArray(new AttributeColumn[0]) : new AttributeColumn[]{(AttributeColumn)event.getData()};
            eventData.setColumns(columns);
        }
        return attributeEvent;
    }

    private double updateRate(int n) {
        int windowLength = 10;
        if (this.rateList.size() == windowLength) {
            Integer oldest = this.rateList.poll();
            this.avgRate = (this.avgRate * (double)windowLength - (double)oldest.intValue()) / (double)(windowLength - 1);
        }
        this.avgRate = (this.avgRate * (double)this.rateList.size() + (double)n) / (double)(this.rateList.size() + 1);
        this.rateList.add(n);
        return this.avgRate;
    }

    public void stop(boolean stop) {
        this.stop = stop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(AbstractEvent event) {
        this.eventQueue.add(event);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void start() {
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.setName("attribute-event-bus");
        if (this.thread.compareAndSet(null, t)) {
            t.start();
        }
    }

    public boolean isRunning() {
        return this.thread.get() != null;
    }

    public void addAttributeListener(AttributeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeAttributeListener(AttributeListener listener) {
        this.listeners.remove(listener);
    }
}

